/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.utils;

import java.util.Arrays;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.model.utils.AuthorizationData;
import org.cyclos.model.utils.Cookie;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;

public class RequestHelper {
    private static final String IGNORE_AUTHORIZATION = "ignoreAuthorization";

    public static boolean acceptsGzip(HttpServletRequest httpServletRequest) {
        return RequestHelper.acceptsEncoding(httpServletRequest, "gzip");
    }

    public static AuthorizationData getAuthorization(HttpServletRequest httpServletRequest) {
        if (Boolean.TRUE.equals(httpServletRequest.getAttribute(IGNORE_AUTHORIZATION))) {
            return null;
        }
        return AuthorizationData.of(arg_0 -> ((HttpServletRequest)httpServletRequest).getHeader(arg_0));
    }

    public static String getCookieValue(HttpServletRequest httpServletRequest, Cookie cookie) {
        javax.servlet.http.Cookie cookie2 = RequestHelper.getCookie(httpServletRequest, cookie.cookieName());
        return cookie2 == null ? null : StringHelper.trimToNull((Object)cookie2.getValue());
    }

    public static void setIgnoreAuthorization(HttpServletRequest httpServletRequest, boolean bl) {
        httpServletRequest.setAttribute(IGNORE_AUTHORIZATION, (Object)bl);
    }

    public static boolean wasModified(HttpServletRequest httpServletRequest, long l) {
        long l2 = httpServletRequest.getDateHeader("If-Modified-Since");
        if (l2 < 0L) {
            return true;
        }
        return l > l2;
    }

    private static boolean acceptsEncoding(HttpServletRequest httpServletRequest, String string) {
        String[] stringArray;
        String string2 = httpServletRequest.getHeader("Accept-Encoding");
        if (StringHelper.isBlank((Object)string2)) {
            return false;
        }
        for (String string3 : stringArray = string2.split(",")) {
            if (!string3.trim().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private static javax.servlet.http.Cookie getCookie(HttpServletRequest httpServletRequest, String string) {
        Object[] objectArray = httpServletRequest.getCookies();
        if (CollectionHelper.isEmpty((Object[])objectArray)) {
            return null;
        }
        Optional<javax.servlet.http.Cookie> optional = Arrays.asList(objectArray).stream().filter(cookie -> cookie.getName().equals(string)).findFirst();
        return optional.isPresent() ? optional.get() : null;
    }
}

