/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.IOHelper;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.services.system.CustomSvgIconService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.utils.IconHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IconHandlerImpl
implements IconHandler {
    @Autowired
    private JsonConverter jsonConverter;
    @Autowired
    private ServletContext servletContext;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private CustomSvgIconService customSvgIconService;
    private volatile Map<String, String> icons;

    @Override
    public String icon(String string) {
        return this.icons().get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> icons() {
        Map<String, String> map;
        Map map2 = this.customSvgIconService.icons();
        Supplier<Map> supplier = () -> {
            Object object;
            InputStream inputStream = null;
            try {
                inputStream = this.servletContext.getResourceAsStream("ui/svg/icons.json");
                if (inputStream == null) {
                    object = new File("../cyclos4-ui/src/svg/icons.json");
                    if (!((File)object).exists()) {
                        object = new File("cyclos4/cyclos4-ui/src/svg/icons.json");
                    }
                    inputStream = new FileInputStream((File)object);
                }
                object = (Map)this.jsonConverter.readValue(inputStream, Map.class);
            }
            catch (IOException iOException) {
                try {
                    throw new UncheckedIOException("Error reading icons", iOException);
                }
                catch (Throwable throwable) {
                    IOHelper.close(inputStream);
                    throw throwable;
                }
            }
            IOHelper.close((Closeable)inputStream);
            return object;
        };
        if (this.cyclosProperties.isDevelopment()) {
            map = supplier.get();
        } else {
            if (this.icons == null) {
                IconHandlerImpl iconHandlerImpl = this;
                synchronized (iconHandlerImpl) {
                    if (this.icons == null) {
                        this.icons = supplier.get();
                    }
                }
            }
            map = this.icons;
        }
        map2.putAll(map);
        return map2;
    }

    @Override
    public Map<String, String> icons(Collection<String> collection) {
        Map<String, String> map = this.icons();
        if (CollectionHelper.isNotEmpty(collection)) {
            map = map.entrySet().stream().filter(entry -> collection.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return map;
    }
}

