/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.utils;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.utils.AbstractParameterStorage;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MapParameterStorage;

public abstract class BaseHttpRequestParameterStorage
extends AbstractParameterStorage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient HttpServletRequest request;

    public BaseHttpRequestParameterStorage(HttpServletRequest httpServletRequest) {
        this.request = httpServletRequest;
    }

    public Iterator<String> getNames() {
        return CollectionHelper.toIterator(this.getNames(this.request));
    }

    public String getString(String string) {
        return (String)CollectionHelper.first((Object[])this.readValue(string, this.request));
    }

    public List<String> getStringList(String string) {
        String[] stringArray = this.readValue(string, this.request);
        return stringArray == null ? null : Arrays.asList(stringArray);
    }

    public void remove(String string) {
        throw new UnsupportedOperationException();
    }

    protected void doSet(String string, List<String> list) {
        throw new UnsupportedOperationException();
    }

    protected Object doWriteReplace() {
        Map<String, String[]> map = this.readValues(this.request);
        if (!(map instanceof Serializable)) {
            map = new HashMap<String, String[]>(map);
        }
        return new MapParameterStorage(map);
    }

    protected abstract Enumeration<String> getNames(HttpServletRequest var1);

    protected abstract String[] readValue(String var1, HttpServletRequest var2);

    protected abstract Map<String, String[]> readValues(HttpServletRequest var1);
}

