/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rpc;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.reflect.TypeToken;
import java.beans.PropertyDescriptor;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.model.CyclosException;
import org.cyclos.server.utils.IOHelper;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.server.utils.jackson.JsonValueContainer;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.Submodule;
import org.cyclos.web.rpc.InvalidInputException;
import org.cyclos.web.rpc.InvalidOperationException;
import org.cyclos.web.rpc.InvalidParameterException;
import org.cyclos.web.rpc.InvalidParametersException;
import org.cyclos.web.rpc.InvalidRequestException;
import org.cyclos.web.rpc.MissingParameterException;
import org.cyclos.web.rpc.WebRpcContentHandler;
import org.cyclos.web.rpc.WebRpcRequest;
import org.cyclos.web.rpc.WebRpcServiceRegistry;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WebRpcContentHandlerImpl
implements WebRpcContentHandler {
    private static final JsonNode[] EMPTY_NODE_ARRAY = new JsonNode[0];
    @Autowired
    private WebRpcServiceRegistry registry;
    @Autowired
    protected JsonConverter jsonConverter;
    private ObjectMapper objectMapper;

    public static boolean isScalar(Object object) {
        return object == null || object.getClass().isEnum() || object instanceof Number || object instanceof String || object instanceof Boolean || object instanceof DateTime || object instanceof Submodule || object instanceof InputStream || object instanceof Page;
    }

    public static Map<String, Object> wrapError(Throwable throwable, ObjectMapper objectMapper) throws JsonProcessingException {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        String string = StringHelper.transformCase((String)StringHelper.removeEnd((String)throwable.getClass().getSimpleName(), (String)"Exception"), (boolean)true, (char)'_');
        linkedHashMap.put("class", throwable.getClass().getName());
        linkedHashMap.put("errorCode", string);
        if (throwable instanceof CyclosException) {
            BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl((Object)throwable);
            for (PropertyDescriptor propertyDescriptor : beanWrapperImpl.getPropertyDescriptors()) {
                Object object;
                String string2;
                Method method = propertyDescriptor.getReadMethod();
                if (method == null || !CyclosException.class.isAssignableFrom(method.getDeclaringClass()) || JsonConverter.BLACKLISTED_ERROR_PROPERTIES.contains(string2 = propertyDescriptor.getName()) || (object = beanWrapperImpl.getPropertyValue(string2)) == null) continue;
                linkedHashMap.put(string2, new JsonValueContainer(objectMapper.writeValueAsString(WebRpcContentHandlerImpl.wrapSuccess(object))));
            }
        }
        return linkedHashMap;
    }

    public static Object wrapSuccess(Object object) {
        if (object instanceof Collection) {
            Object object2 = CollectionHelper.first((Iterable)((Collection)object));
            if (WebRpcContentHandlerImpl.isScalar(object2)) {
                return new ScalarResultWrapper(object);
            }
            return new CollectionWrapper((Collection)object);
        }
        if (WebRpcContentHandlerImpl.isScalar(object)) {
            return new ScalarResultWrapper(object);
        }
        return new TypedResultWrapper(object);
    }

    @PostConstruct
    public void initialize() {
        this.objectMapper = this.jsonConverter.getObjectMapper();
    }

    @Override
    public Object parseArgument(Class<?> clazz, Method method, int n, String string) throws IOException {
        Type type = method.getGenericParameterTypes()[n];
        return this.resolveParameter(clazz, method, n, type, (JsonNode)TextNode.valueOf((String)string));
    }

    @Override
    public WebRpcRequest readRequest(Class<?> clazz, InputStream inputStream) throws IOException {
        Input input;
        try {
            input = (Input)this.objectMapper.readValue(inputStream, Input.class);
        }
        catch (Exception exception) {
            throw new InvalidInputException(exception);
        }
        finally {
            IOHelper.close((Closeable)inputStream);
        }
        Method method = this.getMethod(clazz, input.operation);
        return this.doReadRequest(clazz, method, input);
    }

    @Override
    public WebRpcRequest readRequest(Class<?> clazz, Method method, InputStream inputStream) {
        JsonNode jsonNode;
        Input input;
        block13: {
            input = new Input();
            input.operation = method.getName();
            try {
                jsonNode = (JsonNode)this.objectMapper.readValue(inputStream, JsonNode.class);
            }
            catch (JsonMappingException jsonMappingException) {
                JsonLocation jsonLocation = jsonMappingException.getLocation();
                if (jsonLocation != null && jsonLocation.getLineNr() == 1 & jsonLocation.getColumnNr() == 0) {
                    jsonNode = null;
                    break block13;
                }
                throw new InvalidInputException(jsonMappingException);
            }
            catch (Exception exception) {
                throw new InvalidInputException(exception);
            }
            finally {
                IOHelper.close((Closeable)inputStream);
            }
        }
        if (jsonNode == null || jsonNode.isNull()) {
            input.params = EMPTY_NODE_ARRAY;
        } else if (jsonNode.isArray()) {
            int n = jsonNode.size();
            input.params = new JsonNode[n];
            for (int i = 0; i < n; ++i) {
                input.params[i] = jsonNode.get(i);
            }
        } else {
            input.params = new JsonNode[1];
            input.params[0] = jsonNode;
        }
        return this.doReadRequest(clazz, method, input);
    }

    @Override
    public WebRpcRequest readRequest(Class<?> clazz, Method method, Map<String, String[]> map) {
        Input input = new Input();
        input.operation = method.getName();
        int n = method.getParameterTypes().length;
        if (n == 0) {
            input.params = EMPTY_NODE_ARRAY;
        } else if (n == 1) {
            ObjectNode objectNode = this.objectMapper.createObjectNode();
            for (Map.Entry<String, String[]> entry : map.entrySet()) {
                String string = entry.getKey();
                Object[] objectArray = entry.getValue();
                if (CollectionHelper.isEmpty((Object[])objectArray)) continue;
                if (objectArray.length == 1) {
                    objectNode.put(string, (String)objectArray[0]);
                    continue;
                }
                ArrayNode arrayNode = this.objectMapper.createArrayNode();
                for (Object object : objectArray) {
                    arrayNode.add((String)object);
                }
                objectNode.set(string, (JsonNode)arrayNode);
            }
            input.params = new JsonNode[]{objectNode};
        } else {
            throw new InvalidRequestException("Cannot call this method with multiple parameters");
        }
        return this.doReadRequest(clazz, method, input);
    }

    @Override
    public void writeError(WebRpcRequest webRpcRequest, Throwable throwable, OutputStream outputStream) throws IOException {
        this.objectMapper.writeValue(outputStream, this.wrapError(throwable));
    }

    @Override
    public void writeResponse(WebRpcRequest webRpcRequest, Object object, OutputStream outputStream) throws IOException {
        this.objectMapper.writeValue(outputStream, WebRpcContentHandlerImpl.wrapSuccess(object));
        outputStream.flush();
    }

    protected Method getMethod(Class<?> clazz, String string) {
        Method method = this.registry.get(clazz, string);
        if (method == null && (method = this.registry.get(clazz, "get" + StringUtils.capitalize((String)string))) == null) {
            throw new InvalidOperationException(clazz, string);
        }
        return method;
    }

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    private WebRpcRequest doReadRequest(Class<?> clazz, Method method, Input input) {
        JavaType javaType;
        Type[] typeArray = method.getGenericParameterTypes();
        JsonNode[] jsonNodeArray = (JsonNode[])ObjectHelper.defaultValue((Object)input.params, (Object)EMPTY_NODE_ARRAY);
        boolean bl = false;
        if (typeArray.length == 1) {
            javaType = this.resolveType(clazz, method.getGenericParameterTypes()[0]);
            bl = javaType.isCollectionLikeType();
        }
        if (!bl && jsonNodeArray.length > typeArray.length) {
            throw new InvalidParametersException(typeArray, jsonNodeArray.length);
        }
        javaType = new Object[typeArray.length];
        if (bl) {
            Type type = typeArray[0];
            ArrayNode arrayNode = this.objectMapper.createArrayNode();
            for (JsonNode jsonNode : jsonNodeArray) {
                if (jsonNode instanceof ArrayNode) {
                    arrayNode.addAll((ArrayNode)jsonNode);
                    continue;
                }
                arrayNode.add(jsonNode);
            }
            javaType[0] = this.resolveParameter(clazz, method, 0, type, (JsonNode)arrayNode);
        } else {
            for (int i = 0; i < typeArray.length; ++i) {
                JsonNode jsonNode;
                Type type = typeArray[i];
                try {
                    jsonNode = jsonNodeArray[i];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    jsonNode = NullNode.getInstance();
                }
                javaType[i] = this.resolveParameter(clazz, method, i, type, jsonNode);
            }
        }
        return new WebRpcRequest(method, (Object[])javaType);
    }

    private Object resolveParameter(Class<?> clazz, Method method, int n, Type type, JsonNode jsonNode) {
        if (jsonNode == null || jsonNode.isNull()) {
            Parameter parameter = method.getParameters()[n];
            if (parameter.isAnnotationPresent(NotNull.class)) {
                throw new MissingParameterException(parameter.getParameterizedType(), n);
            }
            return null;
        }
        JavaType javaType = this.resolveType(clazz, type);
        try {
            return this.objectMapper.readValue(this.objectMapper.treeAsTokens((TreeNode)jsonNode), javaType);
        }
        catch (Exception exception) {
            InvalidParameterException invalidParameterException = new InvalidParameterException(type, n);
            invalidParameterException.initCause(exception);
            throw invalidParameterException;
        }
    }

    private JavaType resolveType(Class<?> clazz, Type type) {
        Type type2 = TypeToken.of(clazz).resolveType(type).getType();
        return this.objectMapper.getTypeFactory().constructType(type2);
    }

    private Map<String, Object> wrapError(Throwable throwable) throws JsonProcessingException {
        return WebRpcContentHandlerImpl.wrapError(throwable, this.objectMapper);
    }

    public static class ScalarResultWrapper {
        protected Object result;

        public ScalarResultWrapper(Object object) {
            this.result = object;
        }

        @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
        public Object getResult() {
            return this.result;
        }
    }

    public static class CollectionWrapper {
        private Collection<Object> result;

        public CollectionWrapper(Collection<?> collection) {
            this.result = collection;
        }

        @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="class")
        public Collection<Object> getResult() {
            return this.result;
        }
    }

    public static class TypedResultWrapper {
        protected Object result;

        public TypedResultWrapper(Object object) {
            this.result = object;
        }

        @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="class")
        public Object getResult() {
            return this.result;
        }
    }

    protected static class Input {
        private String operation;
        private JsonNode[] params;

        protected Input() {
        }

        public String getOperation() {
            return this.operation;
        }

        public JsonNode[] getParams() {
            return this.params;
        }

        public void setOperation(String string) {
            this.operation = string;
        }

        public void setParams(JsonNode[] jsonNodeArray) {
            this.params = jsonNodeArray;
        }
    }
}

