/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.root;

import java.io.File;
import java.io.IOException;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.cyclos.server.utils.CyclosProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TempDirInitializer {
    @Autowired
    private CyclosProperties cyclosProperties;

    @PostConstruct
    public void initialize() throws IOException {
        File file = this.cyclosProperties.getTempDir();
        if (file.isFile()) {
            throw new IOException("The temp directory, " + file.getAbsolutePath() + " is actually a file");
        }
        if (file.exists()) {
            if (!file.getCanonicalPath().equals(new File(System.getProperty("java.io.tmpdir")).getCanonicalPath())) {
                try {
                    FileUtils.cleanDirectory((File)file);
                }
                catch (IOException iOException) {}
            } else if (this.cyclosProperties.getTempFilesDir().exists()) {
                try {
                    FileUtils.cleanDirectory((File)this.cyclosProperties.getTempFilesDir());
                }
                catch (IOException iOException) {}
            }
        } else if (!file.mkdirs()) {
            throw new IOException("Couldn't create the temp directory " + file.getAbsolutePath());
        }
    }
}

