/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.root;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.model.CyclosException;
import org.cyclos.model.access.InvalidSessionDataException;
import org.cyclos.services.Service;
import org.cyclos.services.access.InvocationData;
import org.cyclos.services.access.InvocationResult;
import org.cyclos.services.access.ServiceFacade;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component(value="requestServiceFactory")
public class RequestServiceFactory {
    private static final Logger LOG = LogManager.getLogger(RequestServiceFactory.class);
    @Autowired
    private ApplicationContext applicationContext;
    private ServiceFacade serviceFacade;

    public <T extends Service> T getService(Class<T> clazz) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class[] classArray = new Class[]{clazz};
        ServiceProxyInvocationHandler serviceProxyInvocationHandler = new ServiceProxyInvocationHandler(clazz);
        return (T)((Service)Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)serviceProxyInvocationHandler));
    }

    private ServiceFacade getServiceFacade() {
        if (this.serviceFacade == null) {
            this.serviceFacade = (ServiceFacade)this.applicationContext.getBean(ServiceFacade.class);
        }
        return this.serviceFacade;
    }

    private class ServiceProxyInvocationHandler
    implements InvocationHandler {
        private Class<? extends Service> serviceInterface;

        public ServiceProxyInvocationHandler(Class<? extends Service> clazz) {
            this.serviceInterface = clazz;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            InvocationResult invocationResult;
            if (method.getName().equals("toString") && objectArray.length == 0) {
                return "Proxy for " + String.valueOf(this.serviceInterface);
            }
            if (method.getName().equals("equals") && objectArray.length == 1) {
                return object == objectArray[0];
            }
            if (method.getName().equals("hashCode") && objectArray.length == 0) {
                return System.identityHashCode(object);
            }
            HttpServletRequest httpServletRequest = ServletHelper.getRequest();
            if (httpServletRequest == null) {
                throw new IllegalStateException("No request was bound to this thread");
            }
            InvocationData invocationData = ServletHelper.resolveServiceInvocationData(httpServletRequest, this.serviceInterface, method, objectArray);
            try {
                invocationResult = RequestServiceFactory.this.getServiceFacade().invoke(invocationData);
            }
            catch (Exception exception) {
                if (ExceptionUtils.indexOfType((Throwable)exception, CyclosException.class) < 0) {
                    LOG.error("Unhandled error on invocation of " + this.serviceInterface.getSimpleName() + "." + method.getName(), (Throwable)exception);
                }
                invocationResult = new InvocationResult((Throwable)exception);
            }
            if (invocationResult.isSuccessful()) {
                return invocationResult.getResult();
            }
            if (invocationResult.getThrowable() instanceof InvalidSessionDataException) {
                ServletHelper.setSessionToken(httpServletRequest, ServletHelper.getResponse(), null);
            }
            throw invocationResult.getThrowable();
        }
    }
}

