/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.root;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.cyclos.server.utils.jackson.JacksonConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.HandlerMethodReturnValueHandlerComposite;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

@Component
public class ObjectMapperConfig {
    @Autowired
    private JacksonConfiguration jacksonConfiguration;
    @Autowired(required=false)
    private RequestMappingHandlerAdapter requestMappingHandlerAdapter;
    @Autowired(required=false)
    private ExceptionHandlerExceptionResolver exceptionHandlerExceptionResolver;
    private ObjectMapper objectMapper;

    @PostConstruct
    public void init() {
        this.objectMapper = new ObjectMapper();
        this.jacksonConfiguration.configure(this.objectMapper);
        if (this.requestMappingHandlerAdapter != null) {
            this.findAndConfigure(this.requestMappingHandlerAdapter.getMessageConverters());
        }
        if (this.exceptionHandlerExceptionResolver != null) {
            HandlerMethodReturnValueHandlerComposite handlerMethodReturnValueHandlerComposite = this.exceptionHandlerExceptionResolver.getReturnValueHandlers();
            for (HandlerMethodReturnValueHandler handlerMethodReturnValueHandler : handlerMethodReturnValueHandlerComposite.getHandlers()) {
                try {
                    Field field = FieldUtils.getField((Class)handlerMethodReturnValueHandler.getClass(), (String)"messageConverters", (boolean)true);
                    if (field == null) continue;
                    List list = (List)field.get(handlerMethodReturnValueHandler);
                    this.findAndConfigure(list);
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {}
            }
        }
    }

    private void findAndConfigure(Collection<HttpMessageConverter<?>> collection) {
        collection.stream().filter(httpMessageConverter -> httpMessageConverter instanceof MappingJackson2HttpMessageConverter).map(httpMessageConverter -> (MappingJackson2HttpMessageConverter)httpMessageConverter).forEach(mappingJackson2HttpMessageConverter -> mappingJackson2HttpMessageConverter.setObjectMapper(this.objectMapper));
    }
}

