/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.root;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.CyclosVersion;
import org.cyclos.model.access.BasicInitializationData;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.system.configurations.ConfigurationImageVO;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.ReservedUris;
import org.cyclos.services.access.InitializationService;
import org.cyclos.services.app.InternalFrontendService;
import org.cyclos.utils.ContentType;
import org.cyclos.web.controllers.CacheableContentResolver;
import org.cyclos.web.rest.helpers.ImagesApiHelper;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.NoHandlerFoundException;

@Controller
@RequestMapping(value={"/api"})
public class DocumentationController {
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private InitializationService initializationService;
    @Autowired
    private ImagesApiHelper imagesApiHelper;
    @Autowired
    private InternalFrontendService internalFrontendService;

    @RequestMapping(value={"", "/"})
    public ModelAndView index(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws NoHandlerFoundException {
        if (!this.cyclosProperties.isRestReference()) {
            ServletServerHttpRequest servletServerHttpRequest = new ServletServerHttpRequest(httpServletRequest);
            throw new NoHandlerFoundException(httpServletRequest.getMethod(), httpServletRequest.getRequestURL().toString(), servletServerHttpRequest.getHeaders());
        }
        ServletHelper.forceGuest(httpServletRequest);
        ServletHelper.setNoCache(httpServletResponse);
        RequestData requestData = ServletHelper.getRequestData();
        BasicInitializationData basicInitializationData = this.initializationService.getBasicInitializationData();
        ConfigurationImageVO configurationImageVO = basicInitializationData.getShortcutIcon();
        return new ModelAndView("rest-api").addObject("cyclosVersion", (Object)CyclosVersion.get()).addObject("cyclosCommitId", (Object)CyclosVersion.getCommitId()).addObject("applicationName", (Object)basicInitializationData.getApplicationName()).addObject("resourceCacheKey", (Object)basicInitializationData.getResourceCacheKey()).addObject("reservedUris", (Object)ReservedUris.internal()).addObject("shortcutIconUrl", (Object)this.imagesApiHelper.imageURL((ImageVO)configurationImageVO)).addObject("rootUrl", (Object)requestData.getBaseUrl()).addObject("yamlDescriptor", (Object)(requestData.getApiUrl() + "/openapi.yaml")).addObject("jsonDescriptor", (Object)(requestData.getApiUrl() + "/openapi.json"));
    }

    @RequestMapping(value={"/cyclos-openapi.json", "/openapi.json"})
    public void jsonDescriptor(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.descriptor("openapi.json", httpServletRequest, httpServletResponse);
    }

    @RequestMapping(value={"/cyclos-openapi.yaml", "/openapi.yaml"})
    public void yamlDescriptor(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.descriptor("openapi.yaml", httpServletRequest, httpServletResponse);
    }

    private void descriptor(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        new DescriptorContentResolver(ServletHelper.getRequestData(), string).write(httpServletRequest, httpServletResponse);
    }

    private File getTempFile(String string, RequestData requestData) {
        File file = new File(this.cyclosProperties.getTempDir(), "openapi");
        file.mkdirs();
        String string2 = requestData.getBaseUrl();
        string2 = StringUtils.replaceChars((String)string2, (String)":/.", (String)"___");
        return new File(file, string2 + "." + string);
    }

    private class DescriptorContentResolver
    extends CacheableContentResolver {
        private RequestData requestData;
        private String fileName;
        private File file;

        public DescriptorContentResolver(RequestData requestData, String string) {
            this.requestData = requestData;
            this.fileName = string;
            this.file = DocumentationController.this.getTempFile(string, requestData);
        }

        @Override
        protected String resolveAttachmentName() throws IOException {
            return null;
        }

        @Override
        protected ContentType resolveContentType() throws IOException {
            return ContentType.getByFileName((String)this.fileName);
        }

        @Override
        protected File resolveFile() throws IOException {
            return this.file;
        }

        @Override
        protected Long resolveLastModification() throws IOException {
            String string = DocumentationController.this.internalFrontendService.getApiDescriptorLastModified();
            return string == null ? null : Long.valueOf(Long.parseLong(string));
        }

        @Override
        protected void writeContent(File file) throws IOException {
            String string = CyclosVersion.get();
            String string2 = this.requestData.getBaseUrl();
            String string3 = DocumentationController.this.initializationService.getBasicInitializationData().getApplicationName();
            try (InputStream inputStream = this.getClass().getResourceAsStream("/openapi/" + this.fileName);
                 PrintWriter printWriter = new PrintWriter(file);){
                IOUtils.readLines((InputStream)inputStream, (Charset)StandardCharsets.UTF_8).forEach(string4 -> {
                    string4 = StringUtils.stripEnd((String)string4, null);
                    string4 = StringUtils.replace((String)string4, (String)"@cyclosVersion", (String)string);
                    string4 = StringUtils.replace((String)string4, (String)"@applicationName", (String)string3);
                    string4 = StringUtils.replace((String)string4, (String)"http://root", (String)string2);
                    printWriter.println((String)string4);
                });
            }
        }
    }
}

