/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.banking.vouchers.ActivateGiftVoucherDTO;
import org.cyclos.model.banking.vouchers.ChangeVoucherNotificationSettingsDTO;
import org.cyclos.model.banking.vouchers.SimpleChangeVoucherNotificationSettingsDTO;
import org.cyclos.model.banking.vouchers.SimpleChangeVoucherPinDTO;
import org.cyclos.model.banking.vouchers.UnblockVoucherParams;
import org.cyclos.model.banking.vouchers.VoucherInfoData;
import org.cyclos.model.banking.vouchers.VoucherInfoTransactionsQuery;
import org.cyclos.model.banking.vouchers.VoucherInfoVO;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.api.VoucherInfoApi;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.ImagesApiHelper;
import org.cyclos.web.rest.helpers.PhonesApiHelper;
import org.cyclos.web.rest.helpers.UiApiHelper;
import org.cyclos.web.rest.helpers.VouchersApiHelper;
import org.cyclos.web.rest.model.ActivateGiftVoucher;
import org.cyclos.web.rest.model.ChangeVoucherNotificationSettings;
import org.cyclos.web.rest.model.DataForUi;
import org.cyclos.web.rest.model.DataForVoucherInfo;
import org.cyclos.web.rest.model.SimpleChangeVoucherPin;
import org.cyclos.web.rest.model.VoucherInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VoucherInfoApiHelper {
    @Autowired
    private VouchersApiHelper vouchersApiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private PhonesApiHelper phonesApiHelper;
    @Autowired
    private ImagesApiHelper imagesApiHelper;
    @Autowired
    private UiApiHelper uiApiHelper;

    public ActivateGiftVoucherDTO toActivateGiftVoucher(ActivateGiftVoucher activateGiftVoucher) {
        ActivateGiftVoucherDTO activateGiftVoucherDTO = new ActivateGiftVoucherDTO();
        activateGiftVoucherDTO.setPin(this.toSimpleChangeVoucherPinDto(activateGiftVoucher.getPin()));
        if (activateGiftVoucher.getNotification() != null) {
            activateGiftVoucherDTO.setNotification(this.newSimpleChangeVoucherNotificationSettingsDTO(SimpleChangeVoucherNotificationSettingsDTO.class, activateGiftVoucher.getNotification()));
        }
        return activateGiftVoucherDTO;
    }

    public ChangeVoucherNotificationSettingsDTO toChangeVoucherNotificationSettingsDto(String string, ChangeVoucherNotificationSettings changeVoucherNotificationSettings) {
        if (changeVoucherNotificationSettings == null) {
            return null;
        }
        return this.newSimpleChangeVoucherNotificationSettingsDTO(ChangeVoucherNotificationSettingsDTO.class, changeVoucherNotificationSettings);
    }

    public DataForVoucherInfo toDataForVoucherInfo(VoucherInfoData voucherInfoData) {
        DataForVoucherInfo dataForVoucherInfo = new DataForVoucherInfo();
        DataForUi dataForUi = new DataForUi();
        this.uiApiHelper.fill(dataForUi, voucherInfoData.getInitializationData());
        dataForVoucherInfo.setDataForUi(dataForUi);
        dataForVoucherInfo.setApplicationLogo(this.imagesApiHelper.toImage((ImageVO)voucherInfoData.getApplicationLogo()));
        dataForVoucherInfo.setShortcutIcon(this.imagesApiHelper.toImage((ImageVO)voucherInfoData.getShortcutIcon()));
        dataForVoucherInfo.setLocale(voucherInfoData.getLocale());
        dataForVoucherInfo.setResourceCacheKey(voucherInfoData.getResourceCacheKey());
        dataForVoucherInfo.setMask(voucherInfoData.getMask());
        return dataForVoucherInfo;
    }

    public SimpleChangeVoucherPinDTO toSimpleChangeVoucherPinDto(SimpleChangeVoucherPin simpleChangeVoucherPin) {
        if (simpleChangeVoucherPin == null) {
            return null;
        }
        return this.vouchersApiHelper.newSimpleChangeVoucherPinDTO(SimpleChangeVoucherPinDTO.class, simpleChangeVoucherPin);
    }

    public SimpleChangeVoucherPinDTO toSimpleChangeVoucherPinDto(String string, SimpleChangeVoucherPin simpleChangeVoucherPin) {
        if (simpleChangeVoucherPin == null) {
            return null;
        }
        SimpleChangeVoucherPinDTO simpleChangeVoucherPinDTO = this.vouchersApiHelper.newSimpleChangeVoucherPinDTO(SimpleChangeVoucherPinDTO.class, simpleChangeVoucherPin);
        simpleChangeVoucherPinDTO.setOldPin(string);
        return simpleChangeVoucherPinDTO;
    }

    public UnblockVoucherParams toUnblockVoucherParams(String string, String string2) {
        UnblockVoucherParams unblockVoucherParams = new UnblockVoucherParams();
        unblockVoucherParams.setPin(string2);
        unblockVoucherParams.setToken(string);
        return unblockVoucherParams;
    }

    public VoucherInfo toVoucherInfo(VoucherInfoVO voucherInfoVO) {
        VoucherInfo voucherInfo = new VoucherInfo();
        voucherInfo.setToken(voucherInfoVO.getToken());
        voucherInfo.setCanChangePin(voucherInfoVO.isCanChangePin());
        voucherInfo.setCanChangeNotificationSettings(voucherInfoVO.isCanChangeNotificationSettings());
        voucherInfo.setPinInput(this.authApiHelper.toPasswordInput((ICredentialInputDTO)voucherInfoVO.getPinInput()));
        voucherInfo.setBlockedGiftBy(voucherInfoVO.getBlockedGiftBy());
        voucherInfo.setType(this.vouchersApiHelper.toVoucherType(voucherInfoVO.getType()));
        voucherInfo.setStatus(this.vouchersApiHelper.toVoucherStatusEnum(voucherInfoVO.getStatus()));
        voucherInfo.setAmount(voucherInfoVO.getAmount());
        voucherInfo.setBalance(voucherInfoVO.getBalance());
        voucherInfo.setNotificationsEnabled(voucherInfoVO.isEnableNotifications());
        voucherInfo.setCreationType(this.vouchersApiHelper.toVoucherCreationTypeEnum(voucherInfoVO.getCreationType()));
        voucherInfo.setPhoneConfiguration(this.phonesApiHelper.toPhoneConfiguration(voucherInfoVO.getPhoneConfiguration()));
        voucherInfo.setEmail(voucherInfoVO.getEmail());
        voucherInfo.setMobilePhone(voucherInfoVO.getMobilePhone());
        voucherInfo.setForgotPinCaptchaInput(this.authApiHelper.toCaptchaInput(voucherInfoVO.getForgotPinCaptchaInput()));
        CollectionHelper.orEmpty((List)voucherInfoVO.getForgotPinSendMediums()).stream().map(this.apiHelper::toSendMediumEnum).forEach(voucherInfo.getForgotPinSendMediums()::add);
        voucherInfo.setCreationDate(voucherInfoVO.getCreationDate());
        voucherInfo.setRedeemAfterDate(voucherInfoVO.getRedeemAfterDate());
        voucherInfo.setRedeemAfterDateReached(voucherInfoVO.isRedeemAfterDateReached());
        voucherInfo.setExpirationDate(voucherInfoVO.getExpirationDate());
        voucherInfo.setSingleRedeem(this.vouchersApiHelper.toVoucherTransaction(voucherInfoVO.getSingleRedeem()));
        voucherInfo.setHasTransactions(voucherInfoVO.isHasTransactions());
        voucherInfo.setPersonal(voucherInfoVO.getPersonal());
        CollectionHelper.orEmpty((List)voucherInfoVO.getRedeemOnWeekDays()).stream().map(this.apiHelper::toWeekDayEnum).forEach(voucherInfo.getRedeemOnWeekDays()::add);
        CollectionHelper.orEmpty((List)voucherInfoVO.getCustomValues()).stream().map(this.apiHelper::toCustomFieldValue).forEach(voucherInfo.getCustomValues()::add);
        return voucherInfo;
    }

    public VoucherInfoTransactionsQuery toVoucherInfoTransactionsQuery(VoucherInfoApi.SearchVoucherInfoTransactionsParams searchVoucherInfoTransactionsParams) {
        VoucherInfoTransactionsQuery voucherInfoTransactionsQuery = this.apiHelper.newQuery(VoucherInfoTransactionsQuery.class, searchVoucherInfoTransactionsParams.page, searchVoucherInfoTransactionsParams.pageSize, searchVoucherInfoTransactionsParams.skipTotalCount);
        voucherInfoTransactionsQuery.setToken(searchVoucherInfoTransactionsParams.token);
        return voucherInfoTransactionsQuery;
    }

    private <DTO extends SimpleChangeVoucherNotificationSettingsDTO> DTO newSimpleChangeVoucherNotificationSettingsDTO(Class<DTO> clazz, ChangeVoucherNotificationSettings changeVoucherNotificationSettings) {
        SimpleChangeVoucherNotificationSettingsDTO simpleChangeVoucherNotificationSettingsDTO = (SimpleChangeVoucherNotificationSettingsDTO)ClassHelper.instantiate(clazz);
        simpleChangeVoucherNotificationSettingsDTO.setEmail(changeVoucherNotificationSettings.getEmail());
        simpleChangeVoucherNotificationSettingsDTO.setMobilePhone(changeVoucherNotificationSettings.getMobilePhone());
        simpleChangeVoucherNotificationSettingsDTO.setEnableNotifications(Boolean.TRUE.equals(changeVoucherNotificationSettings.getEnableNotifications()));
        return (DTO)simpleChangeVoucherNotificationSettingsDTO;
    }
}

