/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.ChangeUserStatusData;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.model.users.users.UserStatusLogVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.ChangeUserStatusParams;
import org.cyclos.web.rest.model.UserStatusData;
import org.cyclos.web.rest.model.UserStatusEnum;
import org.cyclos.web.rest.model.UserStatusLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class UserStatusApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    @Lazy
    private UsersApiHelper usersApiHelper;

    public org.cyclos.model.users.users.ChangeUserStatusParams toChangeUserStatusParams(String string, ChangeUserStatusParams changeUserStatusParams) {
        org.cyclos.model.users.users.ChangeUserStatusParams changeUserStatusParams2 = new org.cyclos.model.users.users.ChangeUserStatusParams();
        changeUserStatusParams2.setUser((BasicUserVO)ModelHelper.voFromString(BasicUserVO.class, (String)string));
        changeUserStatusParams2.setStatus(this.toUserStatus(changeUserStatusParams.getStatus()));
        changeUserStatusParams2.setComment(changeUserStatusParams.getComment());
        return changeUserStatusParams2;
    }

    public UserStatus toUserStatus(UserStatusEnum userStatusEnum) {
        if (userStatusEnum != null) {
            switch (userStatusEnum) {
                case ACTIVE: {
                    return UserStatus.ACTIVE;
                }
                case BLOCKED: {
                    return UserStatus.BLOCKED;
                }
                case DISABLED: {
                    return UserStatus.DISABLED;
                }
                case PENDING: {
                    return UserStatus.PENDING;
                }
                case REMOVED: {
                    return UserStatus.REMOVED;
                }
                case PURGED: {
                    return UserStatus.PURGED;
                }
            }
        }
        return null;
    }

    public UserStatusData toUserStatusData(ChangeUserStatusData changeUserStatusData) {
        UserStatusData userStatusData = new UserStatusData();
        userStatusData.setUser(this.usersApiHelper.toUser(changeUserStatusData.getUser()));
        userStatusData.setStatus(this.toUserStatusEnum(changeUserStatusData.getStatus()));
        CollectionHelper.orEmpty((List)changeUserStatusData.getPossibleNewStatuses()).stream().map(this::toUserStatusEnum).forEach(userStatusData.getPossibleNewStatuses()::add);
        CollectionHelper.orEmpty((List)changeUserStatusData.getHistory()).stream().map(this::toUserStatusLog).forEach(userStatusData.getHistory()::add);
        return userStatusData;
    }

    public UserStatusEnum toUserStatusEnum(UserStatus userStatus) {
        if (userStatus != null) {
            switch (userStatus) {
                case ACTIVE: {
                    return UserStatusEnum.ACTIVE;
                }
                case BLOCKED: {
                    return UserStatusEnum.BLOCKED;
                }
                case DISABLED: {
                    return UserStatusEnum.DISABLED;
                }
                case PENDING: {
                    return UserStatusEnum.PENDING;
                }
                case REMOVED: {
                    return UserStatusEnum.REMOVED;
                }
                case PURGED: {
                    return UserStatusEnum.PURGED;
                }
            }
        }
        return null;
    }

    public UserStatusLog toUserStatusLog(UserStatusLogVO userStatusLogVO) {
        UserStatusLog userStatusLog = new UserStatusLog();
        userStatusLog.setBy(this.usersApiHelper.toUser(userStatusLogVO.getBy()));
        userStatusLog.setStatus(this.toUserStatusEnum(userStatusLogVO.getStatus()));
        userStatusLog.setPeriod(this.apiHelper.toDatePeriod(userStatusLogVO.getStartDate(), userStatusLogVO.getEndDate()));
        userStatusLog.setComment(userStatusLogVO.getComment());
        return userStatusLog;
    }
}

