/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transactions.ApproveTicketDTO;
import org.cyclos.model.banking.transactions.ApproveTicketPreviewVO;
import org.cyclos.model.banking.transactions.BaseInternalPaymentPreviewVO;
import org.cyclos.model.banking.transactions.CreateTicketDTO;
import org.cyclos.model.banking.transactions.ProcessTicketDTO;
import org.cyclos.model.banking.transactions.TicketBarcodeParams;
import org.cyclos.model.banking.transactions.TicketProcessResult;
import org.cyclos.model.banking.transactions.TicketResultVO;
import org.cyclos.model.banking.transactions.TicketStatus;
import org.cyclos.model.banking.transactions.TicketVO;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.TimeIntervalDTO;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.PaymentsApiHelper;
import org.cyclos.web.rest.helpers.TransactionsApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.BaseTransactionResult;
import org.cyclos.web.rest.model.ImageSizeEnum;
import org.cyclos.web.rest.model.TicketApprovalResult;
import org.cyclos.web.rest.model.TicketNew;
import org.cyclos.web.rest.model.TicketPreview;
import org.cyclos.web.rest.model.TicketStatusEnum;
import org.cyclos.web.rest.model.TransactionView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TicketsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private PaymentsApiHelper paymentsApiHelper;
    @Autowired
    private TransactionsApiHelper transactionsApiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;

    public void fillTransactionResult(TicketResultVO ticketResultVO, BaseTransactionResult baseTransactionResult) {
        baseTransactionResult.setTicketStatus(this.toTicketStatusEnum(ticketResultVO.getStatus()));
        baseTransactionResult.setExpirationDate(ticketResultVO.getExpirationDate());
    }

    public void fillTransactionView(TicketVO ticketVO, TransactionView transactionView) {
        transactionView.setTicketStatus(this.toTicketStatusEnum(ticketVO.getStatus()));
        transactionView.setExpirationDate(ticketVO.getExpirationDate());
        transactionView.setProcessDate(ticketVO.getProcessDate());
        transactionView.setTransaction(this.transactionsApiHelper.toTransaction((TransactionVO)ticketVO.getPayment()));
        transactionView.setApproveUrl(ticketVO.getApproveUrl());
        transactionView.setCancelUrl(ticketVO.getCancelUrl());
        transactionView.setSuccessUrl(ticketVO.getSuccessUrl());
        transactionView.setPayee(this.usersApiHelper.toUser((BasicUserVO)ticketVO.getPayee()));
        transactionView.setPayer(this.usersApiHelper.toUser((BasicUserVO)ticketVO.getPayer()));
        transactionView.setPayerPrincipal(ticketVO.getPayerPrincipal());
    }

    public ApproveTicketDTO toApproveTicketDTO(String string, String string2) {
        ApproveTicketDTO approveTicketDTO = new ApproveTicketDTO();
        approveTicketDTO.setConfirmationPassword(string2);
        approveTicketDTO.setTicket((TicketVO)ModelHelper.voFromString(TicketVO.class, (String)string));
        return approveTicketDTO;
    }

    public CreateTicketDTO toCreateTicketDTO(String string, TicketNew ticketNew) {
        CreateTicketDTO createTicketDTO = new CreateTicketDTO();
        createTicketDTO.setOwner((InternalAccountOwner)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        createTicketDTO.setPayer((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)ticketNew.getPayer()));
        createTicketDTO.setAmount(ticketNew.getAmount());
        createTicketDTO.setCurrency((CurrencyVO)ModelHelper.voFromString(CurrencyVO.class, (String)ticketNew.getCurrency()));
        createTicketDTO.setCustomValues(this.apiHelper.toCustomFieldValuesDTO(ticketNew.getCustomValues()));
        createTicketDTO.setDescription(ticketNew.getDescription());
        createTicketDTO.setType((TransferTypeVO)ModelHelper.voFromString(TransferTypeVO.class, (String)ticketNew.getType()));
        TimeIntervalDTO timeIntervalDTO = this.apiHelper.toTimeIntervalDTO(ticketNew.getExpiresAfter());
        createTicketDTO.setExpiresAfter(timeIntervalDTO);
        createTicketDTO.setCancelUrl(ticketNew.getCancelUrl());
        createTicketDTO.setSuccessUrl(ticketNew.getSuccessUrl());
        createTicketDTO.setSuccessWebhookUrl(ticketNew.getSuccessWebhook());
        createTicketDTO.setOrderId(ticketNew.getOrderId());
        return createTicketDTO;
    }

    public ProcessTicketDTO toProcessTicketDTO(String string, String string2) {
        ProcessTicketDTO processTicketDTO = new ProcessTicketDTO();
        processTicketDTO.setOrderId(string2);
        processTicketDTO.setTicket((TicketVO)ModelHelper.voFromString(TicketVO.class, (String)string));
        return processTicketDTO;
    }

    public TicketApprovalResult toTicketApprovalResult(TicketVO ticketVO) {
        TicketApprovalResult ticketApprovalResult = this.apiHelper.newEntity(TicketApprovalResult.class, ticketVO);
        ticketApprovalResult.setTicketNumber(ticketVO.getTicketNumber());
        ticketApprovalResult.setTicketStatus(this.toTicketStatusEnum(ticketVO.getStatus()));
        ticketApprovalResult.setCancelUrl(ticketVO.getCancelUrl());
        ticketApprovalResult.setSuccessUrl(ticketVO.getSuccessUrl());
        ticketApprovalResult.setTransaction(this.transactionsApiHelper.toTransaction((TransactionVO)ticketVO.getPayment()));
        return ticketApprovalResult;
    }

    public TicketBarcodeParams toTicketBarcodeParams(String string, ImageSizeEnum imageSizeEnum) {
        TicketBarcodeParams ticketBarcodeParams = new TicketBarcodeParams();
        ticketBarcodeParams.setTicket((TicketVO)ModelHelper.voFromString(TicketVO.class, (String)string));
        ticketBarcodeParams.setSize(this.apiHelper.toImageSize(imageSizeEnum));
        return ticketBarcodeParams;
    }

    public TicketPreview toTicketPreview(ApproveTicketPreviewVO approveTicketPreviewVO) {
        String string = this.accountsApiHelper.identifier((AccountOwner)approveTicketPreviewVO.getPaymentPreview().getToAccount().getOwner());
        TicketPreview ticketPreview = this.paymentsApiHelper.toPreview(TicketPreview.class, (BaseInternalPaymentPreviewVO)approveTicketPreviewVO.getPaymentPreview(), string);
        ticketPreview.setCancelUrl(approveTicketPreviewVO.getTicket().getCancelUrl());
        ticketPreview.setSuccessUrl(approveTicketPreviewVO.getTicket().getSuccessUrl());
        return ticketPreview;
    }

    public org.cyclos.web.rest.model.TicketProcessResult toTicketProcessResult(List<String> list, TicketProcessResult ticketProcessResult) {
        TicketVO ticketVO = ticketProcessResult.getTicket();
        org.cyclos.web.rest.model.TicketProcessResult ticketProcessResult2 = this.apiHelper.newEntity(org.cyclos.web.rest.model.TicketProcessResult.class, ticketVO);
        ticketProcessResult2.setTicketNumber(ticketVO.getTicketNumber());
        ticketProcessResult2.setTransaction(this.transactionsApiHelper.toTransaction((TransactionVO)ticketVO.getPayment()));
        ticketProcessResult2.setActuallyProcessed(ticketProcessResult.isActuallyProcessed());
        return ticketProcessResult2;
    }

    public TicketStatus toTicketStatus(TicketStatusEnum ticketStatusEnum) {
        switch (ticketStatusEnum) {
            case CANCELED: {
                return TicketStatus.CANCELED;
            }
            case EXPIRED: {
                return TicketStatus.EXPIRED;
            }
            case OPEN: {
                return TicketStatus.OPEN;
            }
            case PROCESSED: {
                return TicketStatus.PROCESSED;
            }
            case APPROVED: {
                return TicketStatus.APPROVED;
            }
        }
        return null;
    }

    public TicketStatusEnum toTicketStatusEnum(TicketStatus ticketStatus) {
        switch (ticketStatus) {
            case CANCELED: {
                return TicketStatusEnum.CANCELED;
            }
            case EXPIRED: {
                return TicketStatusEnum.EXPIRED;
            }
            case OPEN: {
                return TicketStatusEnum.OPEN;
            }
            case PROCESSED: {
                return TicketStatusEnum.PROCESSED;
            }
            case APPROVED: {
                return TicketStatusEnum.APPROVED;
            }
        }
        return null;
    }
}

