/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.model.EntityModel;
import org.cyclos.model.EntityVO;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.access.channels.ChannelVO;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.ConnectedUserQuery;
import org.cyclos.model.users.users.ConnectedUserSearchData;
import org.cyclos.model.users.users.ConnectedUserVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.model.access.login.AuthVO;
import org.cyclos.services.access.LoginUserDTO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.GroupsApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.LoginUser;
import org.cyclos.web.rest.model.SessionDataForSearch;
import org.cyclos.web.rest.model.SessionQueryFilters;
import org.cyclos.web.rest.model.SessionResult;
import org.cyclos.web.rest.model.UserAuth;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SessionsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;
    @Autowired
    private GroupsApiHelper groupsApiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;

    public ConnectedUserQuery toConnectedUserQuery(SessionQueryFilters sessionQueryFilters) {
        if (sessionQueryFilters == null) {
            return null;
        }
        ConnectedUserQuery connectedUserQuery = this.apiHelper.newQuery(ConnectedUserQuery.class, sessionQueryFilters);
        connectedUserQuery.setExcludeCurrentSession(Boolean.TRUE.equals(sessionQueryFilters.getExcludeCurrentSession()));
        connectedUserQuery.setRoles(CollectionHelper.orEmpty(sessionQueryFilters.getRoles()).stream().map(this.authApiHelper::toRole).collect(Collectors.toSet()));
        connectedUserQuery.setChannels(ModelHelper.vosFromString(ChannelVO.class, sessionQueryFilters.getChannels()));
        connectedUserQuery.setBroker((UserVO)ModelHelper.voFromString(UserVO.class, (String)sessionQueryFilters.getBroker()));
        connectedUserQuery.setOperatorsOf((UserVO)ModelHelper.voFromString(UserVO.class, (String)sessionQueryFilters.getOperatorsOf()));
        connectedUserQuery.setUser((BasicUserVO)ModelHelper.voFromString(UserVO.class, (String)sessionQueryFilters.getUser()));
        return connectedUserQuery;
    }

    public SessionDataForSearch toDataForSearch(ConnectedUserSearchData connectedUserSearchData) {
        SessionDataForSearch sessionDataForSearch = new SessionDataForSearch();
        CollectionHelper.orEmpty((Set)connectedUserSearchData.getRoles()).stream().map(this.authApiHelper::toRoleEnum).forEach(sessionDataForSearch.getRoles()::add);
        CollectionHelper.orEmpty((List)connectedUserSearchData.getChannels()).stream().map(this.apiHelper::toReference).forEach(sessionDataForSearch.getChannels()::add);
        sessionDataForSearch.setQuery(this.toSessionQueryFilters((ConnectedUserQuery)connectedUserSearchData.getQuery()));
        return sessionDataForSearch;
    }

    public LoginUserDTO toLoginUserDTO(LoginUser loginUser) {
        if (loginUser == null) {
            return null;
        }
        LoginUserDTO loginUserDTO = new LoginUserDTO();
        loginUserDTO.setUser(ModelHelper.userLocator((String)loginUser.getUser(), (boolean)false));
        loginUserDTO.setPassword(loginUser.getPassword());
        loginUserDTO.setRemoteAddress(loginUser.getRemoteAddress());
        loginUserDTO.setChannel(loginUser.getChannel());
        loginUserDTO.setSessionTimeout(this.apiHelper.toTimeIntervalDTO(loginUser.getSessionTimeout()));
        loginUserDTO.setUserAgentId(loginUser.getUserAgentId());
        return loginUserDTO;
    }

    public SessionResult toSessionResult(ConnectedUserVO connectedUserVO) {
        if (connectedUserVO == null) {
            return null;
        }
        SessionResult sessionResult = new SessionResult();
        sessionResult.setChannel(this.apiHelper.toReference((EntityModel)connectedUserVO.getChannel()));
        sessionResult.setCreationDate(connectedUserVO.getCreationDate());
        sessionResult.setCurrentSession(connectedUserVO.isCurrentSession());
        sessionResult.setRemoteAddress(connectedUserVO.getRemoteAddress());
        sessionResult.setSessionToken(connectedUserVO.getSessionToken());
        sessionResult.setUser(this.usersApiHelper.toUser(connectedUserVO.getUser()));
        return sessionResult;
    }

    public UserAuth toUserAuth(AuthVO authVO) {
        if (authVO == null) {
            return null;
        }
        UserAuth userAuth = this.authApiHelper.newAuth(UserAuth.class, authVO);
        userAuth.setSessionToken(authVO.getSessionToken());
        userAuth.setConfiguration(this.apiHelper.toVersionedReference(authVO.getConfiguration(), authVO.getConfigurationVersion()));
        userAuth.setGroup(this.groupsApiHelper.toGroup((BasicGroupVO)authVO.getGroup()));
        return userAuth;
    }

    private SessionQueryFilters toSessionQueryFilters(ConnectedUserQuery connectedUserQuery) {
        if (connectedUserQuery == null) {
            return null;
        }
        SessionQueryFilters sessionQueryFilters = this.apiHelper.newQueryFilters(SessionQueryFilters.class, (QueryParameters)connectedUserQuery);
        if (connectedUserQuery.isExcludeCurrentSession()) {
            sessionQueryFilters.setExcludeCurrentSession(true);
        }
        CollectionHelper.orEmpty((Set)connectedUserQuery.getRoles()).stream().map(this.authApiHelper::toRoleEnum).distinct().forEach(sessionQueryFilters.getRoles()::add);
        sessionQueryFilters.setBroker(ModelHelper.stringOrIdFromVO((EntityVO)connectedUserQuery.getBroker()));
        sessionQueryFilters.setUser(ModelHelper.stringOrIdFromVO((EntityVO)connectedUserQuery.getUser()));
        CollectionHelper.orEmpty((Set)connectedUserQuery.getChannels()).stream().map(ModelHelper::internalNameOrId).forEach(sessionQueryFilters.getChannels()::add);
        sessionQueryFilters.setOperatorsOf(ModelHelper.stringOrIdFromVO((EntityVO)connectedUserQuery.getOperatorsOf()));
        return sessionQueryFilters;
    }
}

