/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.model.EntityModel;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.devices.DeviceConfirmationFeedbackPushNotificationData;
import org.cyclos.model.access.devices.DeviceConfirmationVO;
import org.cyclos.model.access.identityproviders.IdentityProviderCallbackResult;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.AccountWithStatusVO;
import org.cyclos.model.banking.transactions.TicketVO;
import org.cyclos.model.banking.transactions.TransactionDetailedVO;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.messaging.messages.IncomingMessageVO;
import org.cyclos.model.messaging.messages.NewMessagePushNotificationData;
import org.cyclos.model.messaging.notifications.NewNotificationPushNotificationData;
import org.cyclos.model.messaging.notifications.NotificationVO;
import org.cyclos.model.messaging.notifications.NotificationsStatusVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.utils.PushNotificationEvent;
import org.cyclos.model.utils.PushNotificationEventFilter;
import org.cyclos.model.utils.PushNotificationEventType;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rest.api.PushApi;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.DeviceConfirmationsApiHelper;
import org.cyclos.web.rest.helpers.IdentityProvidersApiHelper;
import org.cyclos.web.rest.helpers.NotificationsApiHelper;
import org.cyclos.web.rest.helpers.TransactionsApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.DeviceConfirmationFeedbackPush;
import org.cyclos.web.rest.model.IncomingMessage;
import org.cyclos.web.rest.model.NewMessagePush;
import org.cyclos.web.rest.model.NewNotificationPush;
import org.cyclos.web.rest.model.PushNotificationEventKind;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PushApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private NotificationsApiHelper notificationsApiHelper;
    @Autowired
    private TransactionsApiHelper transactionsApiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    private DeviceConfirmationsApiHelper deviceConfirmationsApiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private IdentityProvidersApiHelper identityProviderApiHelper;

    public Object getData(PushNotificationEvent<?> pushNotificationEvent) {
        PushNotificationEventType pushNotificationEventType = pushNotificationEvent.getType();
        if (pushNotificationEventType == PushNotificationEventType.NEW_NOTIFICATION) {
            NewNotificationPushNotificationData newNotificationPushNotificationData = (NewNotificationPushNotificationData)pushNotificationEvent.getData();
            NewNotificationPush newNotificationPush = new NewNotificationPush();
            NotificationVO notificationVO = newNotificationPushNotificationData.getNotification();
            newNotificationPush.setNotification(this.notificationsApiHelper.toNotification(notificationVO, notificationVO.getType().getNotificationEntityType()));
            NotificationsStatusVO notificationsStatusVO = newNotificationPushNotificationData.getNotificationsStatus();
            newNotificationPush.setNewNotifications(notificationsStatusVO.getNewNotifications());
            newNotificationPush.setUnreadNotifications(notificationsStatusVO.getUnreadNotifications());
            return newNotificationPush;
        }
        if (pushNotificationEventType == PushNotificationEventType.NEW_MESSAGE) {
            NewMessagePushNotificationData newMessagePushNotificationData = (NewMessagePushNotificationData)pushNotificationEvent.getData();
            NewMessagePush newMessagePush = new NewMessagePush();
            newMessagePush.setMessage(this.toIncomingMessage(newMessagePushNotificationData.getMessage()));
            newMessagePush.setNewMessages(newMessagePushNotificationData.getNewMessages());
            newMessagePush.setUnreadMessages(newMessagePushNotificationData.getUnreadMessages());
            return newMessagePush;
        }
        if (pushNotificationEventType == PushNotificationEventType.LOGGED_OUT || pushNotificationEventType == PushNotificationEventType.PERMISSIONS_CHANGED) {
            return null;
        }
        if (pushNotificationEventType == PushNotificationEventType.TICKET) {
            TicketVO ticketVO = (TicketVO)pushNotificationEvent.getData();
            return this.transactionsApiHelper.toTransactionView((TransactionDetailedVO)ticketVO);
        }
        if (pushNotificationEventType == PushNotificationEventType.ACCOUNT_STATUS) {
            AccountWithStatusVO accountWithStatusVO = (AccountWithStatusVO)pushNotificationEvent.getData();
            return this.accountsApiHelper.toAccountWithStatus((AccountVO)accountWithStatusVO);
        }
        if (pushNotificationEventType == PushNotificationEventType.DEVICE_CONFIRMATION) {
            DeviceConfirmationVO deviceConfirmationVO = (DeviceConfirmationVO)pushNotificationEvent.getData();
            return this.deviceConfirmationsApiHelper.toDeviceConfirmationView(deviceConfirmationVO);
        }
        if (pushNotificationEventType == PushNotificationEventType.DEVICE_CONFIRMATION_FEEDBACK) {
            DeviceConfirmationFeedbackPushNotificationData deviceConfirmationFeedbackPushNotificationData = (DeviceConfirmationFeedbackPushNotificationData)pushNotificationEvent.getData();
            DeviceConfirmationFeedbackPush deviceConfirmationFeedbackPush = new DeviceConfirmationFeedbackPush();
            deviceConfirmationFeedbackPush.setDeviceConfirmation(this.deviceConfirmationsApiHelper.toDeviceConfirmationView(deviceConfirmationFeedbackPushNotificationData.getDeviceConfirmation()));
            deviceConfirmationFeedbackPush.setSuccessful(deviceConfirmationFeedbackPushNotificationData.isSuccessful());
            return deviceConfirmationFeedbackPush;
        }
        if (pushNotificationEventType == PushNotificationEventType.PAYMENT_AUTHORIZATION) {
            TransactionVO transactionVO = (TransactionVO)pushNotificationEvent.getData();
            return this.transactionsApiHelper.toTransaction(transactionVO);
        }
        if (pushNotificationEventType == PushNotificationEventType.IDENTITY_PROVIDER_CALLBACK) {
            IdentityProviderCallbackResult identityProviderCallbackResult = (IdentityProviderCallbackResult)pushNotificationEvent.getData();
            return this.identityProviderApiHelper.toIdentityProviderCallbackResult(identityProviderCallbackResult);
        }
        throw new IllegalStateException("Unhandled push notification event type: " + String.valueOf(pushNotificationEventType));
    }

    public PushNotificationEventFilter toPushNotificationEventFilter(PushApi.SubscribeForPushNotificationsParams subscribeForPushNotificationsParams) {
        Set set = CollectionHelper.orEmpty(subscribeForPushNotificationsParams.kinds).stream().filter(Objects::nonNull).map(this::toPushNotificationEventType).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set.isEmpty()) {
            throw new ValidationException("No valid event types specified");
        }
        PushNotificationEventFilter pushNotificationEventFilter = new PushNotificationEventFilter();
        pushNotificationEventFilter.setTypes(set);
        pushNotificationEventFilter.setTicketNumber(subscribeForPushNotificationsParams.ticketNumber);
        pushNotificationEventFilter.setDeviceConfirmationId(subscribeForPushNotificationsParams.deviceConfirmationId);
        pushNotificationEventFilter.setIdentityProviderRequestId(subscribeForPushNotificationsParams.identityProviderRequestId);
        return pushNotificationEventFilter;
    }

    public PushNotificationEventKind toPushNotificationEventKind(PushNotificationEventType<?> pushNotificationEventType) {
        return pushNotificationEventType == null ? null : PushNotificationEventKind.valueOf(StringHelper.transformCase((String)pushNotificationEventType.getName(), (boolean)true, (char)'_'));
    }

    public PushNotificationEventType<?> toPushNotificationEventType(PushNotificationEventKind pushNotificationEventKind) {
        return pushNotificationEventKind == null ? null : PushNotificationEventType.getByName((String)pushNotificationEventKind.toString());
    }

    private IncomingMessage toIncomingMessage(IncomingMessageVO incomingMessageVO) {
        if (incomingMessageVO == null) {
            return null;
        }
        IncomingMessage incomingMessage = this.apiHelper.newEntity(IncomingMessage.class, incomingMessageVO);
        incomingMessage.setDate(incomingMessageVO.getDate());
        incomingMessage.setCategory(this.apiHelper.toReference((EntityModel)incomingMessageVO.getCategory()));
        incomingMessage.setFromUser(this.usersApiHelper.toUser((BasicUserVO)incomingMessageVO.getFromUser()));
        incomingMessage.setSubject(incomingMessageVO.getSubject());
        incomingMessage.setBody(incomingMessageVO.getBody());
        return incomingMessage;
    }
}

