/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.users.phones.CodeVerificationStatus;
import org.cyclos.model.users.phones.LandLinePhoneDTO;
import org.cyclos.model.users.phones.ManagedPhoneVO;
import org.cyclos.model.users.phones.MobilePhoneDTO;
import org.cyclos.model.users.phones.MobilePhoneData;
import org.cyclos.model.users.phones.PhoneConfigurationData;
import org.cyclos.model.users.phones.PhoneDTO;
import org.cyclos.model.users.phones.PhoneData;
import org.cyclos.model.users.phones.PhoneListData;
import org.cyclos.model.users.phones.PhoneNature;
import org.cyclos.model.users.phones.PhoneVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.model.users.users.UserProfilePhonesData;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.services.users.PhoneService;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.AvailabilityEnum;
import org.cyclos.web.rest.model.CodeVerificationStatusEnum;
import org.cyclos.web.rest.model.Phone;
import org.cyclos.web.rest.model.PhoneBasicData;
import org.cyclos.web.rest.model.PhoneConfiguration;
import org.cyclos.web.rest.model.PhoneConfigurationForUserProfile;
import org.cyclos.web.rest.model.PhoneDataForEdit;
import org.cyclos.web.rest.model.PhoneDataForNew;
import org.cyclos.web.rest.model.PhoneEdit;
import org.cyclos.web.rest.model.PhoneEditWithId;
import org.cyclos.web.rest.model.PhoneKind;
import org.cyclos.web.rest.model.PhoneManage;
import org.cyclos.web.rest.model.PhoneNew;
import org.cyclos.web.rest.model.PhoneResult;
import org.cyclos.web.rest.model.PhoneView;
import org.cyclos.web.rest.model.UserPhonesListData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PhonesApiHelper {
    @Autowired
    private PhoneService phoneService;
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;

    public Long ensureId(String string) {
        PhoneVO phoneVO = (PhoneVO)ModelHelper.voFromString(PhoneVO.class, (String)string);
        if (phoneVO == null || phoneVO.getId() == null && StringHelper.isBlank((Object)phoneVO.getNumber())) {
            throw new EntityNotFoundException(Phone.class, string);
        }
        if (phoneVO.getId() != null) {
            return phoneVO.getId();
        }
        return this.phoneService.loadByNumber(phoneVO.getNumber()).getId();
    }

    public <PC extends PhoneConfiguration> PC newPhoneConfiguration(Class<PC> clazz, PhoneConfigurationData phoneConfigurationData) {
        PhoneConfiguration phoneConfiguration = (PhoneConfiguration)ClassHelper.instantiate(clazz);
        phoneConfiguration.setExtensionEnabled(phoneConfigurationData.isExtensionEnabled());
        phoneConfiguration.setSmsEnabled(phoneConfigurationData.isSmsEnabled());
        phoneConfiguration.setMobileExample(phoneConfigurationData.getMobileExample());
        phoneConfiguration.setLandLineExample(phoneConfigurationData.getLandLineExample());
        phoneConfiguration.setCountry(phoneConfigurationData.getCountry());
        phoneConfiguration.setAlwaysShowInternationalNumber(phoneConfigurationData.isAlwaysShowInternationalPhoneNumber());
        return (PC)phoneConfiguration;
    }

    public CodeVerificationStatusEnum toCodeVerificationStatusEnum(CodeVerificationStatus codeVerificationStatus) {
        if (codeVerificationStatus != null) {
            switch (codeVerificationStatus) {
                case SUCCESS: {
                    return CodeVerificationStatusEnum.SUCCESS;
                }
                case FAILED: {
                    return CodeVerificationStatusEnum.FAILED;
                }
                case MAX_ATTEMPTS_REACHED: {
                    return CodeVerificationStatusEnum.MAX_ATTEMPTS_REACHED;
                }
            }
        }
        return null;
    }

    public PhoneDataForEdit toDataForEdit(PhoneData phoneData) {
        PhoneDataForEdit phoneDataForEdit = new PhoneDataForEdit();
        this.fill(phoneDataForEdit, phoneData);
        phoneDataForEdit.setCanEdit(phoneData.isEditable() && !phoneData.isCanOnlySetPrivate());
        phoneDataForEdit.setCanRemove(phoneData.isRemovable());
        phoneDataForEdit.setPhone(this.toPhoneEdit((PhoneDTO)phoneData.getDto()));
        return phoneDataForEdit;
    }

    public PhoneDataForNew toDataForNew(PhoneData phoneData) {
        PhoneDataForNew phoneDataForNew = new PhoneDataForNew();
        phoneDataForNew.setPhone(this.toPhoneNew((PhoneDTO)phoneData.getDto()));
        this.fill(phoneDataForNew, phoneData);
        if (phoneData.getDto() instanceof MobilePhoneDTO) {
            phoneDataForNew.setExample(phoneData.getConfiguration().getMobileExample());
        } else {
            phoneDataForNew.setExample(phoneData.getConfiguration().getLandLineExample());
        }
        return phoneDataForNew;
    }

    public LandLinePhoneDTO toLandLinePhoneDTO(PhoneManage phoneManage) {
        if (phoneManage == null) {
            return null;
        }
        LandLinePhoneDTO landLinePhoneDTO = this.toPhoneDTO(LandLinePhoneDTO.class, phoneManage);
        landLinePhoneDTO.setExtension(phoneManage.getExtension());
        return landLinePhoneDTO;
    }

    public MobilePhoneDTO toMobilePhoneDTO(PhoneManage phoneManage) {
        if (phoneManage == null) {
            return null;
        }
        MobilePhoneDTO mobilePhoneDTO = this.toPhoneDTO(MobilePhoneDTO.class, phoneManage);
        mobilePhoneDTO.setEnabledForSms(Boolean.TRUE.equals(phoneManage.getEnabledForSms()));
        mobilePhoneDTO.setVerified(Boolean.TRUE.equals(phoneManage.getVerified()));
        return mobilePhoneDTO;
    }

    public Phone toPhone(PhoneVO phoneVO) {
        if (phoneVO == null) {
            return null;
        }
        Phone phone = this.apiHelper.newEntity(Phone.class, phoneVO);
        phone.setExtension(phoneVO.getExtension());
        phone.setNumber(phoneVO.getFormattedNumber());
        phone.setType(this.toPhoneKind(phoneVO.getNature()));
        phone.setNormalizedNumber(phoneVO.getNormalizedNumber());
        return phone;
    }

    public PhoneConfiguration toPhoneConfiguration(PhoneConfigurationData phoneConfigurationData) {
        if (phoneConfigurationData == null) {
            return null;
        }
        return this.newPhoneConfiguration(PhoneConfiguration.class, phoneConfigurationData);
    }

    public PhoneConfigurationForUserProfile toPhoneConfigurationForUserProfile(UserProfilePhonesData userProfilePhonesData) {
        if (userProfilePhonesData == null) {
            PhoneConfigurationForUserProfile phoneConfigurationForUserProfile = new PhoneConfigurationForUserProfile();
            phoneConfigurationForUserProfile.setMobileAvailability(AvailabilityEnum.DISABLED);
            phoneConfigurationForUserProfile.setMaxMobiles(0);
            phoneConfigurationForUserProfile.setLandLineAvailability(AvailabilityEnum.DISABLED);
            phoneConfigurationForUserProfile.setMaxLandLines(0);
            phoneConfigurationForUserProfile.setEdit(false);
            phoneConfigurationForUserProfile.setManagePrivacy(false);
            return phoneConfigurationForUserProfile;
        }
        PhoneConfigurationForUserProfile phoneConfigurationForUserProfile = this.newPhoneConfiguration(PhoneConfigurationForUserProfile.class, userProfilePhonesData.getConfiguration());
        phoneConfigurationForUserProfile.setEdit(userProfilePhonesData.isEdit());
        phoneConfigurationForUserProfile.setManagePrivacy(userProfilePhonesData.isManagePrivacy());
        phoneConfigurationForUserProfile.setLandLineAvailability(this.apiHelper.toAvailability(userProfilePhonesData.getMaxLandLines() > 0, userProfilePhonesData.isLandLineRequired()));
        phoneConfigurationForUserProfile.setMaxLandLines(userProfilePhonesData.getMaxLandLines());
        phoneConfigurationForUserProfile.setLandLinePhone(this.toPhoneNew((PhoneDTO)userProfilePhonesData.getLandLinePhone()));
        phoneConfigurationForUserProfile.setMobileAvailability(this.apiHelper.toAvailability(userProfilePhonesData.getMaxMobiles() > 0, userProfilePhonesData.isMobileRequired()));
        phoneConfigurationForUserProfile.setMaxMobiles(userProfilePhonesData.getMaxMobiles());
        phoneConfigurationForUserProfile.setMobilePhone(this.toPhoneNew((PhoneDTO)userProfilePhonesData.getMobilePhone()));
        return phoneConfigurationForUserProfile;
    }

    public PhoneEdit toPhoneEdit(PhoneDTO phoneDTO) {
        if (phoneDTO == null) {
            return null;
        }
        return this.newPhoneEdit(PhoneEdit.class, phoneDTO);
    }

    public PhoneEditWithId toPhoneEditWithId(PhoneDTO phoneDTO) {
        if (phoneDTO == null) {
            return null;
        }
        PhoneEditWithId phoneEditWithId = this.newPhoneEdit(PhoneEditWithId.class, phoneDTO);
        phoneEditWithId.setId(ApiHelper.toId(phoneDTO.getId()));
        return phoneEditWithId;
    }

    public PhoneKind toPhoneKind(PhoneNature phoneNature) {
        if (phoneNature != null) {
            switch (phoneNature) {
                case LANDLINE: {
                    return PhoneKind.LAND_LINE;
                }
                case MOBILE: {
                    return PhoneKind.MOBILE;
                }
            }
        }
        return null;
    }

    public PhoneNature toPhoneNature(PhoneKind phoneKind) {
        if (phoneKind != null) {
            switch (phoneKind) {
                case LAND_LINE: {
                    return PhoneNature.LANDLINE;
                }
                case MOBILE: {
                    return PhoneNature.MOBILE;
                }
            }
        }
        return null;
    }

    public PhoneNew toPhoneNew(PhoneDTO phoneDTO) {
        if (phoneDTO == null) {
            return null;
        }
        PhoneNew phoneNew = this.newPhoneManage(PhoneNew.class, phoneDTO);
        phoneNew.setKind(phoneDTO instanceof LandLinePhoneDTO ? PhoneKind.LAND_LINE : PhoneKind.MOBILE);
        phoneNew.setEnabledForSms(null);
        phoneNew.setVerified(null);
        return phoneNew;
    }

    public PhoneResult toPhoneResult(PhoneVO phoneVO) {
        if (phoneVO == null) {
            return null;
        }
        return this.toPhoneResult(PhoneResult.class, phoneVO);
    }

    public PhoneView toPhoneView(PhoneData phoneData) {
        PhoneDTO phoneDTO = (PhoneDTO)phoneData.getDto();
        PhoneView phoneView = this.apiHelper.newEntity(PhoneView.class, phoneDTO);
        phoneView.setCanEdit(phoneData.isEditable());
        phoneView.setUser(this.usersApiHelper.toUser(phoneDTO.getUser()));
        phoneView.setName(phoneDTO.getName());
        phoneView.setNumber(phoneDTO.getFormattedNumber());
        phoneView.setNormalizedNumber(phoneDTO.getNormalizedNumber());
        phoneView.setHidden(phoneDTO.isHidden());
        phoneView.setEnablePrivacy(phoneData.isEnablePrivacy());
        if (phoneDTO instanceof LandLinePhoneDTO) {
            LandLinePhoneDTO landLinePhoneDTO = (LandLinePhoneDTO)phoneDTO;
            phoneView.setType(PhoneKind.LAND_LINE);
            phoneView.setExtension(landLinePhoneDTO.getExtension());
        } else if (phoneDTO instanceof MobilePhoneDTO) {
            MobilePhoneDTO mobilePhoneDTO = (MobilePhoneDTO)phoneDTO;
            phoneView.setType(PhoneKind.MOBILE);
            phoneView.setEnabledForSms(mobilePhoneDTO.isEnabledForSms());
            phoneView.setVerified(mobilePhoneDTO.isVerified());
            phoneView.setVerificationCodeSendDate(mobilePhoneDTO.getVerificationCodeSendDate());
        }
        return phoneView;
    }

    public PhoneView toPhoneView(PhoneVO phoneVO) {
        if (phoneVO == null) {
            return null;
        }
        return this.toPhoneResult(PhoneView.class, phoneVO);
    }

    public UserPhonesListData toUserPhonesListData(PhoneListData phoneListData) {
        UserPhonesListData userPhonesListData = new UserPhonesListData();
        userPhonesListData.setUser(this.usersApiHelper.toUser((BasicUserVO)phoneListData.getUser()));
        userPhonesListData.setCanEdit(phoneListData.isManagesPhones());
        userPhonesListData.setSmsEnabled(phoneListData.isSmsEnabled());
        userPhonesListData.setMaxLandLinePhones(phoneListData.getMaxLandLinePhones());
        userPhonesListData.setMaxMobilePhones(phoneListData.getMaxMobilePhones());
        userPhonesListData.setCanCreateLandLine(phoneListData.isCanCreateLandlinePhone());
        userPhonesListData.setCanCreateMobile(phoneListData.isCanCreateMobilePhone());
        userPhonesListData.setCanVerify(phoneListData.isCanVerify());
        userPhonesListData.setEnablePrivacy(phoneListData.isEnablePrivacy());
        userPhonesListData.setCanEnableForSms(phoneListData.isCanEnableForSms());
        phoneListData.getPhones().stream().map(this::toPhoneResult).forEach(userPhonesListData.getPhones()::add);
        userPhonesListData.setLandLineAvailability(this.apiHelper.toAvailability(phoneListData.getMaxLandLinePhones() == null || phoneListData.getMaxLandLinePhones() != 0, phoneListData.isLandLineRequired()));
        userPhonesListData.setMobileAvailability(this.apiHelper.toAvailability(phoneListData.getMaxMobilePhones() == null || phoneListData.getMaxMobilePhones() != 0, phoneListData.isMobileRequired()));
        return userPhonesListData;
    }

    private void fill(PhoneBasicData phoneBasicData, PhoneData phoneData) {
        phoneBasicData.setUser(this.usersApiHelper.toUser(((PhoneDTO)phoneData.getDto()).getUser()));
        phoneBasicData.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput(phoneData.getConfirmationPasswordInput()));
        PhoneConfigurationData phoneConfigurationData = phoneData.getConfiguration();
        boolean bl = phoneData.getDto() instanceof MobilePhoneDTO;
        phoneBasicData.setType(bl ? PhoneKind.MOBILE : PhoneKind.LAND_LINE);
        phoneBasicData.setCountry(phoneConfigurationData.getCountry());
        phoneBasicData.setAlwaysShowInternationalNumber(phoneConfigurationData.isAlwaysShowInternationalPhoneNumber());
        phoneBasicData.setEnablePrivacy(phoneData.isEnablePrivacy());
        phoneBasicData.setManagePrivacy(phoneData.isCanManagePrivacy());
        if (bl) {
            phoneBasicData.setSmsEnabled(phoneConfigurationData.isSmsEnabled());
            phoneBasicData.setExample(phoneConfigurationData.getMobileExample());
            phoneBasicData.setManuallyVerify(((MobilePhoneData)phoneData).isCanManuallyVerify());
        } else {
            phoneBasicData.setExtensionEnabled(phoneConfigurationData.isExtensionEnabled());
            phoneBasicData.setExample(phoneConfigurationData.getLandLineExample());
        }
    }

    private <E extends PhoneEdit> E newPhoneEdit(Class<E> clazz, PhoneDTO phoneDTO) {
        PhoneEdit phoneEdit = (PhoneEdit)this.newPhoneManage(clazz, phoneDTO);
        phoneEdit.setVersion(phoneDTO.getVersion());
        return (E)phoneEdit;
    }

    private <P extends PhoneManage> P newPhoneManage(Class<P> clazz, PhoneDTO phoneDTO) {
        PhoneManage phoneManage = (PhoneManage)ClassHelper.instantiate(clazz);
        phoneManage.setName(phoneDTO.getName());
        phoneManage.setNumber(phoneDTO.getRawNumber());
        phoneManage.setHidden(phoneDTO.isHidden());
        if (phoneDTO instanceof MobilePhoneDTO) {
            MobilePhoneDTO mobilePhoneDTO = (MobilePhoneDTO)phoneDTO;
            phoneManage.setEnabledForSms(mobilePhoneDTO.isEnabledForSms());
            phoneManage.setVerified(mobilePhoneDTO.isVerified());
        } else if (phoneDTO instanceof LandLinePhoneDTO) {
            LandLinePhoneDTO landLinePhoneDTO = (LandLinePhoneDTO)phoneDTO;
            phoneManage.setExtension(landLinePhoneDTO.getExtension());
        }
        return (P)phoneManage;
    }

    private <T extends PhoneDTO> T toPhoneDTO(Class<T> clazz, PhoneManage phoneManage) {
        PhoneDTO phoneDTO = (PhoneDTO)ClassHelper.instantiate(clazz);
        phoneDTO.setName(phoneManage.getName());
        phoneDTO.setRawNumber(phoneManage.getNumber());
        phoneDTO.setHidden(Boolean.TRUE.equals(phoneManage.getHidden()));
        if (phoneManage instanceof PhoneEdit) {
            phoneDTO.setVersion(((PhoneEdit)phoneManage).getVersion());
            if (phoneManage instanceof PhoneEditWithId) {
                phoneDTO.setId(this.apiHelper.fromId(((PhoneEditWithId)phoneManage).getId()));
            }
        }
        return (T)phoneDTO;
    }

    private <R extends PhoneResult> R toPhoneResult(Class<R> clazz, PhoneVO phoneVO) {
        PhoneResult phoneResult = (PhoneResult)this.apiHelper.newEntity(clazz, phoneVO);
        phoneResult.setName(phoneVO.getName());
        phoneResult.setNumber(phoneVO.getFormattedNumber());
        phoneResult.setNormalizedNumber(phoneVO.getNormalizedNumber());
        phoneResult.setType(this.toPhoneKind(phoneVO.getNature()));
        phoneResult.setExtension(phoneVO.getExtension());
        if (phoneVO instanceof ManagedPhoneVO) {
            ManagedPhoneVO managedPhoneVO = (ManagedPhoneVO)phoneVO;
            phoneResult.setEnabledForSms(managedPhoneVO.isEnabledForSms());
            phoneResult.setVerified(managedPhoneVO.isVerified());
            phoneResult.setVerificationCodeSendDate(managedPhoneVO.getVerificationCodeSendDate());
            phoneResult.setHidden(managedPhoneVO.isHidden());
        } else {
            phoneResult.setHidden(false);
        }
        return (R)phoneResult;
    }
}

