/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import org.cyclos.model.EntityModel;
import org.cyclos.model.banking.transactions.BaseInternalPaymentPreviewVO;
import org.cyclos.model.banking.transactions.BasePaymentPreviewVO;
import org.cyclos.model.banking.transactions.PaymentPreviewVO;
import org.cyclos.model.banking.transactions.PerformBasePaymentDTO;
import org.cyclos.model.banking.transactions.PerformPaymentDTO;
import org.cyclos.model.banking.transactions.PerformPaymentTypeData;
import org.cyclos.model.banking.transactions.PerformRecurringPaymentDTO;
import org.cyclos.model.banking.transactions.PerformScheduledPaymentDTO;
import org.cyclos.model.banking.transactions.PerformTransactionDTO;
import org.cyclos.model.banking.transactions.RecurringPaymentPreviewVO;
import org.cyclos.model.banking.transactions.ScheduledPaymentPreviewVO;
import org.cyclos.model.banking.transactions.TransferFeePreviewVO;
import org.cyclos.model.banking.transfertypes.MaturityPolicy;
import org.cyclos.model.users.operators.OperatorVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.RecurringPaymentsApiHelper;
import org.cyclos.web.rest.helpers.ScheduledPaymentsApiHelper;
import org.cyclos.web.rest.helpers.TransactionsApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.MaturityPolicyEnum;
import org.cyclos.web.rest.model.PaymentPreview;
import org.cyclos.web.rest.model.PaymentSchedulingEnum;
import org.cyclos.web.rest.model.PerformPayment;
import org.cyclos.web.rest.model.TransactionTypeData;
import org.cyclos.web.rest.model.TransferFeePreview;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PaymentsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    private TransactionsApiHelper transactionsApiHelper;
    @Autowired
    private ScheduledPaymentsApiHelper scheduledPaymentsApiHelper;
    @Autowired
    private RecurringPaymentsApiHelper recurringPaymentsApiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;

    public void fillTransactionTypeData(PerformPaymentTypeData performPaymentTypeData, TransactionTypeData transactionTypeData) {
        transactionTypeData.setArate(performPaymentTypeData.getARate());
        transactionTypeData.setDrate(performPaymentTypeData.getDRate());
        transactionTypeData.setDrateCreationValue(performPaymentTypeData.getDRateCreationValue());
        transactionTypeData.setLimitedAwaitingAuthorization(performPaymentTypeData.isLimitedAwaitingAuthorization());
        transactionTypeData.setMaturityPolicy(this.toMaturityPolicyEnum(performPaymentTypeData.getMaturityPolicy()));
        transactionTypeData.setMaturityTableWinnerId(ApiHelper.toId(performPaymentTypeData.getMaturityTableWinnerId()));
        transactionTypeData.setMaxAmountByMaturityPolicy(this.apiHelper.getAmount(performPaymentTypeData.getMaxAmountByMaturityPolicy()));
        transactionTypeData.setNoNegativesMaturityPolicy(performPaymentTypeData.isNoNegativesMaturityPolicy());
    }

    public TransferFeePreview toFeePreview(TransferFeePreviewVO transferFeePreviewVO) {
        TransferFeePreview transferFeePreview = new TransferFeePreview();
        transferFeePreview.setFee(this.apiHelper.toReference((EntityModel)transferFeePreviewVO));
        transferFeePreview.setAmount(this.apiHelper.getAmount(transferFeePreviewVO.getAmount()));
        transferFeePreview.setCurrency(this.accountsApiHelper.toCurrency(transferFeePreviewVO.getAmount()));
        transferFeePreview.setFrom(this.accountsApiHelper.toAccountWithOwner(transferFeePreviewVO.getFrom()));
        transferFeePreview.setTo(this.accountsApiHelper.toAccountWithOwner(transferFeePreviewVO.getTo()));
        transferFeePreview.setType(this.accountsApiHelper.toTransferType(transferFeePreviewVO.getType()));
        return transferFeePreview;
    }

    public MaturityPolicyEnum toMaturityPolicyEnum(MaturityPolicy maturityPolicy) {
        if (maturityPolicy != null) {
            switch (maturityPolicy) {
                case ALWAYS: {
                    return MaturityPolicyEnum.ALWAYS;
                }
                case HISTORY: {
                    return MaturityPolicyEnum.HISTORY;
                }
                case ZERO: {
                    return MaturityPolicyEnum.ZERO;
                }
            }
        }
        return null;
    }

    public PaymentPreview toPaymentPreview(BaseInternalPaymentPreviewVO baseInternalPaymentPreviewVO, String string) {
        return this.toPreview(PaymentPreview.class, baseInternalPaymentPreviewVO, string);
    }

    public PerformPayment toPerform(PerformBasePaymentDTO performBasePaymentDTO) {
        if (performBasePaymentDTO == null) {
            return null;
        }
        PerformPayment performPayment = this.transactionsApiHelper.newPerformTransaction(PerformPayment.class, (PerformTransactionDTO)performBasePaymentDTO);
        performPayment.setNfcChallence(performBasePaymentDTO.getNfcChallenge());
        if (performBasePaymentDTO instanceof PerformScheduledPaymentDTO) {
            this.scheduledPaymentsApiHelper.fillPerform((PerformScheduledPaymentDTO)performBasePaymentDTO, performPayment);
        } else {
            performPayment.setInstallments(null);
        }
        if (performBasePaymentDTO instanceof PerformRecurringPaymentDTO) {
            this.recurringPaymentsApiHelper.fillPerform((PerformRecurringPaymentDTO)performBasePaymentDTO, performPayment);
        }
        return performPayment;
    }

    public PerformBasePaymentDTO toPerformDTO(String string, String string2, PerformPayment performPayment) {
        PaymentSchedulingEnum paymentSchedulingEnum = (PaymentSchedulingEnum)ObjectHelper.defaultValue((Object)performPayment.getScheduling(), (Object)PaymentSchedulingEnum.DIRECT);
        Class<PerformPaymentDTO> clazz = null;
        switch (paymentSchedulingEnum) {
            case DIRECT: {
                clazz = PerformPaymentDTO.class;
                break;
            }
            case SCHEDULED: {
                clazz = PerformScheduledPaymentDTO.class;
                break;
            }
            case RECURRING: {
                clazz = PerformRecurringPaymentDTO.class;
            }
        }
        PerformBasePaymentDTO performBasePaymentDTO = (PerformBasePaymentDTO)this.transactionsApiHelper.newPerformTransactionDTO(clazz, string, string2, performPayment);
        performBasePaymentDTO.setNfcChallenge(performPayment.getNfcChallence());
        switch (paymentSchedulingEnum) {
            case DIRECT: {
                break;
            }
            case SCHEDULED: {
                this.scheduledPaymentsApiHelper.fillPerformDTO((PerformScheduledPaymentDTO)performBasePaymentDTO, performPayment);
                break;
            }
            case RECURRING: {
                this.recurringPaymentsApiHelper.fillPerformDTO((PerformRecurringPaymentDTO)performBasePaymentDTO, performPayment);
            }
        }
        return performBasePaymentDTO;
    }

    public <P extends PaymentPreview> P toPreview(Class<P> clazz, BaseInternalPaymentPreviewVO baseInternalPaymentPreviewVO, String string) {
        Object object;
        if (baseInternalPaymentPreviewVO == null) {
            return null;
        }
        PaymentPreview paymentPreview = (PaymentPreview)this.transactionsApiHelper.newPreview(clazz, (BasePaymentPreviewVO)baseInternalPaymentPreviewVO);
        PerformPaymentDTO performPaymentDTO = null;
        if (baseInternalPaymentPreviewVO instanceof PaymentPreviewVO) {
            object = (PaymentPreviewVO)baseInternalPaymentPreviewVO;
            performPaymentDTO = object.getPayment();
            paymentPreview.setPayment(this.toPerform((PerformBasePaymentDTO)performPaymentDTO));
            paymentPreview.setMainAmount(this.apiHelper.getAmount(object.getMainAmount()));
            CollectionHelper.orEmpty((List)object.getFees()).stream().map(this::toFeePreview).forEach(paymentPreview.getFees()::add);
            paymentPreview.setArate(object.getARate());
            paymentPreview.setDrate(object.getDRate());
            paymentPreview.setPreviousDRate(object.getPreviousDRate());
            paymentPreview.setTransferDRate(object.getTransferDRate());
            paymentPreview.setInstallments(null);
        } else if (baseInternalPaymentPreviewVO instanceof ScheduledPaymentPreviewVO) {
            object = (ScheduledPaymentPreviewVO)baseInternalPaymentPreviewVO;
            this.scheduledPaymentsApiHelper.fillPreview((ScheduledPaymentPreviewVO)object, paymentPreview);
            performPaymentDTO = object.getScheduledPayment();
        } else if (baseInternalPaymentPreviewVO instanceof RecurringPaymentPreviewVO) {
            object = (RecurringPaymentPreviewVO)baseInternalPaymentPreviewVO;
            this.recurringPaymentsApiHelper.fillPreview((RecurringPaymentPreviewVO)object, paymentPreview);
            performPaymentDTO = object.getRecurringPayment();
        }
        object = paymentPreview.getPayment();
        if (object != null) {
            ((PerformPayment)object).setSubject(string);
            if (CollectionHelper.isEmpty(((PerformPayment)object).getInstallments())) {
                ((PerformPayment)object).setInstallments(null);
            }
            if (performPaymentDTO.getOwner() instanceof OperatorVO) {
                paymentPreview.setFromOperator(this.usersApiHelper.toUser((BasicUserVO)((OperatorVO)performPaymentDTO.getOwner())));
            }
            if (performPaymentDTO.getSubject() instanceof OperatorVO) {
                paymentPreview.setToOperator(this.usersApiHelper.toUser((BasicUserVO)((OperatorVO)performPaymentDTO.getSubject())));
            }
        }
        return (P)paymentPreview;
    }
}

