/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.transactions.AcceptPaymentRequestDTO;
import org.cyclos.model.banking.transactions.AcceptPaymentRequestPreviewVO;
import org.cyclos.model.banking.transactions.ChangePaymentRequestExpirationDateDTO;
import org.cyclos.model.banking.transactions.PaymentRequestActionDTO;
import org.cyclos.model.banking.transactions.PaymentRequestResultVO;
import org.cyclos.model.banking.transactions.PaymentRequestStatus;
import org.cyclos.model.banking.transactions.PaymentRequestVO;
import org.cyclos.model.banking.transactions.RequestPaymentTypeData;
import org.cyclos.model.banking.transactions.SchedulingType;
import org.cyclos.model.banking.transactions.SendPaymentRequestDTO;
import org.cyclos.model.banking.transactions.TransactionDetailedVO;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.TimeField;
import org.cyclos.model.utils.TimeIntervalDTO;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.PaymentsApiHelper;
import org.cyclos.web.rest.helpers.TransactionsApiHelper;
import org.cyclos.web.rest.model.AcceptOrReschedulePaymentRequest;
import org.cyclos.web.rest.model.BaseTransactionResult;
import org.cyclos.web.rest.model.ChangePaymentRequestExpirationDate;
import org.cyclos.web.rest.model.PaymentRequestPreview;
import org.cyclos.web.rest.model.PaymentRequestSchedulingEnum;
import org.cyclos.web.rest.model.PaymentRequestStatusEnum;
import org.cyclos.web.rest.model.SendPaymentRequest;
import org.cyclos.web.rest.model.TransactionTypeData;
import org.cyclos.web.rest.model.TransactionView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PaymentRequestsApiHelper {
    @Autowired
    private PaymentsApiHelper paymentsApiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private TransactionsApiHelper transactionsApiHelper;

    public void fillTransactionResult(PaymentRequestResultVO paymentRequestResultVO, BaseTransactionResult baseTransactionResult) {
        baseTransactionResult.setPaymentRequestStatus(this.toPaymentRequestStatusEnum(paymentRequestResultVO.getStatus()));
        baseTransactionResult.setExpirationDate(paymentRequestResultVO.getExpirationDate());
    }

    public void fillTransactionTypeData(RequestPaymentTypeData requestPaymentTypeData, TransactionTypeData transactionTypeData) {
        transactionTypeData.setDefaultExpirationDate(requestPaymentTypeData.getDefaultExpirationDate());
        transactionTypeData.setHideExpirationDate(requestPaymentTypeData.isHideExpirationDate());
    }

    public void fillTransactionView(PaymentRequestVO paymentRequestVO, TransactionView transactionView) {
        transactionView.setComments(paymentRequestVO.getComments());
        transactionView.setExpirationDate(paymentRequestVO.getExpirationDate());
        transactionView.setChangeExpirationDateComments(paymentRequestVO.getExpirationDateComments());
        transactionView.setPaymentRequestStatus(this.toPaymentRequestStatusEnum(paymentRequestVO.getStatus()));
        transactionView.setProcessDate(paymentRequestVO.getProcessDate());
        transactionView.setTransaction(this.transactionsApiHelper.toTransaction((TransactionVO)paymentRequestVO.getTransaction()));
        transactionView.setSmsCode(paymentRequestVO.getSmsCode());
        transactionView.setScheduling(this.toPaymentRequestSchedulingEnum(paymentRequestVO.getScheduling()));
        if (paymentRequestVO.getScheduling() != null && paymentRequestVO.getScheduling().useInstallments()) {
            transactionView.setInstallmentsCount(paymentRequestVO.getSchedulingCount());
            transactionView.setFirstInstallmentIsImmediate(paymentRequestVO.isFirstSchedulingIsImmediate());
        } else if (paymentRequestVO.getScheduling() == SchedulingType.RECURRING) {
            transactionView.setOccurrencesCount(paymentRequestVO.getSchedulingCount());
            transactionView.setFirstOccurrenceIsImmediate(paymentRequestVO.isFirstSchedulingIsImmediate());
            transactionView.setOccurrenceInterval(this.apiHelper.toTimeInterval(paymentRequestVO.getOccurrenceInterval()));
        }
    }

    public AcceptPaymentRequestDTO toAcceptPaymentRequestDTO(String string, String string2, AcceptOrReschedulePaymentRequest acceptOrReschedulePaymentRequest) {
        AcceptPaymentRequestDTO acceptPaymentRequestDTO = this.toPaymentRequestActionDTO(AcceptPaymentRequestDTO.class, string, acceptOrReschedulePaymentRequest.getComments(), string2);
        acceptPaymentRequestDTO.setProcessDate(acceptOrReschedulePaymentRequest.getProcessDate());
        return acceptPaymentRequestDTO;
    }

    public ChangePaymentRequestExpirationDateDTO toChangePaymentRequestExpirationDateDTO(String string, String string2, ChangePaymentRequestExpirationDate changePaymentRequestExpirationDate) {
        ChangePaymentRequestExpirationDateDTO changePaymentRequestExpirationDateDTO = this.toPaymentRequestActionDTO(ChangePaymentRequestExpirationDateDTO.class, string, changePaymentRequestExpirationDate.getComments(), string2);
        changePaymentRequestExpirationDateDTO.setNewExpirationDate(changePaymentRequestExpirationDate.getNewExpirationDate());
        return changePaymentRequestExpirationDateDTO;
    }

    public PaymentRequestActionDTO toPaymentRequestActionDTO(String string, String string2, String string3) {
        return this.toPaymentRequestActionDTO(PaymentRequestActionDTO.class, string, string2, string3);
    }

    public PaymentRequestPreview toPaymentRequestPreview(AcceptPaymentRequestPreviewVO acceptPaymentRequestPreviewVO) {
        PaymentRequestPreview paymentRequestPreview = this.paymentsApiHelper.toPreview(PaymentRequestPreview.class, acceptPaymentRequestPreviewVO.getPaymentPreview(), this.accountsApiHelper.identifier((AccountOwner)acceptPaymentRequestPreviewVO.getPaymentPreview().getToAccount().getOwner()));
        paymentRequestPreview.setPaymentRequest(this.transactionsApiHelper.toTransactionView((TransactionDetailedVO)acceptPaymentRequestPreviewVO.getPaymentRequest()));
        return paymentRequestPreview;
    }

    public PaymentRequestSchedulingEnum toPaymentRequestSchedulingEnum(SchedulingType schedulingType) {
        if (schedulingType != null) {
            switch (schedulingType) {
                case FUTURE_DATE: {
                    return PaymentRequestSchedulingEnum.SCHEDULED;
                }
                case MULTIPLE_INSTALLMENTS: {
                    return PaymentRequestSchedulingEnum.SCHEDULED;
                }
                case NOT_SCHEDULED: {
                    return PaymentRequestSchedulingEnum.DIRECT;
                }
                case RECURRING: {
                    return PaymentRequestSchedulingEnum.RECURRING;
                }
            }
        }
        return null;
    }

    public PaymentRequestStatus toPaymentRequestStatus(PaymentRequestStatusEnum paymentRequestStatusEnum) {
        if (paymentRequestStatusEnum != null) {
            switch (paymentRequestStatusEnum) {
                case OPEN: {
                    return PaymentRequestStatus.OPEN;
                }
                case PROCESSED: {
                    return PaymentRequestStatus.PROCESSED;
                }
                case SCHEDULED: {
                    return PaymentRequestStatus.SCHEDULED;
                }
                case CANCELED: {
                    return PaymentRequestStatus.CANCELED;
                }
                case DENIED: {
                    return PaymentRequestStatus.DENIED;
                }
                case EXPIRED: {
                    return PaymentRequestStatus.EXPIRED;
                }
            }
        }
        return null;
    }

    public PaymentRequestStatusEnum toPaymentRequestStatusEnum(PaymentRequestStatus paymentRequestStatus) {
        if (paymentRequestStatus != null) {
            switch (paymentRequestStatus) {
                case OPEN: {
                    return PaymentRequestStatusEnum.OPEN;
                }
                case PROCESSED: {
                    return PaymentRequestStatusEnum.PROCESSED;
                }
                case SCHEDULED: {
                    return PaymentRequestStatusEnum.SCHEDULED;
                }
                case CANCELED: {
                    return PaymentRequestStatusEnum.CANCELED;
                }
                case DENIED: {
                    return PaymentRequestStatusEnum.DENIED;
                }
                case EXPIRED: {
                    return PaymentRequestStatusEnum.EXPIRED;
                }
            }
        }
        return null;
    }

    public SchedulingType toSchedulingType(PaymentRequestSchedulingEnum paymentRequestSchedulingEnum) {
        if (paymentRequestSchedulingEnum != null) {
            switch (paymentRequestSchedulingEnum) {
                case DIRECT: {
                    return SchedulingType.NOT_SCHEDULED;
                }
                case RECURRING: {
                    return SchedulingType.RECURRING;
                }
                case SCHEDULED: {
                    return SchedulingType.MULTIPLE_INSTALLMENTS;
                }
            }
        }
        return null;
    }

    public SendPaymentRequestDTO toSendPaymentRequestDTO(String string, SendPaymentRequest sendPaymentRequest) {
        SendPaymentRequestDTO sendPaymentRequestDTO = this.transactionsApiHelper.newPerformTransactionDTO(SendPaymentRequestDTO.class, string, null, sendPaymentRequest);
        sendPaymentRequestDTO.setExpirationDate(sendPaymentRequest.getExpirationDate());
        sendPaymentRequestDTO.setScheduling(this.toSchedulingType(sendPaymentRequest.getScheduling()));
        if (sendPaymentRequestDTO.getScheduling() != null && sendPaymentRequestDTO.getScheduling().useInstallments()) {
            sendPaymentRequestDTO.setSchedulingCount(sendPaymentRequest.getInstallmentsCount());
            sendPaymentRequestDTO.setFirstSchedulingIsImmediate(!Boolean.FALSE.equals(sendPaymentRequest.getFirstInstallmentIsImmediate()));
        } else if (sendPaymentRequestDTO.getScheduling() == SchedulingType.RECURRING) {
            sendPaymentRequestDTO.setSchedulingCount(sendPaymentRequest.getOccurrencesCount());
            sendPaymentRequestDTO.setFirstSchedulingIsImmediate(!Boolean.FALSE.equals(sendPaymentRequest.getFirstOccurrenceIsImmediate()));
            TimeIntervalDTO timeIntervalDTO = this.apiHelper.toTimeIntervalDTO(sendPaymentRequest.getOccurrenceInterval());
            if (timeIntervalDTO == null) {
                timeIntervalDTO = ModelHelper.timeInterval((int)1, (TimeField)TimeField.MONTHS);
            } else if (timeIntervalDTO.getAmount() == null) {
                timeIntervalDTO.setAmount(Integer.valueOf(1));
            } else if (timeIntervalDTO.getField() == null) {
                timeIntervalDTO.setField(TimeField.MONTHS);
            }
            sendPaymentRequestDTO.setOccurrenceInterval(timeIntervalDTO);
        }
        return sendPaymentRequestDTO;
    }

    private <T extends PaymentRequestActionDTO> T toPaymentRequestActionDTO(Class<T> clazz, String string, String string2, String string3) {
        PaymentRequestActionDTO paymentRequestActionDTO = (PaymentRequestActionDTO)ClassHelper.instantiate(clazz);
        paymentRequestActionDTO.setComments(string2);
        paymentRequestActionDTO.setConfirmationPassword(string3);
        paymentRequestActionDTO.setPaymentRequest((PaymentRequestVO)ModelHelper.voFromString(PaymentRequestVO.class, (String)string));
        return (T)paymentRequestActionDTO;
    }
}

