/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.access.SecurityQuestion;
import org.cyclos.model.access.passwords.ChangeGeneratedPasswordDTO;
import org.cyclos.model.access.passwords.ChangePasswordDTO;
import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.access.passwords.PasswordAction;
import org.cyclos.model.access.passwords.PasswordActionDTO;
import org.cyclos.model.access.passwords.PasswordData;
import org.cyclos.model.access.passwords.PasswordLogVO;
import org.cyclos.model.access.passwords.ResetAndSendPasswordDTO;
import org.cyclos.model.access.passwords.SecurityQuestionVO;
import org.cyclos.model.access.passwords.SetSecurityQuestionDTO;
import org.cyclos.model.access.passwords.SetSecurityQuestionData;
import org.cyclos.model.access.passwords.UserPasswordsData;
import org.cyclos.model.access.passwordtypes.PasswordInputMethod;
import org.cyclos.model.access.passwordtypes.PasswordMode;
import org.cyclos.model.access.passwordtypes.PasswordTypeDetailedVO;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.utils.IntegerRangeDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.TotpApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.ChangePassword;
import org.cyclos.web.rest.model.DataForSetSecurityAnswer;
import org.cyclos.web.rest.model.DataForUserPasswords;
import org.cyclos.web.rest.model.EntityReference;
import org.cyclos.web.rest.model.PasswordActionEnum;
import org.cyclos.web.rest.model.PasswordActions;
import org.cyclos.web.rest.model.PasswordInputMethodEnum;
import org.cyclos.web.rest.model.PasswordLog;
import org.cyclos.web.rest.model.PasswordModeEnum;
import org.cyclos.web.rest.model.PasswordStatus;
import org.cyclos.web.rest.model.PasswordStatusAndActions;
import org.cyclos.web.rest.model.PasswordStatusAndType;
import org.cyclos.web.rest.model.PasswordStatusEnum;
import org.cyclos.web.rest.model.PasswordType;
import org.cyclos.web.rest.model.PasswordTypeDetailed;
import org.cyclos.web.rest.model.SendMediumEnum;
import org.cyclos.web.rest.model.SetSecurityAnswer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PasswordsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private TotpApiHelper totpApiHelper;

    public <T extends PasswordType> T newPasswordType(Class<T> clazz, PasswordTypeVO passwordTypeVO) {
        PasswordType passwordType = (PasswordType)this.apiHelper.newEntity(clazz, passwordTypeVO);
        passwordType.setMode(this.toPasswordModeEnum(passwordTypeVO.getPasswordMode()));
        passwordType.setGlobal(passwordTypeVO.isGlobal());
        return (T)passwordType;
    }

    public <T extends PasswordTypeDetailed> T newPasswordTypeDetailed(Class<T> clazz, PasswordTypeDetailedVO passwordTypeDetailedVO) {
        PasswordTypeDetailed passwordTypeDetailed = (PasswordTypeDetailed)this.newPasswordType(clazz, (PasswordTypeVO)passwordTypeDetailedVO);
        passwordTypeDetailed.setMode(this.toPasswordModeEnum(passwordTypeDetailedVO.getPasswordMode()));
        passwordTypeDetailed.setGlobal(passwordTypeDetailedVO.isGlobal());
        IntegerRangeDTO integerRangeDTO = passwordTypeDetailedVO.getLength();
        if (integerRangeDTO != null) {
            passwordTypeDetailed.setMaxLength(integerRangeDTO.getMax());
            passwordTypeDetailed.setMinLength(integerRangeDTO.getMin());
        }
        passwordTypeDetailed.setInputMethod(this.toPasswordPasswordInputMethodEnum(passwordTypeDetailedVO.getInputMethod()));
        passwordTypeDetailed.setOnlyNumeric(passwordTypeDetailedVO.isOnlyNumeric());
        passwordTypeDetailed.setDescription(passwordTypeDetailedVO.getDescriptionOnRegistration());
        passwordTypeDetailed.setLowerCaseLetters(this.apiHelper.toAvailabilityEnum(passwordTypeDetailedVO.getLowerCaseLetters()));
        passwordTypeDetailed.setUpperCaseLetters(this.apiHelper.toAvailabilityEnum(passwordTypeDetailedVO.getUpperCaseLetters()));
        passwordTypeDetailed.setNumbers(this.apiHelper.toAvailabilityEnum(passwordTypeDetailedVO.getNumbers()));
        passwordTypeDetailed.setSpecialCharacters(this.apiHelper.toAvailabilityEnum(passwordTypeDetailedVO.getSpecialCharacters()));
        passwordTypeDetailed.setNumberOfButtons(passwordTypeDetailedVO.getNumberOfButtons());
        passwordTypeDetailed.setNumberOfRows(passwordTypeDetailedVO.getNumberOfRows());
        passwordTypeDetailed.setButtonsPerRow(passwordTypeDetailedVO.getButtonsPerRow());
        passwordTypeDetailed.setAllowReuseOtp(passwordTypeDetailedVO.isAllowReuseOTP());
        return (T)passwordTypeDetailed;
    }

    public ChangeGeneratedPasswordDTO toChangeGeneratedPasswordDTO(String string, String string2) {
        ChangeGeneratedPasswordDTO changeGeneratedPasswordDTO = new ChangeGeneratedPasswordDTO();
        changeGeneratedPasswordDTO.setType((PasswordTypeVO)ModelHelper.voFromString(PasswordTypeVO.class, (String)string));
        changeGeneratedPasswordDTO.setConfirmationPassword(string2);
        return changeGeneratedPasswordDTO;
    }

    public ChangePasswordDTO toChangePasswordDTO(String string, String string2, ChangePassword changePassword) {
        ChangePasswordDTO changePasswordDTO = new ChangePasswordDTO();
        changePasswordDTO.setType((PasswordTypeDetailedVO)ModelHelper.voFromString(PasswordTypeDetailedVO.class, (String)string2));
        changePasswordDTO.setUser((BasicUserVO)ModelHelper.voFromString(BasicUserVO.class, (String)string));
        changePasswordDTO.setOldPassword(changePassword.getOldPassword());
        changePasswordDTO.setNewPassword(changePassword.getNewPassword());
        if (Boolean.TRUE.equals(changePassword.getCheckConfirmation())) {
            changePasswordDTO.setConfirmNewPassword(changePassword.getNewPasswordConfirmation());
        } else {
            changePasswordDTO.setConfirmNewPassword(changePassword.getNewPassword());
        }
        changePasswordDTO.setForceChange(Boolean.TRUE.equals(changePassword.getForceChange()));
        return changePasswordDTO;
    }

    public DataForUserPasswords toDataForUserPasswords(UserPasswordsData userPasswordsData) {
        if (userPasswordsData == null) {
            return null;
        }
        DataForUserPasswords dataForUserPasswords = new DataForUserPasswords();
        dataForUserPasswords.setUser(this.usersApiHelper.toUser(userPasswordsData.getUser()));
        dataForUserPasswords.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput((ICredentialInputDTO)userPasswordsData.getConfirmationPasswordInput()));
        dataForUserPasswords.setDataForSetSecurityAnswer(this.toDataForSetSecurityAnswer(userPasswordsData.getSecurityQuestionData()));
        dataForUserPasswords.setTotpSecret(this.totpApiHelper.toTotpSecretData(userPasswordsData.getTotpSecret()));
        CollectionHelper.orEmpty((List)userPasswordsData.getSendMediums()).stream().map(this.apiHelper::toSendMediumEnum).forEach(dataForUserPasswords.getSendMediums()::add);
        CollectionHelper.orEmpty((List)userPasswordsData.getPasswords()).stream().map(this::toPasswordStatusAndActions).forEach(dataForUserPasswords.getPasswords()::add);
        return dataForUserPasswords;
    }

    public EntityReference toEntityReference(SecurityQuestionVO securityQuestionVO) {
        if (securityQuestionVO == null) {
            return null;
        }
        EntityReference entityReference = new EntityReference();
        entityReference.setInternalName(securityQuestionVO.getSecurityQuestion().name());
        entityReference.setName(securityQuestionVO.getLabel());
        return entityReference;
    }

    public PasswordActionDTO toPasswordActionDTO(String string, String string2) {
        PasswordActionDTO passwordActionDTO = new PasswordActionDTO();
        passwordActionDTO.setType((PasswordTypeDetailedVO)ModelHelper.voFromString(PasswordTypeDetailedVO.class, (String)string2));
        passwordActionDTO.setUser((BasicUserVO)ModelHelper.voFromString(BasicUserVO.class, (String)string));
        return passwordActionDTO;
    }

    public PasswordActionEnum toPasswordActionEnum(PasswordAction passwordAction) {
        if (passwordAction != null) {
            switch (passwordAction) {
                case ACTIVATE: {
                    return PasswordActionEnum.ACTIVATE;
                }
                case ALLOW_ACTIVATION: {
                    return PasswordActionEnum.ALLOW_ACTIVATION;
                }
                case CHANGE: {
                    return PasswordActionEnum.CHANGE;
                }
                case DISABLE: {
                    return PasswordActionEnum.DISABLE;
                }
                case ENABLE: {
                    return PasswordActionEnum.ENABLE;
                }
                case RESET: {
                    return PasswordActionEnum.RESET;
                }
                case RESET_AND_SEND: {
                    return PasswordActionEnum.RESET_AND_SEND;
                }
                case UNBLOCK: {
                    return PasswordActionEnum.UNBLOCK;
                }
            }
        }
        return null;
    }

    public PasswordLog toPasswordLog(PasswordLogVO passwordLogVO) {
        PasswordLog passwordLog = new PasswordLog();
        passwordLog.setBy(this.usersApiHelper.toUser((BasicUserVO)passwordLogVO.getBy()));
        passwordLog.setDate(passwordLogVO.getDate());
        passwordLog.setAction(this.toPasswordActionEnum(passwordLogVO.getAction()));
        return passwordLog;
    }

    public PasswordModeEnum toPasswordModeEnum(PasswordMode passwordMode) {
        if (passwordMode != null) {
            switch (passwordMode) {
                case MANUAL: {
                    return PasswordModeEnum.MANUAL;
                }
                case GENERATED: {
                    return PasswordModeEnum.GENERATED;
                }
                case OTP: {
                    return PasswordModeEnum.OTP;
                }
                case SCRIPT: {
                    return PasswordModeEnum.SCRIPT;
                }
            }
        }
        return null;
    }

    public PasswordStatusAndActions toPasswordStatusAndActions(PasswordData passwordData) {
        if (passwordData == null) {
            return null;
        }
        PasswordStatusAndActions passwordStatusAndActions = this.fillPasswordStatus(new PasswordStatusAndActions(), passwordData);
        passwordStatusAndActions.setRequireOldPasswordForChange(passwordData.isRequireOldPasswordForChange());
        passwordStatusAndActions.setPermissions(this.toPasswordActions((PasswordTypeVO)passwordData.getType(), passwordData.getActions()));
        CollectionHelper.orEmpty((List)passwordData.getLogs()).stream().map(this::toPasswordLog).forEach(passwordStatusAndActions.getHistory()::add);
        return passwordStatusAndActions;
    }

    public PasswordStatusAndType toPasswordStatusAndType(PasswordData passwordData) {
        return this.fillPasswordStatus(new PasswordStatusAndType(), passwordData);
    }

    public List<PasswordStatusAndType> toPasswordStatusAndType(UserPasswordsData userPasswordsData) {
        if (userPasswordsData == null) {
            return null;
        }
        ArrayList<PasswordStatusAndType> arrayList = new ArrayList<PasswordStatusAndType>();
        CollectionHelper.orEmpty((List)userPasswordsData.getPasswords()).stream().map(this::toPasswordStatusAndType).forEach(arrayList::add);
        return arrayList;
    }

    public PasswordStatusEnum toPasswordStatusEnum(org.cyclos.model.access.passwords.PasswordStatus passwordStatus) {
        if (passwordStatus != null) {
            switch (passwordStatus) {
                case ACTIVE: {
                    return PasswordStatusEnum.ACTIVE;
                }
                case DISABLED: {
                    return PasswordStatusEnum.DISABLED;
                }
                case EXPIRED: {
                    return PasswordStatusEnum.EXPIRED;
                }
                case NEVER_CREATED: {
                    return PasswordStatusEnum.NEVER_CREATED;
                }
                case PENDING: {
                    return PasswordStatusEnum.PENDING;
                }
                case RESET: {
                    return PasswordStatusEnum.RESET;
                }
                case INDEFINITELY_BLOCKED: {
                    return PasswordStatusEnum.INDEFINITELY_BLOCKED;
                }
                case TEMPORARILY_BLOCKED: {
                    return PasswordStatusEnum.TEMPORARILY_BLOCKED;
                }
            }
        }
        return null;
    }

    public PasswordType toPasswordType(PasswordTypeVO passwordTypeVO) {
        if (passwordTypeVO == null) {
            return null;
        }
        return this.newPasswordType(PasswordType.class, passwordTypeVO);
    }

    public PasswordTypeDetailed toPasswordTypeDetailed(PasswordTypeDetailedVO passwordTypeDetailedVO) {
        if (passwordTypeDetailedVO == null) {
            return null;
        }
        return this.newPasswordTypeDetailed(PasswordTypeDetailed.class, passwordTypeDetailedVO);
    }

    public ResetAndSendPasswordDTO toResetAndSendPasswordDTO(String string, String string2, List<SendMediumEnum> list) {
        ResetAndSendPasswordDTO resetAndSendPasswordDTO = new ResetAndSendPasswordDTO();
        resetAndSendPasswordDTO.setType((PasswordTypeDetailedVO)ModelHelper.voFromString(PasswordTypeDetailedVO.class, (String)string2));
        resetAndSendPasswordDTO.setUser((BasicUserVO)ModelHelper.voFromString(BasicUserVO.class, (String)string));
        resetAndSendPasswordDTO.setSendMediums(CollectionHelper.orEmpty(list).stream().map(this.apiHelper::toSendMedium).collect(Collectors.toSet()));
        return resetAndSendPasswordDTO;
    }

    public SecurityQuestion toSecurityQuestion(String string) {
        if (StringHelper.isBlank((Object)string)) {
            return null;
        }
        try {
            return SecurityQuestion.valueOf((String)string.toUpperCase());
        }
        catch (Exception exception) {
            throw new EntityNotFoundException(SecurityQuestion.class, string);
        }
    }

    public SetSecurityQuestionDTO toSetSecurityQuestionDTO(SetSecurityAnswer setSecurityAnswer) {
        SetSecurityQuestionDTO setSecurityQuestionDTO = new SetSecurityQuestionDTO();
        setSecurityQuestionDTO.setSecurityQuestion(this.toSecurityQuestion(setSecurityAnswer.getSecurityQuestion()));
        setSecurityQuestionDTO.setSecurityAnswer(setSecurityAnswer.getSecurityAnswer());
        return setSecurityQuestionDTO;
    }

    private <T extends PasswordStatus> T fillPasswordStatus(T t, PasswordData passwordData) {
        if (passwordData == null) {
            return t;
        }
        PasswordTypeDetailed passwordTypeDetailed = this.toPasswordTypeDetailed(passwordData.getType());
        if (t instanceof PasswordStatusAndActions) {
            ((PasswordStatusAndActions)t).setType(passwordTypeDetailed);
        } else if (t instanceof PasswordStatusAndType) {
            ((PasswordStatusAndType)t).setType(passwordTypeDetailed);
        }
        t.setStatus(this.toPasswordStatusEnum(passwordData.getStatus()));
        t.setDate(passwordData.getDate());
        return t;
    }

    private DataForSetSecurityAnswer toDataForSetSecurityAnswer(SetSecurityQuestionData setSecurityQuestionData) {
        if (setSecurityQuestionData == null) {
            return null;
        }
        DataForSetSecurityAnswer dataForSetSecurityAnswer = new DataForSetSecurityAnswer();
        CollectionHelper.orEmpty((List)setSecurityQuestionData.getSecurityQuestions()).stream().map(this::toEntityReference).forEach(dataForSetSecurityAnswer.getSecurityQuestions()::add);
        return dataForSetSecurityAnswer;
    }

    private PasswordActions toPasswordActions(PasswordTypeVO passwordTypeVO, Set<PasswordAction> set) {
        set = CollectionHelper.orEmpty(set);
        PasswordActions passwordActions = new PasswordActions();
        passwordActions.setChangeGenerated(passwordTypeVO.getPasswordMode() == PasswordMode.GENERATED && set.contains(PasswordAction.CHANGE));
        passwordActions.setChange(passwordTypeVO.getPasswordMode() == PasswordMode.MANUAL && set.contains(PasswordAction.CHANGE));
        passwordActions.setGenerate(set.contains(PasswordAction.ACTIVATE));
        passwordActions.setAllowGeneration(set.contains(PasswordAction.ALLOW_ACTIVATION));
        passwordActions.setDisable(set.contains(PasswordAction.DISABLE));
        passwordActions.setEnable(set.contains(PasswordAction.ENABLE));
        passwordActions.setResetGenerated(set.contains(PasswordAction.RESET));
        passwordActions.setResetAndSend(set.contains(PasswordAction.RESET_AND_SEND));
        passwordActions.setUnblock(set.contains(PasswordAction.UNBLOCK));
        return passwordActions;
    }

    private PasswordInputMethodEnum toPasswordPasswordInputMethodEnum(PasswordInputMethod passwordInputMethod) {
        if (passwordInputMethod != null) {
            switch (passwordInputMethod) {
                case TEXT_BOX: {
                    return PasswordInputMethodEnum.TEXT_BOX;
                }
                case VIRTUAL_KEYBOARD: {
                    return PasswordInputMethodEnum.VIRTUAL_KEYBOARD;
                }
            }
        }
        return null;
    }
}

