/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.Map;
import org.cyclos.model.access.oidcclients.OidcClientVO;
import org.cyclos.model.access.oidcclients.ResponseMode;
import org.cyclos.server.model.access.oidc.AuthorizeRequest;
import org.cyclos.server.model.access.oidc.AuthorizeResponse;
import org.cyclos.server.model.access.oidc.ClientRequest;
import org.cyclos.server.model.access.oidc.RegisterRequest;
import org.cyclos.server.model.access.oidc.RegisterResponse;
import org.cyclos.server.model.access.oidc.RevokeRequest;
import org.cyclos.server.model.access.oidc.TokenRequest;
import org.cyclos.server.model.access.oidc.TokenResponse;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rest.api.OidcApi;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.ImagesApiHelper;
import org.cyclos.web.rest.model.OidcAuthorizeResult;
import org.cyclos.web.rest.model.OidcClient;
import org.cyclos.web.rest.model.OidcRegisterParams;
import org.cyclos.web.rest.model.OidcRegisterResult;
import org.cyclos.web.rest.model.OidcTokenResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OidcApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private ImagesApiHelper imagesApiHelper;

    public AuthorizeRequest toAuthorizationRequest(OidcApi.OidcAuthorizeParams oidcAuthorizeParams) {
        AuthorizeRequest authorizeRequest = new AuthorizeRequest();
        authorizeRequest.setScope(oidcAuthorizeParams.scope);
        authorizeRequest.setResponseType(oidcAuthorizeParams.responseType);
        authorizeRequest.setClientId(oidcAuthorizeParams.clientId);
        authorizeRequest.setRedirectUri(oidcAuthorizeParams.redirectUri);
        authorizeRequest.setState(oidcAuthorizeParams.state);
        authorizeRequest.setResponseMode(oidcAuthorizeParams.responseMode);
        authorizeRequest.setNonce(oidcAuthorizeParams.nonce);
        authorizeRequest.setDisplay(oidcAuthorizeParams.display);
        authorizeRequest.setPrompt(oidcAuthorizeParams.prompt);
        authorizeRequest.setLoginHint(oidcAuthorizeParams.loginHint);
        return authorizeRequest;
    }

    public OidcAuthorizeResult toOidcAuthorizeResult(AuthorizeResponse authorizeResponse) {
        OidcAuthorizeResult oidcAuthorizeResult = new OidcAuthorizeResult();
        if (authorizeResponse.getResponseMode() == ResponseMode.FORM_POST) {
            oidcAuthorizeResult.setUrl(authorizeResponse.getUrl());
            oidcAuthorizeResult.setPostData(authorizeResponse.getParameters());
        } else {
            boolean bl = authorizeResponse.getResponseMode() == ResponseMode.FRAGMENT;
            StringBuilder stringBuilder = new StringBuilder(authorizeResponse.getUrl());
            Map map = authorizeResponse.getParameters();
            if (CollectionHelper.isNotEmpty((Map)map)) {
                stringBuilder.append((char)(bl ? 35 : (authorizeResponse.getUrl().contains("?") ? 38 : 63))).append(StringHelper.urlEncode((Map)map));
            }
            oidcAuthorizeResult.setUrl(stringBuilder.toString());
            oidcAuthorizeResult.setPostData(null);
        }
        return oidcAuthorizeResult;
    }

    public OidcClient toOidcClient(OidcClientVO oidcClientVO) {
        if (oidcClientVO == null) {
            return null;
        }
        OidcClient oidcClient = this.apiHelper.newEntity(OidcClient.class, oidcClientVO);
        oidcClient.setImage(this.imagesApiHelper.toImage(oidcClientVO.getImage()));
        return oidcClient;
    }

    public OidcRegisterResult toOidcRegisterResult(RegisterResponse registerResponse) {
        OidcRegisterResult oidcRegisterResult = new OidcRegisterResult();
        oidcRegisterResult.setClientId(registerResponse.getClientId());
        oidcRegisterResult.setClientSecret(registerResponse.getClientSecret());
        oidcRegisterResult.setClientIdIssuedAt(registerResponse.getClientIdIssuedAt());
        oidcRegisterResult.setClientSecretExpiresAt(registerResponse.getClientSecretExpiresAt());
        return oidcRegisterResult;
    }

    public OidcTokenResult toOidcTokenResult(TokenResponse tokenResponse) {
        OidcTokenResult oidcTokenResult = new OidcTokenResult();
        oidcTokenResult.setTokenType(tokenResponse.getTokenType());
        oidcTokenResult.setAccessToken(tokenResponse.getAccessToken());
        oidcTokenResult.setIdToken(tokenResponse.getIdToken());
        oidcTokenResult.setState(tokenResponse.getState());
        oidcTokenResult.setExpiresIn(tokenResponse.getExpiresIn());
        oidcTokenResult.setRefreshToken(tokenResponse.getRefreshToken());
        return oidcTokenResult;
    }

    public RegisterRequest toRegisterRequest(OidcRegisterParams oidcRegisterParams) {
        RegisterRequest registerRequest = new RegisterRequest();
        registerRequest.setRedirectUris(oidcRegisterParams.getRedirectUris());
        registerRequest.setResponseTypes(oidcRegisterParams.getResponseTypes());
        registerRequest.setGrantTypes(oidcRegisterParams.getGrantTypes());
        registerRequest.setApplicationType(oidcRegisterParams.getApplicationType());
        registerRequest.setClientName(oidcRegisterParams.getClientName());
        registerRequest.setLogoUri(oidcRegisterParams.getLogoUri());
        registerRequest.setClientUri(oidcRegisterParams.getClientUri());
        registerRequest.setPolicyUri(oidcRegisterParams.getPolicyUri());
        registerRequest.setTosUri(oidcRegisterParams.getTosUri());
        return registerRequest;
    }

    public RevokeRequest toRevokeRequest(String string, String string2, String string3) {
        RevokeRequest revokeRequest = this.newClientRequest(RevokeRequest.class, string, string2);
        revokeRequest.setToken(string3);
        return revokeRequest;
    }

    public TokenRequest toTokenRequest(OidcApi.OidcTokenParams oidcTokenParams) {
        TokenRequest tokenRequest = this.newClientRequest(TokenRequest.class, oidcTokenParams.clientId, oidcTokenParams.clientSecret);
        tokenRequest.setGrantType(oidcTokenParams.grantType);
        tokenRequest.setCode(oidcTokenParams.code);
        tokenRequest.setRedirectUri(oidcTokenParams.redirectUri);
        tokenRequest.setRefreshToken(oidcTokenParams.refreshToken);
        return tokenRequest;
    }

    private <R extends ClientRequest> R newClientRequest(Class<R> clazz, String string, String string2) {
        ClientRequest clientRequest = (ClientRequest)ClassHelper.instantiate(clazz);
        clientRequest.setClientId(string);
        clientRequest.setClientSecret(string2);
        return (R)clientRequest;
    }
}

