/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import org.cyclos.model.messaging.notifications.AccountNotificationType;
import org.cyclos.model.messaging.notifications.AdminNotificationType;
import org.cyclos.model.messaging.notifications.BrokeringNotificationType;
import org.cyclos.model.messaging.notifications.FeedbackAndReferenceNotificationType;
import org.cyclos.model.messaging.notifications.INotificationType;
import org.cyclos.model.messaging.notifications.MarketplaceBuyerNotificationType;
import org.cyclos.model.messaging.notifications.MarketplaceSellerNotificationType;
import org.cyclos.model.messaging.notifications.NotificationEntityType;
import org.cyclos.model.messaging.notifications.NotificationQuery;
import org.cyclos.model.messaging.notifications.NotificationVO;
import org.cyclos.model.messaging.notifications.NotificationsStatusVO;
import org.cyclos.model.messaging.notifications.PersonalNotificationType;
import org.cyclos.model.messaging.notifications.UserNotificationType;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.Notification;
import org.cyclos.web.rest.model.NotificationEntityTypeEnum;
import org.cyclos.web.rest.model.NotificationQueryFilters;
import org.cyclos.web.rest.model.NotificationTypeEnum;
import org.cyclos.web.rest.model.NotificationsStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;

    public Notification toNotification(NotificationVO notificationVO, NotificationEntityType notificationEntityType) {
        if (notificationVO == null) {
            return null;
        }
        Notification notification = this.apiHelper.newEntity(Notification.class, notificationVO);
        notification.setDate(notificationVO.getDate());
        if (notificationVO.getType() != null) {
            notification.setType(this.toNotificationTypeEnum(notificationVO.getType()));
        }
        notification.setRead(notificationVO.isRead());
        notification.setRelatedUser(this.usersApiHelper.toUser((BasicUserVO)notificationVO.getRelatedUser()));
        notification.setEntityId(ApiHelper.toId(notificationVO.getEntityId()));
        notification.setEntityType(this.toNotificationEntityTypeEnum(notificationEntityType));
        notification.setSubject(notificationVO.getSubject());
        notification.setMessage(notificationVO.getMessage());
        return notification;
    }

    public NotificationEntityTypeEnum toNotificationEntityTypeEnum(NotificationEntityType notificationEntityType) {
        if (notificationEntityType == null) {
            return null;
        }
        switch (notificationEntityType) {
            case ACCOUNT: {
                return NotificationEntityTypeEnum.ACCOUNT;
            }
            case AD_QUESTION: {
                return NotificationEntityTypeEnum.AD_QUESTION;
            }
            case ERROR_LOG: {
                return NotificationEntityTypeEnum.ERROR_LOG;
            }
            case FEEDBACK: {
                return NotificationEntityTypeEnum.FEEDBACK;
            }
            case MARKETPLACE: {
                return NotificationEntityTypeEnum.MARKETPLACE;
            }
            case NETWORK: {
                return NotificationEntityTypeEnum.NETWORK;
            }
            case ORDER: {
                return NotificationEntityTypeEnum.ORDER;
            }
            case PASSWORD_TYPE: {
                return NotificationEntityTypeEnum.PASSWORD_TYPE;
            }
            case REFERENCE: {
                return NotificationEntityTypeEnum.REFERENCE;
            }
            case SYSTEM_ALERT: {
                return NotificationEntityTypeEnum.SYSTEM_ALERT;
            }
            case TOKEN: {
                return NotificationEntityTypeEnum.TOKEN;
            }
            case TRANSACTION: {
                return NotificationEntityTypeEnum.TRANSACTION;
            }
            case TRANSFER: {
                return NotificationEntityTypeEnum.TRANSFER;
            }
            case USER: {
                return NotificationEntityTypeEnum.USER;
            }
            case USER_ALERT: {
                return NotificationEntityTypeEnum.USER_ALERT;
            }
            case USER_IMPORTED_FILE: {
                return NotificationEntityTypeEnum.USER_IMPORTED_FILE;
            }
            case VOUCHER: {
                return NotificationEntityTypeEnum.VOUCHER;
            }
            case VOUCHER_TRANSACTION: {
                return NotificationEntityTypeEnum.VOUCHER_TRANSACTION;
            }
            case VOUCHER_TYPE: {
                return NotificationEntityTypeEnum.VOUCHER_TYPE;
            }
        }
        return null;
    }

    public NotificationQuery toNotificationQuery(NotificationQueryFilters notificationQueryFilters) {
        NotificationQuery notificationQuery = this.apiHelper.newQuery(NotificationQuery.class, notificationQueryFilters);
        notificationQuery.setOnlyUnread(Boolean.TRUE.equals(notificationQueryFilters.getOnlyUnread()));
        notificationQuery.setOnlyNew(Boolean.TRUE.equals(notificationQueryFilters.getOnlyNew()));
        return notificationQuery;
    }

    public NotificationsStatus toNotificationsStatus(NotificationsStatusVO notificationsStatusVO) {
        if (notificationsStatusVO == null) {
            return null;
        }
        NotificationsStatus notificationsStatus = new NotificationsStatus();
        notificationsStatus.setLastViewDate(notificationsStatusVO.getLastViewDate());
        notificationsStatus.setNewNotifications(notificationsStatusVO.getNewNotifications());
        notificationsStatus.setUnreadNotifications(notificationsStatusVO.getUnreadNotifications());
        return notificationsStatus;
    }

    public INotificationType toNotificationType(NotificationTypeEnum notificationTypeEnum) {
        if (notificationTypeEnum != null) {
            switch (notificationTypeEnum) {
                case ALL_NON_SMS_PERFORMED_PAYMENTS: {
                    return AccountNotificationType.ALL_NON_SMS_PERFORMED_PAYMENTS;
                }
                case AUTHORIZED_PAYMENT_CANCELED: {
                    return AccountNotificationType.AUTHORIZED_PAYMENT_CANCELED;
                }
                case AUTHORIZED_PAYMENT_DENIED: {
                    return AccountNotificationType.AUTHORIZED_PAYMENT_DENIED;
                }
                case AUTHORIZED_PAYMENT_EXPIRED: {
                    return AccountNotificationType.AUTHORIZED_PAYMENT_EXPIRED;
                }
                case AUTHORIZED_PAYMENT_SUCCEEDED: {
                    return AccountNotificationType.AUTHORIZED_PAYMENT_SUCCEEDED;
                }
                case EXTERNAL_PAYMENT_EXPIRED: {
                    return AccountNotificationType.EXTERNAL_PAYMENT_EXPIRED;
                }
                case EXTERNAL_PAYMENT_PERFORMED_FAILED: {
                    return AccountNotificationType.EXTERNAL_PAYMENT_PERFORMED_FAILED;
                }
                case EXTERNAL_PAYMENT_RECEIVED_FAILED: {
                    return AccountNotificationType.EXTERNAL_PAYMENT_RECEIVED_FAILED;
                }
                case INCOMING_RECURRING_PAYMENT_CANCELED: {
                    return AccountNotificationType.INCOMING_RECURRING_PAYMENT_CANCELED;
                }
                case INCOMING_RECURRING_PAYMENT_FAILED: {
                    return AccountNotificationType.INCOMING_RECURRING_PAYMENT_FAILED;
                }
                case INCOMING_RECURRING_PAYMENT_RECEIVED: {
                    return AccountNotificationType.INCOMING_RECURRING_PAYMENT_RECEIVED;
                }
                case INCOMING_SCHEDULED_PAYMENT_CANCELED: {
                    return AccountNotificationType.INCOMING_SCHEDULED_PAYMENT_CANCELED;
                }
                case INCOMING_SCHEDULED_PAYMENT_FAILED: {
                    return AccountNotificationType.INCOMING_SCHEDULED_PAYMENT_FAILED;
                }
                case INCOMING_SCHEDULED_PAYMENT_RECEIVED: {
                    return AccountNotificationType.INCOMING_SCHEDULED_PAYMENT_RECEIVED;
                }
                case LIMIT_CHANGE: {
                    return AccountNotificationType.LIMIT_CHANGE;
                }
                case OPERATOR_AUTHORIZED_PAYMENT_APPROVED_STILL_PENDING: {
                    return AccountNotificationType.OPERATOR_AUTHORIZED_PAYMENT_APPROVED_STILL_PENDING;
                }
                case OPERATOR_AUTHORIZED_PAYMENT_CANCELED: {
                    return AccountNotificationType.OPERATOR_AUTHORIZED_PAYMENT_CANCELED;
                }
                case OPERATOR_AUTHORIZED_PAYMENT_DENIED: {
                    return AccountNotificationType.OPERATOR_AUTHORIZED_PAYMENT_DENIED;
                }
                case OPERATOR_AUTHORIZED_PAYMENT_EXPIRED: {
                    return AccountNotificationType.OPERATOR_AUTHORIZED_PAYMENT_EXPIRED;
                }
                case OPERATOR_AUTHORIZED_PAYMENT_SUCCEEDED: {
                    return AccountNotificationType.OPERATOR_AUTHORIZED_PAYMENT_SUCCEEDED;
                }
                case OPERATOR_PAYMENT_AWAITING_AUTHORIZATION: {
                    return AccountNotificationType.OPERATOR_PAYMENT_AWAITING_AUTHORIZATION;
                }
                case PAYMENT_AWAITING_AUTHORIZATION: {
                    return AccountNotificationType.PAYMENT_AWAITING_AUTHORIZATION;
                }
                case PAYMENT_PERFORMED_CHARGED_BACK: {
                    return AccountNotificationType.PAYMENT_PERFORMED_CHARGED_BACK;
                }
                case PAYMENT_RECEIVED_CHARGED_BACK: {
                    return AccountNotificationType.PAYMENT_RECEIVED_CHARGED_BACK;
                }
                case PAYMENT_RECEIVED: {
                    return AccountNotificationType.PAYMENT_RECEIVED;
                }
                case PAYMENT_REQUEST_CANCELED: {
                    return AccountNotificationType.PAYMENT_REQUEST_CANCELED;
                }
                case PAYMENT_REQUEST_DENIED: {
                    return AccountNotificationType.PAYMENT_REQUEST_DENIED;
                }
                case PAYMENT_REQUEST_EXPIRATION_DATE_CHANGED: {
                    return AccountNotificationType.PAYMENT_REQUEST_EXPIRATION_DATE_CHANGED;
                }
                case PAYMENT_REQUEST_EXPIRED: {
                    return AccountNotificationType.PAYMENT_REQUEST_EXPIRED;
                }
                case PAYMENT_REQUEST_PROCESSED: {
                    return AccountNotificationType.PAYMENT_REQUEST_PROCESSED;
                }
                case PAYMENT_REQUEST_RECEIVED: {
                    return AccountNotificationType.PAYMENT_REQUEST_RECEIVED;
                }
                case RECURRING_PAYMENT_FAILED: {
                    return AccountNotificationType.RECURRING_PAYMENT_FAILED;
                }
                case RECURRING_PAYMENT_OCCURRENCE_PROCESSED: {
                    return AccountNotificationType.RECURRING_PAYMENT_OCCURRENCE_PROCESSED;
                }
                case SCHEDULED_PAYMENT_FAILED: {
                    return AccountNotificationType.SCHEDULED_PAYMENT_FAILED;
                }
                case SCHEDULED_PAYMENT_INSTALLMENT_PROCESSED: {
                    return AccountNotificationType.SCHEDULED_PAYMENT_INSTALLMENT_PROCESSED;
                }
                case SCHEDULED_PAYMENT_REQUEST_FAILED: {
                    return AccountNotificationType.SCHEDULED_PAYMENT_REQUEST_FAILED;
                }
                case SENT_PAYMENT_REQUEST_EXPIRATION_DATE_CHANGED: {
                    return AccountNotificationType.SENT_PAYMENT_REQUEST_EXPIRATION_DATE_CHANGED;
                }
                case SMS_PERFORMED_PAYMENT: {
                    return AccountNotificationType.SMS_PERFORMED_PAYMENT;
                }
                case TICKET_WEBHOOK_FAILED: {
                    return AccountNotificationType.TICKET_WEBHOOK_FAILED;
                }
                case VOUCHER_ABOUT_TO_EXPIRE: {
                    return AccountNotificationType.VOUCHER_ABOUT_TO_EXPIRE;
                }
                case VOUCHER_EXPIRATION_DATE_CHANGED: {
                    return AccountNotificationType.VOUCHER_EXPIRATION_DATE_CHANGED;
                }
                case VOUCHER_EXPIRED: {
                    return AccountNotificationType.VOUCHER_EXPIRED;
                }
                case VOUCHER_PIN_BLOCKED: {
                    return AccountNotificationType.VOUCHER_PIN_BLOCKED;
                }
                case VOUCHER_REDEEM: {
                    return AccountNotificationType.VOUCHER_REDEEM;
                }
                case VOUCHER_TOP_UP: {
                    return AccountNotificationType.VOUCHER_TOP_UP;
                }
                case VOUCHER_ASSIGNED: {
                    return AccountNotificationType.VOUCHER_ASSIGNED;
                }
                case AD_PENDING_BY_ADMIN_AUTHORIZATION: {
                    return AdminNotificationType.AD_PENDING_AUTHORIZATION;
                }
                case APPLICATION_ERROR: {
                    return AdminNotificationType.APPLICATION_ERROR;
                }
                case EXTERNAL_USER_PAYMENT_EXPIRED: {
                    return AdminNotificationType.EXTERNAL_PAYMENT_EXPIRED;
                }
                case EXTERNAL_USER_PAYMENT_PERFORMED_FAILED: {
                    return AdminNotificationType.EXTERNAL_PAYMENT_PERFORMED_FAILED;
                }
                case GENERATED_VOUCHERS_ABOUT_TO_EXPIRE: {
                    return AdminNotificationType.GENERATED_VOUCHERS_ABOUT_TO_EXPIRE;
                }
                case GENERATED_VOUCHERS_EXPIRED: {
                    return AdminNotificationType.GENERATED_VOUCHERS_EXPIRED;
                }
                case NETWORK_CREATED: {
                    return AdminNotificationType.NETWORK_CREATED;
                }
                case PAYMENT_AWAITING_ADMIN_AUTHORIZATION: {
                    return AdminNotificationType.PAYMENT_AWAITING_AUTHORIZATION;
                }
                case PAYMENT_PERFORMED: {
                    return AdminNotificationType.PAYMENT_PERFORMED;
                }
                case SYSTEM_ALERT: {
                    return AdminNotificationType.SYSTEM_ALERT;
                }
                case USER_ALERT: {
                    return AdminNotificationType.USER_ALERT;
                }
                case USER_IMPORT: {
                    return AdminNotificationType.USER_IMPORT_REGISTRATION;
                }
                case USER_REGISTRATION: {
                    return AdminNotificationType.USER_REGISTRATION;
                }
                case VOUCHER_BUYING_ABOUT_TO_EXPIRE: {
                    return AdminNotificationType.VOUCHER_BUYING_ABOUT_TO_EXPIRE;
                }
                case AD_PENDING_AUTHORIZATION: {
                    return BrokeringNotificationType.AD_PENDING_AUTHORIZATION;
                }
                case MEMBER_ASSIGNED: {
                    return BrokeringNotificationType.MEMBER_ASSIGNED;
                }
                case MEMBER_UNASSIGNED: {
                    return BrokeringNotificationType.MEMBER_UNASSIGNED;
                }
                case AD_INTEREST_NOTIFICATION: {
                    return MarketplaceBuyerNotificationType.AD_INTEREST_NOTIFICATION;
                }
                case AD_QUESTION_ANSWERED: {
                    return MarketplaceBuyerNotificationType.AD_QUESTION_ANSWERED;
                }
                case ORDER_CANCELED_BUYER: {
                    return MarketplaceBuyerNotificationType.ORDER_CANCELED_BUYER;
                }
                case ORDER_PAYMENT_CANCELED_BUYER: {
                    return MarketplaceBuyerNotificationType.ORDER_PAYMENT_CANCELED_BUYER;
                }
                case ORDER_PAYMENT_DENIED_BUYER: {
                    return MarketplaceBuyerNotificationType.ORDER_PAYMENT_DENIED_BUYER;
                }
                case ORDER_PAYMENT_EXPIRED_BUYER: {
                    return MarketplaceBuyerNotificationType.ORDER_PAYMENT_EXPIRED_BUYER;
                }
                case ORDER_PENDING_BUYER: {
                    return MarketplaceBuyerNotificationType.ORDER_PENDING_BUYER;
                }
                case ORDER_PENDING_AUTHORIZATION_BUYER: {
                    return MarketplaceBuyerNotificationType.ORDER_PENDING_AUTHORIZATION_BUYER;
                }
                case ORDER_PENDING_DELIVERY_DATA_BUYER: {
                    return MarketplaceBuyerNotificationType.ORDER_PENDING_DELIVERY_DATA_BUYER;
                }
                case ORDER_REALIZED_SELLER: {
                    return MarketplaceBuyerNotificationType.ORDER_REALIZED_SELLER;
                }
                case ORDER_REJECTED_BY_SELLER: {
                    return MarketplaceBuyerNotificationType.ORDER_REJECTED_BY_SELLER;
                }
                case SALE_PENDING_BUYER: {
                    return MarketplaceBuyerNotificationType.SALE_PENDING_BUYER;
                }
                case SALE_REJECTED_SELLER: {
                    return MarketplaceBuyerNotificationType.SALE_REJECTED_SELLER;
                }
                case FEEDBACK_CHANGED: {
                    return FeedbackAndReferenceNotificationType.FEEDBACK_CHANGED;
                }
                case FEEDBACK_CREATED: {
                    return FeedbackAndReferenceNotificationType.FEEDBACK_CREATED;
                }
                case FEEDBACK_EXPIRATION_REMINDER: {
                    return FeedbackAndReferenceNotificationType.FEEDBACK_EXPIRATION_REMINDER;
                }
                case FEEDBACK_OPTIONAL: {
                    return FeedbackAndReferenceNotificationType.FEEDBACK_OPTIONAL;
                }
                case FEEDBACK_REPLY_CREATED: {
                    return FeedbackAndReferenceNotificationType.FEEDBACK_REPLY_CREATED;
                }
                case FEEDBACK_REQUIRED: {
                    return FeedbackAndReferenceNotificationType.FEEDBACK_REQUIRED;
                }
                case BROKER_ASSIGNED: {
                    return PersonalNotificationType.BROKER_ASSIGNED;
                }
                case BROKER_UNASSIGNED: {
                    return PersonalNotificationType.BROKER_UNASSIGNED;
                }
                case MAX_SMS_PER_MONTH_REACHED: {
                    return PersonalNotificationType.MAX_SMS_PER_MONTH_REACHED;
                }
                case NEW_TOKEN: {
                    return PersonalNotificationType.NEW_TOKEN;
                }
                case NEW_TOKEN_PENDING_ACTIVATION: {
                    return PersonalNotificationType.NEW_TOKEN_PENDING_ACTIVATION;
                }
                case PASSWORD_STATUS_CHANGED: {
                    return PersonalNotificationType.PASSWORD_STATUS_CHANGED;
                }
                case TOKEN_STATUS_CHANGED: {
                    return PersonalNotificationType.TOKEN_STATUS_CHANGED;
                }
                case USER_STATUS_CHANGED: {
                    return PersonalNotificationType.USER_STATUS_CHANGED;
                }
                case REFERENCE_CHANGED: {
                    return FeedbackAndReferenceNotificationType.REFERENCE_CHANGED;
                }
                case REFERENCE_CREATED: {
                    return FeedbackAndReferenceNotificationType.REFERENCE_CREATED;
                }
                case AD_AUTHORIZED: {
                    return MarketplaceSellerNotificationType.AD_AUTHORIZED;
                }
                case AD_EXPIRED: {
                    return MarketplaceSellerNotificationType.AD_EXPIRED;
                }
                case LOW_STOCK_QUANTITY: {
                    return MarketplaceSellerNotificationType.LOW_STOCK_QUANTITY;
                }
                case ARTICLE_OUT_OF_STOCK: {
                    return MarketplaceSellerNotificationType.ARTICLE_OUT_OF_STOCK;
                }
                case AD_QUESTION_CREATED: {
                    return MarketplaceSellerNotificationType.AD_QUESTION_CREATED;
                }
                case AD_REJECTED: {
                    return MarketplaceSellerNotificationType.AD_REJECTED;
                }
                case ORDER_CANCELED_SELLER: {
                    return MarketplaceSellerNotificationType.ORDER_CANCELED_SELLER;
                }
                case ORDER_CREATED: {
                    return MarketplaceSellerNotificationType.ORDER_CREATED;
                }
                case ORDER_PAYMENT_CANCELED_SELLER: {
                    return MarketplaceSellerNotificationType.ORDER_PAYMENT_CANCELED_SELLER;
                }
                case ORDER_PAYMENT_DENIED_SELLER: {
                    return MarketplaceSellerNotificationType.ORDER_PAYMENT_DENIED_SELLER;
                }
                case ORDER_PAYMENT_EXPIRED_SELLER: {
                    return MarketplaceSellerNotificationType.ORDER_PAYMENT_EXPIRED_SELLER;
                }
                case ORDER_PENDING_AUTHORIZATION_SELLER: {
                    return MarketplaceSellerNotificationType.ORDER_PENDING_AUTHORIZATION_SELLER;
                }
                case ORDER_PENDING_DELIVERY_DATA_SELLER: {
                    return MarketplaceSellerNotificationType.ORDER_PENDING_DELIVERY_DATA_SELLER;
                }
                case ORDER_REALIZED_BUYER: {
                    return MarketplaceSellerNotificationType.ORDER_REALIZED_BUYER;
                }
                case ORDER_REJECTED_BY_BUYER: {
                    return MarketplaceSellerNotificationType.ORDER_REJECTED_BY_BUYER;
                }
                case SALE_REALIZED_BUYER: {
                    return MarketplaceSellerNotificationType.SALE_REALIZED_BUYER;
                }
                case BOUGHT_VOUCHERS_ABOUT_TO_EXPIRE: {
                    return AccountNotificationType.VOUCHER_ABOUT_TO_EXPIRE;
                }
                case BOUGHT_VOUCHERS_EXPIRATION_DATE_CHANGED: {
                    return AccountNotificationType.VOUCHER_EXPIRATION_DATE_CHANGED;
                }
                case BOUGHT_VOUCHERS_EXPIRED: {
                    return AccountNotificationType.VOUCHER_EXPIRED;
                }
            }
        }
        return null;
    }

    public NotificationTypeEnum toNotificationTypeEnum(AdminNotificationType adminNotificationType) {
        NotificationTypeEnum notificationTypeEnum = null;
        if (adminNotificationType != null) {
            switch (adminNotificationType) {
                case AD_PENDING_AUTHORIZATION: {
                    notificationTypeEnum = NotificationTypeEnum.AD_PENDING_BY_ADMIN_AUTHORIZATION;
                    break;
                }
                case APPLICATION_ERROR: {
                    notificationTypeEnum = NotificationTypeEnum.APPLICATION_ERROR;
                    break;
                }
                case EXTERNAL_PAYMENT_EXPIRED: {
                    notificationTypeEnum = NotificationTypeEnum.EXTERNAL_USER_PAYMENT_EXPIRED;
                    break;
                }
                case EXTERNAL_PAYMENT_PERFORMED_FAILED: {
                    notificationTypeEnum = NotificationTypeEnum.EXTERNAL_USER_PAYMENT_PERFORMED_FAILED;
                    break;
                }
                case GENERATED_VOUCHERS_ABOUT_TO_EXPIRE: {
                    notificationTypeEnum = NotificationTypeEnum.GENERATED_VOUCHERS_ABOUT_TO_EXPIRE;
                    break;
                }
                case GENERATED_VOUCHERS_EXPIRED: {
                    notificationTypeEnum = NotificationTypeEnum.GENERATED_VOUCHERS_EXPIRED;
                    break;
                }
                case NETWORK_CREATED: {
                    notificationTypeEnum = NotificationTypeEnum.NETWORK_CREATED;
                    break;
                }
                case PAYMENT_AWAITING_AUTHORIZATION: {
                    notificationTypeEnum = NotificationTypeEnum.PAYMENT_AWAITING_ADMIN_AUTHORIZATION;
                    break;
                }
                case PAYMENT_PERFORMED: {
                    notificationTypeEnum = NotificationTypeEnum.PAYMENT_PERFORMED;
                    break;
                }
                case SYSTEM_ALERT: {
                    notificationTypeEnum = NotificationTypeEnum.SYSTEM_ALERT;
                    break;
                }
                case USER_ALERT: {
                    notificationTypeEnum = NotificationTypeEnum.USER_ALERT;
                    break;
                }
                case USER_IMPORT_REGISTRATION: {
                    notificationTypeEnum = NotificationTypeEnum.USER_IMPORT;
                    break;
                }
                case USER_REGISTRATION: {
                    notificationTypeEnum = NotificationTypeEnum.USER_REGISTRATION;
                    break;
                }
                case VOUCHER_BUYING_ABOUT_TO_EXPIRE: {
                    notificationTypeEnum = NotificationTypeEnum.VOUCHER_BUYING_ABOUT_TO_EXPIRE;
                }
            }
        }
        return notificationTypeEnum;
    }

    public NotificationTypeEnum toNotificationTypeEnum(INotificationType iNotificationType) {
        NotificationTypeEnum notificationTypeEnum = null;
        if (iNotificationType instanceof AdminNotificationType) {
            notificationTypeEnum = this.toNotificationTypeEnum((AdminNotificationType)iNotificationType);
        } else if (iNotificationType instanceof UserNotificationType) {
            notificationTypeEnum = this.toNotificationTypeEnum((UserNotificationType)iNotificationType);
        }
        return notificationTypeEnum;
    }

    public NotificationTypeEnum toNotificationTypeEnum(UserNotificationType userNotificationType) {
        NotificationTypeEnum notificationTypeEnum = null;
        if (userNotificationType instanceof AccountNotificationType) {
            notificationTypeEnum = this.toNotificationTypeEnum((AccountNotificationType)userNotificationType);
        } else if (userNotificationType instanceof BrokeringNotificationType) {
            notificationTypeEnum = this.toNotificationTypeEnum((BrokeringNotificationType)userNotificationType);
        } else if (userNotificationType instanceof MarketplaceBuyerNotificationType) {
            notificationTypeEnum = this.toNotificationTypeEnum((MarketplaceBuyerNotificationType)userNotificationType);
        } else if (userNotificationType instanceof MarketplaceSellerNotificationType) {
            notificationTypeEnum = this.toNotificationTypeEnum((MarketplaceSellerNotificationType)userNotificationType);
        } else if (userNotificationType instanceof FeedbackAndReferenceNotificationType) {
            notificationTypeEnum = this.toNotificationTypeEnum((FeedbackAndReferenceNotificationType)userNotificationType);
        } else if (userNotificationType instanceof PersonalNotificationType) {
            notificationTypeEnum = this.toNotificationTypeEnum((PersonalNotificationType)userNotificationType);
        }
        return notificationTypeEnum;
    }

    private NotificationTypeEnum toNotificationTypeEnum(AccountNotificationType accountNotificationType) {
        if (accountNotificationType != null) {
            switch (accountNotificationType) {
                case ALL_NON_SMS_PERFORMED_PAYMENTS: {
                    return NotificationTypeEnum.ALL_NON_SMS_PERFORMED_PAYMENTS;
                }
                case AUTHORIZED_PAYMENT_CANCELED: {
                    return NotificationTypeEnum.AUTHORIZED_PAYMENT_CANCELED;
                }
                case AUTHORIZED_PAYMENT_DENIED: {
                    return NotificationTypeEnum.AUTHORIZED_PAYMENT_DENIED;
                }
                case AUTHORIZED_PAYMENT_EXPIRED: {
                    return NotificationTypeEnum.AUTHORIZED_PAYMENT_EXPIRED;
                }
                case AUTHORIZED_PAYMENT_SUCCEEDED: {
                    return NotificationTypeEnum.AUTHORIZED_PAYMENT_SUCCEEDED;
                }
                case VOUCHER_ASSIGNED: {
                    return NotificationTypeEnum.VOUCHER_ASSIGNED;
                }
                case VOUCHER_ABOUT_TO_EXPIRE: {
                    return NotificationTypeEnum.VOUCHER_ABOUT_TO_EXPIRE;
                }
                case VOUCHER_EXPIRATION_DATE_CHANGED: {
                    return NotificationTypeEnum.VOUCHER_EXPIRATION_DATE_CHANGED;
                }
                case VOUCHER_EXPIRED: {
                    return NotificationTypeEnum.VOUCHER_EXPIRED;
                }
                case VOUCHER_PIN_BLOCKED: {
                    return NotificationTypeEnum.VOUCHER_PIN_BLOCKED;
                }
                case VOUCHER_REDEEM: {
                    return NotificationTypeEnum.VOUCHER_REDEEM;
                }
                case VOUCHER_TOP_UP: {
                    return NotificationTypeEnum.VOUCHER_TOP_UP;
                }
                case EXTERNAL_PAYMENT_EXPIRED: {
                    return NotificationTypeEnum.EXTERNAL_PAYMENT_EXPIRED;
                }
                case EXTERNAL_PAYMENT_PERFORMED_FAILED: {
                    return NotificationTypeEnum.EXTERNAL_PAYMENT_PERFORMED_FAILED;
                }
                case EXTERNAL_PAYMENT_RECEIVED_FAILED: {
                    return NotificationTypeEnum.EXTERNAL_PAYMENT_RECEIVED_FAILED;
                }
                case INCOMING_RECURRING_PAYMENT_CANCELED: {
                    return NotificationTypeEnum.INCOMING_RECURRING_PAYMENT_CANCELED;
                }
                case INCOMING_RECURRING_PAYMENT_FAILED: {
                    return NotificationTypeEnum.INCOMING_RECURRING_PAYMENT_FAILED;
                }
                case INCOMING_RECURRING_PAYMENT_RECEIVED: {
                    return NotificationTypeEnum.INCOMING_RECURRING_PAYMENT_RECEIVED;
                }
                case INCOMING_SCHEDULED_PAYMENT_CANCELED: {
                    return NotificationTypeEnum.INCOMING_SCHEDULED_PAYMENT_CANCELED;
                }
                case INCOMING_SCHEDULED_PAYMENT_FAILED: {
                    return NotificationTypeEnum.INCOMING_SCHEDULED_PAYMENT_FAILED;
                }
                case INCOMING_SCHEDULED_PAYMENT_RECEIVED: {
                    return NotificationTypeEnum.INCOMING_SCHEDULED_PAYMENT_RECEIVED;
                }
                case LIMIT_CHANGE: {
                    return NotificationTypeEnum.LIMIT_CHANGE;
                }
                case OPERATOR_AUTHORIZED_PAYMENT_APPROVED_STILL_PENDING: {
                    return NotificationTypeEnum.OPERATOR_AUTHORIZED_PAYMENT_APPROVED_STILL_PENDING;
                }
                case OPERATOR_AUTHORIZED_PAYMENT_CANCELED: {
                    return NotificationTypeEnum.OPERATOR_AUTHORIZED_PAYMENT_CANCELED;
                }
                case OPERATOR_AUTHORIZED_PAYMENT_DENIED: {
                    return NotificationTypeEnum.OPERATOR_AUTHORIZED_PAYMENT_DENIED;
                }
                case OPERATOR_AUTHORIZED_PAYMENT_EXPIRED: {
                    return NotificationTypeEnum.OPERATOR_AUTHORIZED_PAYMENT_EXPIRED;
                }
                case OPERATOR_AUTHORIZED_PAYMENT_SUCCEEDED: {
                    return NotificationTypeEnum.OPERATOR_AUTHORIZED_PAYMENT_SUCCEEDED;
                }
                case OPERATOR_PAYMENT_AWAITING_AUTHORIZATION: {
                    return NotificationTypeEnum.OPERATOR_PAYMENT_AWAITING_AUTHORIZATION;
                }
                case PAYMENT_AWAITING_AUTHORIZATION: {
                    return NotificationTypeEnum.PAYMENT_AWAITING_AUTHORIZATION;
                }
                case PAYMENT_RECEIVED: {
                    return NotificationTypeEnum.PAYMENT_RECEIVED;
                }
                case PAYMENT_REQUEST_CANCELED: {
                    return NotificationTypeEnum.PAYMENT_REQUEST_CANCELED;
                }
                case PAYMENT_REQUEST_DENIED: {
                    return NotificationTypeEnum.PAYMENT_REQUEST_DENIED;
                }
                case PAYMENT_REQUEST_EXPIRATION_DATE_CHANGED: {
                    return NotificationTypeEnum.PAYMENT_REQUEST_EXPIRATION_DATE_CHANGED;
                }
                case SENT_PAYMENT_REQUEST_EXPIRATION_DATE_CHANGED: {
                    return NotificationTypeEnum.SENT_PAYMENT_REQUEST_EXPIRATION_DATE_CHANGED;
                }
                case PAYMENT_REQUEST_EXPIRED: {
                    return NotificationTypeEnum.PAYMENT_REQUEST_EXPIRED;
                }
                case PAYMENT_REQUEST_PROCESSED: {
                    return NotificationTypeEnum.PAYMENT_REQUEST_PROCESSED;
                }
                case PAYMENT_REQUEST_RECEIVED: {
                    return NotificationTypeEnum.PAYMENT_REQUEST_RECEIVED;
                }
                case RECURRING_PAYMENT_FAILED: {
                    return NotificationTypeEnum.RECURRING_PAYMENT_FAILED;
                }
                case RECURRING_PAYMENT_OCCURRENCE_PROCESSED: {
                    return NotificationTypeEnum.RECURRING_PAYMENT_OCCURRENCE_PROCESSED;
                }
                case SCHEDULED_PAYMENT_FAILED: {
                    return NotificationTypeEnum.SCHEDULED_PAYMENT_FAILED;
                }
                case SCHEDULED_PAYMENT_INSTALLMENT_PROCESSED: {
                    return NotificationTypeEnum.SCHEDULED_PAYMENT_INSTALLMENT_PROCESSED;
                }
                case SCHEDULED_PAYMENT_REQUEST_FAILED: {
                    return NotificationTypeEnum.SCHEDULED_PAYMENT_REQUEST_FAILED;
                }
                case SMS_PERFORMED_PAYMENT: {
                    return NotificationTypeEnum.SMS_PERFORMED_PAYMENT;
                }
                case TICKET_WEBHOOK_FAILED: {
                    return NotificationTypeEnum.TICKET_WEBHOOK_FAILED;
                }
                case PAYMENT_PERFORMED_CHARGED_BACK: {
                    return NotificationTypeEnum.PAYMENT_PERFORMED_CHARGED_BACK;
                }
                case PAYMENT_RECEIVED_CHARGED_BACK: {
                    return NotificationTypeEnum.PAYMENT_RECEIVED_CHARGED_BACK;
                }
            }
        }
        return null;
    }

    private NotificationTypeEnum toNotificationTypeEnum(BrokeringNotificationType brokeringNotificationType) {
        NotificationTypeEnum notificationTypeEnum = null;
        if (brokeringNotificationType != null) {
            switch (brokeringNotificationType) {
                case AD_PENDING_AUTHORIZATION: {
                    notificationTypeEnum = NotificationTypeEnum.AD_PENDING_AUTHORIZATION;
                    break;
                }
                case MEMBER_ASSIGNED: {
                    notificationTypeEnum = NotificationTypeEnum.MEMBER_ASSIGNED;
                    break;
                }
                case MEMBER_UNASSIGNED: {
                    notificationTypeEnum = NotificationTypeEnum.MEMBER_UNASSIGNED;
                }
            }
        }
        return notificationTypeEnum;
    }

    private NotificationTypeEnum toNotificationTypeEnum(FeedbackAndReferenceNotificationType feedbackAndReferenceNotificationType) {
        NotificationTypeEnum notificationTypeEnum = null;
        if (feedbackAndReferenceNotificationType != null) {
            switch (feedbackAndReferenceNotificationType) {
                case FEEDBACK_CHANGED: {
                    notificationTypeEnum = NotificationTypeEnum.FEEDBACK_CHANGED;
                    break;
                }
                case FEEDBACK_CREATED: {
                    notificationTypeEnum = NotificationTypeEnum.FEEDBACK_CREATED;
                    break;
                }
                case FEEDBACK_EXPIRATION_REMINDER: {
                    notificationTypeEnum = NotificationTypeEnum.FEEDBACK_EXPIRATION_REMINDER;
                    break;
                }
                case FEEDBACK_OPTIONAL: {
                    notificationTypeEnum = NotificationTypeEnum.FEEDBACK_OPTIONAL;
                    break;
                }
                case FEEDBACK_REPLY_CREATED: {
                    notificationTypeEnum = NotificationTypeEnum.FEEDBACK_REPLY_CREATED;
                    break;
                }
                case FEEDBACK_REQUIRED: {
                    notificationTypeEnum = NotificationTypeEnum.FEEDBACK_REQUIRED;
                    break;
                }
                case REFERENCE_CHANGED: {
                    notificationTypeEnum = NotificationTypeEnum.REFERENCE_CHANGED;
                    break;
                }
                case REFERENCE_CREATED: {
                    notificationTypeEnum = NotificationTypeEnum.REFERENCE_CREATED;
                }
            }
        }
        return notificationTypeEnum;
    }

    private NotificationTypeEnum toNotificationTypeEnum(MarketplaceBuyerNotificationType marketplaceBuyerNotificationType) {
        NotificationTypeEnum notificationTypeEnum = null;
        if (marketplaceBuyerNotificationType != null) {
            switch (marketplaceBuyerNotificationType) {
                case AD_INTEREST_NOTIFICATION: {
                    notificationTypeEnum = NotificationTypeEnum.AD_INTEREST_NOTIFICATION;
                    break;
                }
                case AD_QUESTION_ANSWERED: {
                    notificationTypeEnum = NotificationTypeEnum.AD_QUESTION_ANSWERED;
                    break;
                }
                case ORDER_CANCELED_BUYER: {
                    notificationTypeEnum = NotificationTypeEnum.ORDER_CANCELED_BUYER;
                    break;
                }
                case ORDER_PAYMENT_CANCELED_BUYER: {
                    notificationTypeEnum = NotificationTypeEnum.ORDER_PAYMENT_CANCELED_BUYER;
                    break;
                }
                case ORDER_PAYMENT_EXPIRED_BUYER: {
                    notificationTypeEnum = NotificationTypeEnum.ORDER_PAYMENT_EXPIRED_BUYER;
                    break;
                }
                case ORDER_PAYMENT_DENIED_BUYER: {
                    notificationTypeEnum = NotificationTypeEnum.ORDER_PAYMENT_DENIED_BUYER;
                    break;
                }
                case ORDER_PENDING_AUTHORIZATION_BUYER: {
                    notificationTypeEnum = NotificationTypeEnum.ORDER_PENDING_AUTHORIZATION_BUYER;
                    break;
                }
                case ORDER_PENDING_BUYER: {
                    notificationTypeEnum = NotificationTypeEnum.ORDER_PENDING_BUYER;
                    break;
                }
                case ORDER_PENDING_DELIVERY_DATA_BUYER: {
                    notificationTypeEnum = NotificationTypeEnum.ORDER_PENDING_DELIVERY_DATA_BUYER;
                    break;
                }
                case ORDER_REALIZED_SELLER: {
                    notificationTypeEnum = NotificationTypeEnum.ORDER_REALIZED_SELLER;
                    break;
                }
                case ORDER_REJECTED_BY_SELLER: {
                    notificationTypeEnum = NotificationTypeEnum.ORDER_REJECTED_BY_SELLER;
                    break;
                }
                case SALE_PENDING_BUYER: {
                    notificationTypeEnum = NotificationTypeEnum.SALE_PENDING_BUYER;
                    break;
                }
                case SALE_REJECTED_SELLER: {
                    notificationTypeEnum = NotificationTypeEnum.SALE_REJECTED_SELLER;
                }
            }
        }
        return notificationTypeEnum;
    }

    private NotificationTypeEnum toNotificationTypeEnum(MarketplaceSellerNotificationType marketplaceSellerNotificationType) {
        NotificationTypeEnum notificationTypeEnum = null;
        if (marketplaceSellerNotificationType != null) {
            switch (marketplaceSellerNotificationType) {
                case AD_AUTHORIZED: {
                    notificationTypeEnum = NotificationTypeEnum.AD_AUTHORIZED;
                    break;
                }
                case AD_EXPIRED: {
                    notificationTypeEnum = NotificationTypeEnum.AD_EXPIRED;
                    break;
                }
                case AD_QUESTION_CREATED: {
                    notificationTypeEnum = NotificationTypeEnum.AD_QUESTION_CREATED;
                    break;
                }
                case AD_REJECTED: {
                    notificationTypeEnum = NotificationTypeEnum.AD_REJECTED;
                    break;
                }
                case ARTICLE_OUT_OF_STOCK: {
                    notificationTypeEnum = NotificationTypeEnum.ARTICLE_OUT_OF_STOCK;
                    break;
                }
                case LOW_STOCK_QUANTITY: {
                    notificationTypeEnum = NotificationTypeEnum.LOW_STOCK_QUANTITY;
                    break;
                }
                case ORDER_CANCELED_SELLER: {
                    notificationTypeEnum = NotificationTypeEnum.ORDER_CANCELED_SELLER;
                    break;
                }
                case ORDER_CREATED: {
                    notificationTypeEnum = NotificationTypeEnum.ORDER_CREATED;
                    break;
                }
                case ORDER_PAYMENT_CANCELED_SELLER: {
                    notificationTypeEnum = NotificationTypeEnum.ORDER_PAYMENT_CANCELED_SELLER;
                    break;
                }
                case ORDER_PAYMENT_DENIED_SELLER: {
                    notificationTypeEnum = NotificationTypeEnum.ORDER_PAYMENT_DENIED_SELLER;
                    break;
                }
                case ORDER_PAYMENT_EXPIRED_SELLER: {
                    notificationTypeEnum = NotificationTypeEnum.ORDER_PAYMENT_EXPIRED_SELLER;
                    break;
                }
                case ORDER_PENDING_AUTHORIZATION_SELLER: {
                    notificationTypeEnum = NotificationTypeEnum.ORDER_PENDING_AUTHORIZATION_SELLER;
                    break;
                }
                case ORDER_PENDING_DELIVERY_DATA_SELLER: {
                    notificationTypeEnum = NotificationTypeEnum.ORDER_PENDING_DELIVERY_DATA_SELLER;
                    break;
                }
                case ORDER_REALIZED_BUYER: {
                    notificationTypeEnum = NotificationTypeEnum.ORDER_REALIZED_BUYER;
                    break;
                }
                case ORDER_REJECTED_BY_BUYER: {
                    notificationTypeEnum = NotificationTypeEnum.ORDER_REJECTED_BY_BUYER;
                    break;
                }
                case SALE_REALIZED_BUYER: {
                    notificationTypeEnum = NotificationTypeEnum.SALE_REALIZED_BUYER;
                }
            }
        }
        return notificationTypeEnum;
    }

    private NotificationTypeEnum toNotificationTypeEnum(PersonalNotificationType personalNotificationType) {
        NotificationTypeEnum notificationTypeEnum = null;
        if (personalNotificationType != null) {
            switch (personalNotificationType) {
                case BROKER_ASSIGNED: {
                    notificationTypeEnum = NotificationTypeEnum.BROKER_ASSIGNED;
                    break;
                }
                case BROKER_UNASSIGNED: {
                    notificationTypeEnum = NotificationTypeEnum.BROKER_UNASSIGNED;
                    break;
                }
                case MAX_SMS_PER_MONTH_REACHED: {
                    notificationTypeEnum = NotificationTypeEnum.MAX_SMS_PER_MONTH_REACHED;
                    break;
                }
                case NEW_TOKEN: {
                    notificationTypeEnum = NotificationTypeEnum.NEW_TOKEN;
                    break;
                }
                case NEW_TOKEN_PENDING_ACTIVATION: {
                    notificationTypeEnum = NotificationTypeEnum.NEW_TOKEN_PENDING_ACTIVATION;
                    break;
                }
                case PASSWORD_STATUS_CHANGED: {
                    notificationTypeEnum = NotificationTypeEnum.PASSWORD_STATUS_CHANGED;
                    break;
                }
                case TOKEN_STATUS_CHANGED: {
                    notificationTypeEnum = NotificationTypeEnum.TOKEN_STATUS_CHANGED;
                    break;
                }
                case USER_STATUS_CHANGED: {
                    notificationTypeEnum = NotificationTypeEnum.USER_STATUS_CHANGED;
                }
            }
        }
        return notificationTypeEnum;
    }
}

