/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import org.cyclos.model.users.users.RegionalSettingsDTO;
import org.cyclos.model.utils.LocaleVO;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rest.model.LocalizationSettings;
import org.cyclos.web.rest.model.UserLocale;
import org.springframework.stereotype.Component;

@Component
public class LocalizationApiHelper {
    public RegionalSettingsDTO toRegionalSettings(LocalizationSettings localizationSettings) {
        if (localizationSettings == null) {
            return null;
        }
        RegionalSettingsDTO regionalSettingsDTO = new RegionalSettingsDTO();
        regionalSettingsDTO.setLocale(localizationSettings.getLocale());
        return regionalSettingsDTO;
    }

    public UserLocale toUserLocale(LocaleVO localeVO) {
        if (localeVO == null) {
            return null;
        }
        UserLocale userLocale = this.newUserLocale(UserLocale.class, localeVO);
        return userLocale;
    }

    private UserLocale newUserLocale(Class<UserLocale> clazz, LocaleVO localeVO) {
        UserLocale userLocale = (UserLocale)ClassHelper.instantiate(clazz);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(localeVO.getLanguage());
        if (StringHelper.isNotBlank((Object)localeVO.getCountry())) {
            stringBuilder.append("_");
            stringBuilder.append(localeVO.getCountry());
            if (StringHelper.isNotBlank((Object)localeVO.getVariant())) {
                stringBuilder.append("_");
                stringBuilder.append(localeVO.getVariant());
            }
        }
        userLocale.setCode(stringBuilder.toString());
        userLocale.setName(localeVO.getName());
        return userLocale;
    }
}

