/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.model.EntityVO;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.banking.vouchertypes.VoucherTypeVO;
import org.cyclos.model.system.imports.AdImportedFileDTO;
import org.cyclos.model.system.imports.AdImportedFileData;
import org.cyclos.model.system.imports.GeneralReferenceImportedFileDTO;
import org.cyclos.model.system.imports.ImportProgressVO;
import org.cyclos.model.system.imports.ImportSearchContext;
import org.cyclos.model.system.imports.ImportType;
import org.cyclos.model.system.imports.ImportedFieldVO;
import org.cyclos.model.system.imports.ImportedFileDTO;
import org.cyclos.model.system.imports.ImportedFileData;
import org.cyclos.model.system.imports.ImportedFileDataParams;
import org.cyclos.model.system.imports.ImportedFileQuery;
import org.cyclos.model.system.imports.ImportedFileSearchData;
import org.cyclos.model.system.imports.ImportedFileStatus;
import org.cyclos.model.system.imports.ImportedFileVO;
import org.cyclos.model.system.imports.ImportedLineDTO;
import org.cyclos.model.system.imports.ImportedLineData;
import org.cyclos.model.system.imports.ImportedLineQuery;
import org.cyclos.model.system.imports.ImportedLineSearchData;
import org.cyclos.model.system.imports.ImportedLineStatus;
import org.cyclos.model.system.imports.ImportedLineVO;
import org.cyclos.model.system.imports.PaymentImportedFileDTO;
import org.cyclos.model.system.imports.RecordImportedFileDTO;
import org.cyclos.model.system.imports.RecordImportedFileData;
import org.cyclos.model.system.imports.TokenImportedFileDTO;
import org.cyclos.model.system.imports.TransferImportedFileDTO;
import org.cyclos.model.system.imports.UserImportedFileDTO;
import org.cyclos.model.system.imports.UserImportedFileData;
import org.cyclos.model.system.imports.UserPaymentImportedFileDTO;
import org.cyclos.model.system.imports.UserPaymentImportedFileData;
import org.cyclos.model.system.imports.UserSendVouchersImportedFileDTO;
import org.cyclos.model.system.imports.UserSendVouchersImportedFileData;
import org.cyclos.model.system.imports.UserSpecificImportedFileDTO;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.recordtypes.RecordTypeVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.GroupsApiHelper;
import org.cyclos.web.rest.helpers.RecordsApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.helpers.VouchersApiHelper;
import org.cyclos.web.rest.model.GeneralImportedFileContextEnum;
import org.cyclos.web.rest.model.GeneralImportedFileKind;
import org.cyclos.web.rest.model.ImportedField;
import org.cyclos.web.rest.model.ImportedFile;
import org.cyclos.web.rest.model.ImportedFileDataForEdit;
import org.cyclos.web.rest.model.ImportedFileDataForNew;
import org.cyclos.web.rest.model.ImportedFileDataForSearch;
import org.cyclos.web.rest.model.ImportedFileEdit;
import org.cyclos.web.rest.model.ImportedFileKind;
import org.cyclos.web.rest.model.ImportedFileNew;
import org.cyclos.web.rest.model.ImportedFileProgress;
import org.cyclos.web.rest.model.ImportedFileQueryFilters;
import org.cyclos.web.rest.model.ImportedFileResult;
import org.cyclos.web.rest.model.ImportedFileStatusEnum;
import org.cyclos.web.rest.model.ImportedFileView;
import org.cyclos.web.rest.model.ImportedFileWithUser;
import org.cyclos.web.rest.model.ImportedLineDataForEdit;
import org.cyclos.web.rest.model.ImportedLineDataForSearch;
import org.cyclos.web.rest.model.ImportedLineEdit;
import org.cyclos.web.rest.model.ImportedLineQueryFilters;
import org.cyclos.web.rest.model.ImportedLineResult;
import org.cyclos.web.rest.model.ImportedLineStatusEnum;
import org.cyclos.web.rest.model.ImportedLineView;
import org.cyclos.web.rest.model.UserImportedFileContextEnum;
import org.cyclos.web.rest.model.UserImportedFileKind;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImportsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private RecordsApiHelper recordsApiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    private GroupsApiHelper groupsApiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;
    @Autowired
    private VouchersApiHelper vouchersApiHelper;

    public ImportedFileDataForEdit toImportedFileDataForEdit(ImportedFileData importedFileData) {
        ImportedFileDTO importedFileDTO = (ImportedFileDTO)importedFileData.getDto();
        ImportedFileDataForEdit importedFileDataForEdit = new ImportedFileDataForEdit();
        importedFileDataForEdit.setKind(this.toImportedFileKind(importedFileData.getImportType()));
        if (importedFileDTO instanceof UserSpecificImportedFileDTO) {
            UserSpecificImportedFileDTO userSpecificImportedFileDTO = (UserSpecificImportedFileDTO)importedFileDTO;
            importedFileDataForEdit.setUser(this.usersApiHelper.toUser((BasicUserVO)userSpecificImportedFileDTO.getUser()));
        }
        importedFileDataForEdit.setFileName(importedFileDTO.getFileName());
        importedFileDataForEdit.setStatus(this.toImportedFileStatusEnum(importedFileDTO.getStatus()));
        importedFileDataForEdit.setCreationDate(importedFileDTO.getCreationDate());
        importedFileDataForEdit.setImportedFile(this.toImportedFileEdit(importedFileDTO));
        return importedFileDataForEdit;
    }

    public ImportedFileDataForNew toImportedFileDataForNew(ImportedFileData importedFileData) {
        AdImportedFileData adImportedFileData;
        ImportedFileDataForNew importedFileDataForNew = new ImportedFileDataForNew();
        importedFileDataForNew.setKind(this.toImportedFileKind(importedFileData.getImportType()));
        importedFileDataForNew.setSeparator(importedFileData.getSeparator());
        importedFileDataForNew.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput(importedFileData.getConfirmationPasswordInput()));
        if (importedFileData instanceof AdImportedFileData) {
            adImportedFileData = (AdImportedFileData)importedFileData;
            CollectionHelper.orEmpty((List)adImportedFileData.getCurrencies()).stream().map(this.accountsApiHelper::toCurrency).forEach(importedFileDataForNew.getCurrencies()::add);
        } else if (importedFileData instanceof RecordImportedFileData) {
            adImportedFileData = (RecordImportedFileData)importedFileData;
            CollectionHelper.orEmpty((List)adImportedFileData.getTypes()).stream().map(this.recordsApiHelper::toRecordType).forEach(importedFileDataForNew.getRecordTypes()::add);
        } else if (importedFileData instanceof UserImportedFileData) {
            adImportedFileData = (UserImportedFileData)importedFileData;
            CollectionHelper.orEmpty((List)adImportedFileData.getGroups()).stream().map(this.groupsApiHelper::toGroup).forEach(importedFileDataForNew.getGroups()::add);
        } else if (importedFileData instanceof UserPaymentImportedFileData) {
            adImportedFileData = (UserPaymentImportedFileData)importedFileData;
            CollectionHelper.orEmpty((List)adImportedFileData.getAccounts()).stream().map(this.accountsApiHelper::toAccountWithStatus).forEach(importedFileDataForNew.getAccounts()::add);
            CollectionHelper.orEmpty((List)adImportedFileData.getPaymentTypes()).stream().map(this.accountsApiHelper::toTransferType).forEach(importedFileDataForNew.getPaymentTypes()::add);
        } else if (importedFileData instanceof UserSendVouchersImportedFileData) {
            adImportedFileData = (UserSendVouchersImportedFileData)importedFileData;
            importedFileDataForNew.setDataForSend(this.vouchersApiHelper.toVoucherDataForBuy(adImportedFileData.getSendData()));
        }
        adImportedFileData = (ImportedFileDTO)importedFileData.getDto();
        importedFileDataForNew.setImportedFile(this.toImportedFileNew((ImportedFileDTO)adImportedFileData));
        if (adImportedFileData instanceof UserSpecificImportedFileDTO) {
            UserSpecificImportedFileDTO userSpecificImportedFileDTO = (UserSpecificImportedFileDTO)adImportedFileData;
            importedFileDataForNew.setUser(this.usersApiHelper.toUser((BasicUserVO)userSpecificImportedFileDTO.getUser()));
        }
        return importedFileDataForNew;
    }

    public ImportedFileDataForSearch toImportedFileDataForSearch(ImportedFileSearchData importedFileSearchData) {
        ImportedFileDataForSearch importedFileDataForSearch = new ImportedFileDataForSearch();
        importedFileDataForSearch.setUser(this.usersApiHelper.toUser((BasicUserVO)importedFileSearchData.getUser()));
        CollectionHelper.orEmpty((List)importedFileSearchData.getAllowedImports()).stream().map(this::toImportedFileKind).forEach(importedFileDataForSearch.getKinds()::add);
        importedFileDataForSearch.setManageKinds(importedFileDataForSearch.getKinds());
        importedFileDataForSearch.setQuery(this.toImportedFileQueryFilters((ImportedFileQuery)importedFileSearchData.getQuery()));
        return importedFileDataForSearch;
    }

    public ImportedFileDataParams toImportedFileDataParams(ImportType importType, String string) {
        ImportedFileDataParams importedFileDataParams = new ImportedFileDataParams();
        importedFileDataParams.setImportType(importType);
        importedFileDataParams.setUser(ModelHelper.userLocator((String)string));
        return importedFileDataParams;
    }

    public ImportedFileDTO toImportedFileDTO(ImportType importType, ImportedFileNew importedFileNew, String string) {
        if (importedFileNew == null) {
            importedFileNew = new ImportedFileNew();
        }
        GeneralReferenceImportedFileDTO generalReferenceImportedFileDTO = null;
        switch (importType) {
            case ADS_IMPORT: {
                AdImportedFileDTO adImportedFileDTO = new AdImportedFileDTO();
                adImportedFileDTO.setCurrency((CurrencyVO)ModelHelper.voFromString(CurrencyVO.class, (String)importedFileNew.getCurrency()));
                generalReferenceImportedFileDTO = adImportedFileDTO;
                break;
            }
            case GENERAL_REFERENCES_IMPORT: {
                generalReferenceImportedFileDTO = new GeneralReferenceImportedFileDTO();
                break;
            }
            case PAYMENTS_IMPORT: {
                PaymentImportedFileDTO paymentImportedFileDTO = new PaymentImportedFileDTO();
                paymentImportedFileDTO.setSendNotifications(Boolean.TRUE.equals(importedFileNew.getSendNotifications()));
                generalReferenceImportedFileDTO = paymentImportedFileDTO;
                break;
            }
            case RECORDS_IMPORT: {
                RecordImportedFileDTO recordImportedFileDTO = new RecordImportedFileDTO();
                recordImportedFileDTO.setType((RecordTypeVO)ModelHelper.voFromString(RecordTypeVO.class, (String)importedFileNew.getRecordType()));
                generalReferenceImportedFileDTO = recordImportedFileDTO;
                break;
            }
            case TOKENS_IMPORT: {
                generalReferenceImportedFileDTO = new TokenImportedFileDTO();
                break;
            }
            case TRANSFERS_IMPORT: {
                generalReferenceImportedFileDTO = new TransferImportedFileDTO();
                break;
            }
            case USERS_IMPORT: {
                UserImportedFileDTO userImportedFileDTO = new UserImportedFileDTO();
                userImportedFileDTO.setGroup((GroupVO)ModelHelper.voFromString(GroupVO.class, (String)importedFileNew.getGroup()));
                userImportedFileDTO.setUseGroupFromFile(Boolean.TRUE.equals(importedFileNew.getUseGroupFromFile()));
                userImportedFileDTO.setSendActivationEmail(Boolean.TRUE.equals(importedFileNew.getSendActivationEmail()));
                generalReferenceImportedFileDTO = userImportedFileDTO;
                break;
            }
            case USER_PAYMENTS_IMPORT: {
                UserPaymentImportedFileDTO userPaymentImportedFileDTO = new UserPaymentImportedFileDTO();
                userPaymentImportedFileDTO.setPaymentType((TransferTypeVO)ModelHelper.voFromString(TransferTypeVO.class, (String)importedFileNew.getPaymentType()));
                generalReferenceImportedFileDTO = userPaymentImportedFileDTO;
                break;
            }
            case USER_SEND_VOUCHERS_IMPORT: {
                UserSendVouchersImportedFileDTO userSendVouchersImportedFileDTO = new UserSendVouchersImportedFileDTO();
                userSendVouchersImportedFileDTO.setVoucherType((VoucherTypeVO)ModelHelper.voFromString(VoucherTypeVO.class, (String)importedFileNew.getVoucherType()));
                userSendVouchersImportedFileDTO.setUseAmountFromFile(Boolean.TRUE.equals(importedFileNew.getUseAmountFromFile()));
                userSendVouchersImportedFileDTO.setAmount(importedFileNew.getAmount());
                userSendVouchersImportedFileDTO.setSendMessage(importedFileNew.getSendMessage());
                generalReferenceImportedFileDTO = userSendVouchersImportedFileDTO;
            }
        }
        if (generalReferenceImportedFileDTO == null) {
            throw new IllegalStateException("Unhandled type: " + String.valueOf(importType));
        }
        if (generalReferenceImportedFileDTO instanceof UserSpecificImportedFileDTO) {
            ((UserSpecificImportedFileDTO)generalReferenceImportedFileDTO).setUser((UserVO)ModelHelper.userLocator((String)string));
        }
        generalReferenceImportedFileDTO.setDescription(importedFileNew.getDescription());
        generalReferenceImportedFileDTO.setPermanent(Boolean.TRUE.equals(importedFileNew.getPermanent()));
        generalReferenceImportedFileDTO.setProcessAutomatically(Boolean.TRUE.equals(importedFileNew.getProcessAutomatically()));
        return generalReferenceImportedFileDTO;
    }

    public ImportedFileDTO toImportedFileDTO(String string, ImportedFileEdit importedFileEdit) {
        ImportedFileDTO importedFileDTO = new ImportedFileDTO();
        importedFileDTO.setId(this.apiHelper.fromId(string));
        importedFileDTO.setVersion(importedFileEdit.getVersion());
        importedFileDTO.setDescription(importedFileEdit.getDescription());
        importedFileDTO.setFileName(importedFileEdit.getFileName());
        importedFileDTO.setPermanent(Boolean.TRUE.equals(importedFileEdit.getPermanent()));
        importedFileDTO.setProcessAutomatically(Boolean.TRUE.equals(importedFileEdit.getProcessAutomatically()));
        return importedFileDTO;
    }

    public ImportedFileKind toImportedFileKind(ImportType importType) {
        if (importType != null) {
            switch (importType) {
                case ADS_IMPORT: {
                    return ImportedFileKind.ADS;
                }
                case GENERAL_REFERENCES_IMPORT: {
                    return ImportedFileKind.GENERAL_REFERENCES;
                }
                case PAYMENTS_IMPORT: {
                    return ImportedFileKind.PAYMENTS;
                }
                case RECORDS_IMPORT: {
                    return ImportedFileKind.RECORDS;
                }
                case TOKENS_IMPORT: {
                    return ImportedFileKind.TOKENS;
                }
                case TRANSFERS_IMPORT: {
                    return ImportedFileKind.TRANSFERS;
                }
                case USERS_IMPORT: {
                    return ImportedFileKind.USERS;
                }
                case USER_PAYMENTS_IMPORT: {
                    return ImportedFileKind.USER_PAYMENTS;
                }
                case USER_SEND_VOUCHERS_IMPORT: {
                    return ImportedFileKind.USER_SEND_VOUCHERS;
                }
            }
        }
        return null;
    }

    public ImportedFileQuery toImportedFileQuery(ImportSearchContext importSearchContext, ImportedFileQueryFilters importedFileQueryFilters, String string) {
        ImportedFileQuery importedFileQuery = this.apiHelper.newQuery(ImportedFileQuery.class, importedFileQueryFilters);
        importedFileQuery.setContext(importSearchContext);
        importedFileQuery.setCreationDate(this.apiHelper.toDatePeriodDTO(importedFileQueryFilters.getCreationPeriod()));
        importedFileQuery.setImportTypes(CollectionHelper.orEmpty(importedFileQueryFilters.getKinds()).stream().map(this::toImportType).collect(Collectors.toSet()));
        importedFileQuery.setStatuses(CollectionHelper.orEmpty(importedFileQueryFilters.getStatuses()).stream().map(this::toImportedFileStatus).collect(Collectors.toSet()));
        importedFileQuery.setUser((UserVO)ModelHelper.userLocator((String)string));
        return importedFileQuery;
    }

    public ImportedFileResult toImportedFileResult(ImportedFileVO importedFileVO) {
        if (importedFileVO == null) {
            return null;
        }
        return this.newImportedFileResult(ImportedFileResult.class, importedFileVO);
    }

    public ImportedFileView toImportedFileView(ImportedFileData importedFileData) {
        UserSpecificImportedFileDTO userSpecificImportedFileDTO;
        ImportedFileDTO importedFileDTO = (ImportedFileDTO)importedFileData.getDto();
        ImportedFileView importedFileView = new ImportedFileView();
        if (importedFileDTO instanceof UserSpecificImportedFileDTO) {
            userSpecificImportedFileDTO = (UserSpecificImportedFileDTO)importedFileDTO;
            importedFileView.setUser(this.usersApiHelper.toUser((BasicUserVO)userSpecificImportedFileDTO.getUser()));
        }
        importedFileView.setCreationDate(importedFileDTO.getCreationDate());
        importedFileView.setFileName(importedFileDTO.getFileName());
        importedFileView.setKind(this.toImportedFileKind(importedFileData.getImportType()));
        importedFileView.setProcessingDate(importedFileDTO.getProcessingDate());
        importedFileView.setStatus(this.toImportedFileStatusEnum(importedFileDTO.getStatus()));
        importedFileView.setBy(this.usersApiHelper.toUser((BasicUserVO)importedFileDTO.getBy()));
        importedFileView.setDescription(importedFileDTO.getDescription());
        importedFileView.setErrorMessage(importedFileDTO.getErrorMessage());
        importedFileView.setArchiveDate(importedFileData.getArchiveDate());
        importedFileView.setPermanent(importedFileDTO.isPermanent());
        importedFileView.setProcessAutomatically(importedFileDTO.isProcessAutomatically());
        importedFileView.setProgress(this.toImportedFileProgress(importedFileData.getProgress()));
        CollectionHelper.orEmpty((List)importedFileData.getFields()).stream().map(this::toImportedField).forEach(importedFileView.getFields()::add);
        importedFileView.setIgnoredFields(importedFileData.getIgnoredFields());
        importedFileView.setCanEdit(importedFileData.isEditable());
        importedFileView.setCanRemove(importedFileData.isRemovable());
        importedFileView.setCanProcess(importedFileData.isCanProcess());
        importedFileView.setCanAbort(importedFileData.isCanAbort());
        if (importedFileDTO instanceof UserImportedFileDTO) {
            userSpecificImportedFileDTO = (UserImportedFileDTO)importedFileDTO;
            importedFileView.setUseGroupFromFile(userSpecificImportedFileDTO.isUseGroupFromFile());
            importedFileView.setGroup(this.groupsApiHelper.toGroup((BasicGroupVO)userSpecificImportedFileDTO.getGroup()));
            importedFileView.setSendActivationEmail(userSpecificImportedFileDTO.isSendActivationEmail());
        } else if (importedFileDTO instanceof AdImportedFileDTO) {
            userSpecificImportedFileDTO = (AdImportedFileDTO)importedFileDTO;
            importedFileView.setCurrency(this.accountsApiHelper.toCurrency(userSpecificImportedFileDTO.getCurrency()));
        } else if (importedFileDTO instanceof RecordImportedFileDTO) {
            userSpecificImportedFileDTO = (RecordImportedFileDTO)importedFileDTO;
            importedFileView.setRecordType(this.recordsApiHelper.toRecordType(userSpecificImportedFileDTO.getType()));
        } else if (importedFileDTO instanceof PaymentImportedFileDTO) {
            userSpecificImportedFileDTO = (PaymentImportedFileDTO)importedFileDTO;
            importedFileView.setSendNotifications(userSpecificImportedFileDTO.isSendNotifications());
        } else if (importedFileDTO instanceof UserPaymentImportedFileDTO) {
            userSpecificImportedFileDTO = (UserPaymentImportedFileDTO)importedFileDTO;
            importedFileView.setPaymentType(this.accountsApiHelper.toTransferType(userSpecificImportedFileDTO.getPaymentType()));
        } else if (importedFileDTO instanceof UserSendVouchersImportedFileDTO) {
            userSpecificImportedFileDTO = (UserSendVouchersImportedFileDTO)importedFileDTO;
            importedFileView.setVoucherType(this.vouchersApiHelper.toVoucherType(userSpecificImportedFileDTO.getVoucherType()));
            importedFileView.setUseAmountFromFile(userSpecificImportedFileDTO.isUseAmountFromFile());
            importedFileView.setAmount(userSpecificImportedFileDTO.getAmount());
            importedFileView.setSendMessage(userSpecificImportedFileDTO.getSendMessage());
        }
        return importedFileView;
    }

    public ImportedLineDataForEdit toImportedLineDataForEdit(ImportedLineData importedLineData) {
        ImportedLineDataForEdit importedLineDataForEdit = new ImportedLineDataForEdit();
        importedLineDataForEdit.setFile(this.toImportedFileWithUser(importedLineData.getFile()));
        CollectionHelper.orEmpty((List)importedLineData.getFields()).stream().map(this::toImportedField).forEach(importedLineDataForEdit.getFields()::add);
        importedLineDataForEdit.setCanEdit(importedLineData.isEditable());
        importedLineDataForEdit.setLineNumber(importedLineData.getLineNumber());
        importedLineDataForEdit.setStatus(this.toImportLineStatusEnum(importedLineData.getStatus()));
        importedLineDataForEdit.setErrorMessage(importedLineData.getErrorMessage());
        importedLineDataForEdit.setImportedLine(this.toImportedLineEdit((ImportedLineDTO)importedLineData.getDto()));
        return importedLineDataForEdit;
    }

    public ImportedLineDataForSearch toImportedLineDataForSearch(ImportedLineSearchData importedLineSearchData) {
        ImportedLineDataForSearch importedLineDataForSearch = new ImportedLineDataForSearch();
        importedLineDataForSearch.setFile(this.toImportedFile(importedLineSearchData.getImportedFile()));
        CollectionHelper.orEmpty((List)importedLineSearchData.getFieldsInList()).stream().map(this::toImportedField).forEach(importedLineDataForSearch.getFieldsInList()::add);
        importedLineDataForSearch.setCanSkipOrInclude(importedLineSearchData.isCanSkipOrInclude());
        importedLineDataForSearch.setQuery(this.toImportedLineQueryFilters((ImportedLineQuery)importedLineSearchData.getQuery()));
        return importedLineDataForSearch;
    }

    public ImportedLineDTO toImportedLineDTO(String string, ImportedLineEdit importedLineEdit) {
        ImportedLineDTO importedLineDTO = new ImportedLineDTO();
        importedLineDTO.setId(this.apiHelper.fromId(string));
        importedLineDTO.setVersion(importedLineEdit.getVersion());
        importedLineDTO.setValues(importedLineEdit.getValues());
        return importedLineDTO;
    }

    public ImportedLineQuery toImportedLineQuery(String string, ImportedLineQueryFilters importedLineQueryFilters) {
        ImportedLineQuery importedLineQuery = this.apiHelper.newQuery(ImportedLineQuery.class, importedLineQueryFilters);
        importedLineQuery.setImportedFileId(this.apiHelper.fromId(string));
        importedLineQuery.setKeywords(importedLineQueryFilters.getKeywords());
        importedLineQuery.setStatuses(CollectionHelper.orEmpty(importedLineQueryFilters.getStatuses()).stream().map(this::toImportedLineStatus).collect(Collectors.toSet()));
        importedLineQuery.setLineNumbers(new HashSet(CollectionHelper.orEmpty(importedLineQueryFilters.getLineNumbers())));
        return importedLineQuery;
    }

    public ImportedLineResult toImportedLineResult(ImportedLineVO importedLineVO) {
        ImportedLineResult importedLineResult = this.apiHelper.newEntity(ImportedLineResult.class, importedLineVO);
        importedLineResult.setLineNumber(importedLineVO.getLineNumber());
        importedLineResult.setStatus(this.toImportLineStatusEnum(importedLineVO.getStatus()));
        importedLineResult.setErrorMessage(importedLineVO.getErrorMessage());
        importedLineResult.setImportedEntityId(ApiHelper.toId(importedLineVO.getImportedEntityId()));
        importedLineResult.setValues(importedLineVO.getValues());
        return importedLineResult;
    }

    public ImportedLineView toImportedLineView(ImportedLineData importedLineData) {
        ImportedLineDTO importedLineDTO = (ImportedLineDTO)importedLineData.getDto();
        ImportedLineView importedLineView = this.apiHelper.newEntity(ImportedLineView.class, importedLineDTO);
        importedLineView.setFile(this.toImportedFileWithUser(importedLineData.getFile()));
        CollectionHelper.orEmpty((List)importedLineData.getFields()).stream().map(this::toImportedField).forEach(importedLineView.getFields()::add);
        importedLineView.setLineNumber(importedLineData.getLineNumber());
        importedLineView.setStatus(this.toImportLineStatusEnum(importedLineData.getStatus()));
        importedLineView.setCanEdit(importedLineData.isEditable());
        importedLineView.setCanInclude(importedLineData.isCanInclude());
        importedLineView.setCanSkip(importedLineData.isCanSkip());
        importedLineView.setErrorMessage(importedLineData.getErrorMessage());
        importedLineView.setImportedEntityId(ApiHelper.toId(importedLineData.getImportedEntityId()));
        importedLineView.setValues(importedLineDTO.getValues());
        return importedLineView;
    }

    public ImportSearchContext toImportSearchContext(GeneralImportedFileContextEnum generalImportedFileContextEnum) {
        if (generalImportedFileContextEnum != null) {
            switch (generalImportedFileContextEnum) {
                case PAYMENTS: {
                    return ImportSearchContext.BANKING;
                }
                case SYSTEM: {
                    return ImportSearchContext.SYSTEM;
                }
            }
        }
        return null;
    }

    public ImportSearchContext toImportSearchContext(UserImportedFileContextEnum userImportedFileContextEnum) {
        if (userImportedFileContextEnum != null) {
            switch (userImportedFileContextEnum) {
                case USER_PAYMENTS: {
                    return ImportSearchContext.USER_PAYMENTS;
                }
                case USER_SEND_VOUCHERS: {
                    return ImportSearchContext.USER_SEND_VOUCHERS;
                }
            }
        }
        return null;
    }

    public ImportType toImportType(GeneralImportedFileKind generalImportedFileKind) {
        if (generalImportedFileKind != null) {
            switch (generalImportedFileKind) {
                case ADS: {
                    return ImportType.ADS_IMPORT;
                }
                case GENERAL_REFERENCES: {
                    return ImportType.GENERAL_REFERENCES_IMPORT;
                }
                case PAYMENTS: {
                    return ImportType.PAYMENTS_IMPORT;
                }
                case RECORDS: {
                    return ImportType.RECORDS_IMPORT;
                }
                case TOKENS: {
                    return ImportType.TOKENS_IMPORT;
                }
                case TRANSFERS: {
                    return ImportType.TRANSFERS_IMPORT;
                }
                case USERS: {
                    return ImportType.USERS_IMPORT;
                }
            }
        }
        return null;
    }

    public ImportType toImportType(UserImportedFileKind userImportedFileKind) {
        if (userImportedFileKind != null) {
            switch (userImportedFileKind) {
                case USER_PAYMENTS: {
                    return ImportType.USER_PAYMENTS_IMPORT;
                }
                case USER_SEND_VOUCHERS: {
                    return ImportType.USER_SEND_VOUCHERS_IMPORT;
                }
            }
        }
        return null;
    }

    public UserImportedFileKind toUserImportedFileKind(ImportType importType) {
        if (importType != null) {
            switch (importType) {
                case USER_PAYMENTS_IMPORT: {
                    return UserImportedFileKind.USER_PAYMENTS;
                }
                case USER_SEND_VOUCHERS_IMPORT: {
                    return UserImportedFileKind.USER_SEND_VOUCHERS;
                }
            }
        }
        return null;
    }

    private <IF extends ImportedFile> IF newImportedFile(Class<IF> clazz, ImportedFileVO importedFileVO) {
        ImportedFile importedFile = (ImportedFile)this.apiHelper.newEntity(clazz, importedFileVO);
        importedFile.setCreationDate(importedFileVO.getCreationDate());
        importedFile.setFileName(importedFileVO.getFileName());
        importedFile.setKind(this.toImportedFileKind(importedFileVO.getImportType()));
        importedFile.setProcessingDate(importedFileVO.getProcessingDate());
        importedFile.setStatus(this.toImportedFileStatusEnum(importedFileVO.getStatus()));
        return (IF)importedFile;
    }

    private <IF extends ImportedFileResult> IF newImportedFileResult(Class<IF> clazz, ImportedFileVO importedFileVO) {
        ImportedFileResult importedFileResult = (ImportedFileResult)this.newImportedFile(clazz, importedFileVO);
        importedFileResult.setBy(this.usersApiHelper.toUser((BasicUserVO)importedFileVO.getBy()));
        importedFileResult.setDescription(importedFileVO.getDescription());
        importedFileResult.setErrorMessage(importedFileVO.getErrorMessage());
        return (IF)importedFileResult;
    }

    private ImportedField toImportedField(ImportedFieldVO importedFieldVO) {
        ImportedField importedField = this.apiHelper.newEntity(ImportedField.class, importedFieldVO);
        importedField.setFieldName(importedFieldVO.getFieldName());
        importedField.setFieldId(importedFieldVO.getFieldId());
        return importedField;
    }

    private ImportedFile toImportedFile(ImportedFileVO importedFileVO) {
        if (importedFileVO == null) {
            return null;
        }
        return this.newImportedFile(ImportedFile.class, importedFileVO);
    }

    private ImportedFileEdit toImportedFileEdit(ImportedFileDTO importedFileDTO) {
        ImportedFileEdit importedFileEdit = new ImportedFileEdit();
        importedFileEdit.setVersion(importedFileDTO.getVersion());
        importedFileEdit.setFileName(importedFileDTO.getFileName());
        importedFileEdit.setDescription(importedFileDTO.getDescription());
        importedFileEdit.setPermanent(importedFileDTO.isPermanent());
        importedFileEdit.setProcessAutomatically(importedFileDTO.isProcessAutomatically());
        return importedFileEdit;
    }

    private ImportedFileNew toImportedFileNew(ImportedFileDTO importedFileDTO) {
        ImportedFileNew importedFileNew = new ImportedFileNew();
        if (importedFileDTO instanceof AdImportedFileDTO) {
            AdImportedFileDTO adImportedFileDTO = (AdImportedFileDTO)importedFileDTO;
            importedFileNew.setCurrency(ModelHelper.stringOrIdFromVO((EntityVO)adImportedFileDTO.getCurrency()));
        } else if (importedFileDTO instanceof RecordImportedFileDTO) {
            RecordImportedFileDTO recordImportedFileDTO = (RecordImportedFileDTO)importedFileDTO;
            importedFileNew.setRecordType(ModelHelper.stringOrIdFromVO((EntityVO)recordImportedFileDTO.getType()));
        } else if (importedFileDTO instanceof UserImportedFileDTO) {
            UserImportedFileDTO userImportedFileDTO = (UserImportedFileDTO)importedFileDTO;
            importedFileNew.setGroup(ModelHelper.stringOrIdFromVO((EntityVO)userImportedFileDTO.getGroup()));
            importedFileNew.setUseGroupFromFile(userImportedFileDTO.isUseGroupFromFile());
        } else if (importedFileDTO instanceof UserPaymentImportedFileDTO) {
            UserPaymentImportedFileDTO userPaymentImportedFileDTO = (UserPaymentImportedFileDTO)importedFileDTO;
            importedFileNew.setPaymentType(ModelHelper.stringOrIdFromVO((EntityVO)userPaymentImportedFileDTO.getPaymentType()));
        } else if (importedFileDTO instanceof UserSendVouchersImportedFileDTO) {
            UserSendVouchersImportedFileDTO userSendVouchersImportedFileDTO = (UserSendVouchersImportedFileDTO)importedFileDTO;
            importedFileNew.setVoucherType(ModelHelper.stringOrIdFromVO((EntityVO)userSendVouchersImportedFileDTO.getVoucherType()));
            importedFileNew.setUseAmountFromFile(userSendVouchersImportedFileDTO.isUseAmountFromFile());
            importedFileNew.setAmount(userSendVouchersImportedFileDTO.getAmount());
            importedFileNew.setSendMessage(userSendVouchersImportedFileDTO.getSendMessage());
        }
        return importedFileNew;
    }

    private ImportedFileProgress toImportedFileProgress(ImportProgressVO importProgressVO) {
        if (importProgressVO == null) {
            return null;
        }
        ImportedFileProgress importedFileProgress = new ImportedFileProgress();
        importedFileProgress.setProgress(importProgressVO.getProgress());
        importedFileProgress.setLinesImportError(importProgressVO.getLinesImportError());
        importedFileProgress.setLinesImported(importProgressVO.getLinesImported());
        importedFileProgress.setLinesReady(importProgressVO.getLinesReady());
        importedFileProgress.setLinesSkipped(importProgressVO.getLinesSkipped());
        importedFileProgress.setLinesValidationError(importProgressVO.getLinesValidationError());
        return importedFileProgress;
    }

    private ImportedFileQueryFilters toImportedFileQueryFilters(ImportedFileQuery importedFileQuery) {
        ImportedFileQueryFilters importedFileQueryFilters = this.apiHelper.newQueryFilters(ImportedFileQueryFilters.class, (QueryParameters)importedFileQuery);
        importedFileQueryFilters.setCreationPeriod(this.apiHelper.toFilter(importedFileQuery.getCreationDate()));
        CollectionHelper.orEmpty((Set)importedFileQuery.getImportTypes()).stream().map(this::toImportedFileKind).forEach(importedFileQueryFilters.getKinds()::add);
        CollectionHelper.orEmpty((Set)importedFileQuery.getStatuses()).stream().map(this::toImportedFileStatusEnum).forEach(importedFileQueryFilters.getStatuses()::add);
        return importedFileQueryFilters;
    }

    private ImportedFileStatus toImportedFileStatus(ImportedFileStatusEnum importedFileStatusEnum) {
        if (importedFileStatusEnum != null) {
            switch (importedFileStatusEnum) {
                case ABORTED: {
                    return ImportedFileStatus.ABORTED;
                }
                case ARCHIVED: {
                    return ImportedFileStatus.ARCHIVED;
                }
                case IMPORTED: {
                    return ImportedFileStatus.IMPORTED;
                }
                case IMPORTING: {
                    return ImportedFileStatus.IMPORTING;
                }
                case INTERNAL_ERROR: {
                    return ImportedFileStatus.INTERNAL_ERROR;
                }
                case INVALID: {
                    return ImportedFileStatus.INVALID;
                }
                case READING_CSV: {
                    return ImportedFileStatus.READING_CSV;
                }
                case READING_ZIP: {
                    return ImportedFileStatus.READING_ZIP;
                }
                case READY: {
                    return ImportedFileStatus.READY;
                }
            }
        }
        return null;
    }

    private ImportedFileStatusEnum toImportedFileStatusEnum(ImportedFileStatus importedFileStatus) {
        if (importedFileStatus != null) {
            switch (importedFileStatus) {
                case ABORTED: {
                    return ImportedFileStatusEnum.ABORTED;
                }
                case ARCHIVED: {
                    return ImportedFileStatusEnum.ARCHIVED;
                }
                case IMPORTED: {
                    return ImportedFileStatusEnum.IMPORTED;
                }
                case IMPORTING: {
                    return ImportedFileStatusEnum.IMPORTING;
                }
                case INTERNAL_ERROR: {
                    return ImportedFileStatusEnum.INTERNAL_ERROR;
                }
                case INVALID: {
                    return ImportedFileStatusEnum.INVALID;
                }
                case READING_CSV: {
                    return ImportedFileStatusEnum.READING_CSV;
                }
                case READING_ZIP: {
                    return ImportedFileStatusEnum.READING_ZIP;
                }
                case READY: {
                    return ImportedFileStatusEnum.READY;
                }
            }
        }
        return null;
    }

    private ImportedFileWithUser toImportedFileWithUser(ImportedFileVO importedFileVO) {
        if (importedFileVO == null) {
            return null;
        }
        ImportedFileWithUser importedFileWithUser = this.newImportedFile(ImportedFileWithUser.class, importedFileVO);
        importedFileWithUser.setUser(this.usersApiHelper.toUser((BasicUserVO)importedFileVO.getUser()));
        return importedFileWithUser;
    }

    private ImportedLineEdit toImportedLineEdit(ImportedLineDTO importedLineDTO) {
        ImportedLineEdit importedLineEdit = new ImportedLineEdit();
        importedLineEdit.setVersion(importedLineDTO.getVersion());
        importedLineEdit.setValues(importedLineDTO.getValues());
        return importedLineEdit;
    }

    private ImportedLineQueryFilters toImportedLineQueryFilters(ImportedLineQuery importedLineQuery) {
        ImportedLineQueryFilters importedLineQueryFilters = this.apiHelper.newQueryFilters(ImportedLineQueryFilters.class, (QueryParameters)importedLineQuery);
        importedLineQueryFilters.setKeywords(importedLineQuery.getKeywords());
        importedLineQueryFilters.setLineNumbers(new ArrayList<Integer>(CollectionHelper.orEmpty((Set)importedLineQuery.getLineNumbers())));
        CollectionHelper.orEmpty((Set)importedLineQuery.getStatuses()).stream().map(this::toImportLineStatusEnum).forEach(importedLineQueryFilters.getStatuses()::add);
        return importedLineQueryFilters;
    }

    private ImportedLineStatus toImportedLineStatus(ImportedLineStatusEnum importedLineStatusEnum) {
        if (importedLineStatusEnum != null) {
            switch (importedLineStatusEnum) {
                case IMPORTED: {
                    return ImportedLineStatus.IMPORTED;
                }
                case IMPORT_ERROR: {
                    return ImportedLineStatus.IMPORT_ERROR;
                }
                case READY: {
                    return ImportedLineStatus.READY;
                }
                case SKIPPED: {
                    return ImportedLineStatus.SKIPPED;
                }
                case VALIDATION_ERROR: {
                    return ImportedLineStatus.VALIDATION_ERROR;
                }
            }
        }
        return null;
    }

    private ImportedLineStatusEnum toImportLineStatusEnum(ImportedLineStatus importedLineStatus) {
        if (importedLineStatus != null) {
            switch (importedLineStatus) {
                case IMPORTED: {
                    return ImportedLineStatusEnum.IMPORTED;
                }
                case IMPORT_ERROR: {
                    return ImportedLineStatusEnum.IMPORT_ERROR;
                }
                case READY: {
                    return ImportedLineStatusEnum.READY;
                }
                case SKIPPED: {
                    return ImportedLineStatusEnum.SKIPPED;
                }
                case VALIDATION_ERROR: {
                    return ImportedLineStatusEnum.VALIDATION_ERROR;
                }
            }
        }
        return null;
    }

    private ImportType toImportType(ImportedFileKind importedFileKind) {
        if (importedFileKind != null) {
            switch (importedFileKind) {
                case ADS: {
                    return ImportType.ADS_IMPORT;
                }
                case GENERAL_REFERENCES: {
                    return ImportType.GENERAL_REFERENCES_IMPORT;
                }
                case PAYMENTS: {
                    return ImportType.PAYMENTS_IMPORT;
                }
                case RECORDS: {
                    return ImportType.RECORDS_IMPORT;
                }
                case TOKENS: {
                    return ImportType.TOKENS_IMPORT;
                }
                case TRANSFERS: {
                    return ImportType.TRANSFERS_IMPORT;
                }
                case USERS: {
                    return ImportType.USERS_IMPORT;
                }
                case USER_PAYMENTS: {
                    return ImportType.USER_PAYMENTS_IMPORT;
                }
                case USER_SEND_VOUCHERS: {
                    return ImportType.USER_SEND_VOUCHERS_IMPORT;
                }
            }
        }
        return null;
    }
}

