/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import java.util.Set;
import org.cyclos.model.ConfigurationEntityVO;
import org.cyclos.model.access.principaltypes.TokenPrincipalTypeVO;
import org.cyclos.model.contentmanagement.contentitems.BannerDetailedVO;
import org.cyclos.model.contentmanagement.contentitems.FrontendContentLayout;
import org.cyclos.model.contentmanagement.contentitems.FrontendScreenSize;
import org.cyclos.model.contentmanagement.contentitems.MenuItemDetailedVO;
import org.cyclos.model.contentmanagement.contentitems.MenuItemType;
import org.cyclos.model.contentmanagement.contentitems.MenuItemVO;
import org.cyclos.model.contentmanagement.staticcontents.FrontendContentVO;
import org.cyclos.model.contentmanagement.staticcontents.FrontendDashboardContentVO;
import org.cyclos.model.contentmanagement.themes.ThemeVO;
import org.cyclos.model.system.configurations.Frontend;
import org.cyclos.model.system.configurations.FrontendLandingPage;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.system.operations.CustomOperationVO;
import org.cyclos.model.system.wizards.CustomWizardVO;
import org.cyclos.model.users.dashboard.QuickAccessType;
import org.cyclos.model.users.dashboardsettings.UserQuickAccessDTO;
import org.cyclos.model.users.dashboardsettings.UserQuickAccessData;
import org.cyclos.model.users.recordtypes.RecordTypeVO;
import org.cyclos.model.users.users.FrontendSettingsDTO;
import org.cyclos.model.utils.FrontendMenu;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.QuickAccessDTO;
import org.cyclos.server.model.app.FrontendDashboardAccountVO;
import org.cyclos.server.model.app.FrontendData;
import org.cyclos.server.model.app.FrontendHomeData;
import org.cyclos.server.model.app.FrontendIconVO;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.ImagesApiHelper;
import org.cyclos.web.rest.helpers.MarketplaceApiHelper;
import org.cyclos.web.rest.helpers.OperationsApiHelper;
import org.cyclos.web.rest.helpers.PasswordsApiHelper;
import org.cyclos.web.rest.helpers.RecordsApiHelper;
import org.cyclos.web.rest.helpers.TokensApiHelper;
import org.cyclos.web.rest.helpers.UiApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.helpers.WizardsApiHelper;
import org.cyclos.web.rest.model.DataForFrontend;
import org.cyclos.web.rest.model.DataForFrontendHome;
import org.cyclos.web.rest.model.DataForUserQuickAccess;
import org.cyclos.web.rest.model.FrontendBanner;
import org.cyclos.web.rest.model.FrontendContentLayoutEnum;
import org.cyclos.web.rest.model.FrontendDashboardAccount;
import org.cyclos.web.rest.model.FrontendEnum;
import org.cyclos.web.rest.model.FrontendHomeContent;
import org.cyclos.web.rest.model.FrontendIcon;
import org.cyclos.web.rest.model.FrontendLandingPageEnum;
import org.cyclos.web.rest.model.FrontendMenuEnum;
import org.cyclos.web.rest.model.FrontendPage;
import org.cyclos.web.rest.model.FrontendPageTypeEnum;
import org.cyclos.web.rest.model.FrontendPageWithContent;
import org.cyclos.web.rest.model.FrontendScreenSizeEnum;
import org.cyclos.web.rest.model.FrontendSettings;
import org.cyclos.web.rest.model.FrontendTheme;
import org.cyclos.web.rest.model.QuickAccess;
import org.cyclos.web.rest.model.QuickAccessTypeEnum;
import org.cyclos.web.rest.model.UserQuickAccessEdit;
import org.cyclos.web.rest.model.UserQuickAccessView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FrontendApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UiApiHelper uiApiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private MarketplaceApiHelper marketplaceApiHelper;
    @Autowired
    private PasswordsApiHelper passwordsApiHelper;
    @Autowired
    private OperationsApiHelper operationsApiHelper;
    @Autowired
    private WizardsApiHelper wizardsApiHelper;
    @Autowired
    private ImagesApiHelper imagesApiHelper;
    @Autowired
    private RecordsApiHelper recordsApiHelper;
    @Autowired
    private TokensApiHelper tokensApiHelper;

    public DataForFrontend toDataForFrontend(FrontendData frontendData) {
        DataForFrontend dataForFrontend = new DataForFrontend();
        dataForFrontend.setFrontend(this.toFrontendEnum(frontendData.getFrontend()));
        dataForFrontend.setAllowFrontendSwitching(frontendData.isAllowFrontendSwitching());
        dataForFrontend.setLogoUrl(this.imagesApiHelper.imageURL((ImageVO)frontendData.getLogo()));
        dataForFrontend.setMapMarkerUrl(this.imagesApiHelper.imageURL((ImageVO)frontendData.getMapMarker()));
        dataForFrontend.setAltMapMarkerUrl(this.imagesApiHelper.imageURL((ImageVO)frontendData.getAltMapMarker()));
        frontendData.getIcons().stream().map(this::toFrontendIcon).forEach(dataForFrontend.getIcons()::add);
        frontendData.getSvgIconNames().forEach(dataForFrontend.getSvgIconNames()::add);
        dataForFrontend.setHasHomePage(frontendData.isHasHomePage());
        dataForFrontend.setHasHelp(frontendData.isHasHelp());
        dataForFrontend.setFooter(frontendData.getFooter() != null ? frontendData.getFooter().getContent() : null);
        dataForFrontend.setTheme(this.toFrontendTheme(frontendData.getTheme()));
        dataForFrontend.setExternalLoginUrl(frontendData.getExternalLoginUrl());
        dataForFrontend.setAfterLogoutUrl(frontendData.getAfterLogoutUrl());
        dataForFrontend.setLocales(frontendData.getLocales());
        dataForFrontend.setTitle(frontendData.getTitle());
        dataForFrontend.setMobileTitle(frontendData.getMobileTitle());
        dataForFrontend.setMobileMenuTitle(frontendData.getMobileMenuTitle());
        dataForFrontend.setMobileLandingPage(this.toFrontendLandingPageEnum(frontendData.getMobileLandingPage()));
        dataForFrontend.setMenuBar(frontendData.isMenuBar());
        dataForFrontend.setDataForUi(this.uiApiHelper.toDataForUi(frontendData.getUiData()));
        dataForFrontend.setVoucherBuyingMenu(this.apiHelper.toUserMenuEnum(frontendData.getVoucherBuyingMenu()));
        dataForFrontend.setTopUpEnabled(frontendData.isTopUpEnabled());
        dataForFrontend.setCanManageQuickAccess(frontendData.isCanManageQuickAccess());
        dataForFrontend.setDevelopment(frontendData.isDevelopment());
        CollectionHelper.orEmpty((List)frontendData.getBanners()).stream().map(this::toFrontendBanner).forEach(dataForFrontend.getBanners()::add);
        CollectionHelper.orEmpty((List)frontendData.getPages()).stream().map(this::toFrontendPage).forEach(dataForFrontend.getPages()::add);
        return dataForFrontend;
    }

    public DataForFrontendHome toDataForFrontendHome(FrontendHomeData frontendHomeData) {
        DataForFrontendHome dataForFrontendHome = new DataForFrontendHome();
        dataForFrontendHome.setContent(this.toFrontendHomeContent((FrontendContentVO)ObjectHelper.defaultValue((Object)frontendHomeData.getGuestHomePage(), (Object)frontendHomeData.getDashboardContent())));
        CollectionHelper.orEmpty((List)frontendHomeData.getQuickAccess()).stream().map(this::toQuickAccess).forEach(dataForFrontendHome.getQuickAccess()::add);
        dataForFrontendHome.setMergeAccounts(frontendHomeData.getMergeAccounts());
        CollectionHelper.orEmpty((List)frontendHomeData.getAccounts()).stream().map(this::toFrontendDashboardAccount).forEach(dataForFrontendHome.getAccounts()::add);
        dataForFrontendHome.setShowLatestUsers(frontendHomeData.isShowLatestUsers());
        CollectionHelper.orEmpty((List)frontendHomeData.getLatestUsers()).stream().map(this.usersApiHelper::toUserResult).forEach(dataForFrontendHome.getLatestUsers()::add);
        dataForFrontendHome.setShowLatestAds(frontendHomeData.isShowLatestAds());
        CollectionHelper.orEmpty((List)frontendHomeData.getLatestAds()).stream().map(this.marketplaceApiHelper::toAdResult).forEach(dataForFrontendHome.getLatestAds()::add);
        CollectionHelper.orEmpty((List)frontendHomeData.getPasswordsNeedingAttention()).stream().map(this.passwordsApiHelper::toPasswordStatusAndType).forEach(dataForFrontendHome.getPasswordsNeedingAttention()::add);
        dataForFrontendHome.setPendingSecurityQuestion(frontendHomeData.getPendingSecurityQuestion());
        dataForFrontendHome.setPendingTotp(frontendHomeData.getPendingTotp());
        return dataForFrontendHome;
    }

    public DataForUserQuickAccess toDataForUserQuickAccess(UserQuickAccessData userQuickAccessData) {
        DataForUserQuickAccess dataForUserQuickAccess = new DataForUserQuickAccess();
        dataForUserQuickAccess.setUser(this.usersApiHelper.toUser(userQuickAccessData.getUser()));
        dataForUserQuickAccess.setCanEdit(userQuickAccessData.isEditable());
        userQuickAccessData.getQuickAccess().stream().map(this::toUserQuickAccessView).forEach(dataForUserQuickAccess.getQuickAccess()::add);
        return dataForUserQuickAccess;
    }

    public FrontendEnum toFrontendEnum(Frontend frontend) {
        if (frontend != null) {
            switch (frontend) {
                case CLASSIC: {
                    return FrontendEnum.CLASSIC;
                }
                case NEW: {
                    return FrontendEnum.NEW;
                }
            }
        }
        return null;
    }

    public FrontendHomeContent toFrontendHomeContent(FrontendContentVO frontendContentVO) {
        if (frontendContentVO == null) {
            return null;
        }
        FrontendHomeContent frontendHomeContent = new FrontendHomeContent();
        frontendHomeContent.setTitle(frontendContentVO.getTitle());
        frontendHomeContent.setLayout(this.toFrontendContentLayout(frontendContentVO.getLayout()));
        frontendHomeContent.setContent(frontendContentVO.getContent());
        if (frontendContentVO instanceof FrontendDashboardContentVO) {
            frontendHomeContent.setFullWidth(((FrontendDashboardContentVO)frontendContentVO).isFullWidth());
        }
        return frontendHomeContent;
    }

    public FrontendMenuEnum toFrontendMenu(FrontendMenu frontendMenu) {
        if (frontendMenu != null) {
            switch (frontendMenu) {
                case BANKING: {
                    return FrontendMenuEnum.BANKING;
                }
                case BROKERING: {
                    return FrontendMenuEnum.BROKERING;
                }
                case CONTENT: {
                    return FrontendMenuEnum.CONTENT;
                }
                case DASHBOARD: {
                    return FrontendMenuEnum.DASHBOARD;
                }
                case HELP: {
                    return FrontendMenuEnum.HELP;
                }
                case HOME: {
                    return FrontendMenuEnum.HOME;
                }
                case LOGIN: {
                    return FrontendMenuEnum.LOGIN;
                }
                case MARKETPLACE: {
                    return FrontendMenuEnum.MARKETPLACE;
                }
                case OPERATORS: {
                    return FrontendMenuEnum.OPERATORS;
                }
                case PERSONAL: {
                    return FrontendMenuEnum.PERSONAL;
                }
                case PUBLIC_DIRECTORY: {
                    return FrontendMenuEnum.PUBLIC_DIRECTORY;
                }
                case PUBLIC_MARKETPLACE: {
                    return FrontendMenuEnum.PUBLIC_MARKETPLACE;
                }
                case REGISTRATION: {
                    return FrontendMenuEnum.REGISTRATION;
                }
                case USERS: {
                    return FrontendMenuEnum.USERS;
                }
            }
        }
        return null;
    }

    public FrontendPageWithContent toFrontendPageWithContent(MenuItemDetailedVO menuItemDetailedVO) {
        FrontendPageWithContent frontendPageWithContent = this.newFrontendPage(FrontendPageWithContent.class, (MenuItemVO)menuItemDetailedVO);
        frontendPageWithContent.setContent(menuItemDetailedVO.getContent());
        return frontendPageWithContent;
    }

    public FrontendScreenSize toFrontendScreenSize(FrontendScreenSizeEnum frontendScreenSizeEnum) {
        if (frontendScreenSizeEnum != null) {
            switch (frontendScreenSizeEnum) {
                case DESKTOP: {
                    return FrontendScreenSize.DESKTOP;
                }
                case FEATURE: {
                    return FrontendScreenSize.FEATURE;
                }
                case MOBILE: {
                    return FrontendScreenSize.MOBILE;
                }
                case TABLET: {
                    return FrontendScreenSize.TABLET;
                }
            }
        }
        return null;
    }

    public FrontendSettingsDTO toFrontendSettingsDTO(FrontendSettings frontendSettings) {
        FrontendSettingsDTO frontendSettingsDTO = new FrontendSettingsDTO();
        frontendSettingsDTO.setFrontend(this.toFrontend(frontendSettings.getFrontend()));
        return frontendSettingsDTO;
    }

    public QuickAccessType toQuickAccessType(QuickAccessTypeEnum quickAccessTypeEnum) {
        if (quickAccessTypeEnum != null) {
            switch (quickAccessTypeEnum) {
                case ACCOUNT: {
                    return QuickAccessType.ACCOUNT;
                }
                case CONTACTS: {
                    return QuickAccessType.CONTACTS;
                }
                case EDIT_PROFILE: {
                    return QuickAccessType.EDIT_PROFILE;
                }
                case PASSWORDS: {
                    return QuickAccessType.PASSWORDS;
                }
                case PAY_SYSTEM: {
                    return QuickAccessType.PAY_SYSTEM;
                }
                case PAY_USER: {
                    return QuickAccessType.PAY_USER;
                }
                case POS: {
                    return QuickAccessType.POS;
                }
                case RECEIVE_QR_PAYMENT: {
                    return QuickAccessType.RECEIVE_QR_PAYMENT;
                }
                case SEARCH_ADS: {
                    return QuickAccessType.SEARCH_ADS;
                }
                case SEARCH_USERS: {
                    return QuickAccessType.SEARCH_USERS;
                }
                case SWITCH_THEME: {
                    return QuickAccessType.SWITCH_THEME;
                }
                case SWITCH_FRONTEND: {
                    return QuickAccessType.SWITCH_FRONTEND;
                }
                case PAY_EXTERNAL_USER: {
                    return QuickAccessType.PAY_EXTERNAL_USER;
                }
                case PAYMENT_REQUESTS: {
                    return QuickAccessType.PAYMENT_REQUESTS;
                }
                case REQUEST_PAYMENT_FROM_SYSTEM: {
                    return QuickAccessType.REQUEST_PAYMENT_FROM_SYSTEM;
                }
                case REQUEST_PAYMENT_FROM_USER: {
                    return QuickAccessType.REQUEST_PAYMENT_FROM_USER;
                }
                case SCHEDULED_PAYMENTS: {
                    return QuickAccessType.SCHEDULED_PAYMENTS;
                }
                case SETTINGS: {
                    return QuickAccessType.SETTINGS;
                }
                case VOUCHERS: {
                    return QuickAccessType.VOUCHERS;
                }
                case BUY_VOUCHER: {
                    return QuickAccessType.BUY_VOUCHER;
                }
                case SEND_VOUCHER: {
                    return QuickAccessType.SEND_VOUCHER;
                }
                case VOUCHER_TRANSACTIONS: {
                    return QuickAccessType.VOUCHER_TRANSACTIONS;
                }
                case REDEEM_VOUCHER: {
                    return QuickAccessType.REDEEM_VOUCHER;
                }
                case TOP_UP_VOUCHER: {
                    return QuickAccessType.TOP_UP_VOUCHER;
                }
                case AD_INTERESTS: {
                    return QuickAccessType.AD_INTERESTS;
                }
                case BALANCES_OVERVIEW: {
                    return QuickAccessType.BALANCES_OVERVIEW;
                }
                case BROKERED_USERS: {
                    return QuickAccessType.BROKERED_USERS;
                }
                case CREATE_AD: {
                    return QuickAccessType.CREATE_AD;
                }
                case CREATE_WEBSHOP_AD: {
                    return QuickAccessType.CREATE_WEBSHOP_AD;
                }
                case DOCUMENTS: {
                    return QuickAccessType.DOCUMENTS;
                }
                case EXTERNAL_PAYMENTS: {
                    return QuickAccessType.EXTERNAL_PAYMENTS;
                }
                case HELP: {
                    return QuickAccessType.HELP;
                }
                case INVITE_USER: {
                    return QuickAccessType.INVITE_USER;
                }
                case MESSAGES: {
                    return QuickAccessType.MESSAGES;
                }
                case MY_ADS: {
                    return QuickAccessType.MY_ADS;
                }
                case MY_WEBSHOP: {
                    return QuickAccessType.MY_WEBSHOP;
                }
                case NOTIFICATIONS: {
                    return QuickAccessType.NOTIFICATIONS;
                }
                case OPERATION: {
                    return QuickAccessType.OPERATION;
                }
                case PAY_SELF: {
                    return QuickAccessType.PAY_SELF;
                }
                case PENDING_USERS: {
                    return QuickAccessType.PENDING_USERS;
                }
                case PURCHASES: {
                    return QuickAccessType.PURCHASES;
                }
                case RECORD: {
                    return QuickAccessType.RECORD;
                }
                case REFERENCES: {
                    return QuickAccessType.REFERENCES;
                }
                case REGISTER_USER: {
                    return QuickAccessType.REGISTER_USER;
                }
                case SALES: {
                    return QuickAccessType.SALES;
                }
                case SEND_MESSAGE: {
                    return QuickAccessType.SEND_MESSAGE;
                }
                case TOKEN: {
                    return QuickAccessType.TOKEN;
                }
                case TRANSACTION_FEEDBACKS: {
                    return QuickAccessType.TRANSACTION_FEEDBACKS;
                }
                case TRANSFERS_OVERVIEW: {
                    return QuickAccessType.TRANSFERS_OVERVIEW;
                }
                case WIZARD: {
                    return QuickAccessType.WIZARD;
                }
            }
        }
        return null;
    }

    public QuickAccessTypeEnum toQuickAccessTypeEnum(QuickAccessType quickAccessType) {
        if (quickAccessType != null) {
            switch (quickAccessType) {
                case ACCOUNT: {
                    return QuickAccessTypeEnum.ACCOUNT;
                }
                case CONTACTS: {
                    return QuickAccessTypeEnum.CONTACTS;
                }
                case EDIT_PROFILE: {
                    return QuickAccessTypeEnum.EDIT_PROFILE;
                }
                case PASSWORDS: {
                    return QuickAccessTypeEnum.PASSWORDS;
                }
                case PAY_SYSTEM: {
                    return QuickAccessTypeEnum.PAY_SYSTEM;
                }
                case PAY_USER: {
                    return QuickAccessTypeEnum.PAY_USER;
                }
                case POS: {
                    return QuickAccessTypeEnum.POS;
                }
                case RECEIVE_QR_PAYMENT: {
                    return QuickAccessTypeEnum.RECEIVE_QR_PAYMENT;
                }
                case SEARCH_ADS: {
                    return QuickAccessTypeEnum.SEARCH_ADS;
                }
                case SEARCH_USERS: {
                    return QuickAccessTypeEnum.SEARCH_USERS;
                }
                case SWITCH_THEME: {
                    return QuickAccessTypeEnum.SWITCH_THEME;
                }
                case SWITCH_FRONTEND: {
                    return QuickAccessTypeEnum.SWITCH_FRONTEND;
                }
                case PAY_EXTERNAL_USER: {
                    return QuickAccessTypeEnum.PAY_EXTERNAL_USER;
                }
                case PAYMENT_REQUESTS: {
                    return QuickAccessTypeEnum.PAYMENT_REQUESTS;
                }
                case REQUEST_PAYMENT_FROM_SYSTEM: {
                    return QuickAccessTypeEnum.REQUEST_PAYMENT_FROM_SYSTEM;
                }
                case REQUEST_PAYMENT_FROM_USER: {
                    return QuickAccessTypeEnum.REQUEST_PAYMENT_FROM_USER;
                }
                case SCHEDULED_PAYMENTS: {
                    return QuickAccessTypeEnum.SCHEDULED_PAYMENTS;
                }
                case SETTINGS: {
                    return QuickAccessTypeEnum.SETTINGS;
                }
                case VOUCHERS: {
                    return QuickAccessTypeEnum.VOUCHERS;
                }
                case BUY_VOUCHER: {
                    return QuickAccessTypeEnum.BUY_VOUCHER;
                }
                case SEND_VOUCHER: {
                    return QuickAccessTypeEnum.SEND_VOUCHER;
                }
                case VOUCHER_TRANSACTIONS: {
                    return QuickAccessTypeEnum.VOUCHER_TRANSACTIONS;
                }
                case REDEEM_VOUCHER: {
                    return QuickAccessTypeEnum.REDEEM_VOUCHER;
                }
                case TOP_UP_VOUCHER: {
                    return QuickAccessTypeEnum.TOP_UP_VOUCHER;
                }
                case AD_INTERESTS: {
                    return QuickAccessTypeEnum.AD_INTERESTS;
                }
                case BALANCES_OVERVIEW: {
                    return QuickAccessTypeEnum.BALANCES_OVERVIEW;
                }
                case BROKERED_USERS: {
                    return QuickAccessTypeEnum.BROKERED_USERS;
                }
                case CREATE_AD: {
                    return QuickAccessTypeEnum.CREATE_AD;
                }
                case CREATE_WEBSHOP_AD: {
                    return QuickAccessTypeEnum.CREATE_WEBSHOP_AD;
                }
                case DOCUMENTS: {
                    return QuickAccessTypeEnum.DOCUMENTS;
                }
                case EXTERNAL_PAYMENTS: {
                    return QuickAccessTypeEnum.EXTERNAL_PAYMENTS;
                }
                case HELP: {
                    return QuickAccessTypeEnum.HELP;
                }
                case INVITE_USER: {
                    return QuickAccessTypeEnum.INVITE_USER;
                }
                case MESSAGES: {
                    return QuickAccessTypeEnum.MESSAGES;
                }
                case MY_ADS: {
                    return QuickAccessTypeEnum.MY_ADS;
                }
                case MY_WEBSHOP: {
                    return QuickAccessTypeEnum.MY_WEBSHOP;
                }
                case NOTIFICATIONS: {
                    return QuickAccessTypeEnum.NOTIFICATIONS;
                }
                case OPERATION: {
                    return QuickAccessTypeEnum.OPERATION;
                }
                case PAY_SELF: {
                    return QuickAccessTypeEnum.PAY_SELF;
                }
                case PENDING_USERS: {
                    return QuickAccessTypeEnum.PENDING_USERS;
                }
                case PURCHASES: {
                    return QuickAccessTypeEnum.PURCHASES;
                }
                case RECORD: {
                    return QuickAccessTypeEnum.RECORD;
                }
                case REFERENCES: {
                    return QuickAccessTypeEnum.REFERENCES;
                }
                case REGISTER_USER: {
                    return QuickAccessTypeEnum.REGISTER_USER;
                }
                case SALES: {
                    return QuickAccessTypeEnum.SALES;
                }
                case SEND_MESSAGE: {
                    return QuickAccessTypeEnum.SEND_MESSAGE;
                }
                case TOKEN: {
                    return QuickAccessTypeEnum.TOKEN;
                }
                case TRANSACTION_FEEDBACKS: {
                    return QuickAccessTypeEnum.TRANSACTION_FEEDBACKS;
                }
                case TRANSFERS_OVERVIEW: {
                    return QuickAccessTypeEnum.TRANSFERS_OVERVIEW;
                }
                case WIZARD: {
                    return QuickAccessTypeEnum.WIZARD;
                }
            }
        }
        return null;
    }

    public UserQuickAccessDTO toUserQuickAccessDTO(UserQuickAccessEdit userQuickAccessEdit) {
        Class<CustomOperationVO> clazz;
        UserQuickAccessDTO userQuickAccessDTO = new UserQuickAccessDTO();
        QuickAccessType quickAccessType = this.toQuickAccessType(userQuickAccessEdit.getType());
        userQuickAccessDTO.setType(quickAccessType);
        switch ((QuickAccessType)ObjectHelper.defaultValue((Object)quickAccessType, (Object)QuickAccessType.ACCOUNT)) {
            case OPERATION: {
                clazz = CustomOperationVO.class;
                break;
            }
            case WIZARD: {
                clazz = CustomWizardVO.class;
                break;
            }
            case RECORD: {
                clazz = RecordTypeVO.class;
                break;
            }
            case TOKEN: {
                clazz = TokenPrincipalTypeVO.class;
                break;
            }
            default: {
                clazz = null;
            }
        }
        if (clazz != null) {
            userQuickAccessDTO.setEntity((ConfigurationEntityVO)ModelHelper.voFromString(clazz, (String)userQuickAccessEdit.getEntity()));
        }
        userQuickAccessDTO.setEnabled(Boolean.TRUE.equals(userQuickAccessEdit.getEnabled()));
        return userQuickAccessDTO;
    }

    protected <T extends QuickAccess> T newQuickAccess(Class<T> clazz, QuickAccessDTO quickAccessDTO) {
        QuickAccess quickAccess = (QuickAccess)ClassHelper.instantiate(clazz);
        quickAccess.setType(this.toQuickAccessTypeEnum(quickAccessDTO.getType()));
        ConfigurationEntityVO configurationEntityVO = quickAccessDTO.getEntity();
        if (configurationEntityVO instanceof CustomOperationVO) {
            quickAccess.setOperation(this.operationsApiHelper.toOperation((CustomOperationVO)configurationEntityVO));
        } else if (configurationEntityVO instanceof CustomWizardVO) {
            quickAccess.setWizard(this.wizardsApiHelper.toWizard((CustomWizardVO)configurationEntityVO));
        } else if (configurationEntityVO instanceof RecordTypeVO) {
            quickAccess.setRecordType(this.recordsApiHelper.toRecordType((RecordTypeVO)configurationEntityVO));
        } else if (configurationEntityVO instanceof TokenPrincipalTypeVO) {
            quickAccess.setTokenType(this.tokensApiHelper.toTokenType((TokenPrincipalTypeVO)configurationEntityVO));
        }
        return (T)quickAccess;
    }

    private <P extends FrontendPage> P newFrontendPage(Class<P> clazz, MenuItemVO menuItemVO) {
        FrontendPage frontendPage = (FrontendPage)this.apiHelper.newEntity(clazz, menuItemVO);
        frontendPage.setTitle(menuItemVO.getTitle());
        frontendPage.setSvgIcon(menuItemVO.getSvgIcon());
        frontendPage.setMenu(this.toFrontendMenu(menuItemVO.getFrontendMenu()));
        frontendPage.setLayout(this.toFrontendContentLayout(menuItemVO.getFrontendLayout()));
        frontendPage.setType(this.toFrontendPageTypeEnum(menuItemVO.getType()));
        frontendPage.setUrl(menuItemVO.getUrl());
        frontendPage.setOperation(this.operationsApiHelper.toOperation(menuItemVO.getCustomOperation()));
        frontendPage.setWizard(this.wizardsApiHelper.toWizard(menuItemVO.getWizard()));
        return (P)frontendPage;
    }

    private Frontend toFrontend(FrontendEnum frontendEnum) {
        if (frontendEnum != null) {
            switch (frontendEnum) {
                case CLASSIC: {
                    return Frontend.CLASSIC;
                }
                case NEW: {
                    return Frontend.NEW;
                }
            }
        }
        return null;
    }

    private FrontendBanner toFrontendBanner(BannerDetailedVO bannerDetailedVO) {
        FrontendBanner frontendBanner = this.apiHelper.newEntity(FrontendBanner.class, bannerDetailedVO);
        frontendBanner.setUrl(bannerDetailedVO.getUrl());
        frontendBanner.setNewWindow(bannerDetailedVO.getNewWindow());
        CollectionHelper.orEmpty((Set)bannerDetailedVO.getMenus()).stream().map(this::toFrontendMenu).forEach(frontendBanner.getMenus()::add);
        frontendBanner.setContent(bannerDetailedVO.getContent());
        frontendBanner.setThemed(bannerDetailedVO.isThemed());
        return frontendBanner;
    }

    private FrontendContentLayoutEnum toFrontendContentLayout(FrontendContentLayout frontendContentLayout) {
        if (frontendContentLayout != null) {
            switch (frontendContentLayout) {
                case FULL: {
                    return FrontendContentLayoutEnum.FULL;
                }
                case CARD: {
                    return FrontendContentLayoutEnum.CARD;
                }
                case CARD_TIGHT: {
                    return FrontendContentLayoutEnum.CARD_TIGHT;
                }
            }
        }
        return null;
    }

    private FrontendDashboardAccount toFrontendDashboardAccount(FrontendDashboardAccountVO frontendDashboardAccountVO) {
        FrontendDashboardAccount frontendDashboardAccount = new FrontendDashboardAccount();
        frontendDashboardAccount.setAccount(this.accountsApiHelper.toAccountWithCurrency(frontendDashboardAccountVO.getAccount()));
        frontendDashboardAccount.setBalance(frontendDashboardAccountVO.getBalance());
        CollectionHelper.orEmpty((List)frontendDashboardAccountVO.getBalanceHistory()).stream().map(this.accountsApiHelper::toAccountBalanceEntry).forEach(frontendDashboardAccount.getBalanceHistory()::add);
        CollectionHelper.orEmpty((List)frontendDashboardAccountVO.getLastTransfers()).stream().map(this.accountsApiHelper::toAccountHistoryResult).forEach(frontendDashboardAccount.getLastTransfers()::add);
        return frontendDashboardAccount;
    }

    private FrontendIcon toFrontendIcon(FrontendIconVO frontendIconVO) {
        FrontendIcon frontendIcon = new FrontendIcon();
        frontendIcon.setRel(frontendIconVO.getRel());
        frontendIcon.setUrl(this.imagesApiHelper.imageURL((ImageVO)frontendIconVO.getImage(), frontendIconVO.getWidth(), frontendIconVO.getHeight()));
        frontendIcon.setWidth(frontendIconVO.getWidth());
        frontendIcon.setHeight(frontendIconVO.getHeight());
        return frontendIcon;
    }

    private FrontendLandingPageEnum toFrontendLandingPageEnum(FrontendLandingPage frontendLandingPage) {
        if (frontendLandingPage != null) {
            switch (frontendLandingPage) {
                case HOME: {
                    return FrontendLandingPageEnum.HOME;
                }
                case LOGIN: {
                    return FrontendLandingPageEnum.LOGIN;
                }
            }
        }
        return null;
    }

    private FrontendPage toFrontendPage(MenuItemVO menuItemVO) {
        if (menuItemVO == null) {
            return null;
        }
        return this.newFrontendPage(FrontendPage.class, menuItemVO);
    }

    private FrontendPageTypeEnum toFrontendPageTypeEnum(MenuItemType menuItemType) {
        if (menuItemType != null) {
            switch (menuItemType) {
                case CONTENT: {
                    return FrontendPageTypeEnum.CONTENT;
                }
                case URL: {
                    return FrontendPageTypeEnum.URL;
                }
                case IFRAME: {
                    return FrontendPageTypeEnum.IFRAME;
                }
                case CUSTOM_OPERATION: {
                    return FrontendPageTypeEnum.OPERATION;
                }
                case WIZARD: {
                    return FrontendPageTypeEnum.WIZARD;
                }
            }
        }
        return null;
    }

    private FrontendTheme toFrontendTheme(ThemeVO themeVO) {
        if (themeVO == null) {
            return null;
        }
        FrontendTheme frontendTheme = this.apiHelper.newEntity(FrontendTheme.class, themeVO);
        frontendTheme.setLastModifiedInMillis(themeVO.getLastModifiedInMillis());
        return frontendTheme;
    }

    private QuickAccess toQuickAccess(QuickAccessDTO quickAccessDTO) {
        if (quickAccessDTO == null) {
            return null;
        }
        return this.newQuickAccess(QuickAccess.class, quickAccessDTO);
    }

    private UserQuickAccessView toUserQuickAccessView(UserQuickAccessDTO userQuickAccessDTO) {
        UserQuickAccessView userQuickAccessView = this.newQuickAccess(UserQuickAccessView.class, (QuickAccessDTO)userQuickAccessDTO);
        userQuickAccessView.setEnabled(userQuickAccessDTO.isEnabled());
        userQuickAccessView.setOriginalOrder(userQuickAccessDTO.getOriginalOrder());
        return userQuickAccessView;
    }
}

