/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.net.URI;
import org.cyclos.model.utils.RawFileVO;
import org.cyclos.model.utils.StoredFileVO;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.model.StoredFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FilesApiHelper {
    @Autowired
    private ApiHelper apiHelper;

    public URI fileURI(RawFileVO rawFileVO) {
        if (rawFileVO == null) {
            return null;
        }
        return this.apiHelper.uriFromApi("files", rawFileVO.getId(), "content");
    }

    public <F extends StoredFile> F newStoredFile(Class<F> clazz, StoredFileVO storedFileVO) {
        StoredFile storedFile = (StoredFile)this.apiHelper.newEntity(clazz, storedFileVO);
        storedFile.setContentType(storedFileVO.getContentType());
        storedFile.setLength(storedFileVO.getLength());
        if (storedFileVO instanceof RawFileVO) {
            storedFile.setUrl(StringHelper.trimToNull((Object)this.fileURI((RawFileVO)storedFileVO)));
        }
        return (F)storedFile;
    }

    public StoredFile toStoredFile(StoredFileVO storedFileVO) {
        if (storedFileVO == null) {
            return null;
        }
        return this.newStoredFile(StoredFile.class, storedFileVO);
    }
}

