/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import org.cyclos.model.access.devices.ActivateTrustedDeviceDTO;
import org.cyclos.model.access.devices.ActivateTrustedDeviceData;
import org.cyclos.model.access.devices.DeviceActivationMode;
import org.cyclos.model.access.devices.RequestActivationResult;
import org.cyclos.model.access.devices.RequestDeviceActivationParams;
import org.cyclos.model.access.devices.TrustedDeviceActivationParams;
import org.cyclos.model.access.devices.TrustedDeviceActivationWithoutCodeParams;
import org.cyclos.model.access.devices.TrustedDeviceDTO;
import org.cyclos.model.access.devices.TrustedDeviceData;
import org.cyclos.model.access.devices.TrustedDeviceVO;
import org.cyclos.model.access.passwords.OtpResult;
import org.cyclos.model.users.phones.PhoneVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.model.ActivationRequest;
import org.cyclos.web.rest.model.Device;
import org.cyclos.web.rest.model.DeviceActivation;
import org.cyclos.web.rest.model.DeviceActivationInfo;
import org.cyclos.web.rest.model.DeviceActivationModeEnum;
import org.cyclos.web.rest.model.DeviceActivationResult;
import org.cyclos.web.rest.model.DeviceDataForEdit;
import org.cyclos.web.rest.model.DeviceEdit;
import org.cyclos.web.rest.model.SendActivationCodeRequest;
import org.cyclos.web.rest.model.SendActivationCodeResult;
import org.cyclos.web.rest.model.SendOtp;
import org.cyclos.web.rest.model.SendOtpWithId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DevicesApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;

    public Device toDevice(TrustedDeviceVO trustedDeviceVO) {
        if (trustedDeviceVO == null) {
            return null;
        }
        Device device = this.apiHelper.newEntity(Device.class, trustedDeviceVO);
        device.setDate(trustedDeviceVO.getDate());
        device.setActive(trustedDeviceVO.isActive());
        return device;
    }

    public DeviceActivationInfo toDeviceActivationInfo(ActivateTrustedDeviceData activateTrustedDeviceData) {
        if (activateTrustedDeviceData == null) {
            return null;
        }
        DeviceActivationInfo deviceActivationInfo = new DeviceActivationInfo();
        deviceActivationInfo.setActivationResult(this.toDeviceActivationResult(activateTrustedDeviceData.getActivateTrustedDeviceDto()));
        deviceActivationInfo.setDataForSendingOtp(this.authApiHelper.toDataForSendingOtp(activateTrustedDeviceData.getSendOtpData()));
        return deviceActivationInfo;
    }

    public DeviceActivationModeEnum toDeviceActivationModeEnum(DeviceActivationMode deviceActivationMode) {
        if (deviceActivationMode != null) {
            switch (deviceActivationMode) {
                case DISABLED: {
                    return DeviceActivationModeEnum.DISABLED;
                }
                case OPTIONAL: {
                    return DeviceActivationModeEnum.OPTIONAL;
                }
                case REQUIRED: {
                    return DeviceActivationModeEnum.REQUIRED;
                }
                case REQUIRED_NO_MEDIUMS: {
                    return DeviceActivationModeEnum.REQUIRED_NO_MEDIUMS;
                }
                case REQUIRED_WITH_DEVICE: {
                    return DeviceActivationModeEnum.REQUIRED_WITH_DEVICE;
                }
            }
        }
        return null;
    }

    public DeviceActivationResult toDeviceActivationResult(ActivateTrustedDeviceDTO activateTrustedDeviceDTO) {
        if (activateTrustedDeviceDTO == null) {
            return null;
        }
        DeviceActivationResult deviceActivationResult = new DeviceActivationResult();
        deviceActivationResult.setKey(activateTrustedDeviceDTO.getKey());
        deviceActivationResult.setDevice(this.toDevice(activateTrustedDeviceDTO.getDevice()));
        return deviceActivationResult;
    }

    public DeviceDataForEdit toDeviceDataForEdit(TrustedDeviceData trustedDeviceData) {
        if (trustedDeviceData == null) {
            return null;
        }
        DeviceDataForEdit deviceDataForEdit = new DeviceDataForEdit();
        deviceDataForEdit.setDevice(this.toDeviceEdit(trustedDeviceData.getDevice()));
        deviceDataForEdit.setCanEdit(trustedDeviceData.isCanManage());
        return deviceDataForEdit;
    }

    public TrustedDeviceDTO toDeviceDTO(String string, DeviceEdit deviceEdit) {
        if (deviceEdit == null) {
            return null;
        }
        TrustedDeviceDTO trustedDeviceDTO = new TrustedDeviceDTO();
        trustedDeviceDTO.setId(this.apiHelper.fromId(string));
        trustedDeviceDTO.setName(deviceEdit.getName());
        trustedDeviceDTO.setVersion(deviceEdit.getVersion());
        return trustedDeviceDTO;
    }

    public DeviceEdit toDeviceEdit(TrustedDeviceDTO trustedDeviceDTO) {
        if (trustedDeviceDTO == null) {
            return null;
        }
        DeviceEdit deviceEdit = this.apiHelper.newEntity(DeviceEdit.class, trustedDeviceDTO);
        deviceEdit.setName(trustedDeviceDTO.getName());
        deviceEdit.setVersion(trustedDeviceDTO.getVersion());
        return deviceEdit;
    }

    public RequestDeviceActivationParams toRequestDeviceActivationParams(SendActivationCodeRequest sendActivationCodeRequest) {
        RequestDeviceActivationParams requestDeviceActivationParams = this.newRequestDeviceActivationParams(sendActivationCodeRequest);
        requestDeviceActivationParams.setName(sendActivationCodeRequest.getName());
        requestDeviceActivationParams.setPinId(this.apiHelper.fromId(sendActivationCodeRequest.getPinId()));
        if (requestDeviceActivationParams.getMobilePhone() == null && sendActivationCodeRequest.getMobilePhoneId() != null) {
            requestDeviceActivationParams.setMobilePhone((PhoneVO)ModelHelper.voFromString(PhoneVO.class, (String)sendActivationCodeRequest.getMobilePhoneId()));
        }
        return requestDeviceActivationParams;
    }

    public RequestDeviceActivationParams toRequestDeviceActivationParams(String string, SendOtp sendOtp) {
        RequestDeviceActivationParams requestDeviceActivationParams = this.newRequestDeviceActivationParams(sendOtp);
        requestDeviceActivationParams.setDeviceId(this.apiHelper.fromId(string));
        if (requestDeviceActivationParams.getMobilePhone() == null && sendOtp instanceof SendOtpWithId) {
            SendOtpWithId sendOtpWithId = (SendOtpWithId)sendOtp;
            requestDeviceActivationParams.setMobilePhone((PhoneVO)ModelHelper.voFromString(PhoneVO.class, (String)sendOtpWithId.getMobilePhoneId()));
        }
        return requestDeviceActivationParams;
    }

    public SendActivationCodeResult toSendActivationCodeResult(RequestActivationResult requestActivationResult) {
        if (requestActivationResult == null) {
            return null;
        }
        SendActivationCodeResult sendActivationCodeResult = this.authApiHelper.newOtpResult(SendActivationCodeResult.class, (OtpResult)requestActivationResult);
        sendActivationCodeResult.setDevice(this.toDevice(requestActivationResult.getDevice()));
        return sendActivationCodeResult;
    }

    public TrustedDeviceActivationParams toTrustedDeviceActivationParams(DeviceActivation deviceActivation) {
        if (deviceActivation == null) {
            return null;
        }
        TrustedDeviceActivationParams trustedDeviceActivationParams = new TrustedDeviceActivationParams();
        trustedDeviceActivationParams.setCode(deviceActivation.getCode());
        trustedDeviceActivationParams.setDeviceConfirmationId(deviceActivation.getDeviceConfirmationId());
        trustedDeviceActivationParams.setDeviceId(this.apiHelper.fromId(deviceActivation.getDeviceId()));
        return trustedDeviceActivationParams;
    }

    public TrustedDeviceActivationWithoutCodeParams toTrustedDeviceActivationWithoutCodeParams(ActivationRequest activationRequest) {
        if (activationRequest == null) {
            return null;
        }
        TrustedDeviceActivationWithoutCodeParams trustedDeviceActivationWithoutCodeParams = new TrustedDeviceActivationWithoutCodeParams();
        trustedDeviceActivationWithoutCodeParams.setUserAgentId(activationRequest.getUserAgentId());
        trustedDeviceActivationWithoutCodeParams.setName(activationRequest.getName());
        trustedDeviceActivationWithoutCodeParams.setPindId(this.apiHelper.fromId(activationRequest.getPinId()));
        return trustedDeviceActivationWithoutCodeParams;
    }

    private RequestDeviceActivationParams newRequestDeviceActivationParams(SendOtp sendOtp) {
        RequestDeviceActivationParams requestDeviceActivationParams = new RequestDeviceActivationParams();
        requestDeviceActivationParams.setMedium(this.apiHelper.toSendMedium(sendOtp.getMedium()));
        requestDeviceActivationParams.setMobilePhone((PhoneVO)ModelHelper.voFromString(PhoneVO.class, (String)sendOtp.getMobilePhone()));
        return requestDeviceActivationParams;
    }
}

