/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.access.pins.CreatePinDTO;
import org.cyclos.model.access.pins.CurrentCredentialsForPinManage;
import org.cyclos.model.access.pins.NewCredentialsForPinManage;
import org.cyclos.model.access.pins.PinDTO;
import org.cyclos.model.access.pins.PinData;
import org.cyclos.model.access.pins.PinDetailedVO;
import org.cyclos.model.access.pins.PinLocatorVO;
import org.cyclos.model.access.pins.PinVO;
import org.cyclos.model.access.pins.SetPinParams;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.services.access.PinService;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.CreateDevicePin;
import org.cyclos.web.rest.model.CreateDevicePinResult;
import org.cyclos.web.rest.model.DevicePin;
import org.cyclos.web.rest.model.DevicePinDataForEdit;
import org.cyclos.web.rest.model.DevicePinEdit;
import org.cyclos.web.rest.model.DevicePinRemoveParams;
import org.cyclos.web.rest.model.DevicePinView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DevicePinsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private PinService pinService;

    public Long locateId(String string) {
        if (string == null) {
            return null;
        }
        Long l = this.apiHelper.fromId(string);
        if (l == null) {
            PinDetailedVO pinDetailedVO = this.pinService.locate((PinLocatorVO)ModelHelper.voFromString(PinLocatorVO.class, (String)string));
            l = pinDetailedVO.getId();
            return l;
        }
        return l;
    }

    public CreateDevicePinResult toCreateDevicePinResult(CreatePinDTO createPinDTO) {
        if (createPinDTO == null) {
            return null;
        }
        CreateDevicePinResult createDevicePinResult = new CreateDevicePinResult();
        createDevicePinResult.setPin(this.toDevicePinView(createPinDTO.getPin()));
        createDevicePinResult.setPrincipal(createPinDTO.getPrincipal());
        createDevicePinResult.setSalt(createPinDTO.getSalt());
        return createDevicePinResult;
    }

    public CurrentCredentialsForPinManage toCurrentPinAndPassword(DevicePinRemoveParams devicePinRemoveParams) {
        CurrentCredentialsForPinManage currentCredentialsForPinManage = new CurrentCredentialsForPinManage();
        currentCredentialsForPinManage.setCurrentPin(devicePinRemoveParams.getCurrentPin());
        currentCredentialsForPinManage.setCurrentPassword(devicePinRemoveParams.getCurrentPassword());
        return currentCredentialsForPinManage;
    }

    public DevicePin toDevicePin(PinVO pinVO) {
        if (pinVO == null) {
            return null;
        }
        DevicePin devicePin = this.apiHelper.newEntity(DevicePin.class, pinVO);
        devicePin.setDate(pinVO.getDate());
        return devicePin;
    }

    public DevicePinDataForEdit toDevicePinDataForEdit(PinData pinData) {
        if (pinData == null) {
            return null;
        }
        DevicePinDataForEdit devicePinDataForEdit = new DevicePinDataForEdit();
        devicePinDataForEdit.setPin(this.toDevicePinEdit(pinData.getPin()));
        devicePinDataForEdit.setCanEdit(pinData.isCanManage());
        return devicePinDataForEdit;
    }

    public DevicePinEdit toDevicePinEdit(PinDTO pinDTO) {
        if (pinDTO == null) {
            return null;
        }
        DevicePinEdit devicePinEdit = this.apiHelper.newEntity(DevicePinEdit.class, pinDTO);
        devicePinEdit.setName(pinDTO.getName());
        devicePinEdit.setVersion(pinDTO.getVersion());
        return devicePinEdit;
    }

    public DevicePinView toDevicePinView(PinDetailedVO pinDetailedVO) {
        if (pinDetailedVO == null) {
            return null;
        }
        DevicePinView devicePinView = this.apiHelper.newEntity(DevicePinView.class, pinDetailedVO);
        devicePinView.setUser(this.usersApiHelper.toUser(pinDetailedVO.getUser()));
        devicePinView.setPasswordInput(this.authApiHelper.toPasswordInput((ICredentialInputDTO)pinDetailedVO.getPasswordInput()));
        devicePinView.setDate(pinDetailedVO.getDate());
        devicePinView.setPrincipalType(this.authApiHelper.toPrincipalType(pinDetailedVO.getPrincipalType()));
        return devicePinView;
    }

    public PinDTO toPinDTO(String string, DevicePinEdit devicePinEdit) {
        if (devicePinEdit == null) {
            return null;
        }
        PinDTO pinDTO = new PinDTO();
        pinDTO.setId(this.locateId(string));
        pinDTO.setName(devicePinEdit.getName());
        pinDTO.setVersion(devicePinEdit.getVersion());
        return pinDTO;
    }

    public SetPinParams toSetPinParams(CreateDevicePin createDevicePin) {
        if (createDevicePin == null) {
            return null;
        }
        SetPinParams setPinParams = new SetPinParams();
        setPinParams.setDeviceId(this.apiHelper.fromId(createDevicePin.getDeviceId()));
        setPinParams.setName(createDevicePin.getName());
        setPinParams.setPinCreationToken(createDevicePin.getPinCreationToken());
        setPinParams.setPinLocator((PinLocatorVO)ModelHelper.voFromString(PinLocatorVO.class, (String)createDevicePin.getPinLocator()));
        NewCredentialsForPinManage newCredentialsForPinManage = new NewCredentialsForPinManage();
        newCredentialsForPinManage.setCurrentPin(createDevicePin.getCurrentPin());
        newCredentialsForPinManage.setCurrentPassword(createDevicePin.getCurrentPassword());
        newCredentialsForPinManage.setPin(createDevicePin.getPin());
        if (Boolean.TRUE.equals(createDevicePin.getCheckConfirmation())) {
            newCredentialsForPinManage.setPinConfirmation(createDevicePin.getPinConfirmation());
        } else {
            newCredentialsForPinManage.setPinConfirmation(createDevicePin.getPin());
        }
        setPinParams.setNewAndCurrentCredentials(newCredentialsForPinManage);
        return setPinParams;
    }
}

