/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import org.cyclos.model.IEntity;
import org.cyclos.model.marketplace.webshopdeliverymethods.AdDeliveryMethodChargeType;
import org.cyclos.model.marketplace.webshopdeliverymethods.AdDeliveryMethodDTO;
import org.cyclos.model.marketplace.webshopdeliverymethods.AdDeliveryMethodData;
import org.cyclos.model.marketplace.webshopdeliverymethods.AdDeliveryMethodType;
import org.cyclos.model.marketplace.webshopdeliverymethods.AdDeliveryMethodVO;
import org.cyclos.model.marketplace.webshopdeliverymethods.UserAdDeliveryMethodsListData;
import org.cyclos.model.users.addresses.GeoLocatedAddressVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.AddressesApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.DeliveryMethod;
import org.cyclos.web.rest.model.DeliveryMethodBasicData;
import org.cyclos.web.rest.model.DeliveryMethodChargeTypeEnum;
import org.cyclos.web.rest.model.DeliveryMethodDataForEdit;
import org.cyclos.web.rest.model.DeliveryMethodDataForNew;
import org.cyclos.web.rest.model.DeliveryMethodEdit;
import org.cyclos.web.rest.model.DeliveryMethodManage;
import org.cyclos.web.rest.model.DeliveryMethodNew;
import org.cyclos.web.rest.model.DeliveryMethodTypeEnum;
import org.cyclos.web.rest.model.DeliveryMethodView;
import org.cyclos.web.rest.model.UserDeliveryMethodsListData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeliveryMethodsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    private AddressesApiHelper addressesApiHelper;

    public AdDeliveryMethodChargeType toAdDeliveryMethodChargeType(DeliveryMethodChargeTypeEnum deliveryMethodChargeTypeEnum) {
        if (deliveryMethodChargeTypeEnum != null) {
            switch (deliveryMethodChargeTypeEnum) {
                case FIXED: {
                    return AdDeliveryMethodChargeType.FIXED;
                }
                case NEGOTIATED: {
                    return AdDeliveryMethodChargeType.NEGOTIATED;
                }
            }
        }
        return null;
    }

    public AdDeliveryMethodDTO toAdDeliveryMethodDTO(DeliveryMethodManage deliveryMethodManage) {
        AdDeliveryMethodDTO adDeliveryMethodDTO = new AdDeliveryMethodDTO();
        adDeliveryMethodDTO.setEnabled(Boolean.TRUE.equals(deliveryMethodManage.getEnabled()));
        adDeliveryMethodDTO.setName(deliveryMethodManage.getName());
        adDeliveryMethodDTO.setDetails(deliveryMethodManage.getDescription());
        adDeliveryMethodDTO.setChargeType(this.toAdDeliveryMethodChargeType(deliveryMethodManage.getChargeType()));
        adDeliveryMethodDTO.setDeliveryType(this.toAdDeliveryMethodType(deliveryMethodManage.getDeliveryType()));
        adDeliveryMethodDTO.setAddress(this.addressesApiHelper.toUserAddressVO(deliveryMethodManage.getAddress()));
        adDeliveryMethodDTO.setMinDeliveryTime(this.apiHelper.toTimeIntervalDTO(deliveryMethodManage.getMinDeliveryTime()));
        adDeliveryMethodDTO.setMaxDeliveryTime(this.apiHelper.toTimeIntervalDTO(deliveryMethodManage.getMaxDeliveryTime()));
        adDeliveryMethodDTO.setPrice(this.apiHelper.toCurrencyAmountDTO(deliveryMethodManage.getChargeCurrency(), deliveryMethodManage.getChargeAmount()));
        if (deliveryMethodManage instanceof DeliveryMethodEdit) {
            adDeliveryMethodDTO.setVersion(((DeliveryMethodEdit)deliveryMethodManage).getVersion());
        }
        return adDeliveryMethodDTO;
    }

    public AdDeliveryMethodType toAdDeliveryMethodType(DeliveryMethodTypeEnum deliveryMethodTypeEnum) {
        if (deliveryMethodTypeEnum != null) {
            switch (deliveryMethodTypeEnum) {
                case PICKUP: {
                    return AdDeliveryMethodType.PICKUP;
                }
                case DELIVER: {
                    return AdDeliveryMethodType.DELIVER;
                }
            }
        }
        return null;
    }

    public DeliveryMethod toDeliveryMethod(AdDeliveryMethodVO adDeliveryMethodVO) {
        if (adDeliveryMethodVO == null) {
            return null;
        }
        DeliveryMethod deliveryMethod = this.apiHelper.newEntity(DeliveryMethod.class, adDeliveryMethodVO);
        deliveryMethod.setEnabled(adDeliveryMethodVO.isEnabled());
        deliveryMethod.setDescription(adDeliveryMethodVO.getDetails());
        deliveryMethod.setChargeType(this.toDeliveryMethodChargeTypeEnum(adDeliveryMethodVO.getChargeType()));
        deliveryMethod.setDeliveryType(this.toDeliveryMethodTypeEnum(adDeliveryMethodVO.getDeliveryType()));
        deliveryMethod.setMinDeliveryTime(this.apiHelper.toTimeInterval(adDeliveryMethodVO.getMinDeliveryTime()));
        deliveryMethod.setMaxDeliveryTime(this.apiHelper.toTimeInterval(adDeliveryMethodVO.getMaxDeliveryTime()));
        deliveryMethod.setAddress(this.addressesApiHelper.toAddress((GeoLocatedAddressVO)adDeliveryMethodVO.getAddress()));
        CurrencyAmountDTO currencyAmountDTO = adDeliveryMethodVO.getPrice();
        if (currencyAmountDTO != null) {
            deliveryMethod.setChargeAmount(currencyAmountDTO.getAmount());
            deliveryMethod.setChargeCurrency(this.accountsApiHelper.toCurrency(currencyAmountDTO.getCurrency()));
        }
        return deliveryMethod;
    }

    public DeliveryMethodChargeTypeEnum toDeliveryMethodChargeTypeEnum(AdDeliveryMethodChargeType adDeliveryMethodChargeType) {
        if (adDeliveryMethodChargeType != null) {
            switch (adDeliveryMethodChargeType) {
                case FIXED: {
                    return DeliveryMethodChargeTypeEnum.FIXED;
                }
                case NEGOTIATED: {
                    return DeliveryMethodChargeTypeEnum.NEGOTIATED;
                }
            }
        }
        return null;
    }

    public DeliveryMethodDataForEdit toDeliveryMethodDataForEdit(AdDeliveryMethodData adDeliveryMethodData) {
        if (adDeliveryMethodData == null) {
            return null;
        }
        DeliveryMethodDataForEdit deliveryMethodDataForEdit = this.newDeliveryMethodBasicData(DeliveryMethodDataForEdit.class, adDeliveryMethodData);
        deliveryMethodDataForEdit.setCanEdit(adDeliveryMethodData.isEditable());
        deliveryMethodDataForEdit.setCanRemove(adDeliveryMethodData.isRemovable());
        deliveryMethodDataForEdit.setDeliveryMethod(this.toDeliveryMethodEdit((AdDeliveryMethodDTO)adDeliveryMethodData.getDto()));
        return deliveryMethodDataForEdit;
    }

    public DeliveryMethodDataForNew toDeliveryMethodDataForNew(AdDeliveryMethodData adDeliveryMethodData) {
        if (adDeliveryMethodData == null) {
            return null;
        }
        DeliveryMethodDataForNew deliveryMethodDataForNew = this.newDeliveryMethodBasicData(DeliveryMethodDataForNew.class, adDeliveryMethodData);
        deliveryMethodDataForNew.setDeliveryMethod(this.toDeliveryMethodNew((AdDeliveryMethodDTO)adDeliveryMethodData.getDto()));
        return deliveryMethodDataForNew;
    }

    public DeliveryMethodEdit toDeliveryMethodEdit(AdDeliveryMethodDTO adDeliveryMethodDTO) {
        if (adDeliveryMethodDTO == null) {
            return null;
        }
        DeliveryMethodEdit deliveryMethodEdit = this.newDeliveryMethodManage(DeliveryMethodEdit.class, adDeliveryMethodDTO);
        deliveryMethodEdit.setVersion(adDeliveryMethodDTO.getVersion());
        return deliveryMethodEdit;
    }

    public DeliveryMethodNew toDeliveryMethodNew(AdDeliveryMethodDTO adDeliveryMethodDTO) {
        if (adDeliveryMethodDTO == null) {
            return null;
        }
        return this.newDeliveryMethodManage(DeliveryMethodNew.class, adDeliveryMethodDTO);
    }

    public DeliveryMethodTypeEnum toDeliveryMethodTypeEnum(AdDeliveryMethodType adDeliveryMethodType) {
        if (adDeliveryMethodType != null) {
            switch (adDeliveryMethodType) {
                case PICKUP: {
                    return DeliveryMethodTypeEnum.PICKUP;
                }
                case DELIVER: {
                    return DeliveryMethodTypeEnum.DELIVER;
                }
            }
        }
        return null;
    }

    public DeliveryMethodView toDeliveryMethodView(AdDeliveryMethodData adDeliveryMethodData) {
        DeliveryMethodView deliveryMethodView = new DeliveryMethodView();
        deliveryMethodView.setCanRemove(adDeliveryMethodData.isRemovable());
        deliveryMethodView.setCanEdit(adDeliveryMethodData.isEditable());
        AdDeliveryMethodDTO adDeliveryMethodDTO = (AdDeliveryMethodDTO)adDeliveryMethodData.getDto();
        deliveryMethodView.setId(ApiHelper.toId(adDeliveryMethodDTO.getId()));
        deliveryMethodView.setName(adDeliveryMethodDTO.getName());
        deliveryMethodView.setDescription(adDeliveryMethodDTO.getDetails());
        deliveryMethodView.setChargeType(this.toDeliveryMethodChargeTypeEnum(adDeliveryMethodDTO.getChargeType()));
        deliveryMethodView.setDeliveryType(this.toDeliveryMethodTypeEnum(adDeliveryMethodDTO.getDeliveryType()));
        deliveryMethodView.setAddress(this.addressesApiHelper.toAddress((GeoLocatedAddressVO)adDeliveryMethodDTO.getAddress()));
        deliveryMethodView.setEnabled(adDeliveryMethodDTO.isEnabled());
        deliveryMethodView.setMinDeliveryTime(this.apiHelper.toTimeInterval(adDeliveryMethodDTO.getMinDeliveryTime()));
        deliveryMethodView.setMaxDeliveryTime(this.apiHelper.toTimeInterval(adDeliveryMethodDTO.getMaxDeliveryTime()));
        deliveryMethodView.setUser(this.usersApiHelper.toUser((BasicUserVO)adDeliveryMethodDTO.getOwner()));
        CurrencyAmountDTO currencyAmountDTO = adDeliveryMethodDTO.getPrice();
        if (currencyAmountDTO != null) {
            deliveryMethodView.setChargeAmount(currencyAmountDTO.getAmount());
            deliveryMethodView.setChargeCurrency(this.accountsApiHelper.toCurrency(currencyAmountDTO.getCurrency()));
        }
        return deliveryMethodView;
    }

    public UserDeliveryMethodsListData toUserDeliveryMethodsListData(UserAdDeliveryMethodsListData userAdDeliveryMethodsListData) {
        UserDeliveryMethodsListData userDeliveryMethodsListData = new UserDeliveryMethodsListData();
        userDeliveryMethodsListData.setUser(this.usersApiHelper.toUser((BasicUserVO)userAdDeliveryMethodsListData.getUser()));
        userDeliveryMethodsListData.setCanCreate(userAdDeliveryMethodsListData.isManage());
        userDeliveryMethodsListData.setCanEdit(userAdDeliveryMethodsListData.isManage());
        CollectionHelper.orEmpty((List)userAdDeliveryMethodsListData.getAdDeliveryMethods()).stream().map(this::toDeliveryMethod).forEach(userDeliveryMethodsListData.getDeliveryMethods()::add);
        return userDeliveryMethodsListData;
    }

    private <D extends DeliveryMethodBasicData> D newDeliveryMethodBasicData(Class<D> clazz, AdDeliveryMethodData adDeliveryMethodData) {
        DeliveryMethodBasicData deliveryMethodBasicData = (DeliveryMethodBasicData)ClassHelper.instantiate(clazz);
        deliveryMethodBasicData.setUser(this.usersApiHelper.toUser((BasicUserVO)((AdDeliveryMethodDTO)adDeliveryMethodData.getDto()).getOwner()));
        CollectionHelper.orEmpty((List)adDeliveryMethodData.getCurrencies()).stream().map(this.accountsApiHelper::toCurrency).forEach(deliveryMethodBasicData.getCurrencies()::add);
        CollectionHelper.orEmpty((List)adDeliveryMethodData.getAddresses()).stream().map(this.addressesApiHelper::toAddress).forEach(deliveryMethodBasicData.getAddresses()::add);
        return (D)deliveryMethodBasicData;
    }

    private <A extends DeliveryMethodManage> A newDeliveryMethodManage(Class<A> clazz, AdDeliveryMethodDTO adDeliveryMethodDTO) {
        DeliveryMethodManage deliveryMethodManage = (DeliveryMethodManage)ClassHelper.instantiate(clazz);
        deliveryMethodManage.setEnabled(adDeliveryMethodDTO.isEnabled());
        deliveryMethodManage.setName(adDeliveryMethodDTO.getName());
        deliveryMethodManage.setDescription(adDeliveryMethodDTO.getDetails());
        deliveryMethodManage.setChargeType(this.toDeliveryMethodChargeTypeEnum(adDeliveryMethodDTO.getChargeType()));
        deliveryMethodManage.setMinDeliveryTime(this.apiHelper.toTimeInterval(adDeliveryMethodDTO.getMinDeliveryTime()));
        deliveryMethodManage.setMaxDeliveryTime(this.apiHelper.toTimeInterval(adDeliveryMethodDTO.getMaxDeliveryTime()));
        deliveryMethodManage.setDeliveryType(this.toDeliveryMethodTypeEnum(adDeliveryMethodDTO.getDeliveryType()));
        CurrencyAmountDTO currencyAmountDTO = adDeliveryMethodDTO.getPrice();
        if (currencyAmountDTO != null) {
            deliveryMethodManage.setChargeAmount(currencyAmountDTO.getAmount());
            deliveryMethodManage.setChargeCurrency(ModelHelper.internalNameOrId((IEntity)currencyAmountDTO.getCurrency()));
        }
        deliveryMethodManage.setAddress(ModelHelper.internalNameOrId((IEntity)adDeliveryMethodDTO.getAddress()));
        return (A)deliveryMethodManage;
    }
}

