/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cyclos.model.EntityVO;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.users.addresses.GeoLocatedAddressVO;
import org.cyclos.model.users.addresses.UserAddressVO;
import org.cyclos.model.users.contactinfos.AddressContactInfoDTO;
import org.cyclos.model.users.contactinfos.AddressContactInfoVO;
import org.cyclos.model.users.contactinfos.BaseContactInfoDTO;
import org.cyclos.model.users.contactinfos.BaseContactInfoVO;
import org.cyclos.model.users.contactinfos.ContactInfoDTO;
import org.cyclos.model.users.contactinfos.ContactInfoData;
import org.cyclos.model.users.contactinfos.ContactInfoListData;
import org.cyclos.model.users.contactinfos.ContactInfoVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.model.users.users.UserProfileContactInfosData;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.helpers.AddressesApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.ImagesApiHelper;
import org.cyclos.web.rest.helpers.OperationsApiHelper;
import org.cyclos.web.rest.helpers.PhonesApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.AddressContactInfo;
import org.cyclos.web.rest.model.AddressContactInfoManage;
import org.cyclos.web.rest.model.AvailabilityEnum;
import org.cyclos.web.rest.model.ContactInfo;
import org.cyclos.web.rest.model.ContactInfoBasicData;
import org.cyclos.web.rest.model.ContactInfoBinaryValuesForUserProfile;
import org.cyclos.web.rest.model.ContactInfoConfigurationForUserProfile;
import org.cyclos.web.rest.model.ContactInfoDataForEdit;
import org.cyclos.web.rest.model.ContactInfoDataForNew;
import org.cyclos.web.rest.model.ContactInfoDetailed;
import org.cyclos.web.rest.model.ContactInfoEdit;
import org.cyclos.web.rest.model.ContactInfoEditWithId;
import org.cyclos.web.rest.model.ContactInfoManage;
import org.cyclos.web.rest.model.ContactInfoNew;
import org.cyclos.web.rest.model.ContactInfoResult;
import org.cyclos.web.rest.model.ContactInfoView;
import org.cyclos.web.rest.model.ContactInfoWithFields;
import org.cyclos.web.rest.model.IContactInfo;
import org.cyclos.web.rest.model.INormalizedPhones;
import org.cyclos.web.rest.model.UserContactInfosListData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContactInfosApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private ImagesApiHelper imagesApiHelper;
    @Autowired
    private AddressesApiHelper addressApiHelper;
    @Autowired
    private PhonesApiHelper phonesApiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private OperationsApiHelper operationsApiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;

    public AddressContactInfo toAddressContactInfo(org.cyclos.model.users.contactinfos.IContactInfo iContactInfo) {
        if (iContactInfo == null) {
            return null;
        }
        AddressContactInfo addressContactInfo = new AddressContactInfo();
        this.fill(addressContactInfo, iContactInfo);
        if (iContactInfo instanceof AddressContactInfoVO) {
            addressContactInfo.setCustomValues(this.apiHelper.toCustomFieldValuesList(((AddressContactInfoVO)iContactInfo).getCustomValues()));
        }
        return addressContactInfo;
    }

    public AddressContactInfoDTO toAddressContactInfoDTO(AddressContactInfoManage addressContactInfoManage) {
        if (addressContactInfoManage == null) {
            return null;
        }
        AddressContactInfoDTO addressContactInfoDTO = this.newContactInfoDTO(AddressContactInfoDTO.class, addressContactInfoManage);
        addressContactInfoDTO.setCustomValues(this.apiHelper.toCustomFieldValuesDTO(addressContactInfoManage.getCustomValues()));
        return addressContactInfoDTO;
    }

    public AddressContactInfoManage toAddressContactInfoManage(AddressContactInfoDTO addressContactInfoDTO) {
        if (addressContactInfoDTO == null) {
            return null;
        }
        AddressContactInfoManage addressContactInfoManage = new AddressContactInfoManage();
        this.fill(addressContactInfoManage, (org.cyclos.model.users.contactinfos.IContactInfo)addressContactInfoDTO);
        addressContactInfoManage.setCustomValues(this.apiHelper.toCustomFieldValuesMap(addressContactInfoDTO.getCustomValues()));
        return addressContactInfoManage;
    }

    public ContactInfo toContactInfo(ContactInfoVO contactInfoVO) {
        if (contactInfoVO == null) {
            return null;
        }
        return this.newContactInfo(ContactInfo.class, (org.cyclos.model.users.contactinfos.IContactInfo)contactInfoVO);
    }

    public Map<String, ContactInfoBinaryValuesForUserProfile> toContactInfoBinaryValuesForUserProfile(List<ContactInfoDTO> list) {
        HashMap<String, ContactInfoBinaryValuesForUserProfile> hashMap = new HashMap<String, ContactInfoBinaryValuesForUserProfile>();
        for (ContactInfoDTO contactInfoDTO : CollectionHelper.orEmpty(list)) {
            ContactInfoBinaryValuesForUserProfile contactInfoBinaryValuesForUserProfile = this.apiHelper.newCustomFieldBinaryValues(ContactInfoBinaryValuesForUserProfile.class, contactInfoDTO.getCustomValues());
            contactInfoBinaryValuesForUserProfile.setImage(this.imagesApiHelper.toImage(contactInfoDTO.getImage()));
            hashMap.put(ApiHelper.toId(contactInfoDTO.getId()), contactInfoBinaryValuesForUserProfile);
        }
        return hashMap;
    }

    public ContactInfoConfigurationForUserProfile toContactInfoConfigurationForUserProfile(UserProfileContactInfosData userProfileContactInfosData) {
        if (userProfileContactInfosData == null) {
            ContactInfoConfigurationForUserProfile contactInfoConfigurationForUserProfile = new ContactInfoConfigurationForUserProfile();
            contactInfoConfigurationForUserProfile.setAvailability(AvailabilityEnum.DISABLED);
            contactInfoConfigurationForUserProfile.setMaxContactInfos(0);
            contactInfoConfigurationForUserProfile.setEdit(false);
            contactInfoConfigurationForUserProfile.setManagePrivacy(false);
            return contactInfoConfigurationForUserProfile;
        }
        ContactInfoConfigurationForUserProfile contactInfoConfigurationForUserProfile = new ContactInfoConfigurationForUserProfile();
        CollectionHelper.orEmpty((List)userProfileContactInfosData.getCustomFields()).stream().map(this.apiHelper::toCustomFieldDetailed).forEach(contactInfoConfigurationForUserProfile.getCustomFields()::add);
        contactInfoConfigurationForUserProfile.setAvailability(this.apiHelper.toAvailability(userProfileContactInfosData.getMaxContactInfos() > 0, false));
        contactInfoConfigurationForUserProfile.setMaxContactInfos(userProfileContactInfosData.getMaxContactInfos());
        contactInfoConfigurationForUserProfile.setEdit(userProfileContactInfosData.isEdit());
        contactInfoConfigurationForUserProfile.setManagePrivacy(userProfileContactInfosData.isManagePrivacy());
        contactInfoConfigurationForUserProfile.setContactInfo(this.toContactInfoNew(userProfileContactInfosData.getContactInfo()));
        return contactInfoConfigurationForUserProfile;
    }

    public ContactInfoDataForEdit toContactInfoDataForEdit(ContactInfoData contactInfoData) {
        if (contactInfoData == null) {
            return null;
        }
        ContactInfoDataForEdit contactInfoDataForEdit = this.newContactInfoBasicData(ContactInfoDataForEdit.class, contactInfoData);
        contactInfoDataForEdit.setCanEdit(contactInfoData.isEditable());
        contactInfoDataForEdit.setCanRemove(contactInfoData.isRemovable());
        contactInfoDataForEdit.setContactInfo(this.toContactInfoEdit((ContactInfoDTO)contactInfoData.getDto()));
        contactInfoDataForEdit.setImage(this.imagesApiHelper.toImage(contactInfoData.getImage()));
        contactInfoDataForEdit.setBinaryValues(this.apiHelper.toCustomFieldBinaryValues(((ContactInfoDTO)contactInfoData.getDto()).getCustomValues()));
        return contactInfoDataForEdit;
    }

    public ContactInfoDataForNew toContactInfoDataForNew(ContactInfoData contactInfoData) {
        if (contactInfoData == null) {
            return null;
        }
        ContactInfoDataForNew contactInfoDataForNew = this.newContactInfoBasicData(ContactInfoDataForNew.class, contactInfoData);
        contactInfoDataForNew.setContactInfo(this.toContactInfoNew((ContactInfoDTO)contactInfoData.getDto()));
        return contactInfoDataForNew;
    }

    public ContactInfoDetailed toContactInfoDetailed(ContactInfoVO contactInfoVO) {
        if (contactInfoVO == null) {
            return null;
        }
        ContactInfoDetailed contactInfoDetailed = this.newContactInfoWithFields(ContactInfoDetailed.class, contactInfoVO);
        CollectionHelper.orEmpty((List)contactInfoVO.getCustomOperations()).stream().map(this.operationsApiHelper::toOperation).forEach(contactInfoDetailed.getOperations()::add);
        return contactInfoDetailed;
    }

    public ContactInfoDTO toContactInfoDTO(ContactInfoManage contactInfoManage) {
        if (contactInfoManage == null) {
            return null;
        }
        ContactInfoDTO contactInfoDTO = this.newContactInfoDTO(ContactInfoDTO.class, contactInfoManage);
        if (contactInfoManage instanceof ContactInfoEdit) {
            contactInfoDTO.setVersion(((ContactInfoEdit)contactInfoManage).getVersion());
            if (contactInfoManage instanceof ContactInfoEditWithId) {
                contactInfoDTO.setId(this.apiHelper.fromId(((ContactInfoEditWithId)contactInfoManage).getId()));
            }
        }
        contactInfoDTO.setName(contactInfoManage.getName());
        contactInfoDTO.setHidden(Boolean.TRUE.equals(contactInfoManage.getHidden()));
        contactInfoDTO.setImage((ImageVO)ModelHelper.voFromString(ImageVO.class, (String)contactInfoManage.getImage()));
        contactInfoDTO.setAddress((UserAddressVO)ModelHelper.voFromString(UserAddressVO.class, (String)contactInfoManage.getAddress()));
        contactInfoDTO.setCustomValues(this.apiHelper.toCustomFieldValuesDTO(contactInfoManage.getCustomValues()));
        return contactInfoDTO;
    }

    public ContactInfoEdit toContactInfoEdit(ContactInfoDTO contactInfoDTO) {
        if (contactInfoDTO == null) {
            return null;
        }
        return this.newContactInfoEdit(ContactInfoEdit.class, contactInfoDTO);
    }

    public ContactInfoEditWithId toContactInfoEditWithId(ContactInfoDTO contactInfoDTO) {
        if (contactInfoDTO == null) {
            return null;
        }
        ContactInfoEditWithId contactInfoEditWithId = this.newContactInfoEdit(ContactInfoEditWithId.class, contactInfoDTO);
        contactInfoEditWithId.setId(ApiHelper.toId(contactInfoDTO.getId()));
        return contactInfoEditWithId;
    }

    public ContactInfoNew toContactInfoNew(ContactInfoDTO contactInfoDTO) {
        if (contactInfoDTO == null) {
            return null;
        }
        return this.newContactInfoManage(ContactInfoNew.class, contactInfoDTO);
    }

    public ContactInfoResult toContactInfoResult(ContactInfoVO contactInfoVO) {
        if (contactInfoVO == null) {
            return null;
        }
        ContactInfoResult contactInfoResult = this.newContactInfo(ContactInfoResult.class, (org.cyclos.model.users.contactinfos.IContactInfo)contactInfoVO);
        contactInfoResult.setHidden(contactInfoVO.isHidden());
        contactInfoResult.setCustomValues(this.apiHelper.toCustomFieldValuesMap(contactInfoVO.getCustomValues()));
        return contactInfoResult;
    }

    public ContactInfoView toContactInfoView(ContactInfoData contactInfoData) {
        if (contactInfoData == null) {
            return null;
        }
        ContactInfoDTO contactInfoDTO = (ContactInfoDTO)contactInfoData.getDto();
        ContactInfoView contactInfoView = this.newContactInfo(ContactInfoView.class, (org.cyclos.model.users.contactinfos.IContactInfo)contactInfoDTO);
        contactInfoView.setCanEdit(contactInfoData.isEditable());
        contactInfoView.setAddress(this.addressApiHelper.toAddress((GeoLocatedAddressVO)contactInfoDTO.getAddress()));
        contactInfoView.setImage(this.imagesApiHelper.toImage(contactInfoData.getImage()));
        contactInfoView.setUser(this.usersApiHelper.toUser((BasicUserVO)contactInfoDTO.getUser()));
        contactInfoView.setHidden(contactInfoDTO.isHidden());
        contactInfoView.setCustomValues(this.apiHelper.toCustomFieldValuesList(contactInfoDTO.getCustomValues()));
        CollectionHelper.orEmpty((List)contactInfoData.getCustomOperations()).stream().map(this.operationsApiHelper::toOperation).forEach(contactInfoView.getOperations()::add);
        return contactInfoView;
    }

    public ContactInfoWithFields toContactInfoWithFields(ContactInfoVO contactInfoVO) {
        if (contactInfoVO == null) {
            return null;
        }
        return this.newContactInfoWithFields(ContactInfoWithFields.class, contactInfoVO);
    }

    public UserContactInfosListData toUserContactInfosListData(ContactInfoListData contactInfoListData) {
        UserContactInfosListData userContactInfosListData = new UserContactInfosListData();
        userContactInfosListData.setUser(this.usersApiHelper.toUser((BasicUserVO)contactInfoListData.getUser()));
        userContactInfosListData.setCanEdit(contactInfoListData.isCanManage());
        userContactInfosListData.setCanCreate(contactInfoListData.isCanCreate());
        userContactInfosListData.setMaxContactInfos(contactInfoListData.getMaxContactInfo());
        CollectionHelper.orEmpty((List)contactInfoListData.getCustomFields()).stream().map(this.apiHelper::toCustomFieldDetailed).forEach(userContactInfosListData.getCustomFields()::add);
        CollectionHelper.orEmpty((List)contactInfoListData.getContactInfos()).stream().map(this::toContactInfoResult).forEach(userContactInfosListData.getContactInfos()::add);
        userContactInfosListData.setAvailability(this.apiHelper.toAvailability(contactInfoListData.getMaxContactInfo() == null || contactInfoListData.getMaxContactInfo() != 0, false));
        return userContactInfosListData;
    }

    private void fill(IContactInfo iContactInfo, org.cyclos.model.users.contactinfos.IContactInfo iContactInfo2) {
        BaseContactInfoVO baseContactInfoVO;
        INormalizedPhones iNormalizedPhones;
        iContactInfo.setEmail(iContactInfo2.getEmail());
        iContactInfo.setMobilePhone(iContactInfo2.getMobilePhone());
        iContactInfo.setLandLinePhone(iContactInfo2.getLandLinePhone());
        iContactInfo.setLandLineExtension(iContactInfo2.getLandLineExtension());
        if (iContactInfo instanceof INormalizedPhones && iContactInfo2 instanceof BaseContactInfoVO) {
            iNormalizedPhones = (INormalizedPhones)((Object)iContactInfo);
            baseContactInfoVO = (BaseContactInfoVO)iContactInfo2;
            iNormalizedPhones.setNormalizedMobilePhone(baseContactInfoVO.getNormalizedMobilePhone());
            iNormalizedPhones.setNormalizedLandLinePhone(baseContactInfoVO.getNormalizedLandLinePhone());
        }
        if (iContactInfo instanceof ContactInfo && iContactInfo2 instanceof ContactInfoVO) {
            iNormalizedPhones = (ContactInfo)iContactInfo;
            baseContactInfoVO = (ContactInfoVO)iContactInfo2;
            ((ContactInfo)iNormalizedPhones).setAddress(this.addressApiHelper.toAddress((GeoLocatedAddressVO)baseContactInfoVO.getAddress()));
            ((ContactInfo)iNormalizedPhones).setImage(this.imagesApiHelper.toImage(baseContactInfoVO.getImage()));
        }
    }

    private <C extends ContactInfo> C newContactInfo(Class<C> clazz, org.cyclos.model.users.contactinfos.IContactInfo iContactInfo) {
        ContactInfo contactInfo = (ContactInfo)this.apiHelper.newEntity(clazz, iContactInfo);
        this.fill(contactInfo, iContactInfo);
        return (C)contactInfo;
    }

    private <D extends ContactInfoBasicData> D newContactInfoBasicData(Class<D> clazz, ContactInfoData contactInfoData) {
        ContactInfoBasicData contactInfoBasicData = (ContactInfoBasicData)ClassHelper.instantiate(clazz);
        CollectionHelper.orEmpty((List)contactInfoData.getCustomFields()).stream().map(this.apiHelper::toCustomFieldDetailed).forEach(contactInfoBasicData.getCustomFields()::add);
        contactInfoBasicData.setUser(this.usersApiHelper.toUser((BasicUserVO)((ContactInfoDTO)contactInfoData.getDto()).getUser()));
        contactInfoBasicData.setPhoneConfiguration(this.phonesApiHelper.toPhoneConfiguration(contactInfoData.getPhoneConfiguration()));
        contactInfoBasicData.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput(contactInfoData.getConfirmationPasswordInput()));
        CollectionHelper.orEmpty((List)contactInfoData.getAddresses()).stream().map(this.addressApiHelper::toAddress).forEach(contactInfoBasicData.getAddresses()::add);
        return (D)contactInfoBasicData;
    }

    private <DTO extends BaseContactInfoDTO> DTO newContactInfoDTO(Class<DTO> clazz, IContactInfo iContactInfo) {
        BaseContactInfoDTO baseContactInfoDTO = (BaseContactInfoDTO)ClassHelper.instantiate(clazz);
        baseContactInfoDTO.setEmail(iContactInfo.getEmail());
        baseContactInfoDTO.setMobilePhone(iContactInfo.getMobilePhone());
        baseContactInfoDTO.setLandLinePhone(iContactInfo.getLandLinePhone());
        baseContactInfoDTO.setLandLineExtension(iContactInfo.getLandLineExtension());
        return (DTO)baseContactInfoDTO;
    }

    private <E extends ContactInfoEdit> E newContactInfoEdit(Class<E> clazz, ContactInfoDTO contactInfoDTO) {
        ContactInfoEdit contactInfoEdit = (ContactInfoEdit)this.newContactInfoManage(clazz, contactInfoDTO);
        contactInfoEdit.setVersion(contactInfoDTO.getVersion());
        return (E)contactInfoEdit;
    }

    private <C extends ContactInfoManage> C newContactInfoManage(Class<C> clazz, ContactInfoDTO contactInfoDTO) {
        ContactInfoManage contactInfoManage = (ContactInfoManage)ClassHelper.instantiate(clazz);
        this.fill(contactInfoManage, (org.cyclos.model.users.contactinfos.IContactInfo)contactInfoDTO);
        contactInfoManage.setName(contactInfoDTO.getName());
        contactInfoManage.setImage(ApiHelper.toId(EntityVO.id((EntityVO)contactInfoDTO.getImage())));
        contactInfoManage.setAddress(ApiHelper.toId(EntityVO.id((EntityVO)contactInfoDTO.getAddress())));
        contactInfoManage.setHidden(contactInfoDTO.isHidden());
        contactInfoManage.setCustomValues(this.apiHelper.toCustomFieldValuesMap(contactInfoDTO.getCustomValues()));
        return (C)contactInfoManage;
    }

    private <C extends ContactInfoWithFields> C newContactInfoWithFields(Class<C> clazz, ContactInfoVO contactInfoVO) {
        ContactInfoWithFields contactInfoWithFields = (ContactInfoWithFields)this.newContactInfo(clazz, (org.cyclos.model.users.contactinfos.IContactInfo)contactInfoVO);
        contactInfoWithFields.setCustomValues(this.apiHelper.toCustomFieldValuesList(contactInfoVO.getCustomValues()));
        return (C)contactInfoWithFields;
    }
}

