/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.model.Availability;
import org.cyclos.model.Bean;
import org.cyclos.model.EntityModel;
import org.cyclos.model.EntityVO;
import org.cyclos.model.IEntity;
import org.cyclos.model.IInternalNamedEntity;
import org.cyclos.model.INamedEntity;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.TranslatableVersionedVO;
import org.cyclos.model.VersionedVO;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.system.configurations.ResultType;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.system.fields.BaseValueForSearchDTO;
import org.cyclos.model.system.fields.CustomFieldControl;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.fields.CustomFieldNature;
import org.cyclos.model.system.fields.CustomFieldPossibleValueCategoryVO;
import org.cyclos.model.system.fields.CustomFieldPossibleValueVO;
import org.cyclos.model.system.fields.CustomFieldSize;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.system.fields.CustomFieldValueDTO;
import org.cyclos.model.system.fields.CustomFieldValueForSearchDTO;
import org.cyclos.model.system.fields.DynamicFieldValueVO;
import org.cyclos.model.system.fields.ICustomFieldValue;
import org.cyclos.model.system.fields.LinkedAdVO;
import org.cyclos.model.system.fields.LinkedEntityType;
import org.cyclos.model.system.fields.LinkedEntityVO;
import org.cyclos.model.system.fields.LinkedRecordVO;
import org.cyclos.model.system.fields.LinkedTransactionVO;
import org.cyclos.model.system.fields.LinkedTransferVO;
import org.cyclos.model.system.fields.LinkedUserVO;
import org.cyclos.model.system.images.ImageSize;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.users.users.AddressFieldValueForSearchDTO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicProfileFieldValueForSearchDTO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.utils.AdminMainMenu;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.model.utils.CurrencyAmountRangeDTO;
import org.cyclos.model.utils.DatePeriodDTO;
import org.cyclos.model.utils.DecimalRangeDTO;
import org.cyclos.model.utils.FileMimeType;
import org.cyclos.model.utils.ICurrencyAmount;
import org.cyclos.model.utils.IntegerRangeDTO;
import org.cyclos.model.utils.LatLongDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.NotificationLevel;
import org.cyclos.model.utils.PeriodPreselectorOptionData;
import org.cyclos.model.utils.ProfileManagementSection;
import org.cyclos.model.utils.RawFileVO;
import org.cyclos.model.utils.RequestInfo;
import org.cyclos.model.utils.SendMedium;
import org.cyclos.model.utils.TimeField;
import org.cyclos.model.utils.TimeIntervalDTO;
import org.cyclos.model.utils.UserMainMenu;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.server.utils.ServerImageHelper;
import org.cyclos.services.access.InvocationData;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.CustomFieldHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.MapParameterStorage;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.ParameterStorage;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.WeekDay;
import org.cyclos.web.rest.helpers.FilesApiHelper;
import org.cyclos.web.rest.helpers.ImagesApiHelper;
import org.cyclos.web.rest.helpers.MarketplaceApiHelper;
import org.cyclos.web.rest.helpers.RecordsApiHelper;
import org.cyclos.web.rest.helpers.TransactionsApiHelper;
import org.cyclos.web.rest.helpers.TransfersApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.AdminMenuEnum;
import org.cyclos.web.rest.model.AvailabilityEnum;
import org.cyclos.web.rest.model.BaseCustomFieldValue;
import org.cyclos.web.rest.model.CustomField;
import org.cyclos.web.rest.model.CustomFieldBinaryValues;
import org.cyclos.web.rest.model.CustomFieldControlEnum;
import org.cyclos.web.rest.model.CustomFieldDetailed;
import org.cyclos.web.rest.model.CustomFieldDynamicValue;
import org.cyclos.web.rest.model.CustomFieldKind;
import org.cyclos.web.rest.model.CustomFieldPossibleValue;
import org.cyclos.web.rest.model.CustomFieldSizeEnum;
import org.cyclos.web.rest.model.CustomFieldTypeEnum;
import org.cyclos.web.rest.model.CustomFieldValue;
import org.cyclos.web.rest.model.DatePeriod;
import org.cyclos.web.rest.model.DecimalRange;
import org.cyclos.web.rest.model.Entity;
import org.cyclos.web.rest.model.EntityReference;
import org.cyclos.web.rest.model.ExportFormat;
import org.cyclos.web.rest.model.GeographicalCoordinate;
import org.cyclos.web.rest.model.HttpRequestData;
import org.cyclos.web.rest.model.Image;
import org.cyclos.web.rest.model.ImageSizeEnum;
import org.cyclos.web.rest.model.IntegerRange;
import org.cyclos.web.rest.model.InternalNamedEntity;
import org.cyclos.web.rest.model.LinkedEntityTypeEnum;
import org.cyclos.web.rest.model.MobilePage;
import org.cyclos.web.rest.model.NamedEntity;
import org.cyclos.web.rest.model.NotificationLevelEnum;
import org.cyclos.web.rest.model.Operation;
import org.cyclos.web.rest.model.PreselectedPeriod;
import org.cyclos.web.rest.model.QueryFilters;
import org.cyclos.web.rest.model.RecordType;
import org.cyclos.web.rest.model.RestModel;
import org.cyclos.web.rest.model.ResultTypeEnum;
import org.cyclos.web.rest.model.SendMediumEnum;
import org.cyclos.web.rest.model.StoredFile;
import org.cyclos.web.rest.model.TimeFieldEnum;
import org.cyclos.web.rest.model.TimeInterval;
import org.cyclos.web.rest.model.UserMenuEnum;
import org.cyclos.web.rest.model.UserProfileSectionEnum;
import org.cyclos.web.rest.model.VersionedEntity;
import org.cyclos.web.rest.model.VersionedEntityReference;
import org.cyclos.web.rest.model.WeekDayEnum;
import org.cyclos.web.rest.model.Wizard;
import org.cyclos.web.utils.AuthenticationMode;
import org.cyclos.web.utils.IconHandler;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApiHelper {
    @Autowired
    private MarketplaceApiHelper marketplaceApiHelper;
    @Autowired
    private TransactionsApiHelper transactionsApiHelper;
    @Autowired
    private TransfersApiHelper transfersApiHelper;
    @Autowired
    private RecordsApiHelper recordsApiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private ImagesApiHelper imagesApiHelper;
    @Autowired
    private FilesApiHelper filesApiHelper;
    @Autowired
    private IconHandler iconHandler;

    public static String toId(Long l) {
        return l == null ? null : l.toString();
    }

    public Long fromId(String string) {
        try {
            return Long.parseLong(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List<Long> fromIds(List<String> list) {
        return list == null ? null : list.stream().map(this::fromId).collect(Collectors.toList());
    }

    public Set<Long> fromIdsAsSet(List<String> list) {
        return list == null ? null : list.stream().map(this::fromId).collect(Collectors.toSet());
    }

    public BigDecimal getAmount(CurrencyAmountDTO currencyAmountDTO) {
        return currencyAmountDTO == null ? null : currencyAmountDTO.getAmount();
    }

    public AuthenticationMode getAuthenticationMode() {
        HttpServletRequest httpServletRequest = ServletHelper.getRequest();
        return ServletHelper.resolveAuthenticationMode(httpServletRequest);
    }

    public CurrencyVO getCurrency(CurrencyAmountDTO currencyAmountDTO) {
        return currencyAmountDTO == null ? null : currencyAmountDTO.getCurrency();
    }

    public InvocationData getInvocationData() {
        HttpServletRequest httpServletRequest = ServletHelper.getRequest();
        return ServletHelper.resolveInvocationData(httpServletRequest);
    }

    public RequestData getRequestData() {
        return ServletHelper.getRequestData();
    }

    public boolean isAccessClient() {
        return this.getAuthenticationMode() == AuthenticationMode.ACCESS_CLIENT;
    }

    public boolean isBasicAuth() {
        return this.getAuthenticationMode() == AuthenticationMode.BASIC;
    }

    public boolean isGuest() {
        return this.getAuthenticationMode() == AuthenticationMode.GUEST;
    }

    public boolean isSession() {
        return this.getAuthenticationMode() == AuthenticationMode.SESSION;
    }

    public boolean isSystem(String string) {
        return "SYSTEM".equalsIgnoreCase(string);
    }

    public <C extends BaseCustomFieldValue> C newBaseFieldValue(Class<C> clazz, ICustomFieldValue<CustomFieldPossibleValueVO, CustomFieldPossibleValueCategoryVO, RawFileVO, ImageVO> iCustomFieldValue) {
        BaseCustomFieldValue baseCustomFieldValue = (BaseCustomFieldValue)this.newEntity((Class)clazz, (IEntity)iCustomFieldValue);
        CustomFieldVO customFieldVO = (CustomFieldVO)iCustomFieldValue.getField();
        if (baseCustomFieldValue instanceof CustomFieldValue) {
            ((CustomFieldValue)baseCustomFieldValue).setField(this.toCustomField(customFieldVO));
        }
        block0 : switch (customFieldVO.getType()) {
            case STRING: 
            case URL: {
                baseCustomFieldValue.setStringValue(iCustomFieldValue.getStringValue());
                break;
            }
            case TEXT: {
                baseCustomFieldValue.setStringValue(iCustomFieldValue.getTextValue());
                break;
            }
            case RICH_TEXT: {
                baseCustomFieldValue.setStringValue(iCustomFieldValue.getRichTextValue());
                break;
            }
            case BOOLEAN: {
                baseCustomFieldValue.setBooleanValue(iCustomFieldValue.getBooleanValue());
                break;
            }
            case DATE: {
                baseCustomFieldValue.setDateValue((DateTime)iCustomFieldValue.getDateValue());
                break;
            }
            case DECIMAL: {
                baseCustomFieldValue.setDecimalValue(iCustomFieldValue.getDecimalValue());
                break;
            }
            case INTEGER: {
                baseCustomFieldValue.setIntegerValue(iCustomFieldValue.getIntegerValue());
                break;
            }
            case SINGLE_SELECTION: {
                if (iCustomFieldValue.getEnumeratedValue() == null) break;
                baseCustomFieldValue.getEnumeratedValues().add(this.toCustomFieldPossibleValue((CustomFieldPossibleValueVO)iCustomFieldValue.getEnumeratedValue()));
                break;
            }
            case MULTI_SELECTION: {
                CollectionHelper.orEmpty((Collection)CustomFieldHelper.getEnumeratedValues(iCustomFieldValue)).stream().map(this::toCustomFieldPossibleValue).forEach(baseCustomFieldValue.getEnumeratedValues()::add);
                break;
            }
            case FILE: {
                CollectionHelper.orEmpty((List)iCustomFieldValue.getFileValues()).stream().map(this.filesApiHelper::toStoredFile).forEach(baseCustomFieldValue.getFileValues()::add);
                break;
            }
            case IMAGE: {
                CollectionHelper.orEmpty((List)iCustomFieldValue.getImageValues()).stream().map(this.imagesApiHelper::toImage).forEach(baseCustomFieldValue.getImageValues()::add);
                break;
            }
            case DYNAMIC_SELECTION: {
                if (!StringHelper.isNotBlank((Object)iCustomFieldValue.getStringValue())) break;
                CustomFieldDynamicValue customFieldDynamicValue = new CustomFieldDynamicValue();
                customFieldDynamicValue.setValue(iCustomFieldValue.getStringValue());
                customFieldDynamicValue.setLabel((String)ObjectHelper.defaultValue((Object)iCustomFieldValue.getTextValue(), (Object)iCustomFieldValue.getStringValue()));
                baseCustomFieldValue.getDynamicValues().add(customFieldDynamicValue);
                baseCustomFieldValue.setDynamicValue(customFieldDynamicValue);
                break;
            }
            case DYNAMIC_MULTI_SELECTION: {
                CollectionHelper.orEmpty((Collection)CustomFieldHelper.getDynamicValues(iCustomFieldValue)).stream().map(this::toCustomFieldDynamicValue).forEach(baseCustomFieldValue.getDynamicValues()::add);
                break;
            }
            case LINKED_ENTITY: {
                LinkedEntityVO linkedEntityVO = iCustomFieldValue.getLinkedEntityValue();
                if (linkedEntityVO == null) break;
                switch (customFieldVO.getLinkedEntityType()) {
                    case ADVERTISEMENT: {
                        LinkedAdVO linkedAdVO = (LinkedAdVO)linkedEntityVO;
                        baseCustomFieldValue.setAdValue(this.marketplaceApiHelper.toAd(linkedAdVO.getAd()));
                        break block0;
                    }
                    case RECORD: {
                        LinkedRecordVO linkedRecordVO = (LinkedRecordVO)linkedEntityVO;
                        baseCustomFieldValue.setRecordValue(this.recordsApiHelper.toRecord(linkedRecordVO.getRecord()));
                        break block0;
                    }
                    case TRANSACTION: {
                        LinkedTransactionVO linkedTransactionVO = (LinkedTransactionVO)linkedEntityVO;
                        baseCustomFieldValue.setTransactionValue(this.transactionsApiHelper.toTransaction(linkedTransactionVO.getTransaction()));
                        break block0;
                    }
                    case TRANSFER: {
                        LinkedTransferVO linkedTransferVO = (LinkedTransferVO)linkedEntityVO;
                        baseCustomFieldValue.setTransferValue(this.transfersApiHelper.toTransfer(linkedTransferVO.getTransfer()));
                        break block0;
                    }
                    case USER: {
                        LinkedUserVO linkedUserVO = (LinkedUserVO)linkedEntityVO;
                        baseCustomFieldValue.setUserValue(this.usersApiHelper.toUser((BasicUserVO)linkedUserVO.getUser()));
                    }
                }
            }
        }
        if (!customFieldVO.getType().isEnumerated()) {
            baseCustomFieldValue.setEnumeratedValues(null);
        }
        if (!customFieldVO.getType().isDynamic()) {
            baseCustomFieldValue.setDynamicValues(null);
        }
        if (customFieldVO.getType() != CustomFieldType.FILE) {
            baseCustomFieldValue.setFileValues(null);
        }
        if (customFieldVO.getType() != CustomFieldType.IMAGE) {
            baseCustomFieldValue.setImageValues(null);
        }
        return (C)baseCustomFieldValue;
    }

    public <C extends CustomField> C newCustomField(Class<C> clazz, CustomFieldVO customFieldVO) {
        CustomField customField = (CustomField)this.newEntity(clazz, customFieldVO, true);
        customField.setType(this.toCustomFieldTypeEnum(customFieldVO.getType()));
        if (customFieldVO.getType() == CustomFieldType.LINKED_ENTITY) {
            customField.setLinkedEntityType(this.toLinkedEntityTypeEnum(customFieldVO.getLinkedEntityType()));
        }
        customField.setControl(this.toCustomFieldControlEnum(customFieldVO.getControl()));
        customField.setDecimalDigits(customFieldVO.getDecimalDigits());
        customField.setKind(this.toCustomFieldKind(customFieldVO.getNature()));
        return (C)customField;
    }

    public <FV extends ICustomFieldValue<CustomFieldPossibleValueVO, CustomFieldPossibleValueCategoryVO, RawFileVO, ImageVO>, BV extends CustomFieldBinaryValues> BV newCustomFieldBinaryValues(Class<BV> clazz, Collection<FV> collection) {
        CustomFieldBinaryValues customFieldBinaryValues = (CustomFieldBinaryValues)ClassHelper.instantiate(clazz);
        customFieldBinaryValues.setFileValues(new HashMap<String, List<StoredFile>>());
        customFieldBinaryValues.setImageValues(new HashMap<String, List<Image>>());
        for (ICustomFieldValue iCustomFieldValue : CollectionHelper.orEmpty(collection)) {
            if (CollectionHelper.isNotEmpty((Iterable)iCustomFieldValue.getFileValues())) {
                customFieldBinaryValues.getFileValues().put(iCustomFieldValue.getField().getInternalName(), iCustomFieldValue.getFileValues().stream().map(this.filesApiHelper::toStoredFile).collect(Collectors.toList()));
            }
            if (!CollectionHelper.isNotEmpty((Iterable)iCustomFieldValue.getImageValues())) continue;
            customFieldBinaryValues.getImageValues().put(iCustomFieldValue.getField().getInternalName(), iCustomFieldValue.getImageValues().stream().map(this.imagesApiHelper::toImage).collect(Collectors.toList()));
        }
        return (BV)customFieldBinaryValues;
    }

    public <CF extends CustomFieldDetailed> CF newCustomFieldDetailed(Class<CF> clazz, CustomFieldDetailedVO customFieldDetailedVO) {
        boolean bl;
        CustomFieldDetailed customFieldDetailed = (CustomFieldDetailed)this.newCustomField(clazz, (CustomFieldVO)customFieldDetailedVO);
        CustomFieldType customFieldType = customFieldDetailedVO.getType();
        customFieldDetailed.setInformationText(customFieldDetailedVO.getInformationText());
        customFieldDetailed.setPattern(customFieldDetailedVO.getPattern());
        customFieldDetailed.setRequired(customFieldDetailedVO.isRequired());
        customFieldDetailed.setDefaultValue(this.getDefaultValue(customFieldDetailedVO));
        customFieldDetailed.setSize(this.toCustomFieldSizeEnum(customFieldDetailedVO.getSize()));
        customFieldDetailed.setAllSelectedLabel(customFieldDetailedVO.getAllSelectedLabel());
        customFieldDetailed.setMaxFiles(customFieldDetailedVO.getMaxFiles());
        customFieldDetailed.setShowQrCodeScan(customFieldDetailedVO.getShowQrCodeScan());
        customFieldDetailed.setAutomaticallyProcessAfterScan(customFieldDetailedVO.getProcessAfterScan());
        if (customFieldType.isEnumerated()) {
            CollectionHelper.orEmpty((List)customFieldDetailedVO.getPossibleValueCategories()).stream().map(this::toReference).forEach(customFieldDetailed.getPossibleValueCategories()::add);
        } else {
            customFieldDetailed.setPossibleValueCategories(null);
        }
        boolean bl2 = customFieldDetailedVO.isHasValuesList();
        customFieldDetailed.setHasValuesList(bl2);
        LinkedEntityType linkedEntityType = customFieldDetailedVO.getLinkedEntityType();
        boolean bl3 = bl = customFieldType == CustomFieldType.LINKED_ENTITY && bl2;
        if (customFieldType.isEnumerated()) {
            CollectionHelper.orEmpty((List)customFieldDetailedVO.getPossibleValues()).stream().map(this::toCustomFieldPossibleValue).forEach(customFieldDetailed.getPossibleValues()::add);
        } else {
            customFieldDetailed.setPossibleValues(null);
        }
        if (customFieldType.isDynamic()) {
            CollectionHelper.orEmpty((List)customFieldDetailedVO.getDynamicValues()).stream().map(this::toCustomFieldDynamicValue).forEach(customFieldDetailed.getDynamicValues()::add);
        } else {
            customFieldDetailed.setDynamicValues(null);
        }
        if (customFieldType.isSingleString() && bl2) {
            customFieldDetailed.setStringValues(customFieldDetailedVO.getStringValues());
        } else {
            customFieldDetailed.setStringValues(null);
        }
        if (customFieldType == CustomFieldType.INTEGER && bl2) {
            customFieldDetailed.setIntegerValues(customFieldDetailedVO.getIntegerValues());
        } else {
            customFieldDetailed.setIntegerValues(null);
        }
        if (customFieldType == CustomFieldType.DECIMAL && bl2) {
            customFieldDetailed.setDecimalValues(customFieldDetailedVO.getDecimalValues());
        } else {
            customFieldDetailed.setDecimalValues(null);
        }
        if (customFieldType == CustomFieldType.DATE && bl2) {
            customFieldDetailed.setDateValues(customFieldDetailedVO.getDateValues());
        } else {
            customFieldDetailed.setDateValues(null);
        }
        if (linkedEntityType == LinkedEntityType.ADVERTISEMENT && bl) {
            customFieldDetailedVO.getAdValues().stream().map(this.marketplaceApiHelper::toAd).forEach(customFieldDetailed.getAdValues()::add);
        } else {
            customFieldDetailed.setAdValues(null);
        }
        if (linkedEntityType == LinkedEntityType.TRANSACTION && bl) {
            customFieldDetailedVO.getTransactionValues().stream().map(this.transactionsApiHelper::toTransaction).forEach(customFieldDetailed.getTransactionValues()::add);
        } else {
            customFieldDetailed.setTransactionValues(null);
        }
        if (linkedEntityType == LinkedEntityType.TRANSFER && bl) {
            customFieldDetailedVO.getTransferValues().stream().map(this.transfersApiHelper::toTransfer).forEach(customFieldDetailed.getTransferValues()::add);
        } else {
            customFieldDetailed.setTransferValues(null);
        }
        if (linkedEntityType == LinkedEntityType.RECORD && bl) {
            customFieldDetailedVO.getRecordValues().stream().map(this.recordsApiHelper::toRecord).forEach(customFieldDetailed.getRecordValues()::add);
        } else {
            customFieldDetailed.setRecordValues(null);
        }
        if (linkedEntityType == LinkedEntityType.USER && bl) {
            customFieldDetailedVO.getUserValues().stream().map(this.usersApiHelper::toUser).forEach(customFieldDetailed.getUserValues()::add);
        } else {
            customFieldDetailed.setUserValues(null);
        }
        if (customFieldType.isBinary()) {
            if (customFieldType == CustomFieldType.FILE) {
                customFieldDetailedVO.getAllowedMimeTypes().stream().map(FileMimeType::getMimeTypes).forEach(customFieldDetailed.getMimeTypes()::addAll);
                customFieldDetailed.getMimeTypes().addAll(StringHelper.splitTrimming((String)customFieldDetailedVO.getOtherMimeTypes(), (String)"\n"));
            } else if (customFieldType == CustomFieldType.IMAGE) {
                for (ServerImageHelper.ImageType imageType : ServerImageHelper.ImageType.values()) {
                    customFieldDetailed.getMimeTypes().addAll(Arrays.asList(imageType.getContentTypes()));
                }
            }
        } else {
            customFieldDetailed.setMimeTypes(null);
        }
        return (CF)customFieldDetailed;
    }

    public <S extends IEntity, D extends RestModel> D newEntity(Class<D> clazz, S s) {
        return this.newEntity(clazz, s, false);
    }

    public <S extends IEntity, D extends RestModel> D newEntity(Class<D> clazz, S s, boolean bl) {
        if (s == null) {
            return null;
        }
        RestModel restModel = (RestModel)ClassHelper.instantiate(clazz);
        if (restModel instanceof Entity) {
            ((Entity)restModel).setId(Objects.toString(s.getId(), null));
        }
        if (restModel instanceof NamedEntity && s instanceof INamedEntity) {
            ((NamedEntity)restModel).setName(((INamedEntity)s).getName());
        }
        if (restModel instanceof InternalNamedEntity && s instanceof IInternalNamedEntity) {
            String string = ((IInternalNamedEntity)s).getInternalName();
            if (bl) {
                string = ModelHelper.unqualifyInternalName((String)string);
            }
            ((InternalNamedEntity)restModel).setInternalName(string);
        }
        return (D)restModel;
    }

    public <Q extends QueryParameters> Q newQuery(Class<Q> clazz, Integer n, Integer n2, Boolean bl) {
        QueryParameters queryParameters = (QueryParameters)ClassHelper.instantiate(clazz);
        queryParameters.setCurrentPage(n);
        queryParameters.setPageSize(n2);
        queryParameters.setSkipTotalCount(Boolean.TRUE.equals(bl));
        return (Q)queryParameters;
    }

    public <Q extends QueryParameters> Q newQuery(Class<Q> clazz, QueryFilters queryFilters) {
        return this.newQuery(clazz, queryFilters.getPage(), queryFilters.getPageSize(), Boolean.TRUE.equals(queryFilters.getSkipTotalCount()));
    }

    public <F extends QueryFilters> F newQueryFilters(Class<F> clazz, QueryParameters queryParameters) {
        QueryFilters queryFilters = (QueryFilters)ClassHelper.instantiate(clazz);
        queryFilters.setPage(queryParameters.getCurrentPage());
        queryFilters.setPageSize(queryParameters.getPageSize());
        queryFilters.setSkipTotalCount(queryParameters.isSkipTotalCount());
        return (F)queryFilters;
    }

    public void setIconOrCustomSVG(String string, Object object) {
        if (StringHelper.isNotBlank((Object)string)) {
            if (string.length() == 1) {
                if (object instanceof Operation) {
                    ((Operation)object).setIcon(string);
                } else if (object instanceof Wizard) {
                    ((Wizard)object).setIcon(string);
                } else if (object instanceof MobilePage) {
                    ((MobilePage)object).setIcon(string);
                } else if (object instanceof RecordType) {
                    ((RecordType)object).setIcon(string);
                }
            } else {
                String string2 = this.iconHandler.icon(string);
                if (object instanceof Operation) {
                    ((Operation)object).setCustomIconContent(string2);
                } else if (object instanceof Wizard) {
                    ((Wizard)object).setCustomIconContent(string2);
                } else if (object instanceof MobilePage) {
                    ((MobilePage)object).setCustomIconContent(string2);
                } else if (object instanceof RecordType) {
                    ((RecordType)object).setCustomIconContent(string2);
                }
            }
        }
    }

    public Pair<String, String> splitFieldParts(String string) {
        String string2 = StringUtils.substringBefore((String)string, (String)":");
        String string3 = StringUtils.substringAfter((String)string, (String)":");
        if (StringHelper.isBlank((Object)string2) || StringHelper.isBlank((Object)string3)) {
            return null;
        }
        return Pair.create((Object)string2, (Object)string3);
    }

    public AdminMenuEnum toAdminMenuEnum(AdminMainMenu adminMainMenu) {
        if (adminMainMenu != null) {
            switch (adminMainMenu) {
                case SYSTEM_BANKING: {
                    return AdminMenuEnum.SYSTEM_BANKING;
                }
                case CONTENT_MANAGEMENT: {
                    return AdminMenuEnum.CONTENT_MANAGEMENT;
                }
                case SYSTEM_MANAGEMENT: {
                    return AdminMenuEnum.SYSTEM_MANAGEMENT;
                }
                case USER_MANAGEMENT: {
                    return AdminMenuEnum.USER_MANAGEMENT;
                }
                case REPORTS: {
                    return AdminMenuEnum.REPORTS;
                }
            }
        }
        return null;
    }

    public AvailabilityEnum toAvailability(boolean bl, boolean bl2) {
        if (!bl) {
            return AvailabilityEnum.DISABLED;
        }
        return bl2 ? AvailabilityEnum.REQUIRED : AvailabilityEnum.OPTIONAL;
    }

    public AvailabilityEnum toAvailabilityEnum(Availability availability) {
        if (availability != null) {
            switch (availability) {
                case DISABLED: {
                    return AvailabilityEnum.DISABLED;
                }
                case OPTIONAL: {
                    return AvailabilityEnum.OPTIONAL;
                }
                case REQUIRED: {
                    return AvailabilityEnum.REQUIRED;
                }
            }
        }
        return null;
    }

    public BigDecimal toBigDecimal(Number number) {
        if (number == null) {
            return null;
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        return new BigDecimal(number.doubleValue());
    }

    public CurrencyAmountDTO toCurrencyAmountDTO(String string, BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return null;
        }
        CurrencyAmountDTO currencyAmountDTO = new CurrencyAmountDTO();
        currencyAmountDTO.setCurrency((CurrencyVO)ModelHelper.voFromString(CurrencyVO.class, (String)string));
        currencyAmountDTO.setAmount(bigDecimal);
        return currencyAmountDTO;
    }

    public CurrencyAmountRangeDTO toCurrencyAmountRangeDTO(String string, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        if (StringHelper.isBlank((Object)string) || bigDecimal == null && bigDecimal2 == null) {
            return null;
        }
        CurrencyAmountRangeDTO currencyAmountRangeDTO = new CurrencyAmountRangeDTO();
        currencyAmountRangeDTO.setCurrency((CurrencyVO)ModelHelper.voFromString(CurrencyVO.class, (String)string));
        currencyAmountRangeDTO.setMin(bigDecimal);
        currencyAmountRangeDTO.setMax(bigDecimal2);
        return currencyAmountRangeDTO;
    }

    public CurrencyAmountRangeDTO toCurrencyAmountRangeDTO(String string, List<BigDecimal> list) {
        if (CollectionHelper.isEmpty(list)) {
            return null;
        }
        CurrencyAmountRangeDTO currencyAmountRangeDTO = new CurrencyAmountRangeDTO();
        currencyAmountRangeDTO.setCurrency((CurrencyVO)ModelHelper.voFromString(CurrencyVO.class, (String)string));
        currencyAmountRangeDTO.setMin(list.get(0));
        if (list.size() > 1) {
            currencyAmountRangeDTO.setMax(list.get(1));
        }
        return currencyAmountRangeDTO;
    }

    public CustomField toCustomField(CustomFieldVO customFieldVO) {
        if (customFieldVO == null) {
            return null;
        }
        return this.newCustomField(CustomField.class, customFieldVO);
    }

    public <FV extends ICustomFieldValue<CustomFieldPossibleValueVO, CustomFieldPossibleValueCategoryVO, RawFileVO, ImageVO>> CustomFieldBinaryValues toCustomFieldBinaryValues(Collection<FV> collection) {
        return this.newCustomFieldBinaryValues(CustomFieldBinaryValues.class, collection);
    }

    public CustomFieldControlEnum toCustomFieldControlEnum(CustomFieldControl customFieldControl) {
        if (customFieldControl != null) {
            switch (customFieldControl) {
                case CHECKBOX: {
                    return CustomFieldControlEnum.CHECKBOX;
                }
                case ENTITY_SELECTION: {
                    return CustomFieldControlEnum.ENTITY_SELECTION;
                }
                case MULTI_SELECTION: {
                    return CustomFieldControlEnum.MULTI_SELECTION;
                }
                case RADIO: {
                    return CustomFieldControlEnum.RADIO;
                }
                case RICH_EDITOR: {
                    return CustomFieldControlEnum.RICH_EDITOR;
                }
                case SINGLE_SELECTION: {
                    return CustomFieldControlEnum.SINGLE_SELECTION;
                }
                case TEXT: {
                    return CustomFieldControlEnum.TEXT;
                }
                case TEXTAREA: {
                    return CustomFieldControlEnum.TEXTAREA;
                }
                case UPLOAD: {
                    return CustomFieldControlEnum.UPLOAD;
                }
            }
        }
        return null;
    }

    public CustomFieldDetailed toCustomFieldDetailed(CustomFieldDetailedVO customFieldDetailedVO) {
        if (customFieldDetailedVO == null) {
            return null;
        }
        return this.newCustomFieldDetailed(CustomFieldDetailed.class, customFieldDetailedVO);
    }

    public CustomFieldDynamicValue toCustomFieldDynamicValue(DynamicFieldValueVO dynamicFieldValueVO) {
        if (dynamicFieldValueVO == null) {
            return null;
        }
        CustomFieldDynamicValue customFieldDynamicValue = new CustomFieldDynamicValue();
        customFieldDynamicValue.setValue(dynamicFieldValueVO.getValue());
        customFieldDynamicValue.setLabel((String)ObjectHelper.defaultValue((Object)dynamicFieldValueVO.getLabel(), (Object)dynamicFieldValueVO.getValue()));
        customFieldDynamicValue.setDefaultValue(dynamicFieldValueVO.isDefaultValue());
        return customFieldDynamicValue;
    }

    public CustomFieldKind toCustomFieldKind(CustomFieldNature customFieldNature) {
        if (customFieldNature != null) {
            switch (customFieldNature) {
                case AD: {
                    return CustomFieldKind.MARKETPLACE;
                }
                case CONTACT: {
                    return CustomFieldKind.CONTACT;
                }
                case CONTACT_INFO: {
                    return CustomFieldKind.CONTACT_INFO;
                }
                case CUSTOM_OPERATION: {
                    return CustomFieldKind.CUSTOM_OPERATION;
                }
                case CUSTOM_WIZARD: {
                    return CustomFieldKind.CUSTOM_WIZARD;
                }
                case DOCUMENT: {
                    return CustomFieldKind.DOCUMENT;
                }
                case RECORD: {
                    return CustomFieldKind.RECORD;
                }
                case TRANSFER: {
                    return CustomFieldKind.TRANSACTION;
                }
                case USER: {
                    return CustomFieldKind.USER;
                }
                case VOUCHER: {
                    return CustomFieldKind.VOUCHER;
                }
            }
        }
        return null;
    }

    public CustomFieldNature toCustomFieldNature(CustomFieldKind customFieldKind) {
        if (customFieldKind != null) {
            switch (customFieldKind) {
                case MARKETPLACE: {
                    return CustomFieldNature.AD;
                }
                case CONTACT: {
                    return CustomFieldNature.CONTACT;
                }
                case CONTACT_INFO: {
                    return CustomFieldNature.CONTACT_INFO;
                }
                case CUSTOM_OPERATION: {
                    return CustomFieldNature.CUSTOM_OPERATION;
                }
                case CUSTOM_WIZARD: {
                    return CustomFieldNature.CUSTOM_WIZARD;
                }
                case DOCUMENT: {
                    return CustomFieldNature.DOCUMENT;
                }
                case RECORD: {
                    return CustomFieldNature.RECORD;
                }
                case TRANSACTION: {
                    return CustomFieldNature.TRANSFER;
                }
                case USER: {
                    return CustomFieldNature.USER;
                }
                case VOUCHER: {
                    return CustomFieldNature.VOUCHER;
                }
            }
        }
        return null;
    }

    public CustomFieldPossibleValue toCustomFieldPossibleValue(CustomFieldPossibleValueVO customFieldPossibleValueVO) {
        if (customFieldPossibleValueVO == null) {
            return null;
        }
        CustomFieldPossibleValue customFieldPossibleValue = this.newEntity(CustomFieldPossibleValue.class, customFieldPossibleValueVO);
        customFieldPossibleValue.setValue(customFieldPossibleValueVO.getValue());
        customFieldPossibleValue.setInternalName(ModelHelper.unqualifyInternalName((String)customFieldPossibleValueVO.getInternalName()));
        customFieldPossibleValue.setCategory(this.toReference((EntityModel)customFieldPossibleValueVO.getCategory()));
        return customFieldPossibleValue;
    }

    public CustomFieldSizeEnum toCustomFieldSizeEnum(CustomFieldSize customFieldSize) {
        if (customFieldSize != null) {
            switch (customFieldSize) {
                case FULL: {
                    return CustomFieldSizeEnum.FULL;
                }
                case LARGE: {
                    return CustomFieldSizeEnum.LARGE;
                }
                case MEDIUM: {
                    return CustomFieldSizeEnum.MEDIUM;
                }
                case SMALL: {
                    return CustomFieldSizeEnum.SMALL;
                }
                case TINY: {
                    return CustomFieldSizeEnum.TINY;
                }
            }
        }
        return null;
    }

    public CustomFieldTypeEnum toCustomFieldTypeEnum(CustomFieldType customFieldType) {
        if (customFieldType != null) {
            switch (customFieldType) {
                case BOOLEAN: {
                    return CustomFieldTypeEnum.BOOLEAN;
                }
                case DATE: {
                    return CustomFieldTypeEnum.DATE;
                }
                case DECIMAL: {
                    return CustomFieldTypeEnum.DECIMAL;
                }
                case DYNAMIC_SELECTION: {
                    return CustomFieldTypeEnum.DYNAMIC_SELECTION;
                }
                case DYNAMIC_MULTI_SELECTION: {
                    return CustomFieldTypeEnum.DYNAMIC_MULTI_SELECTION;
                }
                case INTEGER: {
                    return CustomFieldTypeEnum.INTEGER;
                }
                case LINKED_ENTITY: {
                    return CustomFieldTypeEnum.LINKED_ENTITY;
                }
                case MULTI_SELECTION: {
                    return CustomFieldTypeEnum.MULTI_SELECTION;
                }
                case RICH_TEXT: {
                    return CustomFieldTypeEnum.RICH_TEXT;
                }
                case SINGLE_SELECTION: {
                    return CustomFieldTypeEnum.SINGLE_SELECTION;
                }
                case STRING: {
                    return CustomFieldTypeEnum.STRING;
                }
                case TEXT: {
                    return CustomFieldTypeEnum.TEXT;
                }
                case URL: {
                    return CustomFieldTypeEnum.URL;
                }
                case FILE: {
                    return CustomFieldTypeEnum.FILE;
                }
                case IMAGE: {
                    return CustomFieldTypeEnum.IMAGE;
                }
            }
        }
        return null;
    }

    public <C extends BaseCustomFieldValue> C toCustomFieldValue(Class<C> clazz, ICustomFieldValue<CustomFieldPossibleValueVO, CustomFieldPossibleValueCategoryVO, RawFileVO, ImageVO> iCustomFieldValue) {
        if (iCustomFieldValue == null) {
            return null;
        }
        return this.newBaseFieldValue(clazz, iCustomFieldValue);
    }

    public CustomFieldValue toCustomFieldValue(ICustomFieldValue<CustomFieldPossibleValueVO, CustomFieldPossibleValueCategoryVO, RawFileVO, ImageVO> iCustomFieldValue) {
        return this.toCustomFieldValue(CustomFieldValue.class, iCustomFieldValue);
    }

    public CustomFieldValueDTO toCustomFieldValueDTO(String string) {
        Pair<String, String> pair = this.splitFieldParts(string);
        if (pair == null) {
            return null;
        }
        CustomFieldValueDTO customFieldValueDTO = new CustomFieldValueDTO();
        customFieldValueDTO.setField((CustomFieldVO)ModelHelper.voFromString(CustomFieldVO.class, (String)((String)pair.getFirst())));
        customFieldValueDTO.setReferenceValue((String)pair.getSecond());
        return customFieldValueDTO;
    }

    public CustomFieldValueForSearchDTO toCustomFieldValueForSearch(String string) {
        Pair<String, String> pair = this.splitFieldParts(string);
        if (pair == null) {
            return null;
        }
        CustomFieldValueForSearchDTO customFieldValueForSearchDTO = new CustomFieldValueForSearchDTO();
        customFieldValueForSearchDTO.setField((CustomFieldVO)ModelHelper.voFromString(CustomFieldVO.class, (String)((String)pair.getFirst())));
        customFieldValueForSearchDTO.setStringValue((String)pair.getSecond());
        return customFieldValueForSearchDTO;
    }

    public List<CustomFieldValueDTO> toCustomFieldValuesDTO(List<String> list) {
        if (CollectionHelper.isEmpty(list)) {
            return null;
        }
        return list.stream().map(this::toCustomFieldValueDTO).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<CustomFieldValueDTO> toCustomFieldValuesDTO(Map<String, String> map) {
        ArrayList<CustomFieldValueDTO> arrayList = new ArrayList<CustomFieldValueDTO>(map.size());
        map.forEach((string, string2) -> {
            CustomFieldValueDTO customFieldValueDTO = new CustomFieldValueDTO();
            customFieldValueDTO.setField((CustomFieldVO)ModelHelper.voFromString(CustomFieldVO.class, (String)string));
            customFieldValueDTO.setReferenceValue(string2);
            arrayList.add(customFieldValueDTO);
        });
        return arrayList;
    }

    public Set<CustomFieldValueForSearchDTO> toCustomFieldValuesForSearch(Collection<String> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return null;
        }
        return collection.stream().map(this::toCustomFieldValueForSearch).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public <V extends BaseCustomFieldValue> List<V> toCustomFieldValuesList(Class<V> clazz, List<? extends ICustomFieldValue<CustomFieldPossibleValueVO, CustomFieldPossibleValueCategoryVO, RawFileVO, ImageVO>> list, BiConsumer<V, ICustomFieldValue<CustomFieldPossibleValueVO, CustomFieldPossibleValueCategoryVO, RawFileVO, ImageVO>> biConsumer) {
        ArrayList<V> arrayList = null;
        if (list != null) {
            for (ICustomFieldValue<CustomFieldPossibleValueVO, CustomFieldPossibleValueCategoryVO, RawFileVO, ImageVO> iCustomFieldValue : list) {
                String string = CustomFieldHelper.toReference(iCustomFieldValue);
                if (string == null) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<V>();
                }
                V v = this.toCustomFieldValue(clazz, iCustomFieldValue);
                if (biConsumer != null) {
                    biConsumer.accept(v, iCustomFieldValue);
                }
                arrayList.add(v);
            }
        }
        return arrayList;
    }

    public List<CustomFieldValue> toCustomFieldValuesList(List<? extends ICustomFieldValue<CustomFieldPossibleValueVO, CustomFieldPossibleValueCategoryVO, RawFileVO, ImageVO>> list) {
        return this.toCustomFieldValuesList(CustomFieldValue.class, list, null);
    }

    public Map<String, String> toCustomFieldValuesMap(List<? extends ICustomFieldValue<CustomFieldPossibleValueVO, CustomFieldPossibleValueCategoryVO, RawFileVO, ImageVO>> list) {
        HashMap<String, String> hashMap = null;
        if (list != null) {
            for (ICustomFieldValue<CustomFieldPossibleValueVO, CustomFieldPossibleValueCategoryVO, RawFileVO, ImageVO> iCustomFieldValue : list) {
                String string = (String)ObjectHelper.defaultValue((Object)CustomFieldHelper.toReference(iCustomFieldValue), (Object)"");
                if (hashMap == null) {
                    hashMap = new HashMap<String, String>();
                }
                hashMap.put(ModelHelper.unqualifiedInternalNameOrId((IEntity)iCustomFieldValue.getField()), string);
            }
        }
        return hashMap;
    }

    public CustomFieldVO toCustomFieldVO(String string, CustomFieldKind customFieldKind) {
        if (string == null || customFieldKind == null) {
            return null;
        }
        CustomFieldVO customFieldVO = (CustomFieldVO)ModelHelper.voFromString(CustomFieldVO.class, (String)string);
        customFieldVO.setNature(this.toCustomFieldNature(customFieldKind));
        return customFieldVO;
    }

    public DatePeriod toDatePeriod(DatePeriodDTO datePeriodDTO) {
        if (datePeriodDTO == null) {
            return null;
        }
        return this.toDatePeriod(datePeriodDTO.getBegin(), datePeriodDTO.getEnd());
    }

    public DatePeriod toDatePeriod(DateTime dateTime, DateTime dateTime2) {
        if (dateTime == null && dateTime2 == null) {
            return null;
        }
        DatePeriod datePeriod = new DatePeriod();
        datePeriod.setBegin(dateTime);
        datePeriod.setEnd(dateTime2);
        return datePeriod;
    }

    public DatePeriodDTO toDatePeriodDTO(DatePeriod datePeriod) {
        if (datePeriod == null) {
            return null;
        }
        return ModelHelper.datePeriod((DateTime)datePeriod.getBegin(), (DateTime)datePeriod.getEnd());
    }

    public DatePeriodDTO toDatePeriodDTO(List<DateTime> list) {
        if (CollectionHelper.isEmpty(list)) {
            return null;
        }
        DatePeriodDTO datePeriodDTO = new DatePeriodDTO();
        datePeriodDTO.setBegin(list.get(0));
        if (list.size() > 1) {
            datePeriodDTO.setEnd(list.get(1));
        }
        return datePeriodDTO;
    }

    public DatePeriodDTO toDatePeriodDTO(String string) {
        if (StringHelper.isBlank((Object)string)) {
            return null;
        }
        List<DateTime> list = StringHelper.splitTrimming((String)string, (String)CustomFieldHelper.VALUE_SEPARATOR).stream().map(DateTime::parse).collect(Collectors.toList());
        if (string.startsWith(CustomFieldHelper.VALUE_SEPARATOR)) {
            list.add(0, null);
        }
        return this.toDatePeriodDTO(list);
    }

    public DecimalRange toDecimalRange(DecimalRangeDTO decimalRangeDTO) {
        if (decimalRangeDTO == null || decimalRangeDTO.getMin() == null && decimalRangeDTO.getMax() == null) {
            return null;
        }
        DecimalRange decimalRange = new DecimalRange();
        decimalRange.setMin(decimalRangeDTO.getMin());
        decimalRange.setMax(decimalRangeDTO.getMax());
        return decimalRange;
    }

    public DecimalRangeDTO toDecimalRangeDTO(DecimalRange decimalRange) {
        if (decimalRange == null) {
            return null;
        }
        DecimalRangeDTO decimalRangeDTO = new DecimalRangeDTO();
        decimalRangeDTO.setMin(decimalRange.getMin());
        decimalRangeDTO.setMax(decimalRange.getMax());
        return decimalRangeDTO;
    }

    public DecimalRangeDTO toDecimalRangeDTO(List<BigDecimal> list) {
        if (CollectionHelper.isEmpty(list)) {
            return null;
        }
        DecimalRangeDTO decimalRangeDTO = new DecimalRangeDTO();
        decimalRangeDTO.setMin(list.get(0));
        if (list.size() > 1) {
            decimalRangeDTO.setMax(list.get(1));
        }
        return decimalRangeDTO;
    }

    public List<BigDecimal> toDecimalRangeList(DecimalRangeDTO decimalRangeDTO) {
        if (decimalRangeDTO == null || decimalRangeDTO.getMin() == null && decimalRangeDTO.getMax() == null) {
            return null;
        }
        ArrayList<BigDecimal> arrayList = new ArrayList<BigDecimal>();
        arrayList.add(decimalRangeDTO.getMin());
        arrayList.add(decimalRangeDTO.getMax());
        return arrayList;
    }

    public Double toDouble(ICurrencyAmount iCurrencyAmount) {
        return iCurrencyAmount == null ? null : this.toDouble(iCurrencyAmount.getAmount());
    }

    public Double toDouble(Number number) {
        if (number == null) {
            return null;
        }
        if (number instanceof Double) {
            return (Double)number;
        }
        return number.doubleValue();
    }

    public ExportFormat toExportFormat(ExportFormatVO exportFormatVO) {
        if (exportFormatVO == null) {
            return null;
        }
        ExportFormat exportFormat = this.newEntity(ExportFormat.class, exportFormatVO);
        exportFormat.setContentType(exportFormatVO.getContentType());
        exportFormat.setBinary(exportFormatVO.isBinary());
        exportFormat.setEncoding(exportFormatVO.getEncoding());
        return exportFormat;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public String toFilter(BaseValueForSearchDTO var1_1) {
        if (var1_1 == null) {
            return null;
        }
        if (var1_1 instanceof BasicProfileFieldValueForSearchDTO) {
            var4_2 /* !! */  = (BasicProfileFieldValueForSearchDTO)var1_1;
            var5_3 /* !! */  = var4_2 /* !! */ .getField();
            var2_4 = var5_3 /* !! */ .getAlias();
            var3_5 = var5_3 /* !! */  == BasicProfileField.IMAGE ? CustomFieldType.BOOLEAN : CustomFieldType.STRING;
        } else if (var1_1 instanceof AddressFieldValueForSearchDTO) {
            var4_2 /* !! */  = (AddressFieldValueForSearchDTO)var1_1;
            var2_4 = BasicProfileField.ADDRESS.getAlias() + "." + var4_2 /* !! */ .getAddressField().internalName();
            var3_5 = CustomFieldType.STRING;
        } else if (var1_1 instanceof CustomFieldValueForSearchDTO) {
            var4_2 /* !! */  = (CustomFieldValueForSearchDTO)var1_1;
            var5_3 /* !! */  = var4_2 /* !! */ .getField();
            var2_4 = var5_3 /* !! */ .getInternalName();
            var3_5 = var5_3 /* !! */ .getType();
        } else {
            throw new IllegalStateException("Unhandled BaseValueForSearchDTO subclass: " + var1_1.getClass().getName());
        }
        var4_2 /* !! */  = null;
        switch (1.$SwitchMap$org$cyclos$model$system$fields$CustomFieldType[var3_5.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                var4_2 /* !! */  = StringHelper.trim((Object)var1_1.getStringValue());
                break;
            }
            case 5: {
                var4_2 /* !! */  = StringHelper.trim((Object)var1_1.getBooleanValue());
                break;
            }
            case 6: {
                var4_2 /* !! */  = this.rangeToValue((Bean)var1_1.getDatePeriod());
                break;
            }
            case 7: {
                var4_2 /* !! */  = this.rangeToValue((Bean)var1_1.getDecimalRange());
                break;
            }
            case 8: {
                var4_2 /* !! */  = this.rangeToValue((Bean)var1_1.getIntegerRange());
                break;
            }
            case 15: {
                var4_2 /* !! */  = this.entitiesToValue(((CustomFieldValueForSearchDTO)var1_1).getLinkedEntityValues());
                break;
            }
            case 9: 
            case 10: {
                var4_2 /* !! */  = this.entitiesToValue(((CustomFieldValueForSearchDTO)var1_1).getEnumeratedValues());
                break;
            }
            case 13: 
            case 14: {
                if (!StringHelper.isNotBlank((Object)var1_1.getStringValue())) ** GOTO lbl48
                var4_2 /* !! */  = var1_1.getStringValue();
                ** GOTO lbl53
lbl48:
                // 1 sources

                if (var1_1 instanceof CustomFieldValueForSearchDTO) {
                    var5_3 /* !! */  = ((CustomFieldValueForSearchDTO)var1_1).getDynamicValues();
                    var4_2 /* !! */  = CollectionHelper.orEmpty((Set)var5_3 /* !! */ ).stream().map((Function<DynamicFieldValueVO, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getValue(), (Lorg/cyclos/model/system/fields/DynamicFieldValueVO;)Ljava/lang/String;)()).collect(Collectors.joining("|"));
                } else {
                    var4_2 /* !! */  = "";
                }
            }
lbl53:
            // 4 sources

            case 11: 
            case 12: {
                var4_2 /* !! */  = "";
            }
        }
        if (var4_2 /* !! */  == null) {
            throw new IllegalStateException("Unhandled field type: " + String.valueOf(var3_5));
        }
        return (String)var2_4 + ":" + (String)var4_2 /* !! */ ;
    }

    public List<DateTime> toFilter(DatePeriodDTO datePeriodDTO) {
        DateTime dateTime = datePeriodDTO == null ? null : datePeriodDTO.getBegin();
        DateTime dateTime2 = datePeriodDTO == null ? null : datePeriodDTO.getEnd();
        return this.toFilter(dateTime, dateTime2);
    }

    public List<BigDecimal> toFilter(DecimalRangeDTO decimalRangeDTO) {
        BigDecimal bigDecimal = decimalRangeDTO == null ? null : decimalRangeDTO.getMin();
        BigDecimal bigDecimal2 = decimalRangeDTO == null ? null : decimalRangeDTO.getMax();
        return this.toFilter(bigDecimal, bigDecimal2);
    }

    public List<Integer> toFilter(IntegerRangeDTO integerRangeDTO) {
        Integer n = integerRangeDTO == null ? null : integerRangeDTO.getMin();
        Integer n2 = integerRangeDTO == null ? null : integerRangeDTO.getMax();
        return this.toFilter(n, n2);
    }

    public List<String> toFilters(Collection<? extends BaseValueForSearchDTO> collection) {
        return CollectionHelper.orEmpty(collection).stream().map(this::toFilter).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Float toFloat(Number number) {
        return number == null ? null : Float.valueOf(number.floatValue());
    }

    public ImageSize toImageSize(ImageSizeEnum imageSizeEnum) {
        if (imageSizeEnum != null) {
            switch (imageSizeEnum) {
                case TINY: {
                    return ImageSize.TINY;
                }
                case SMALL: {
                    return ImageSize.SMALL;
                }
                case MEDIUM: {
                    return ImageSize.MEDIUM;
                }
                case LARGE: {
                    return ImageSize.LARGE;
                }
            }
        }
        return null;
    }

    public IntegerRange toIntegerRange(IntegerRangeDTO integerRangeDTO) {
        if (integerRangeDTO == null || integerRangeDTO.getMin() == null && integerRangeDTO.getMax() == null) {
            return null;
        }
        IntegerRange integerRange = new IntegerRange();
        integerRange.setMin(integerRangeDTO.getMin());
        integerRange.setMax(integerRangeDTO.getMax());
        return integerRange;
    }

    public IntegerRangeDTO toIntegerRangeDTO(List<Integer> list) {
        if (CollectionHelper.isEmpty(list)) {
            return null;
        }
        IntegerRangeDTO integerRangeDTO = new IntegerRangeDTO();
        integerRangeDTO.setMin(list.get(0));
        if (list.size() > 1) {
            integerRangeDTO.setMax(list.get(1));
        }
        return integerRangeDTO;
    }

    public LatLongDTO toLatLongDTO(GeographicalCoordinate geographicalCoordinate) {
        if (geographicalCoordinate == null || geographicalCoordinate.getLatitude() == null || geographicalCoordinate.getLongitude() == null) {
            return null;
        }
        return ModelHelper.latLong((double)geographicalCoordinate.getLatitude(), (double)geographicalCoordinate.getLongitude());
    }

    public LinkedEntityTypeEnum toLinkedEntityTypeEnum(LinkedEntityType linkedEntityType) {
        if (linkedEntityType != null) {
            switch (linkedEntityType) {
                case RECORD: {
                    return LinkedEntityTypeEnum.RECORD;
                }
                case TRANSACTION: {
                    return LinkedEntityTypeEnum.TRANSACTION;
                }
                case TRANSFER: {
                    return LinkedEntityTypeEnum.TRANSFER;
                }
                case USER: {
                    return LinkedEntityTypeEnum.USER;
                }
                case ADVERTISEMENT: {
                    return LinkedEntityTypeEnum.ADVERTISEMENT;
                }
            }
        }
        return null;
    }

    public NotificationLevelEnum toNotificationLevelEnum(NotificationLevel notificationLevel) {
        if (notificationLevel != null) {
            switch (notificationLevel) {
                case INFORMATION: {
                    return NotificationLevelEnum.INFORMATION;
                }
                case WARNING: {
                    return NotificationLevelEnum.WARNING;
                }
                case ERROR: {
                    return NotificationLevelEnum.ERROR;
                }
            }
        }
        return null;
    }

    public PreselectedPeriod toPreselectedPeriod(PeriodPreselectorOptionData periodPreselectorOptionData) {
        if (periodPreselectorOptionData == null) {
            return null;
        }
        PreselectedPeriod preselectedPeriod = new PreselectedPeriod();
        preselectedPeriod.setDefaultOption(periodPreselectorOptionData.isDefaultOption());
        preselectedPeriod.setName(periodPreselectorOptionData.getName());
        if (periodPreselectorOptionData.getPeriod() != null) {
            preselectedPeriod.setBegin(periodPreselectorOptionData.getPeriod().getBegin());
            preselectedPeriod.setEnd(periodPreselectorOptionData.getPeriod().getEnd());
        }
        return preselectedPeriod;
    }

    public EntityReference toReference(EntityModel entityModel) {
        return this.newEntity(EntityReference.class, entityModel);
    }

    public EntityReference toReference(EntityModel entityModel, boolean bl) {
        return this.newEntity(EntityReference.class, entityModel, bl);
    }

    public RequestInfo toRequestInfo(HttpRequestData httpRequestData) {
        if (httpRequestData == null) {
            return null;
        }
        String string2 = StringHelper.trimToNull(CollectionHelper.orEmpty(httpRequestData.getHeaders()).get("Cookie"));
        MapParameterStorage mapParameterStorage = new MapParameterStorage(true);
        if (string2 != null) {
            StringHelper.splitTrimming((String)string2, (String)";").stream().map(string -> StringHelper.splitTrimming((String)string, (String)"=")).forEach(list -> mapParameterStorage.setString((String)list.get(0), new String[]{list.isEmpty() ? null : (String)list.get(1)}));
        }
        return RequestInfo.builder().method(httpRequestData.getMethod()).parameters(this.toParameterStorage(false, httpRequestData.getParameters())).headers(this.toParameterStorage(true, httpRequestData.getHeaders())).cookies((ParameterStorage)mapParameterStorage).body(httpRequestData.getBody()).build();
    }

    public ResultTypeEnum toResultTypeEnum(ResultType resultType) {
        if (resultType != null) {
            switch (resultType) {
                case LIST: {
                    return ResultTypeEnum.LIST;
                }
                case LIST_THUMB: {
                    return ResultTypeEnum.LIST_THUMB;
                }
                case MAP: {
                    return ResultTypeEnum.MAP;
                }
                case TILED: {
                    return ResultTypeEnum.TILED;
                }
            }
        }
        return null;
    }

    public SendMedium toSendMedium(SendMediumEnum sendMediumEnum) {
        if (sendMediumEnum != null) {
            switch (sendMediumEnum) {
                case EMAIL: {
                    return SendMedium.EMAIL;
                }
                case SMS: {
                    return SendMedium.SMS;
                }
            }
        }
        return null;
    }

    public SendMediumEnum toSendMediumEnum(SendMedium sendMedium) {
        if (sendMedium != null) {
            switch (sendMedium) {
                case EMAIL: {
                    return SendMediumEnum.EMAIL;
                }
                case SMS: {
                    return SendMediumEnum.SMS;
                }
            }
        }
        return null;
    }

    public TimeField toTimeField(TimeFieldEnum timeFieldEnum) {
        if (timeFieldEnum != null) {
            switch (timeFieldEnum) {
                case MILLIS: {
                    return TimeField.MILLIS;
                }
                case SECONDS: {
                    return TimeField.SECONDS;
                }
                case MINUTES: {
                    return TimeField.MINUTES;
                }
                case HOURS: {
                    return TimeField.HOURS;
                }
                case DAYS: {
                    return TimeField.DAYS;
                }
                case WEEKS: {
                    return TimeField.WEEKS;
                }
                case MONTHS: {
                    return TimeField.MONTHS;
                }
                case YEARS: {
                    return TimeField.YEARS;
                }
            }
        }
        return null;
    }

    public TimeFieldEnum toTimeFieldEnum(TimeField timeField) {
        if (timeField != null) {
            switch (timeField) {
                case MILLIS: {
                    return TimeFieldEnum.MILLIS;
                }
                case SECONDS: {
                    return TimeFieldEnum.SECONDS;
                }
                case MINUTES: {
                    return TimeFieldEnum.MINUTES;
                }
                case HOURS: {
                    return TimeFieldEnum.HOURS;
                }
                case DAYS: {
                    return TimeFieldEnum.DAYS;
                }
                case WEEKS: {
                    return TimeFieldEnum.WEEKS;
                }
                case MONTHS: {
                    return TimeFieldEnum.MONTHS;
                }
                case YEARS: {
                    return TimeFieldEnum.YEARS;
                }
            }
        }
        return null;
    }

    public TimeInterval toTimeInterval(TimeIntervalDTO timeIntervalDTO) {
        if (timeIntervalDTO == null || timeIntervalDTO.getAmount() == null || timeIntervalDTO.getField() == null) {
            return null;
        }
        TimeInterval timeInterval = new TimeInterval();
        timeInterval.setAmount(timeIntervalDTO.getAmount());
        timeInterval.setField(this.toTimeFieldEnum(timeIntervalDTO.getField()));
        return timeInterval;
    }

    public TimeIntervalDTO toTimeIntervalDTO(Integer n, TimeFieldEnum timeFieldEnum) {
        if (StringHelper.isBlank((Object)timeFieldEnum)) {
            return null;
        }
        return ModelHelper.timeInterval((int)((Integer)ObjectHelper.defaultValue((Object)n, (Object)1)), (TimeField)this.toTimeField(timeFieldEnum));
    }

    public TimeIntervalDTO toTimeIntervalDTO(TimeInterval timeInterval) {
        if (timeInterval == null) {
            return null;
        }
        return this.toTimeIntervalDTO(timeInterval.getAmount(), timeInterval.getField());
    }

    public TranslatableVersionedVO toTranslatableVersionedVO(String string) {
        Object object;
        Long l = null;
        Integer n = null;
        Long l2 = null;
        Integer n2 = null;
        Boolean bl = null;
        String string2 = null;
        if ("true".equalsIgnoreCase(string)) {
            bl = true;
        } else if ("false".equalsIgnoreCase(string)) {
            bl = false;
        } else if (StringHelper.isNotBlank((Object)string) && string.contains("|")) {
            object = StringHelper.splitTrimming((String)string, (String)"|");
            try {
                l = this.fromId((String)object.get(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                n = Integer.parseInt((String)object.get(1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                l2 = this.fromId((String)object.get(2));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                n2 = Integer.parseInt((String)object.get(3));
            }
            catch (Exception exception) {}
        } else {
            string2 = string;
        }
        object = new TranslatableVersionedVO();
        object.setId(l);
        object.setVersion(n);
        object.setForce(bl);
        object.setDataTranslationId(l2);
        object.setDataTranslationVersion(n2);
        object.setContentHash(string2);
        return object;
    }

    public UserMenuEnum toUserMenuEnum(UserMainMenu userMainMenu) {
        if (userMainMenu != null) {
            switch (userMainMenu) {
                case BANKING: {
                    return UserMenuEnum.BANKING;
                }
                case COMMUNITY: {
                    return UserMenuEnum.COMMUNITY;
                }
                case MARKETPLACE: {
                    return UserMenuEnum.MARKETPLACE;
                }
                case PERSONAL: {
                    return UserMenuEnum.PERSONAL;
                }
            }
        }
        return null;
    }

    public UserProfileSectionEnum toUserProfileSectionEnum(ProfileManagementSection profileManagementSection) {
        if (profileManagementSection != null) {
            switch (profileManagementSection) {
                case ACCOUNTS: {
                    return UserProfileSectionEnum.BANKING;
                }
                case ADVERTISEMENTS: {
                    return UserProfileSectionEnum.MARKETPLACE;
                }
                case INFORMATION: {
                    return UserProfileSectionEnum.INFORMATION;
                }
                case USER_MANAGEMENT: {
                    return UserProfileSectionEnum.MANAGEMENT;
                }
            }
        }
        return null;
    }

    public VersionedEntity toVersioned(EntityVO entityVO, Integer n) {
        return this.toVersioned(EntityVO.id((EntityVO)entityVO), n);
    }

    public VersionedEntity toVersioned(Long l, Integer n) {
        if (l == null) {
            return null;
        }
        VersionedEntity versionedEntity = new VersionedEntity();
        versionedEntity.setId(ApiHelper.toId(l));
        versionedEntity.setVersion(n);
        return versionedEntity;
    }

    public VersionedEntityReference toVersionedReference(ConfigurationVO configurationVO, Integer n) {
        if (configurationVO == null) {
            return null;
        }
        VersionedEntityReference versionedEntityReference = this.newEntity(VersionedEntityReference.class, configurationVO);
        versionedEntityReference.setVersion(n);
        return versionedEntityReference;
    }

    public VersionedVO toVersionedVO(String string) {
        Object object;
        Long l = null;
        Integer n = null;
        Boolean bl = null;
        if ("true".equalsIgnoreCase(string)) {
            bl = true;
        } else if ("false".equalsIgnoreCase(string)) {
            bl = false;
        } else if (StringHelper.isNotBlank((Object)string) && string.contains("|")) {
            object = StringHelper.splitTrimming((String)string, (String)"|");
            try {
                l = this.fromId((String)object.get(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                n = Integer.parseInt((String)object.get(1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = new VersionedVO();
        object.setId(l);
        object.setVersion(n);
        object.setForce(bl);
        return object;
    }

    public WeekDayEnum toWeekDayEnum(WeekDay weekDay) {
        if (weekDay != null) {
            switch (weekDay) {
                case SUNDAY: {
                    return WeekDayEnum.SUN;
                }
                case MONDAY: {
                    return WeekDayEnum.MON;
                }
                case TUESDAY: {
                    return WeekDayEnum.TUE;
                }
                case WEDNESDAY: {
                    return WeekDayEnum.WED;
                }
                case THURSDAY: {
                    return WeekDayEnum.THU;
                }
                case FRIDAY: {
                    return WeekDayEnum.FRI;
                }
                case SATURDAY: {
                    return WeekDayEnum.SAT;
                }
            }
        }
        return null;
    }

    public URI uriFromApi(List<?> list) {
        try {
            return new URI(this.urlFromApi(list));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException(uRISyntaxException);
        }
    }

    public URI uriFromApi(Object ... objectArray) {
        try {
            return new URI(this.urlFromApi(objectArray));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException(uRISyntaxException);
        }
    }

    public String urlFromApi(List<?> list) {
        String string = list.stream().map(object -> object == null ? "" : StringHelper.encodeURIComponent((String)object.toString())).collect(Collectors.joining("/"));
        return StringUtils.appendIfMissing((String)this.getRequestData().getApiUrl(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + string;
    }

    public String urlFromApi(Object ... objectArray) {
        return this.urlFromApi(Arrays.asList(objectArray));
    }

    public String urlFromContent(List<?> list) {
        try {
            list.add(0, "content");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            list = new ArrayList(list);
            return this.urlFromContent(list);
        }
        return this.urlFromRoot(list);
    }

    public String urlFromContent(Object ... objectArray) {
        return this.urlFromContent(Arrays.asList(objectArray));
    }

    public String urlFromRoot(List<?> list) {
        String string = list.stream().map(object -> StringHelper.encodeURIComponent((String)object.toString())).collect(Collectors.joining("/"));
        return StringUtils.appendIfMissing((String)this.getRequestData().getBaseUrl(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + string;
    }

    public String urlFromRoot(Object ... objectArray) {
        return this.urlFromRoot(Arrays.asList(objectArray));
    }

    private String anyPropertyToString(Bean bean, Property<?, ?> ... propertyArray) {
        if (bean == null || CollectionHelper.isEmpty((Object[])propertyArray)) {
            return null;
        }
        for (Property<?, ?> property : propertyArray) {
            try {
                String string = StringHelper.trimToNull((Object)bean.get(property));
                if (string == null) continue;
                return string;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private String entitiesToValue(Collection<? extends IEntity> collection) {
        return CollectionHelper.orEmpty(collection).stream().map(ModelHelper::unqualifiedInternalNameOrId).collect(Collectors.joining("|"));
    }

    private String getDefaultValue(CustomFieldDetailedVO customFieldDetailedVO) {
        Object object = CustomFieldHelper.getDefaultValue((CustomFieldDetailedVO)customFieldDetailedVO);
        if (object == null) {
            return null;
        }
        switch (customFieldDetailedVO.getType()) {
            case STRING: 
            case URL: 
            case TEXT: 
            case RICH_TEXT: 
            case BOOLEAN: 
            case DATE: 
            case DECIMAL: 
            case INTEGER: {
                return object.toString();
            }
            case DYNAMIC_SELECTION: {
                return ((DynamicFieldValueVO)object).getValue();
            }
            case DYNAMIC_MULTI_SELECTION: {
                Iterator iterator = IteratorUtils.getIterator((Object)object);
                return CollectionHelper.asStream((Iterator)iterator).map(DynamicFieldValueVO::getValue).collect(Collectors.joining("|"));
            }
            case SINGLE_SELECTION: 
            case MULTI_SELECTION: 
            case LINKED_ENTITY: {
                Iterator iterator = IteratorUtils.getIterator((Object)object);
                return CollectionHelper.asStream((Iterator)iterator).map(ModelHelper::unqualifiedInternalNameOrId).collect(Collectors.joining("|"));
            }
            case FILE: 
            case IMAGE: {
                return null;
            }
        }
        return null;
    }

    private String rangeToValue(Bean bean) {
        String string = StringHelper.trim((Object)this.anyPropertyToString(bean, new Property[]{DatePeriodDTO.BEGIN, DecimalRangeDTO.MIN, IntegerRangeDTO.MIN}));
        String string2 = StringHelper.trim((Object)this.anyPropertyToString(bean, new Property[]{DatePeriodDTO.END, DecimalRangeDTO.MAX, IntegerRangeDTO.MAX}));
        if (string.isEmpty() && string2.isEmpty()) {
            return "";
        }
        if (string.equals(string2)) {
            return string;
        }
        return string + "|" + string2;
    }

    private <T> List<T> toFilter(T t, T t2) {
        if (t == null && t2 == null) {
            return Collections.emptyList();
        }
        if (t != null && t.equals(t2)) {
            return Collections.singletonList(t);
        }
        return Arrays.asList(t, t2);
    }

    private ParameterStorage toParameterStorage(boolean bl, Map<String, String> map) {
        if (map == null) {
            return null;
        }
        MapParameterStorage mapParameterStorage = new MapParameterStorage(bl);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            mapParameterStorage.setString(entry.getKey(), new String[]{entry.getValue()});
        }
        return mapParameterStorage;
    }
}

