/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.model.EntityVO;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.messaging.alerts.AlertVO;
import org.cyclos.model.messaging.alerts.SystemAlertType;
import org.cyclos.model.messaging.alerts.UserAlertQuery;
import org.cyclos.model.messaging.alerts.UserAlertSearchData;
import org.cyclos.model.messaging.alerts.UserAlertType;
import org.cyclos.model.messaging.alerts.UserAlertVO;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.GroupsApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.Alert;
import org.cyclos.web.rest.model.SystemAlertTypeEnum;
import org.cyclos.web.rest.model.UserAlert;
import org.cyclos.web.rest.model.UserAlertDataForSearch;
import org.cyclos.web.rest.model.UserAlertQueryFilters;
import org.cyclos.web.rest.model.UserAlertTypeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AlertsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private GroupsApiHelper groupsApiHelper;

    public SystemAlertType toSystemAlertType(SystemAlertTypeEnum systemAlertTypeEnum) {
        if (systemAlertTypeEnum != null) {
            switch (systemAlertTypeEnum) {
                case APPLICATION_RESTARTED: {
                    return SystemAlertType.APPLICATION_RESTARTED;
                }
                case ACCOUNT_BALANCE_FIXED: {
                    return SystemAlertType.ACCOUNT_BALANCE_FIXED;
                }
                case ARCHIVING_FAILED: {
                    return SystemAlertType.ARCHIVING_FAILED;
                }
                case INCONSISTENT_DB_SCHEMA: {
                    return SystemAlertType.INCONSISTENT_DB_SCHEMA;
                }
                case INCONSISTENT_BALANCE_BELOW_LIMIT: {
                    return SystemAlertType.INCONSISTENT_BALANCE_BELOW_LIMIT;
                }
                case PARTIAL_DATA_RETURNED: {
                    return SystemAlertType.PARTIAL_DATA_RETURNED;
                }
                case MAX_INCORRECT_LOGIN_ATTEMPTS: {
                    return SystemAlertType.MAX_INCORRECT_LOGIN_ATTEMPTS;
                }
                case MAX_GLOBAL_SMS_REACHED: {
                    return SystemAlertType.MAX_GLOBAL_SMS_REACHED;
                }
                case MAX_BLOCKED_USERS_REACHED: {
                    return SystemAlertType.MAX_BLOCKED_USERS_REACHED;
                }
                case ACCOUNT_FEE_CHARGED_NO_FAILURES: {
                    return SystemAlertType.ACCOUNT_FEE_CHARGED_NO_FAILURES;
                }
                case ACCOUNT_FEE_CHARGED_WITH_FAILURES: {
                    return SystemAlertType.ACCOUNT_FEE_CHARGED_WITH_FAILURES;
                }
                case EMAIL_SENDING_FAILED: {
                    return SystemAlertType.EMAIL_SENDING_FAILED;
                }
                case SMS_SENDING_FAILED: {
                    return SystemAlertType.SMS_SENDING_FAILED;
                }
                case CUSTOM_TRANSLATIONS_INVALIDATED: {
                    return SystemAlertType.CUSTOM_TRANSLATIONS_INVALIDATED;
                }
                case CUSTOM: {
                    return SystemAlertType.CUSTOM;
                }
                case MAX_USERS_ALMOST_REACHED: {
                    return SystemAlertType.MAX_USERS_ALMOST_REACHED;
                }
            }
        }
        return null;
    }

    public SystemAlertTypeEnum toSystemAlertTypeEnum(SystemAlertType systemAlertType) {
        if (systemAlertType != null) {
            switch (systemAlertType) {
                case ACCOUNT_FEE_CHARGED_NO_FAILURES: {
                    return SystemAlertTypeEnum.ACCOUNT_FEE_CHARGED_NO_FAILURES;
                }
                case ACCOUNT_FEE_CHARGED_WITH_FAILURES: {
                    return SystemAlertTypeEnum.ACCOUNT_FEE_CHARGED_WITH_FAILURES;
                }
                case INCONSISTENT_DB_SCHEMA: {
                    return SystemAlertTypeEnum.INCONSISTENT_DB_SCHEMA;
                }
                case INCONSISTENT_BALANCE_BELOW_LIMIT: {
                    return SystemAlertTypeEnum.INCONSISTENT_BALANCE_BELOW_LIMIT;
                }
                case ARCHIVING_FAILED: {
                    return SystemAlertTypeEnum.ARCHIVING_FAILED;
                }
                case APPLICATION_RESTARTED: {
                    return SystemAlertTypeEnum.APPLICATION_RESTARTED;
                }
                case ACCOUNT_BALANCE_FIXED: {
                    return SystemAlertTypeEnum.ACCOUNT_BALANCE_FIXED;
                }
                case PARTIAL_DATA_RETURNED: {
                    return SystemAlertTypeEnum.PARTIAL_DATA_RETURNED;
                }
                case MAX_BLOCKED_USERS_REACHED: {
                    return SystemAlertTypeEnum.MAX_BLOCKED_USERS_REACHED;
                }
                case MAX_GLOBAL_SMS_REACHED: {
                    return SystemAlertTypeEnum.MAX_GLOBAL_SMS_REACHED;
                }
                case MAX_INCORRECT_LOGIN_ATTEMPTS: {
                    return SystemAlertTypeEnum.MAX_INCORRECT_LOGIN_ATTEMPTS;
                }
                case EMAIL_SENDING_FAILED: {
                    return SystemAlertTypeEnum.EMAIL_SENDING_FAILED;
                }
                case SMS_SENDING_FAILED: {
                    return SystemAlertTypeEnum.SMS_SENDING_FAILED;
                }
                case CUSTOM_TRANSLATIONS_INVALIDATED: {
                    return SystemAlertTypeEnum.CUSTOM_TRANSLATIONS_INVALIDATED;
                }
                case CUSTOM: {
                    return SystemAlertTypeEnum.CUSTOM;
                }
                case MAX_USERS_ALMOST_REACHED: {
                    return SystemAlertTypeEnum.MAX_USERS_ALMOST_REACHED;
                }
            }
        }
        return null;
    }

    public UserAlert toUserAlert(UserAlertVO userAlertVO) {
        UserAlert userAlert = this.newAlert(UserAlert.class, (AlertVO)userAlertVO);
        userAlert.setType(this.toUserAlertTypeEnum(userAlertVO.getType()));
        userAlert.setUser(this.usersApiHelper.toUser((BasicUserVO)userAlertVO.getUser()));
        return userAlert;
    }

    public UserAlertDataForSearch toUserAlertDataForSearch(UserAlertSearchData userAlertSearchData) {
        UserAlertDataForSearch userAlertDataForSearch = new UserAlertDataForSearch();
        CollectionHelper.orEmpty((List)userAlertSearchData.getGroups()).stream().map(this.groupsApiHelper::toGroup).forEach(userAlertDataForSearch.getGroups()::add);
        userAlertDataForSearch.setQuery(this.toUserAlertQueryFilter((UserAlertQuery)userAlertSearchData.getQuery()));
        return userAlertDataForSearch;
    }

    public UserAlertQuery toUserAlertQuery(UserAlertQueryFilters userAlertQueryFilters) {
        UserAlertQuery userAlertQuery = this.apiHelper.newQuery(UserAlertQuery.class, userAlertQueryFilters.getPage(), userAlertQueryFilters.getPageSize(), userAlertQueryFilters.getSkipTotalCount());
        userAlertQuery.setDatePeriod(this.apiHelper.toDatePeriodDTO(userAlertQueryFilters.getDatePeriod()));
        userAlertQuery.setTypes(CollectionHelper.orEmpty(userAlertQueryFilters.getTypes()).stream().map(this::toUserAlertType).collect(Collectors.toSet()));
        userAlertQuery.setGroups(CollectionHelper.orEmpty(userAlertQueryFilters.getGroups()).stream().map(string -> (BasicGroupVO)ModelHelper.voFromString(BasicGroupVO.class, (String)string)).collect(Collectors.toSet()));
        userAlertQuery.setBrokers(CollectionHelper.orEmpty(userAlertQueryFilters.getBrokers()).stream().map(string -> (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string)).collect(Collectors.toSet()));
        userAlertQuery.setUser((UserVO)ModelHelper.voFromString(UserLocatorVO.class, (String)userAlertQueryFilters.getUser()));
        return userAlertQuery;
    }

    public UserAlertQueryFilters toUserAlertQueryFilter(UserAlertQuery userAlertQuery) {
        if (userAlertQuery == null) {
            return null;
        }
        UserAlertQueryFilters userAlertQueryFilters = this.apiHelper.newQueryFilters(UserAlertQueryFilters.class, (QueryParameters)userAlertQuery);
        userAlertQueryFilters.setDatePeriod(this.apiHelper.toFilter(userAlertQuery.getDatePeriod()));
        userAlertQueryFilters.setTypes(CollectionHelper.orEmpty((Set)userAlertQuery.getTypes()).stream().map(this::toUserAlertTypeEnum).collect(Collectors.toList()));
        userAlertQueryFilters.setGroups(CollectionHelper.orEmpty((Set)userAlertQuery.getGroups()).stream().map(ModelHelper::stringOrIdFromVO).collect(Collectors.toList()));
        userAlertQueryFilters.setBrokers(CollectionHelper.orEmpty((Set)userAlertQuery.getBrokers()).stream().map(ModelHelper::stringOrIdFromVO).collect(Collectors.toList()));
        userAlertQueryFilters.setUser(ModelHelper.stringOrIdFromVO((EntityVO)userAlertQuery.getUser()));
        return userAlertQueryFilters;
    }

    public UserAlertType toUserAlertType(UserAlertTypeEnum userAlertTypeEnum) {
        if (userAlertTypeEnum != null) {
            switch (userAlertTypeEnum) {
                case CUSTOM: {
                    return UserAlertType.CUSTOM;
                }
                case GIVEN_VERY_BAD_REFS: {
                    return UserAlertType.GIVEN_VERY_BAD_REFS;
                }
                case INSUFFICIENT_BALANCE_FOR_INITIAL_CREDIT: {
                    return UserAlertType.INSUFFICIENT_BALANCE_FOR_INITIAL_CREDIT;
                }
                case INCONSISTENT_BALANCE_BELOW_LIMIT: {
                    return UserAlertType.INCONSISTENT_BALANCE_BELOW_LIMIT;
                }
                case MAX_DEVICE_ACTIVATION_ATTEMPTS_REACHED: {
                    return UserAlertType.MAX_DEVICE_ACTIVATION_ATTEMPTS_REACHED;
                }
                case MAX_DEVICE_CONFIRMATION_CHECK_ATTEMPTS_REACHED: {
                    return UserAlertType.MAX_DEVICE_CONFIRMATION_CHECK_ATTEMPTS_REACHED;
                }
                case MAX_TOKEN_ACTIVATION_ATTEMPTS_REACHED: {
                    return UserAlertType.MAX_TOKEN_ACTIVATION_ATTEMPTS_REACHED;
                }
                case MAX_CLIENT_ACTIVATION_ATTEMPTS_REACHED: {
                    return UserAlertType.MAX_ACCESS_CLIENT_ACTIVATION_ATTEMPTS_REACHED;
                }
                case MAX_TOTP_ACTIVATION_ATTEMPTS_REACHED: {
                    return UserAlertType.MAX_TOTP_ACTIVATION_ATTEMPTS_REACHED;
                }
                case MAX_TOTP_ATTEMPTS_REACHED: {
                    return UserAlertType.MAX_TOTP_ATTEMPTS_REACHED;
                }
                case MAX_USER_LOCALIZATION_ATTEMPTS_REACHED: {
                    return UserAlertType.MAX_USER_LOCALIZATION_ATTEMPTS_REACHED;
                }
                case MAX_VOUCHER_REDEEM_ATTEMPTS_REACHED: {
                    return UserAlertType.MAX_VOUCHER_REDEEM_ATTEMPTS_REACHED;
                }
                case MOVE_USER_AUTOMATICALLY_FAILED: {
                    return UserAlertType.MOVE_USER_AUTOMATICALLY_FAILED;
                }
                case PASSWORD_DISABLED_BY_TRIES: {
                    return UserAlertType.PASSWORD_DISABLED_BY_TRIES;
                }
                case PASSWORD_TEMPORARILY_BLOCKED: {
                    return UserAlertType.PASSWORD_TEMPORARILY_BLOCKED;
                }
                case RECEIVED_VERY_BAD_REFS: {
                    return UserAlertType.RECEIVED_VERY_BAD_REFS;
                }
                case SCHEDULED_PAYMENT_FAILED: {
                    return UserAlertType.SCHEDULED_PAYMENT_FAILED;
                }
            }
        }
        return null;
    }

    public UserAlertTypeEnum toUserAlertTypeEnum(UserAlertType userAlertType) {
        if (userAlertType != null) {
            switch (userAlertType) {
                case CUSTOM: {
                    return UserAlertTypeEnum.CUSTOM;
                }
                case GIVEN_VERY_BAD_REFS: {
                    return UserAlertTypeEnum.GIVEN_VERY_BAD_REFS;
                }
                case INSUFFICIENT_BALANCE_FOR_INITIAL_CREDIT: {
                    return UserAlertTypeEnum.INSUFFICIENT_BALANCE_FOR_INITIAL_CREDIT;
                }
                case INCONSISTENT_BALANCE_BELOW_LIMIT: {
                    return UserAlertTypeEnum.INCONSISTENT_BALANCE_BELOW_LIMIT;
                }
                case MAX_DEVICE_ACTIVATION_ATTEMPTS_REACHED: {
                    return UserAlertTypeEnum.MAX_DEVICE_ACTIVATION_ATTEMPTS_REACHED;
                }
                case MAX_DEVICE_CONFIRMATION_CHECK_ATTEMPTS_REACHED: {
                    return UserAlertTypeEnum.MAX_DEVICE_CONFIRMATION_CHECK_ATTEMPTS_REACHED;
                }
                case MAX_TOTP_ACTIVATION_ATTEMPTS_REACHED: {
                    return UserAlertTypeEnum.MAX_TOTP_ACTIVATION_ATTEMPTS_REACHED;
                }
                case MAX_TOKEN_ACTIVATION_ATTEMPTS_REACHED: {
                    return UserAlertTypeEnum.MAX_TOKEN_ACTIVATION_ATTEMPTS_REACHED;
                }
                case MAX_ACCESS_CLIENT_ACTIVATION_ATTEMPTS_REACHED: {
                    return UserAlertTypeEnum.MAX_CLIENT_ACTIVATION_ATTEMPTS_REACHED;
                }
                case MAX_TOTP_ATTEMPTS_REACHED: {
                    return UserAlertTypeEnum.MAX_TOTP_ATTEMPTS_REACHED;
                }
                case MAX_USER_LOCALIZATION_ATTEMPTS_REACHED: {
                    return UserAlertTypeEnum.MAX_USER_LOCALIZATION_ATTEMPTS_REACHED;
                }
                case MAX_VOUCHER_REDEEM_ATTEMPTS_REACHED: {
                    return UserAlertTypeEnum.MAX_VOUCHER_REDEEM_ATTEMPTS_REACHED;
                }
                case MOVE_USER_AUTOMATICALLY_FAILED: {
                    return UserAlertTypeEnum.MOVE_USER_AUTOMATICALLY_FAILED;
                }
                case PASSWORD_DISABLED_BY_TRIES: {
                    return UserAlertTypeEnum.PASSWORD_DISABLED_BY_TRIES;
                }
                case PASSWORD_TEMPORARILY_BLOCKED: {
                    return UserAlertTypeEnum.PASSWORD_TEMPORARILY_BLOCKED;
                }
                case RECEIVED_VERY_BAD_REFS: {
                    return UserAlertTypeEnum.RECEIVED_VERY_BAD_REFS;
                }
                case SCHEDULED_PAYMENT_FAILED: {
                    return UserAlertTypeEnum.SCHEDULED_PAYMENT_FAILED;
                }
            }
        }
        return null;
    }

    private <A extends Alert> A newAlert(Class<A> clazz, AlertVO alertVO) {
        Alert alert = (Alert)this.apiHelper.newEntity(clazz, alertVO);
        alert.setDate(alertVO.getDate());
        alert.setText(alertVO.getText());
        return (A)alert;
    }
}

