/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import java.util.Set;
import org.cyclos.model.EntityVO;
import org.cyclos.model.access.agreementlogs.AgreementLogVO;
import org.cyclos.model.access.agreements.AcceptedAgreementVO;
import org.cyclos.model.access.agreements.AgreementContentVO;
import org.cyclos.model.access.agreements.AgreementVO;
import org.cyclos.model.access.agreements.UserAgreementsData;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.AcceptedAgreement;
import org.cyclos.web.rest.model.Agreement;
import org.cyclos.web.rest.model.AgreementContent;
import org.cyclos.web.rest.model.AgreementLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AgreementsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;

    public Agreement toAgreement(AgreementVO agreementVO) {
        if (agreementVO == null) {
            return null;
        }
        return this.newAgreement(Agreement.class, agreementVO);
    }

    public AgreementContent toAgreementContent(AgreementContentVO agreementContentVO) {
        if (agreementContentVO == null) {
            return null;
        }
        AgreementContent agreementContent = new AgreementContent();
        agreementContent.setAgreement(this.toAgreement(agreementContentVO.getAgreement()));
        agreementContent.setContent(agreementContentVO.getContent());
        agreementContent.setContentVersion(agreementContentVO.getContentVersion());
        agreementContent.setLastVersion(agreementContentVO.getLastVersion());
        return agreementContent;
    }

    public org.cyclos.web.rest.model.UserAgreementsData toUserAgreementsData(UserAgreementsData userAgreementsData) {
        if (userAgreementsData == null) {
            return null;
        }
        org.cyclos.web.rest.model.UserAgreementsData userAgreementsData2 = new org.cyclos.web.rest.model.UserAgreementsData();
        userAgreementsData2.setUser(this.usersApiHelper.toUser((BasicUserVO)userAgreementsData.getUser()));
        userAgreementsData2.setCanEdit(userAgreementsData.isEditable());
        CollectionHelper.orEmpty((List)userAgreementsData.getAgreements()).stream().map(this::toAgreement).forEach(userAgreementsData2.getAgreements()::add);
        for (AcceptedAgreementVO acceptedAgreementVO : CollectionHelper.orEmpty((Set)userAgreementsData.getAccepted())) {
            String string = ApiHelper.toId(EntityVO.id((EntityVO)acceptedAgreementVO.getAgreement()));
            userAgreementsData2.getAccepted().put(string, this.toAcceptedAgreement(acceptedAgreementVO));
        }
        CollectionHelper.orEmpty((List)userAgreementsData.getLog()).stream().map(this::toAgreementLog).forEach(userAgreementsData2.getHistory()::add);
        return userAgreementsData2;
    }

    private <A extends Agreement> A newAgreement(Class<A> clazz, AgreementVO agreementVO) {
        Agreement agreement = (Agreement)this.apiHelper.newEntity(clazz, agreementVO);
        agreement.setRequired(agreementVO.isRequired());
        return (A)agreement;
    }

    private AcceptedAgreement toAcceptedAgreement(AcceptedAgreementVO acceptedAgreementVO) {
        if (acceptedAgreementVO == null) {
            return null;
        }
        AcceptedAgreement acceptedAgreement = this.apiHelper.newEntity(AcceptedAgreement.class, acceptedAgreementVO.getAgreement());
        acceptedAgreement.setDate(acceptedAgreementVO.getDate());
        acceptedAgreement.setAcceptedVersion(acceptedAgreementVO.getAcceptedVersion());
        return acceptedAgreement;
    }

    private AgreementLog toAgreementLog(AgreementLogVO agreementLogVO) {
        if (agreementLogVO == null) {
            return null;
        }
        AgreementContentVO agreementContentVO = agreementLogVO.getAgreementContent();
        AgreementLog agreementLog = this.apiHelper.newEntity(AgreementLog.class, agreementLogVO);
        agreementLog.setAgreement(this.toAgreement(agreementContentVO.getAgreement()));
        agreementLog.setDate(agreementLogVO.getDate());
        agreementLog.setRemoteAddress(agreementLogVO.getRemoteAddress());
        agreementLog.setAccepted(agreementLogVO.isAccepted());
        if (agreementLogVO.isAccepted()) {
            agreementLog.setAcceptedVersion(agreementContentVO.getContentVersion());
        }
        return agreementLog;
    }
}

