/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cyclos.model.users.addresses.AdAddressResult;
import org.cyclos.model.users.addresses.AddressConfigurationData;
import org.cyclos.model.users.addresses.AddressDTO;
import org.cyclos.model.users.addresses.AddressFields;
import org.cyclos.model.users.addresses.AddressQueryField;
import org.cyclos.model.users.addresses.GeoLocatedAddressVO;
import org.cyclos.model.users.addresses.IAddress;
import org.cyclos.model.users.addresses.UserAddressDTO;
import org.cyclos.model.users.addresses.UserAddressData;
import org.cyclos.model.users.addresses.UserAddressListData;
import org.cyclos.model.users.addresses.UserAddressResult;
import org.cyclos.model.users.addresses.UserAddressVO;
import org.cyclos.model.users.contactinfos.AddressContactInfoDTO;
import org.cyclos.model.users.contactinfos.IContactInfo;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.utils.CountryVO;
import org.cyclos.model.utils.DistanceDTO;
import org.cyclos.model.utils.LatLongDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.SearchByDistanceData;
import org.cyclos.server.model.users.users.UserProfileAddressesData;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.ContactInfosApiHelper;
import org.cyclos.web.rest.helpers.PhonesApiHelper;
import org.cyclos.web.rest.helpers.UiApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.AdAddressResultEnum;
import org.cyclos.web.rest.model.Address;
import org.cyclos.web.rest.model.AddressBasicData;
import org.cyclos.web.rest.model.AddressConfiguration;
import org.cyclos.web.rest.model.AddressConfigurationForUserProfile;
import org.cyclos.web.rest.model.AddressDataForEdit;
import org.cyclos.web.rest.model.AddressDataForNew;
import org.cyclos.web.rest.model.AddressEdit;
import org.cyclos.web.rest.model.AddressEditWithId;
import org.cyclos.web.rest.model.AddressFieldEnum;
import org.cyclos.web.rest.model.AddressManage;
import org.cyclos.web.rest.model.AddressNew;
import org.cyclos.web.rest.model.AddressQueryFieldEnum;
import org.cyclos.web.rest.model.AddressResult;
import org.cyclos.web.rest.model.AddressView;
import org.cyclos.web.rest.model.AvailabilityEnum;
import org.cyclos.web.rest.model.ContactInfoBinaryValuesForUserProfile;
import org.cyclos.web.rest.model.Country;
import org.cyclos.web.rest.model.CustomFieldBinaryValues;
import org.cyclos.web.rest.model.FullTextWithDistanceQueryFilters;
import org.cyclos.web.rest.model.GeographicalCoordinate;
import org.cyclos.web.rest.model.SimpleAddress;
import org.cyclos.web.rest.model.UserAddressResultEnum;
import org.cyclos.web.rest.model.UserAddressesListData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AddressesApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;
    @Autowired
    private UiApiHelper uiApiHelper;
    @Autowired
    private ContactInfosApiHelper contactInfosApiHelper;
    @Autowired
    private PhonesApiHelper phonesApiHelper;

    public void fillDistance(FullTextWithDistanceQueryFilters fullTextWithDistanceQueryFilters, DistanceDTO distanceDTO) {
        LatLongDTO latLongDTO = distanceDTO == null ? null : distanceDTO.getLocation();
        fullTextWithDistanceQueryFilters.setLatitude(latLongDTO == null ? null : (Double)CoercionHelper.coerce(Double.class, (Object)latLongDTO.getLatitude()));
        fullTextWithDistanceQueryFilters.setLongitude(latLongDTO == null ? null : (Double)CoercionHelper.coerce(Double.class, (Object)latLongDTO.getLongitude()));
        fullTextWithDistanceQueryFilters.setMaxDistance(distanceDTO == null ? null : (Double)CoercionHelper.coerce(Double.class, (Object)distanceDTO.getDistance()));
    }

    public <C extends AddressConfiguration> C newAddressConfiguration(Class<C> clazz, AddressConfigurationData addressConfigurationData) {
        AddressConfiguration addressConfiguration = (AddressConfiguration)ClassHelper.instantiate(clazz);
        addressConfiguration.setUseMap(addressConfigurationData.isUseMap());
        this.fillAddressFields(addressConfiguration.getRequiredFields(), addressConfigurationData.getRequiredAddressFields());
        Collections.sort(addressConfigurationData.getEnabledAddressFields());
        this.fillAddressFields(addressConfiguration.getEnabledFields(), addressConfigurationData.getEnabledAddressFields());
        return (C)addressConfiguration;
    }

    public AdAddressResult toAdAddressResult(AdAddressResultEnum adAddressResultEnum) {
        if (adAddressResultEnum != null) {
            switch (adAddressResultEnum) {
                case NONE: {
                    return AdAddressResult.NO_ADDRESSES;
                }
                case ALL: {
                    return AdAddressResult.ALL_LOCATED_ADDRESSES;
                }
                case NEAREST: {
                    return AdAddressResult.NEAREST_ADDRESS;
                }
            }
        }
        return null;
    }

    public AdAddressResultEnum toAdAddressResultEnum(AdAddressResult adAddressResult) {
        if (adAddressResult != null) {
            switch (adAddressResult) {
                case NO_ADDRESSES: {
                    return AdAddressResultEnum.NONE;
                }
                case ALL_LOCATED_ADDRESSES: {
                    return AdAddressResultEnum.ALL;
                }
                case NEAREST_ADDRESS: {
                    return AdAddressResultEnum.NEAREST;
                }
            }
        }
        return null;
    }

    public Address toAddress(GeoLocatedAddressVO geoLocatedAddressVO) {
        if (geoLocatedAddressVO == null) {
            return null;
        }
        return this.newAddress(Address.class, geoLocatedAddressVO);
    }

    public Map<String, CustomFieldBinaryValues> toAddressBinaryValuesForUserProfile(List<UserAddressDTO> list) {
        if (CollectionHelper.isEmpty(list)) {
            return null;
        }
        HashMap<String, CustomFieldBinaryValues> hashMap = new HashMap<String, CustomFieldBinaryValues>();
        for (UserAddressDTO userAddressDTO : list) {
            AddressContactInfoDTO addressContactInfoDTO = userAddressDTO.getContactInfo();
            if (addressContactInfoDTO == null) continue;
            ContactInfoBinaryValuesForUserProfile contactInfoBinaryValuesForUserProfile = this.apiHelper.newCustomFieldBinaryValues(ContactInfoBinaryValuesForUserProfile.class, addressContactInfoDTO.getCustomValues());
            hashMap.put(ApiHelper.toId(userAddressDTO.getId()), contactInfoBinaryValuesForUserProfile);
        }
        return hashMap;
    }

    public AddressConfiguration toAddressConfiguration(AddressConfigurationData addressConfigurationData) {
        if (addressConfigurationData == null) {
            return null;
        }
        return this.newAddressConfiguration(AddressConfiguration.class, addressConfigurationData);
    }

    public AddressConfigurationForUserProfile toAddressConfigurationForUserProfile(UserProfileAddressesData userProfileAddressesData) {
        if (userProfileAddressesData == null) {
            AddressConfigurationForUserProfile addressConfigurationForUserProfile = new AddressConfigurationForUserProfile();
            addressConfigurationForUserProfile.setAvailability(AvailabilityEnum.DISABLED);
            addressConfigurationForUserProfile.setMaxAddresses(0);
            addressConfigurationForUserProfile.setEdit(false);
            addressConfigurationForUserProfile.setManagePrivacy(false);
            return addressConfigurationForUserProfile;
        }
        AddressConfigurationForUserProfile addressConfigurationForUserProfile = this.newAddressConfiguration(AddressConfigurationForUserProfile.class, userProfileAddressesData.getConfiguration());
        addressConfigurationForUserProfile.setAvailability(this.apiHelper.toAvailability(userProfileAddressesData.getMaxAddresses() > 0, userProfileAddressesData.isRequired()));
        addressConfigurationForUserProfile.setEdit(userProfileAddressesData.isEdit());
        addressConfigurationForUserProfile.setManagePrivacy(userProfileAddressesData.isManagePrivacy());
        addressConfigurationForUserProfile.setMaxAddresses(userProfileAddressesData.getMaxAddresses());
        addressConfigurationForUserProfile.setAddress(this.toAddressNew(userProfileAddressesData.getAddress()));
        return addressConfigurationForUserProfile;
    }

    public UserAddressDTO toAddressDTO(AddressManage addressManage) {
        if (addressManage == null) {
            return null;
        }
        UserAddressDTO userAddressDTO = this.toAddressDTO(UserAddressDTO.class, addressManage);
        userAddressDTO.setName(addressManage.getName());
        userAddressDTO.setDefaultAddress(Boolean.TRUE.equals(addressManage.getDefaultAddress()));
        userAddressDTO.setLocation(this.apiHelper.toLatLongDTO(addressManage.getLocation()));
        userAddressDTO.setLocated(userAddressDTO.getLocation() != null);
        userAddressDTO.setHidden(Boolean.TRUE.equals(addressManage.getHidden()));
        userAddressDTO.setContactInfo(this.contactInfosApiHelper.toAddressContactInfoDTO(addressManage.getContactInfo()));
        return userAddressDTO;
    }

    public <A extends AddressDTO> A toAddressDTO(Class<A> clazz, org.cyclos.web.rest.model.IAddress iAddress) {
        if (iAddress == null) {
            return null;
        }
        AddressDTO addressDTO = (AddressDTO)ClassHelper.instantiate(clazz);
        if (iAddress instanceof AddressEdit) {
            addressDTO.setVersion(((AddressEdit)iAddress).getVersion());
            if (iAddress instanceof AddressEditWithId) {
                addressDTO.setId(this.apiHelper.fromId(((AddressEditWithId)iAddress).getId()));
            }
        }
        addressDTO.setAddressLine1(iAddress.getAddressLine1());
        addressDTO.setAddressLine2(iAddress.getAddressLine2());
        addressDTO.setBuildingNumber(iAddress.getBuildingNumber());
        addressDTO.setCity(iAddress.getCity());
        addressDTO.setComplement(iAddress.getComplement());
        addressDTO.setCountry(iAddress.getCountry());
        addressDTO.setNeighborhood(iAddress.getNeighborhood());
        addressDTO.setPoBox(iAddress.getPoBox());
        addressDTO.setRegion(iAddress.getRegion());
        addressDTO.setStreet(iAddress.getStreet());
        addressDTO.setZip(iAddress.getZip());
        return (A)addressDTO;
    }

    public AddressEdit toAddressEdit(UserAddressDTO userAddressDTO) {
        if (userAddressDTO == null) {
            return null;
        }
        return this.newAddressEdit(AddressEdit.class, userAddressDTO);
    }

    public AddressEditWithId toAddressEditWithId(UserAddressDTO userAddressDTO) {
        if (userAddressDTO == null) {
            return null;
        }
        AddressEditWithId addressEditWithId = this.newAddressEdit(AddressEditWithId.class, userAddressDTO);
        addressEditWithId.setId(ApiHelper.toId(userAddressDTO.getId()));
        return addressEditWithId;
    }

    public AddressFieldEnum toAddressFieldEnum(AddressFields addressFields) {
        if (addressFields != null) {
            switch (addressFields) {
                case ADDRESS_LINE_1: {
                    return AddressFieldEnum.ADDRESS_LINE1;
                }
                case ADDRESS_LINE_2: {
                    return AddressFieldEnum.ADDRESS_LINE2;
                }
                case BUILDING_NUMBER: {
                    return AddressFieldEnum.BUILDING_NUMBER;
                }
                case CITY: {
                    return AddressFieldEnum.CITY;
                }
                case COMPLEMENT: {
                    return AddressFieldEnum.COMPLEMENT;
                }
                case COUNTRY: {
                    return AddressFieldEnum.COUNTRY;
                }
                case NEIGHBORHOOD: {
                    return AddressFieldEnum.NEIGHBORHOOD;
                }
                case PO_BOX: {
                    return AddressFieldEnum.PO_BOX;
                }
                case REGION: {
                    return AddressFieldEnum.REGION;
                }
                case STREET: {
                    return AddressFieldEnum.STREET;
                }
                case ZIP: {
                    return AddressFieldEnum.ZIP;
                }
            }
        }
        return null;
    }

    public AddressNew toAddressNew(UserAddressDTO userAddressDTO) {
        if (userAddressDTO == null) {
            return null;
        }
        return this.newAddressManage(AddressNew.class, userAddressDTO);
    }

    public AddressQueryFieldEnum toAddressQueryFieldEnum(AddressQueryField addressQueryField) {
        if (addressQueryField != null) {
            switch (addressQueryField) {
                case ADDRESS: {
                    return AddressQueryFieldEnum.ADDRESS;
                }
                case CITY: {
                    return AddressQueryFieldEnum.CITY;
                }
                case COUNTRY: {
                    return AddressQueryFieldEnum.COUNTRY;
                }
                case NEIGHBORHOOD: {
                    return AddressQueryFieldEnum.NEIGHBORHOOD;
                }
                case PO_BOX: {
                    return AddressQueryFieldEnum.PO_BOX;
                }
                case REGION: {
                    return AddressQueryFieldEnum.REGION;
                }
                case ZIP: {
                    return AddressQueryFieldEnum.ZIP;
                }
            }
        }
        return null;
    }

    public AddressResult toAddressResult(GeoLocatedAddressVO geoLocatedAddressVO) {
        if (geoLocatedAddressVO == null) {
            return null;
        }
        return this.toAddressResult(AddressResult.class, geoLocatedAddressVO);
    }

    public AddressView toAddressView(GeoLocatedAddressVO geoLocatedAddressVO) {
        if (geoLocatedAddressVO == null) {
            return null;
        }
        return this.toAddressResult(AddressView.class, geoLocatedAddressVO);
    }

    public AddressView toAddressView(UserAddressData userAddressData) {
        UserAddressDTO userAddressDTO = (UserAddressDTO)userAddressData.getDto();
        AddressView addressView = this.apiHelper.newEntity(AddressView.class, userAddressDTO);
        this.fill(addressView, (IAddress)userAddressDTO);
        addressView.setCanEdit(userAddressData.isEditable());
        addressView.setUser(this.usersApiHelper.toUser((BasicUserVO)userAddressDTO.getUser()));
        addressView.setName(userAddressDTO.getName());
        addressView.setHidden(userAddressDTO.isHidden());
        addressView.setLocation(this.toGeographicalCoordinate(userAddressDTO.getLocation()));
        addressView.setDefaultAddress(userAddressDTO.isDefaultAddress());
        addressView.setEnablePrivacy(userAddressData.isEnablePrivacy());
        addressView.setContactInfo(this.contactInfosApiHelper.toAddressContactInfo((IContactInfo)userAddressDTO.getContactInfo()));
        return addressView;
    }

    public AddressView toAddressView(UserAddressVO userAddressVO) {
        if (userAddressVO == null) {
            return null;
        }
        AddressView addressView = this.toAddressView((GeoLocatedAddressVO)userAddressVO);
        addressView.setHidden(userAddressVO.isHidden());
        return addressView;
    }

    public Country toCountry(CountryVO countryVO) {
        if (countryVO == null) {
            return null;
        }
        Country country = new Country();
        country.setCode(countryVO.getCode());
        country.setName(countryVO.getName());
        return country;
    }

    public AddressDataForEdit toDataForEdit(UserAddressData userAddressData) {
        if (userAddressData == null) {
            return null;
        }
        AddressDataForEdit addressDataForEdit = this.newAddressBasicData(AddressDataForEdit.class, userAddressData);
        addressDataForEdit.setCanEdit(userAddressData.isEditable() && !userAddressData.isCanOnlySetPrivate());
        addressDataForEdit.setCanRemove(userAddressData.isRemovable());
        addressDataForEdit.setAddress(this.toAddressEdit((UserAddressDTO)userAddressData.getDto()));
        return addressDataForEdit;
    }

    public AddressDataForNew toDataForNew(UserAddressData userAddressData) {
        if (userAddressData == null) {
            return null;
        }
        AddressDataForNew addressDataForNew = this.newAddressBasicData(AddressDataForNew.class, userAddressData);
        addressDataForNew.setAddress(this.toAddressNew((UserAddressDTO)userAddressData.getDto()));
        return addressDataForNew;
    }

    public DistanceDTO toDistanceDTO(Number number, Number number2, Number number3) {
        if (number != null && number2 != null && number3 != null) {
            DistanceDTO distanceDTO = new DistanceDTO();
            distanceDTO.setLocation(ModelHelper.latLong((double)number.doubleValue(), (double)number2.doubleValue()));
            distanceDTO.setDistance(new BigDecimal(number3.doubleValue()));
            return distanceDTO;
        }
        return null;
    }

    public GeographicalCoordinate toGeographicalCoordinate(LatLongDTO latLongDTO) {
        if (latLongDTO == null) {
            return null;
        }
        GeographicalCoordinate geographicalCoordinate = new GeographicalCoordinate();
        geographicalCoordinate.setLatitude(latLongDTO.getLatitude() == null ? null : Double.valueOf(latLongDTO.getLatitude().doubleValue()));
        geographicalCoordinate.setLongitude(latLongDTO.getLongitude() == null ? null : Double.valueOf(latLongDTO.getLongitude().doubleValue()));
        return geographicalCoordinate;
    }

    public org.cyclos.web.rest.model.SearchByDistanceData toSearchByDistanceData(SearchByDistanceData searchByDistanceData) {
        if (searchByDistanceData == null) {
            return null;
        }
        org.cyclos.web.rest.model.SearchByDistanceData searchByDistanceData2 = new org.cyclos.web.rest.model.SearchByDistanceData();
        CollectionHelper.orEmpty((List)searchByDistanceData.getAddresses()).stream().map(this::toAddress).forEach(searchByDistanceData2.getAddresses()::add);
        searchByDistanceData2.setDistanceUnit(this.uiApiHelper.toDistanceUnitEnum(searchByDistanceData.getDistanceUnit()));
        this.setDefaultValues(searchByDistanceData2.getDefaultValues(), searchByDistanceData.getCountry(), searchByDistanceData.getDefaultRegion(), searchByDistanceData.getDefaultCity());
        return searchByDistanceData2;
    }

    public SimpleAddress toSimpleAddress(IAddress iAddress) {
        if (iAddress == null) {
            return null;
        }
        SimpleAddress simpleAddress = new SimpleAddress();
        this.fill(simpleAddress, iAddress);
        return simpleAddress;
    }

    public UserAddressesListData toUserAddressesListData(UserAddressListData userAddressListData) {
        UserAddressesListData userAddressesListData = new UserAddressesListData();
        userAddressesListData.setUser(this.usersApiHelper.toUser((BasicUserVO)userAddressListData.getUser()));
        userAddressesListData.setCanEdit(userAddressListData.isManagesAddresses());
        userAddressesListData.setCanCreate(userAddressListData.isCanCreateAddress());
        userAddressesListData.setEnablePrivacy(userAddressListData.isEnablePrivacy());
        userAddressesListData.setMaxAddresses(userAddressListData.getMaxAddresses());
        CollectionHelper.orEmpty((List)userAddressListData.getAddresses()).stream().map(this::toAddressResult).forEach(userAddressesListData.getAddresses()::add);
        userAddressesListData.setAvailability(this.apiHelper.toAvailability(userAddressListData.getMaxAddresses() == null || userAddressListData.getMaxAddresses() != 0, userAddressListData.isAddressRequired()));
        return userAddressesListData;
    }

    public UserAddressResult toUserAddressResult(UserAddressResultEnum userAddressResultEnum) {
        if (userAddressResultEnum != null) {
            switch (userAddressResultEnum) {
                case NONE: {
                    return UserAddressResult.NO_ADDRESSES;
                }
                case ALL: {
                    return UserAddressResult.ALL_LOCATED_ADDRESSES;
                }
                case NEAREST: {
                    return UserAddressResult.NEAREST_ADDRESS;
                }
                case PRIMARY: {
                    return UserAddressResult.DEFAULT_ADDRESS;
                }
            }
        }
        return null;
    }

    public UserAddressResultEnum toUserAddressResultEnum(UserAddressResult userAddressResult) {
        if (userAddressResult != null) {
            switch (userAddressResult) {
                case NO_ADDRESSES: {
                    return UserAddressResultEnum.NONE;
                }
                case ALL_LOCATED_ADDRESSES: {
                    return UserAddressResultEnum.ALL;
                }
                case NEAREST_ADDRESS: {
                    return UserAddressResultEnum.NEAREST;
                }
                case DEFAULT_ADDRESS: {
                    return UserAddressResultEnum.PRIMARY;
                }
            }
        }
        return null;
    }

    public UserAddressVO toUserAddressVO(String string) {
        if (string == null) {
            return null;
        }
        UserAddressVO userAddressVO = (UserAddressVO)ModelHelper.voFromString(UserAddressVO.class, (String)string);
        return userAddressVO;
    }

    private void fill(org.cyclos.web.rest.model.IAddress iAddress, IAddress iAddress2) {
        iAddress.setAddressLine1(iAddress2.getAddressLine1());
        iAddress.setAddressLine2(iAddress2.getAddressLine2());
        iAddress.setBuildingNumber(iAddress2.getBuildingNumber());
        iAddress.setCity(iAddress2.getCity());
        iAddress.setComplement(iAddress2.getComplement());
        iAddress.setCountry(iAddress2.getCountry());
        iAddress.setNeighborhood(iAddress2.getNeighborhood());
        iAddress.setPoBox(iAddress2.getPoBox());
        iAddress.setRegion(iAddress2.getRegion());
        iAddress.setStreet(iAddress2.getStreet());
        iAddress.setZip(iAddress2.getZip());
    }

    private void fillAddressFields(List<AddressFieldEnum> list, List<AddressFields> list2) {
        CollectionHelper.orEmpty(list2).stream().map(this::toAddressFieldEnum).forEach(list::add);
    }

    private <A extends Address> A newAddress(Class<A> clazz, GeoLocatedAddressVO geoLocatedAddressVO) {
        Address address = (Address)this.apiHelper.newEntity(clazz, geoLocatedAddressVO);
        address.setName(geoLocatedAddressVO.getName());
        address.setLocation(this.toGeographicalCoordinate(geoLocatedAddressVO.getLocation()));
        this.fill(address, (IAddress)geoLocatedAddressVO);
        if (geoLocatedAddressVO instanceof UserAddressVO) {
            UserAddressVO userAddressVO = (UserAddressVO)geoLocatedAddressVO;
            address.setContactInfo(this.contactInfosApiHelper.toAddressContactInfo((IContactInfo)userAddressVO.getContactInfo()));
        }
        return (A)address;
    }

    private <D extends AddressBasicData> D newAddressBasicData(Class<D> clazz, UserAddressData userAddressData) {
        AddressBasicData addressBasicData = (AddressBasicData)this.newAddressConfiguration(clazz, userAddressData.getConfiguration());
        addressBasicData.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput(userAddressData.getConfirmationPasswordInput()));
        addressBasicData.setManagePrivacy(userAddressData.isCanManagePrivacy());
        addressBasicData.setEnablePrivacy(userAddressData.isEnablePrivacy());
        addressBasicData.setUser(this.usersApiHelper.toUser((BasicUserVO)((UserAddressDTO)userAddressData.getDto()).getUser()));
        addressBasicData.setContactInfoEnabled(userAddressData.isContactInfoEnabled());
        CollectionHelper.orEmpty((List)userAddressData.getContactInfoFields()).stream().map(this.apiHelper::toCustomFieldDetailed).forEach(addressBasicData.getContactInfoFields()::add);
        addressBasicData.setPhoneConfiguration(this.phonesApiHelper.toPhoneConfiguration(userAddressData.getPhoneConfiguration()));
        return (D)addressBasicData;
    }

    private <E extends AddressEdit> E newAddressEdit(Class<E> clazz, UserAddressDTO userAddressDTO) {
        AddressEdit addressEdit = (AddressEdit)this.newAddressManage(clazz, userAddressDTO);
        addressEdit.setVersion(userAddressDTO.getVersion());
        return (E)addressEdit;
    }

    private <A extends AddressManage> A newAddressManage(Class<A> clazz, UserAddressDTO userAddressDTO) {
        AddressManage addressManage = (AddressManage)ClassHelper.instantiate(clazz);
        addressManage.setName(userAddressDTO.getName());
        addressManage.setLocation(this.toGeographicalCoordinate(userAddressDTO.getLocation()));
        addressManage.setDefaultAddress(userAddressDTO.isDefaultAddress());
        addressManage.setHidden(userAddressDTO.isHidden());
        addressManage.setContactInfo(this.contactInfosApiHelper.toAddressContactInfoManage(userAddressDTO.getContactInfo()));
        this.fill(addressManage, (IAddress)userAddressDTO);
        return (A)addressManage;
    }

    private void setDefaultValues(Map<String, String> map, String string, String string2, String string3) {
        if (StringHelper.isNotBlank((Object)string)) {
            map.put(AddressFields.COUNTRY.internalName(), string);
        }
        if (StringHelper.isNotBlank((Object)string2)) {
            map.put(AddressFields.REGION.internalName(), string2);
        }
        if (StringHelper.isNotBlank((Object)string3)) {
            map.put(AddressFields.CITY.internalName(), string3);
        }
    }

    private <A extends AddressResult> A toAddressResult(Class<A> clazz, GeoLocatedAddressVO geoLocatedAddressVO) {
        AddressResult addressResult = (AddressResult)this.apiHelper.newEntity(clazz, geoLocatedAddressVO);
        addressResult.setName(geoLocatedAddressVO.getName());
        addressResult.setLocation(this.toGeographicalCoordinate(geoLocatedAddressVO.getLocation()));
        if (geoLocatedAddressVO instanceof UserAddressVO) {
            UserAddressVO userAddressVO = (UserAddressVO)geoLocatedAddressVO;
            addressResult.setDefaultAddress(userAddressVO.isDefaultAddress());
            addressResult.setHidden(userAddressVO.isHidden());
            addressResult.setContactInfo(this.contactInfosApiHelper.toAddressContactInfo((IContactInfo)((UserAddressVO)geoLocatedAddressVO).getContactInfo()));
        }
        this.fill(addressResult, (IAddress)geoLocatedAddressVO);
        return (A)addressResult;
    }
}

