/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.model.EntityVO;
import org.cyclos.model.marketplace.categories.AdCategoryVO;
import org.cyclos.model.marketplace.interests.AdInterestDTO;
import org.cyclos.model.marketplace.interests.AdInterestData;
import org.cyclos.model.marketplace.interests.AdInterestVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.CurrencyAmountRangeDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.MarketplaceApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.AdInterest;
import org.cyclos.web.rest.model.AdInterestBasicData;
import org.cyclos.web.rest.model.AdInterestDataForEdit;
import org.cyclos.web.rest.model.AdInterestDataForNew;
import org.cyclos.web.rest.model.AdInterestEdit;
import org.cyclos.web.rest.model.AdInterestManage;
import org.cyclos.web.rest.model.AdInterestNew;
import org.cyclos.web.rest.model.AdInterestView;
import org.cyclos.web.rest.model.UserAdInterestsListData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AdInterestsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    private MarketplaceApiHelper marketplaceApiHelper;

    public AdInterest toAdInterest(AdInterestVO adInterestVO) {
        if (adInterestVO == null) {
            return null;
        }
        AdInterest adInterest = this.apiHelper.newEntity(AdInterest.class, adInterestVO);
        AdCategoryVO adCategoryVO = adInterestVO.getCategory();
        if (adCategoryVO != null) {
            adInterest.setCategory(this.marketplaceApiHelper.toAdCategoryWithParent(adCategoryVO));
        }
        CollectionHelper.orEmpty((Set)adInterestVO.getKeywords()).stream().sorted().forEach(adInterest.getKeywords()::add);
        adInterest.setAdUser(this.usersApiHelper.toUser((BasicUserVO)adInterestVO.getUser()));
        return adInterest;
    }

    public AdInterestDataForEdit toAdInterestDataForEdit(AdInterestData adInterestData) {
        if (adInterestData == null) {
            return null;
        }
        AdInterestDataForEdit adInterestDataForEdit = this.newAdInterestBasicData(AdInterestDataForEdit.class, adInterestData);
        adInterestDataForEdit.setCanEdit(adInterestData.isEditable());
        adInterestDataForEdit.setCanRemove(adInterestData.isRemovable());
        adInterestDataForEdit.setAdInterest(this.toAdInterestEdit((AdInterestDTO)adInterestData.getDto()));
        return adInterestDataForEdit;
    }

    public AdInterestDataForNew toAdInterestDataForNew(AdInterestData adInterestData) {
        if (adInterestData == null) {
            return null;
        }
        AdInterestDataForNew adInterestDataForNew = this.newAdInterestBasicData(AdInterestDataForNew.class, adInterestData);
        adInterestDataForNew.setAdInterest(this.toAdInterestNew((AdInterestDTO)adInterestData.getDto()));
        return adInterestDataForNew;
    }

    public AdInterestDTO toAdInterestDTO(AdInterestManage adInterestManage) {
        AdInterestDTO adInterestDTO = new AdInterestDTO();
        adInterestDTO.setName(adInterestManage.getName());
        adInterestDTO.setAdType(this.marketplaceApiHelper.toAdType(adInterestManage.getKind()));
        adInterestDTO.setCategory((AdCategoryVO)ModelHelper.voFromString(AdCategoryVO.class, (String)adInterestManage.getCategory()));
        adInterestDTO.setKeywords(CollectionHelper.orEmpty(adInterestManage.getKeywords()).stream().collect(Collectors.toSet()));
        adInterestDTO.setPriceRange(this.apiHelper.toCurrencyAmountRangeDTO(adInterestManage.getCurrency(), adInterestManage.getMinPrice(), adInterestManage.getMaxPrice()));
        adInterestDTO.setPriceRange(this.apiHelper.toCurrencyAmountRangeDTO(adInterestManage.getCurrency(), adInterestManage.getMinPrice(), adInterestManage.getMaxPrice()));
        adInterestDTO.setUser((UserVO)ModelHelper.voFromString(UserVO.class, (String)adInterestManage.getUser()));
        if (adInterestManage instanceof AdInterestEdit) {
            adInterestDTO.setVersion(((AdInterestEdit)adInterestManage).getVersion());
        }
        return adInterestDTO;
    }

    public AdInterestEdit toAdInterestEdit(AdInterestDTO adInterestDTO) {
        if (adInterestDTO == null) {
            return null;
        }
        AdInterestEdit adInterestEdit = this.newAdInterestManage(AdInterestEdit.class, adInterestDTO);
        adInterestEdit.setVersion(adInterestDTO.getVersion());
        return adInterestEdit;
    }

    public AdInterestNew toAdInterestNew(AdInterestDTO adInterestDTO) {
        if (adInterestDTO == null) {
            return null;
        }
        return this.newAdInterestManage(AdInterestNew.class, adInterestDTO);
    }

    public AdInterestView toAdInterestView(AdInterestData adInterestData) {
        AdInterestDTO adInterestDTO = (AdInterestDTO)adInterestData.getDto();
        AdInterestView adInterestView = new AdInterestView();
        adInterestView.setCanEdit(adInterestData.isEditable());
        adInterestView.setCanRemove(adInterestData.isRemovable());
        adInterestView.setId(ApiHelper.toId(adInterestDTO.getId()));
        adInterestView.setName(adInterestDTO.getName());
        adInterestView.setKind(this.marketplaceApiHelper.toAdKind(adInterestDTO.getAdType()));
        AdCategoryVO adCategoryVO = adInterestDTO.getCategory();
        if (adCategoryVO != null) {
            CollectionHelper.orEmpty((List)adInterestData.getCategories()).stream().filter(adCategoryDetailedVO -> adCategoryDetailedVO.getId().equals(adCategoryVO.getId())).findFirst().ifPresent(adCategoryDetailedVO -> adInterestView.setCategory(this.marketplaceApiHelper.toAdCategoryWithParent((AdCategoryVO)adCategoryDetailedVO)));
        }
        CollectionHelper.orEmpty((Set)adInterestDTO.getKeywords()).stream().sorted().forEach(adInterestView.getKeywords()::add);
        CurrencyAmountRangeDTO currencyAmountRangeDTO = adInterestDTO.getPriceRange();
        if (currencyAmountRangeDTO != null) {
            adInterestView.setCurrency(this.accountsApiHelper.toCurrency(currencyAmountRangeDTO.getCurrency()));
            adInterestView.setMinPrice(currencyAmountRangeDTO.getMin());
            adInterestView.setMaxPrice(currencyAmountRangeDTO.getMax());
        }
        adInterestView.setUser(this.usersApiHelper.toUser((BasicUserVO)adInterestDTO.getOwner()));
        adInterestView.setAdUser(this.usersApiHelper.toUser((BasicUserVO)adInterestDTO.getUser()));
        return adInterestView;
    }

    public UserAdInterestsListData toUserAdInterestsListData(org.cyclos.model.marketplace.interests.UserAdInterestsListData userAdInterestsListData) {
        UserAdInterestsListData userAdInterestsListData2 = new UserAdInterestsListData();
        userAdInterestsListData2.setUser(this.usersApiHelper.toUser((BasicUserVO)userAdInterestsListData.getUser()));
        userAdInterestsListData2.setCanCreate(userAdInterestsListData.isManage());
        userAdInterestsListData2.setCanEdit(userAdInterestsListData.isManage());
        CollectionHelper.orEmpty((List)userAdInterestsListData.getAdInterests()).stream().map(this::toAdInterest).forEach(userAdInterestsListData2.getAdInterests()::add);
        return userAdInterestsListData2;
    }

    private <D extends AdInterestBasicData> D newAdInterestBasicData(Class<D> clazz, AdInterestData adInterestData) {
        AdInterestBasicData adInterestBasicData = (AdInterestBasicData)ClassHelper.instantiate(clazz);
        adInterestBasicData.setUser(this.usersApiHelper.toUser((BasicUserVO)((AdInterestDTO)adInterestData.getDto()).getOwner()));
        CollectionHelper.orEmpty((List)adInterestData.getCurrencies()).stream().map(this.accountsApiHelper::toCurrency).forEach(adInterestBasicData.getCurrencies()::add);
        adInterestBasicData.setCategories(this.marketplaceApiHelper.toAdCategoryList(adInterestData.getCategories()));
        return (D)adInterestBasicData;
    }

    private <A extends AdInterestManage> A newAdInterestManage(Class<A> clazz, AdInterestDTO adInterestDTO) {
        AdInterestManage adInterestManage = (AdInterestManage)ClassHelper.instantiate(clazz);
        adInterestManage.setName(adInterestDTO.getName());
        adInterestManage.setKind(this.marketplaceApiHelper.toAdKind(adInterestDTO.getAdType()));
        adInterestManage.setCategory(ModelHelper.stringOrIdFromVO((EntityVO)adInterestDTO.getCategory()));
        adInterestManage.setKeywords(CollectionHelper.orEmpty((Set)adInterestDTO.getKeywords()).stream().sorted().collect(Collectors.toList()));
        adInterestManage.setUser(ModelHelper.stringOrIdFromVO((EntityVO)adInterestDTO.getUser()));
        CurrencyAmountRangeDTO currencyAmountRangeDTO = adInterestDTO.getPriceRange();
        if (currencyAmountRangeDTO != null) {
            adInterestManage.setCurrency(ModelHelper.stringOrIdFromVO((EntityVO)currencyAmountRangeDTO.getCurrency()));
            adInterestManage.setMinPrice(currencyAmountRangeDTO.getMin());
            adInterestManage.setMaxPrice(currencyAmountRangeDTO.getMax());
        }
        return (A)adInterestManage;
    }
}

