/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.model.EntityModel;
import org.cyclos.model.banking.accounts.UserAccountVisibilityData;
import org.cyclos.model.banking.accounts.UserAccountVisibilitySettingsData;
import org.cyclos.model.banking.accounttypes.UserAccountTypeVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.DataForUserAccountVisibility;
import org.cyclos.web.rest.model.SaveUserAccountVisibilityAsVisibleParams;
import org.cyclos.web.rest.model.UserAccountVisibility;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccountVisibilityApiHelper {
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;

    public Set<UserAccountTypeVO> toAccountTypes(SaveUserAccountVisibilityAsVisibleParams saveUserAccountVisibilityAsVisibleParams) {
        return CollectionHelper.orEmpty(saveUserAccountVisibilityAsVisibleParams == null ? null : saveUserAccountVisibilityAsVisibleParams.getAccounts()).stream().map(string -> (UserAccountTypeVO)ModelHelper.voFromString(UserAccountTypeVO.class, (String)string)).collect(Collectors.toSet());
    }

    public DataForUserAccountVisibility toDataForUserAccountVisibility(UserAccountVisibilitySettingsData userAccountVisibilitySettingsData) {
        DataForUserAccountVisibility dataForUserAccountVisibility = new DataForUserAccountVisibility();
        dataForUserAccountVisibility.setUser(this.usersApiHelper.toUser(userAccountVisibilitySettingsData.getUser()));
        dataForUserAccountVisibility.setCanManage(userAccountVisibilitySettingsData.isEditable());
        CollectionHelper.orEmpty((List)userAccountVisibilitySettingsData.getAccounts()).stream().map(this::toUserAccountVisibility).forEach(dataForUserAccountVisibility.getAccounts()::add);
        return dataForUserAccountVisibility;
    }

    private UserAccountVisibility toUserAccountVisibility(UserAccountVisibilityData userAccountVisibilityData) {
        if (userAccountVisibilityData == null) {
            return null;
        }
        UserAccountVisibility userAccountVisibility = new UserAccountVisibility();
        userAccountVisibility.setType(this.apiHelper.toReference((EntityModel)userAccountVisibilityData.getAccountType()));
        userAccountVisibility.setNumber(userAccountVisibilityData.getAccountNumber());
        userAccountVisibility.setCurrency(this.accountsApiHelper.toCurrency(userAccountVisibilityData.getAccountType().getCurrency()));
        userAccountVisibility.setCanHide(userAccountVisibilityData.isCanHide());
        userAccountVisibility.setVisible(userAccountVisibilityData.isVisible());
        return userAccountVisibility;
    }
}

