/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.exceptions;

import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.vouchers.MaxVoucherBalanceException;
import org.cyclos.model.banking.vouchers.TopUpNotAllowedForVoucherException;
import org.cyclos.model.banking.vouchers.VoucherActivationExpiredException;
import org.cyclos.model.banking.vouchers.VoucherAlreadyActivatedException;
import org.cyclos.web.rest.exceptions.BaseErrorHandler;
import org.cyclos.web.rest.exceptions.PaymentErrorHandler;
import org.cyclos.web.rest.helpers.VouchersApiHelper;
import org.cyclos.web.rest.model.PaymentError;
import org.cyclos.web.rest.model.TopUpVoucherError;
import org.cyclos.web.rest.model.TopUpVoucherErrorCode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TopUpVoucherErrorHandler
extends BaseErrorHandler<TopUpVoucherError> {
    @Autowired
    private PaymentErrorHandler paymentErrorHandler;
    @Autowired
    private VouchersApiHelper vouchersApiHelper;

    public TopUpVoucherErrorHandler() {
        super(TopUpVoucherError.class);
    }

    @Override
    protected void fill(TopUpVoucherError topUpVoucherError, Throwable throwable) {
        TopUpVoucherErrorCode topUpVoucherErrorCode = TopUpVoucherErrorCode.UNEXPECTED;
        Class<?> clazz = throwable.getClass();
        if (clazz == VoucherActivationExpiredException.class) {
            topUpVoucherErrorCode = TopUpVoucherErrorCode.ACTIVATION_EXPIRED;
        } else if (clazz == VoucherAlreadyActivatedException.class) {
            topUpVoucherErrorCode = TopUpVoucherErrorCode.ALREADY_ACTIVATED;
        } else if (clazz == TopUpNotAllowedForVoucherException.class) {
            topUpVoucherErrorCode = TopUpVoucherErrorCode.NOT_ALLOWED_FOR_VOUCHER;
        } else if (clazz == MaxVoucherBalanceException.class) {
            topUpVoucherErrorCode = TopUpVoucherErrorCode.MAX_BALANCE_REACHED;
        } else if (TransferException.class.isAssignableFrom(clazz)) {
            topUpVoucherErrorCode = TopUpVoucherErrorCode.PAYMENT;
        }
        topUpVoucherError.setCode(topUpVoucherErrorCode);
        if (throwable instanceof VoucherActivationExpiredException) {
            VoucherActivationExpiredException voucherActivationExpiredException = (VoucherActivationExpiredException)throwable;
            topUpVoucherError.setActivationLimit(voucherActivationExpiredException.getLimit());
        } else if (throwable instanceof TopUpNotAllowedForVoucherException) {
            TopUpNotAllowedForVoucherException topUpNotAllowedForVoucherException = (TopUpNotAllowedForVoucherException)throwable;
            topUpVoucherError.setVoucherStatus(this.vouchersApiHelper.toVoucherStatusEnum(topUpNotAllowedForVoucherException.getVoucherStatus()));
        } else if (throwable instanceof TransferException) {
            topUpVoucherError.setPaymentError((PaymentError)this.paymentErrorHandler.getError(throwable));
        }
    }
}

