/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.exceptions;

import org.cyclos.model.banking.InsufficientBalanceException;
import org.cyclos.model.banking.MaxAmountExceededException;
import org.cyclos.model.banking.MaxAmountPerDayExceededException;
import org.cyclos.model.banking.MaxAmountPerMonthExceededException;
import org.cyclos.model.banking.MaxAmountPerWeekExceededException;
import org.cyclos.model.banking.MaxAmountPerYearExceededException;
import org.cyclos.model.banking.MaxPaymentAmountExceededException;
import org.cyclos.model.banking.MaxPaymentsExceededException;
import org.cyclos.model.banking.MaxPaymentsPerDayExceededException;
import org.cyclos.model.banking.MaxPaymentsPerMonthExceededException;
import org.cyclos.model.banking.MaxPaymentsPerWeekExceededException;
import org.cyclos.model.banking.MinTimeBetweenPaymentsException;
import org.cyclos.model.banking.PosPayerException;
import org.cyclos.model.banking.UpperCreditLimitReachedException;
import org.cyclos.web.rest.exceptions.BaseErrorHandler;
import org.cyclos.web.rest.exceptions.PosErrorHandler;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.model.PaymentError;
import org.cyclos.web.rest.model.PaymentErrorCode;
import org.cyclos.web.rest.model.PosError;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PaymentErrorHandler
extends BaseErrorHandler<PaymentError> {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    private PosErrorHandler posErrorHandler;

    public PaymentErrorHandler() {
        super(PaymentError.class);
    }

    @Override
    protected void fill(PaymentError paymentError, Throwable throwable) {
        PaymentErrorCode paymentErrorCode = PaymentErrorCode.UNEXPECTED;
        Class<?> clazz = throwable.getClass();
        if (clazz == InsufficientBalanceException.class) {
            paymentErrorCode = PaymentErrorCode.INSUFFICIENT_BALANCE;
            paymentError.setVoucher(((InsufficientBalanceException)throwable).isVoucher());
        } else if (clazz == MaxAmountPerDayExceededException.class) {
            paymentErrorCode = PaymentErrorCode.DAILY_AMOUNT_EXCEEDED;
        } else if (clazz == MaxAmountPerMonthExceededException.class) {
            paymentErrorCode = PaymentErrorCode.MONTHLY_AMOUNT_EXCEEDED;
        } else if (clazz == MaxAmountPerYearExceededException.class) {
            paymentErrorCode = PaymentErrorCode.YEARLY_AMOUNT_EXCEEDED;
        } else if (clazz == MaxAmountPerWeekExceededException.class) {
            paymentErrorCode = PaymentErrorCode.WEEKLY_AMOUNT_EXCEEDED;
        } else if (clazz == MaxPaymentAmountExceededException.class) {
            paymentErrorCode = PaymentErrorCode.PAYMENT_AMOUNT_EXCEEDED;
        } else if (clazz == MaxPaymentsPerDayExceededException.class) {
            paymentErrorCode = PaymentErrorCode.DAILY_PAYMENTS_EXCEEDED;
        } else if (clazz == MaxPaymentsPerMonthExceededException.class) {
            paymentErrorCode = PaymentErrorCode.MONTHLY_PAYMENTS_EXCEEDED;
        } else if (clazz == MaxPaymentsPerWeekExceededException.class) {
            paymentErrorCode = PaymentErrorCode.WEEKLY_PAYMENTS_EXCEEDED;
        } else if (clazz == MinTimeBetweenPaymentsException.class) {
            paymentErrorCode = PaymentErrorCode.TIME_BETWEEN_PAYMENTS_NOT_MET;
        } else if (clazz == UpperCreditLimitReachedException.class) {
            paymentErrorCode = PaymentErrorCode.DESTINATION_UPPER_LIMIT_REACHED;
        } else if (PosPayerException.class.isAssignableFrom(clazz)) {
            paymentErrorCode = PaymentErrorCode.POS;
            paymentError.setPosError((PosError)this.posErrorHandler.getError(throwable));
        }
        paymentError.setCode(paymentErrorCode);
        if (throwable instanceof MaxAmountExceededException) {
            MaxAmountExceededException maxAmountExceededException = (MaxAmountExceededException)throwable;
            paymentError.setMaxAmount(this.apiHelper.getAmount(maxAmountExceededException.getMaxAmount()));
            paymentError.setCurrency(this.accountsApiHelper.toCurrency(maxAmountExceededException.getMaxAmount()));
        } else if (throwable instanceof MaxPaymentsExceededException) {
            paymentError.setMaxPayments(((MaxPaymentsExceededException)throwable).getMaxPayments());
        }
    }
}

