/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.exceptions;

import org.cyclos.model.access.TokenAlreadyInUseException;
import org.cyclos.web.rest.exceptions.BaseErrorHandler;
import org.cyclos.web.rest.helpers.TokensApiHelper;
import org.cyclos.web.rest.model.InitializeNfcError;
import org.cyclos.web.rest.model.InitializeNfcErrorCode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InitializeNfcErrorHandler
extends BaseErrorHandler<InitializeNfcError> {
    @Autowired
    private TokensApiHelper tokensApiHelper;

    public InitializeNfcErrorHandler() {
        super(InitializeNfcError.class);
    }

    @Override
    protected void fill(InitializeNfcError initializeNfcError, Throwable throwable) {
        if (throwable instanceof TokenAlreadyInUseException) {
            initializeNfcError.setCode(InitializeNfcErrorCode.TOKEN_IN_USE);
            initializeNfcError.setToken(this.tokensApiHelper.toTokenDetailed(((TokenAlreadyInUseException)throwable).getToken()));
        } else {
            initializeNfcError.setCode(InitializeNfcErrorCode.UNEXPECTED);
        }
    }
}

