/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.exceptions;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.model.ConstraintViolatedOnRemoveException;
import org.cyclos.model.CredentialsNotSuppliedException;
import org.cyclos.model.CyclosException;
import org.cyclos.model.DataAccessException;
import org.cyclos.model.EntityModel;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.MaxItemsException;
import org.cyclos.model.QueryParseException;
import org.cyclos.model.StaleEntityException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.DeviceActivationException;
import org.cyclos.model.access.InaccessibleChannelException;
import org.cyclos.model.access.InaccessibleGroupException;
import org.cyclos.model.access.InaccessiblePrincipalException;
import org.cyclos.model.access.InvalidAccessClientException;
import org.cyclos.model.access.InvalidAccessTokenException;
import org.cyclos.model.access.InvalidChannelUsageException;
import org.cyclos.model.access.InvalidDeviceConfirmationException;
import org.cyclos.model.access.InvalidNetworkException;
import org.cyclos.model.access.InvalidPasswordException;
import org.cyclos.model.access.InvalidPinRemovedException;
import org.cyclos.model.access.InvalidTotpException;
import org.cyclos.model.access.LoggedOutException;
import org.cyclos.model.access.LoginException;
import org.cyclos.model.access.OperatorWithPendingAgreementsException;
import org.cyclos.model.access.OtpInvalidatedException;
import org.cyclos.model.access.PasswordException;
import org.cyclos.model.access.PasswordStatusException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.RemoteAddressBlockedException;
import org.cyclos.model.access.UnauthorizedAddressException;
import org.cyclos.model.access.UnauthorizedURLException;
import org.cyclos.model.access.clients.AccessClientStatus;
import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.access.passwords.PasswordStatus;
import org.cyclos.model.messaging.EmailSendingException;
import org.cyclos.model.messaging.sms.OutboundSmsStatus;
import org.cyclos.model.messaging.sms.SmsSendingException;
import org.cyclos.server.model.AggregatedFrameworkExceptions;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.ValidationResult;
import org.cyclos.utils.coercion.CoercionException;
import org.cyclos.web.rest.exceptions.HttpStatusMappedErrorHolder;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.DeviceConfirmationsApiHelper;
import org.cyclos.web.rest.helpers.PasswordsApiHelper;
import org.cyclos.web.rest.helpers.UserStatusApiHelper;
import org.cyclos.web.rest.model.BadRequestError;
import org.cyclos.web.rest.model.BadRequestErrorCode;
import org.cyclos.web.rest.model.ConflictError;
import org.cyclos.web.rest.model.ConflictErrorCode;
import org.cyclos.web.rest.model.CredentialTypeEnum;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.ErrorKind;
import org.cyclos.web.rest.model.ForbiddenError;
import org.cyclos.web.rest.model.ForbiddenErrorCode;
import org.cyclos.web.rest.model.InputError;
import org.cyclos.web.rest.model.InputErrorCode;
import org.cyclos.web.rest.model.NotFoundError;
import org.cyclos.web.rest.model.OutboundSmsStatusEnum;
import org.cyclos.web.rest.model.UnauthorizedError;
import org.cyclos.web.rest.model.UnauthorizedErrorCode;
import org.cyclos.web.rest.model.UnavailableError;
import org.cyclos.web.rest.model.UnavailableErrorCode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.NoHandlerFoundException;

@Component
public class ExceptionHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UserStatusApiHelper userStatusApiHelper;
    @Autowired
    private DeviceConfirmationsApiHelper deviceConfirmationsApiHelper;
    @Autowired
    private PasswordsApiHelper passwordsApiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;

    public BadRequestError badRequest(HttpServletRequest httpServletRequest, HttpMessageNotReadableException httpMessageNotReadableException) {
        BadRequestError badRequestError = new BadRequestError();
        badRequestError.setCode(BadRequestErrorCode.GENERAL);
        badRequestError.setMessage(httpMessageNotReadableException.getMessage());
        return badRequestError;
    }

    public BadRequestError badRequest(JsonParseException jsonParseException) {
        BadRequestError badRequestError = new BadRequestError();
        badRequestError.setCode(BadRequestErrorCode.JSON);
        JsonLocation jsonLocation = jsonParseException.getLocation();
        badRequestError.setMessage(jsonParseException.getOriginalMessage());
        if (jsonLocation != null) {
            badRequestError.setLine(jsonLocation.getLineNr());
            badRequestError.setColumn(jsonLocation.getColumnNr());
        }
        return badRequestError;
    }

    public ConflictError toConflictError(ConstraintViolatedOnRemoveException constraintViolatedOnRemoveException) {
        ConflictError conflictError = new ConflictError();
        conflictError.setCode(ConflictErrorCode.CONSTRAINT_VIOLATED_ON_REMOVE);
        return conflictError;
    }

    public ConflictError toConflictError(Exception exception) {
        if (exception instanceof ConstraintViolatedOnRemoveException) {
            return this.toConflictError((ConstraintViolatedOnRemoveException)exception);
        }
        if (exception instanceof StaleEntityException) {
            return this.toConflictError((StaleEntityException)exception);
        }
        return null;
    }

    public ConflictError toConflictError(StaleEntityException staleEntityException) {
        ConflictError conflictError = new ConflictError();
        conflictError.setCode(ConflictErrorCode.STALE_ENTITY);
        return conflictError;
    }

    public <E extends Error> E toError(Class<E> clazz, Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (throwable instanceof DataAccessException) {
            throwable = (Throwable)ClassHelper.convert((Object)throwable, throwable.getClass());
        }
        Error error = (Error)ClassHelper.instantiate(clazz);
        ErrorKind errorKind = ErrorKind.GENERAL;
        if (Error.class != clazz) {
            String string = StringHelper.transformCase((String)clazz.getSimpleName().replace("Error", ""), (boolean)true, (char)'_');
            errorKind = ErrorKind.valueOf(string);
        }
        error.setKind(errorKind);
        error.setExceptionType(throwable.getClass().getName());
        error.setExceptionMessage(throwable.getMessage());
        return (E)error;
    }

    public ForbiddenError toForbiddenError(Exception exception) {
        if (exception instanceof PermissionDeniedException) {
            return this.toForbiddenError((PermissionDeniedException)exception);
        }
        return null;
    }

    public ForbiddenError toForbiddenError(PermissionDeniedException permissionDeniedException) {
        ForbiddenError forbiddenError = new ForbiddenError();
        if (permissionDeniedException.isHasExpiredPassword()) {
            forbiddenError.setCode(ForbiddenErrorCode.EXPIRED_PASSWORD);
        } else if (permissionDeniedException.getLoginConfirmation() != null) {
            forbiddenError.setCode(ForbiddenErrorCode.LOGIN_CONFIRMATION);
            forbiddenError.setLoginConfirmation(this.authApiHelper.toPasswordInput((ICredentialInputDTO)permissionDeniedException.getLoginConfirmation()));
        } else if (permissionDeniedException.isHasPendingAgreements()) {
            forbiddenError.setCode(ForbiddenErrorCode.PENDING_AGREEMENTS);
        } else {
            forbiddenError.setCode(ForbiddenErrorCode.PERMISSION_DENIED);
        }
        return forbiddenError;
    }

    public HttpStatusMappedErrorHolder toHttpStatusMappedErrorHolder(CyclosException cyclosException) {
        Enum enum_ = this.getForbiddenErrorCode(cyclosException);
        if (enum_ != null) {
            ForbiddenError forbiddenError = new ForbiddenError();
            forbiddenError.setCode((ForbiddenErrorCode)enum_);
            if (cyclosException instanceof PasswordException) {
                PasswordException passwordException = (PasswordException)cyclosException;
                forbiddenError.setPasswordType(this.apiHelper.toReference((EntityModel)passwordException.getPasswordType()));
            } else if (enum_ == ForbiddenErrorCode.INVALID_DEVICE_CONFIRMATION) {
                InvalidDeviceConfirmationException invalidDeviceConfirmationException = (InvalidDeviceConfirmationException)cyclosException;
                forbiddenError.setInvalidDeviceConfirmation(this.deviceConfirmationsApiHelper.toInvalidDeviceConfirmationEnum(invalidDeviceConfirmationException.getResult()));
            } else if (enum_ == ForbiddenErrorCode.INVALID_DEVICE_ACTIVATION_CODE) {
                forbiddenError.setMaxDeviceActivationReached(((DeviceActivationException)cyclosException).isMaxReached());
            }
            return new HttpStatusMappedErrorHolder(HttpStatus.FORBIDDEN, forbiddenError);
        }
        enum_ = this.getUnauthorizedErrorCode(cyclosException);
        if (enum_ != null) {
            UnauthorizedError unauthorizedError = new UnauthorizedError();
            unauthorizedError.setCode((UnauthorizedErrorCode)enum_);
            return new HttpStatusMappedErrorHolder(HttpStatus.UNAUTHORIZED, unauthorizedError);
        }
        return HttpStatusMappedErrorHolder.EMPTY;
    }

    public InputError toInputError(AggregatedFrameworkExceptions aggregatedFrameworkExceptions) {
        HashMap<String, InputError> hashMap = new HashMap<String, InputError>();
        CollectionHelper.orEmpty((Map)aggregatedFrameworkExceptions.getExceptions()).forEach((string, frameworkException) -> hashMap.put((String)string, this.toInputError((Exception)frameworkException)));
        HashMap<String, List<InputError>> hashMap2 = new HashMap<String, List<InputError>>();
        CollectionHelper.orEmpty((Map)aggregatedFrameworkExceptions.getIndexedExceptions()).forEach((string, list) -> {
            if (CollectionHelper.isNotEmpty((Iterable)list)) {
                hashMap2.put((String)string, list.stream().map(this::toInputError).collect(Collectors.toList()));
            }
        });
        InputError inputError = this.emptyInputError();
        inputError.setCode(InputErrorCode.AGGREGATED);
        inputError.setErrors(hashMap);
        inputError.setIndexedErrors(hashMap2);
        return inputError;
    }

    public InputError toInputError(CoercionException coercionException) {
        InputError inputError = this.emptyInputError();
        inputError.setCode(InputErrorCode.DATA_CONVERSION);
        inputError.setValue(coercionException.getValue());
        return inputError;
    }

    public InputError toInputError(ConversionFailedException conversionFailedException) {
        InputError inputError = this.emptyInputError();
        inputError.setCode(InputErrorCode.DATA_CONVERSION);
        inputError.setValue(StringHelper.trimToNull((Object)conversionFailedException.getValue()));
        return inputError;
    }

    public InputError toInputError(Exception exception) {
        return this.toInputError(exception, false);
    }

    public InputError toInputError(Exception exception, boolean bl) {
        if (exception == null) {
            return null;
        }
        if (exception instanceof CoercionException) {
            return this.toInputError((CoercionException)exception);
        }
        if (exception instanceof AggregatedFrameworkExceptions) {
            return this.toInputError((AggregatedFrameworkExceptions)exception);
        }
        if (exception instanceof ConversionFailedException) {
            return this.toInputError((ConversionFailedException)exception);
        }
        if (exception instanceof InvalidFormatException) {
            return this.toInputError((InvalidFormatException)exception);
        }
        if (exception instanceof MaxItemsException) {
            return this.toInputError((MaxItemsException)exception);
        }
        if (exception instanceof MethodArgumentTypeMismatchException) {
            return this.toInputError((MethodArgumentTypeMismatchException)exception);
        }
        if (exception instanceof QueryParseException) {
            return this.toInputError((QueryParseException)exception);
        }
        if (exception instanceof ValidationException) {
            return this.toInputError((ValidationException)exception);
        }
        if (exception instanceof EntityNotFoundException || !bl) {
            return this.toInputError(new ValidationException());
        }
        return null;
    }

    public InputError toInputError(InvalidFormatException invalidFormatException) {
        InputError inputError = this.emptyInputError();
        inputError.setCode(InputErrorCode.DATA_CONVERSION);
        inputError.setValue(StringHelper.trimToNull((Object)invalidFormatException.getValue()));
        return inputError;
    }

    public InputError toInputError(MaxItemsException maxItemsException) {
        InputError inputError = this.emptyInputError();
        inputError.setCode(InputErrorCode.MAX_ITEMS);
        inputError.setMaxItems(maxItemsException.getMaxItems());
        return inputError;
    }

    public InputError toInputError(MaxUploadSizeExceededException maxUploadSizeExceededException) {
        InputError inputError = this.emptyInputError();
        inputError.setCode(InputErrorCode.FILE_UPLOAD_SIZE);
        inputError.setMaxFileSize((int)maxUploadSizeExceededException.getMaxUploadSize());
        return inputError;
    }

    public InputError toInputError(MethodArgumentTypeMismatchException methodArgumentTypeMismatchException) {
        InputError inputError = this.emptyInputError();
        inputError.setCode(InputErrorCode.DATA_CONVERSION);
        inputError.setValue(StringHelper.trimToNull((Object)methodArgumentTypeMismatchException.getValue()));
        return inputError;
    }

    public InputError toInputError(QueryParseException queryParseException) {
        InputError inputError = this.emptyInputError();
        inputError.setCode(InputErrorCode.QUERY_PARSE);
        inputError.setValue(queryParseException.getValue());
        return inputError;
    }

    public InputError toInputError(ValidationException validationException) {
        InputError inputError = this.emptyInputError();
        inputError.setCode(InputErrorCode.VALIDATION);
        ValidationResult validationResult = validationException.getValidation();
        inputError.setGeneralErrors(validationResult == null ? Collections.emptyList() : validationResult.getGeneralErrors());
        inputError.setProperties(validationResult == null ? Collections.emptyList() : validationResult.getProperties());
        inputError.setPropertyErrors(validationResult == null ? Collections.emptyMap() : validationResult.getPropertyErrors());
        inputError.setCustomFields(validationResult == null ? Collections.emptyList() : validationResult.getCustomFields());
        inputError.setCustomFieldErrors(validationResult == null ? Collections.emptyMap() : validationResult.getCustomFieldErrors());
        return inputError;
    }

    public InputError toMissingRequiredParameterError(MissingServletRequestParameterException missingServletRequestParameterException) {
        return this.toMissingRequiredParameterError(missingServletRequestParameterException.getParameterName());
    }

    public InputError toMissingRequiredParameterError(String string) {
        InputError inputError = this.emptyInputError();
        inputError.setCode(InputErrorCode.MISSING_PARAMETER);
        inputError.setName(string);
        return inputError;
    }

    public NotFoundError toNotFoundError(EntityNotFoundException entityNotFoundException) {
        NotFoundError notFoundError = new NotFoundError();
        notFoundError.setEntityType(entityNotFoundException.getEntityType());
        if (entityNotFoundException.getId() != null) {
            notFoundError.setKey(entityNotFoundException.getId().toString());
        } else if (entityNotFoundException.getKey() != null) {
            notFoundError.setKey(entityNotFoundException.getKey());
        }
        return notFoundError;
    }

    public NotFoundError toNotFoundError(Exception exception) {
        if (exception instanceof EntityNotFoundException) {
            return this.toNotFoundError((EntityNotFoundException)exception);
        }
        if (exception instanceof NoHandlerFoundException) {
            return this.toNotFoundError((NoHandlerFoundException)exception);
        }
        return null;
    }

    public NotFoundError toNotFoundError(NoHandlerFoundException noHandlerFoundException) {
        NotFoundError notFoundError = new NotFoundError();
        notFoundError.setEntityType(noHandlerFoundException.getHttpMethod());
        notFoundError.setKey(noHandlerFoundException.getRequestURL());
        return notFoundError;
    }

    public OutboundSmsStatusEnum toOutboundSmsStatusEnum(OutboundSmsStatus outboundSmsStatus) {
        if (outboundSmsStatus != null) {
            switch (outboundSmsStatus) {
                case GATEWAY_UNREACHABLE: {
                    return OutboundSmsStatusEnum.GATEWAY_UREACHABLE;
                }
                case INVALID: {
                    return OutboundSmsStatusEnum.INVALID;
                }
                case MAX_GLOBAL_MESSAGES_REACHED: 
                case MAX_UNREGISTERED_MESSAGES_REACHED: 
                case MAX_USER_MESSAGES_REACHED: {
                    return OutboundSmsStatusEnum.MAX_MESSAGES_REACHED;
                }
                case REJECTED: {
                    return OutboundSmsStatusEnum.REJECTED;
                }
                case SUCCESS: {
                    return OutboundSmsStatusEnum.SUCCESS;
                }
                case TIMEOUT: {
                    return OutboundSmsStatusEnum.TIMEOUT;
                }
                case UNKNOWN_ERROR: {
                    return OutboundSmsStatusEnum.UNEXPECTED;
                }
            }
        }
        return null;
    }

    public UnauthorizedError toUnauthorizedError(CredentialsNotSuppliedException credentialsNotSuppliedException) {
        UnauthorizedError unauthorizedError = new UnauthorizedError();
        unauthorizedError.setCode(UnauthorizedErrorCode.MISSING_AUTHORIZATION);
        unauthorizedError.setMissingLoginConfirmationCredentials(null);
        return unauthorizedError;
    }

    public UnauthorizedError toUnauthorizedError(Exception exception) {
        if (exception instanceof LoginException) {
            return this.toUnauthorizedError((LoginException)exception);
        }
        if (exception instanceof InvalidAccessTokenException) {
            return this.toUnauthorizedError((InvalidAccessTokenException)exception);
        }
        if (exception instanceof CredentialsNotSuppliedException) {
            return this.toUnauthorizedError((CredentialsNotSuppliedException)exception);
        }
        return null;
    }

    public UnauthorizedError toUnauthorizedError(InvalidAccessTokenException invalidAccessTokenException) {
        UnauthorizedError unauthorizedError = new UnauthorizedError();
        unauthorizedError.setCode(UnauthorizedErrorCode.INVALID_ACCESS_TOKEN);
        unauthorizedError.setError("invalid_token");
        unauthorizedError.setMissingLoginConfirmationCredentials(null);
        return unauthorizedError;
    }

    public UnauthorizedError toUnauthorizedError(LoginException loginException) {
        UnauthorizedError unauthorizedError = new UnauthorizedError();
        unauthorizedError.setCode(UnauthorizedErrorCode.LOGIN);
        CollectionHelper.orEmpty((Set)loginException.getMissingLoginConfirmationCredentials()).stream().map(this.authApiHelper::toCredentialTypeEnum).forEach(unauthorizedError.getMissingLoginConfirmationCredentials()::add);
        unauthorizedError.setMissingLoginConfirmationPasswordType(this.passwordsApiHelper.toPasswordType(loginException.getMissingLoginConfirmationPasswordType()));
        unauthorizedError.setUserStatus(this.userStatusApiHelper.toUserStatusEnum(loginException.getUserStatus()));
        unauthorizedError.setPasswordStatus(this.passwordsApiHelper.toPasswordStatusEnum(loginException.getPasswordStatus()));
        if (loginException.getInvalidDeviceConfirmationResult() != null) {
            unauthorizedError.setInvalidDeviceConfirmation(this.deviceConfirmationsApiHelper.toInvalidDeviceConfirmationEnum(loginException.getInvalidDeviceConfirmationResult()));
        }
        unauthorizedError.setMissingSecondaryPassword(unauthorizedError.getMissingLoginConfirmationPasswordType());
        unauthorizedError.setSecondaryDeviceAllowed(unauthorizedError.getMissingLoginConfirmationCredentials().contains(CredentialTypeEnum.DEVICE));
        return unauthorizedError;
    }

    public UnauthorizedError toUnauthorizedError(PermissionDeniedException permissionDeniedException) {
        UnauthorizedError unauthorizedError = new UnauthorizedError();
        unauthorizedError.setCode(UnauthorizedErrorCode.MISSING_AUTHORIZATION);
        unauthorizedError.setMissingLoginConfirmationCredentials(null);
        return unauthorizedError;
    }

    public UnavailableError toUnavailableError(EmailSendingException emailSendingException) {
        UnavailableError unavailableError = new UnavailableError();
        unavailableError.setCode(UnavailableErrorCode.EMAIL_SENDING);
        return unavailableError;
    }

    public UnavailableError toUnavailableError(SmsSendingException smsSendingException) {
        UnavailableError unavailableError = new UnavailableError();
        unavailableError.setCode(UnavailableErrorCode.SMS_SENDING);
        unavailableError.setSmsStatus(this.toOutboundSmsStatusEnum(smsSendingException.getStatus()));
        return unavailableError;
    }

    private InputError emptyInputError() {
        InputError inputError = new InputError();
        inputError.setGeneralErrors(null);
        inputError.setPropertyErrors(null);
        inputError.setCustomFieldErrors(null);
        inputError.setProperties(null);
        inputError.setCustomFields(null);
        inputError.setErrors(null);
        inputError.setIndexedErrors(null);
        return inputError;
    }

    private ForbiddenErrorCode getForbiddenErrorCode(CyclosException cyclosException) {
        Class<?> clazz = cyclosException.getClass();
        if (clazz == PasswordStatusException.class) {
            PasswordStatusException passwordStatusException = (PasswordStatusException)cyclosException;
            PasswordStatus passwordStatus = passwordStatusException.getPasswordStatus();
            if (passwordStatus == PasswordStatus.DISABLED) {
                return ForbiddenErrorCode.DISABLED_PASSWORD;
            }
            if (passwordStatus == PasswordStatus.EXPIRED) {
                return ForbiddenErrorCode.EXPIRED_PASSWORD;
            }
            if (passwordStatus == PasswordStatus.RESET) {
                return ForbiddenErrorCode.RESET_PASSWORD;
            }
            if (passwordStatus == PasswordStatus.TEMPORARILY_BLOCKED) {
                return ForbiddenErrorCode.TEMPORARILY_BLOCKED;
            }
            if (passwordStatus == PasswordStatus.INDEFINITELY_BLOCKED) {
                return ForbiddenErrorCode.INDEFINITELY_BLOCKED;
            }
            return ForbiddenErrorCode.INVALID_PASSWORD;
        }
        if (clazz == InvalidPasswordException.class) {
            return ForbiddenErrorCode.INVALID_PASSWORD;
        }
        if (clazz == InvalidTotpException.class) {
            return ((InvalidTotpException)cyclosException).isBlockedByTries() ? ForbiddenErrorCode.BLOCKED_BY_TOTP : ForbiddenErrorCode.INVALID_TOTP;
        }
        if (clazz == IllegalActionException.class) {
            return ForbiddenErrorCode.ILLEGAL_ACTION;
        }
        if (clazz == InaccessibleChannelException.class) {
            return ForbiddenErrorCode.INACCESSIBLE_CHANNEL;
        }
        if (clazz == InaccessiblePrincipalException.class) {
            return ForbiddenErrorCode.INACCESSIBLE_PRINCIPAL;
        }
        if (clazz == InaccessibleGroupException.class) {
            return ForbiddenErrorCode.INACCESSIBLE_GROUP;
        }
        if (clazz == OperatorWithPendingAgreementsException.class) {
            return ForbiddenErrorCode.OPERATOR_WITH_PENDING_AGREEMENTS;
        }
        if (clazz == InvalidDeviceConfirmationException.class) {
            return ForbiddenErrorCode.INVALID_DEVICE_CONFIRMATION;
        }
        if (clazz == DeviceActivationException.class) {
            return ForbiddenErrorCode.INVALID_DEVICE_ACTIVATION_CODE;
        }
        if (clazz == InvalidPinRemovedException.class) {
            return ForbiddenErrorCode.DEVICE_PIN_REMOVED;
        }
        if (clazz == OtpInvalidatedException.class) {
            return ForbiddenErrorCode.OTP_INVALIDATED;
        }
        return null;
    }

    private UnauthorizedErrorCode getUnauthorizedErrorCode(CyclosException cyclosException) {
        Class<?> clazz = cyclosException.getClass();
        if (clazz == InvalidAccessClientException.class) {
            InvalidAccessClientException invalidAccessClientException = (InvalidAccessClientException)cyclosException;
            if (invalidAccessClientException.getAccessClient() != null && invalidAccessClientException.getAccessClient().getStatus() == AccessClientStatus.BLOCKED) {
                return UnauthorizedErrorCode.BLOCKED_ACCESS_CLIENT;
            }
            return UnauthorizedErrorCode.INVALID_ACCESS_CLIENT;
        }
        if (clazz == InvalidAccessTokenException.class) {
            return UnauthorizedErrorCode.INVALID_ACCESS_TOKEN;
        }
        if (clazz == LoggedOutException.class) {
            return UnauthorizedErrorCode.LOGGED_OUT;
        }
        if (clazz == UnauthorizedAddressException.class) {
            return UnauthorizedErrorCode.UNAUTHORIZED_ADDRESS;
        }
        if (clazz == UnauthorizedURLException.class) {
            return UnauthorizedErrorCode.UNAUTHORIZED_URL;
        }
        if (clazz == RemoteAddressBlockedException.class) {
            return UnauthorizedErrorCode.REMOTE_ADDRESS_BLOCKED;
        }
        if (clazz == InvalidChannelUsageException.class) {
            return UnauthorizedErrorCode.INVALID_CHANNEL_USAGE;
        }
        if (clazz == InvalidNetworkException.class) {
            return UnauthorizedErrorCode.INVALID_NETWORK;
        }
        return null;
    }
}

