/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserValidationResult;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.services.users.BasicUserService;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.UserRegistrationResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class ValidationApiImpl
extends BaseApiImpl {
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private BasicUserService basicUserService;

    public ResponseEntity<Void> manuallyValidateEmailChange(String string) {
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string);
        this.basicUserService.manuallyValidateEmailChange(userLocatorVO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<UserRegistrationResult> manuallyValidateUserRegistration(String string) {
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string);
        UserValidationResult userValidationResult = this.basicUserService.manuallyValidateRegistration(userLocatorVO);
        UserRegistrationResult userRegistrationResult = this.usersApiHelper.toUserRegistrationResult(userValidationResult);
        return this.ok(userRegistrationResult);
    }

    public ResponseEntity<Void> resendEmailChangeEmail(String string) {
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string);
        this.basicUserService.resendEmailChangeMail(userLocatorVO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> resendUserRegistrationEmail(String string) {
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string);
        this.basicUserService.resendRegistrationValidationMail(userLocatorVO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> validateEmailChange(String string) {
        this.basicUserService.validateEmailChange(string);
        return this.ok();
    }

    public ResponseEntity<UserRegistrationResult> validateUserRegistration(String string) {
        UserValidationResult userValidationResult = this.basicUserService.validateRegistration(string);
        UserRegistrationResult userRegistrationResult = this.usersApiHelper.toUserRegistrationResult(userValidationResult);
        return this.ok(userRegistrationResult);
    }
}

