/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.users.groups.InitialGroupVO;
import org.cyclos.model.users.users.AbstractSimpleRegistrationData;
import org.cyclos.model.users.users.AbstractSimpleUserRegistrationDTO;
import org.cyclos.model.users.users.AbstractViewProfileData;
import org.cyclos.model.users.users.BaseUserRegistrationResult;
import org.cyclos.model.users.users.BasicUserDTO;
import org.cyclos.model.users.users.BasicUserEditProfileData;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.PublicRegistrationDTO;
import org.cyclos.model.users.users.UserDTO;
import org.cyclos.model.users.users.UserDataParams;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserMapDirectoryData;
import org.cyclos.model.users.users.UserQuery;
import org.cyclos.model.users.users.UserRegistrationByMemberDTO;
import org.cyclos.model.users.users.UserRegistrationDTO;
import org.cyclos.model.users.users.UserSearchContext;
import org.cyclos.model.users.users.UserSearchData;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.users.users.ValidateRegistrationFieldParams;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.model.users.users.SaveFullProfileData;
import org.cyclos.server.model.users.users.SaveFullProfileParams;
import org.cyclos.server.model.users.users.SaveFullProfileResult;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.services.users.InternalBasicUserService;
import org.cyclos.services.users.UserService;
import org.cyclos.utils.Page;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.UsersApi;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.DataForEditFullProfile;
import org.cyclos.web.rest.model.FullProfileEditResult;
import org.cyclos.web.rest.model.GroupForRegistration;
import org.cyclos.web.rest.model.User;
import org.cyclos.web.rest.model.UserDataForEdit;
import org.cyclos.web.rest.model.UserDataForMap;
import org.cyclos.web.rest.model.UserDataForNew;
import org.cyclos.web.rest.model.UserDataForSearch;
import org.cyclos.web.rest.model.UserEdit;
import org.cyclos.web.rest.model.UserNew;
import org.cyclos.web.rest.model.UserQueryFilters;
import org.cyclos.web.rest.model.UserRegistrationResult;
import org.cyclos.web.rest.model.UserResult;
import org.cyclos.web.rest.model.UserView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Component
public class UsersApiImpl
extends BaseApiImpl {
    @Autowired
    private UserService userService;
    @Autowired
    private InternalBasicUserService internalBasicUserService;
    @Autowired
    private UsersApiHelper usersApiHelper;

    public ResponseEntity<UserRegistrationResult> createUser(UserNew userNew) {
        AbstractSimpleUserRegistrationDTO abstractSimpleUserRegistrationDTO = this.usersApiHelper.toUserRegistrationDTO(userNew);
        org.cyclos.model.users.users.UserRegistrationResult userRegistrationResult = abstractSimpleUserRegistrationDTO instanceof PublicRegistrationDTO ? this.userService.publicRegister((PublicRegistrationDTO)abstractSimpleUserRegistrationDTO) : (abstractSimpleUserRegistrationDTO instanceof UserRegistrationByMemberDTO ? this.userService.registerByMember((UserRegistrationByMemberDTO)abstractSimpleUserRegistrationDTO) : this.userService.register((UserRegistrationDTO)abstractSimpleUserRegistrationDTO));
        String string = this.usersApiHelper.getUserIdentification((BaseUserRegistrationResult)userRegistrationResult);
        URI uRI = this.apiHelper.uriFromApi("users", string);
        return ResponseEntity.created((URI)uRI).body((Object)this.usersApiHelper.toUserRegistrationResult(userRegistrationResult));
    }

    public ResponseEntity<Void> deletePendingUser(String string) {
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string);
        this.internalBasicUserService.remove(userLocatorVO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<InputStream> exportUsers(UsersApi.ExportUsersParams exportUsersParams) {
        UserQueryFilters userQueryFilters = (UserQueryFilters)ClassHelper.convert((Object)exportUsersParams, UserQueryFilters.class);
        UserQuery userQuery = this.usersApiHelper.toUserQuery(userQueryFilters);
        ExportFormatVO exportFormatVO = (ExportFormatVO)ModelHelper.voFromString(ExportFormatVO.class, (String)exportUsersParams.format);
        FileInfo fileInfo = this.userService.exportUsers(exportFormatVO, userQuery);
        this.writeFile(fileInfo);
        return null;
    }

    public ResponseEntity<DataForEditFullProfile> getDataForEditFullProfile(String string, List<String> list) {
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string);
        SaveFullProfileData saveFullProfileData = this.internalBasicUserService.getEditFullProfileData(userLocatorVO);
        return this.ok(this.usersApiHelper.toDataForEditFullProfile(saveFullProfileData));
    }

    public ResponseEntity<UserDataForMap> getDataForMapDirectory(List<String> list) {
        UserMapDirectoryData userMapDirectoryData = (UserMapDirectoryData)this.userService.getSearchData(UserSearchContext.MAP_DIRECTORY, null);
        UserDataForMap userDataForMap = this.usersApiHelper.toDataForMap(userMapDirectoryData);
        return this.ok(userDataForMap);
    }

    public ResponseEntity<List<GroupForRegistration>> getGroupsForUserRegistration(List<String> list, Boolean bl) {
        List list2 = this.apiHelper.isGuest() ? this.userService.getPublicRegistrationGroups() : this.userService.getUserRegistrationGroups(Boolean.TRUE.equals(bl));
        List list3 = list2.stream().map(this.usersApiHelper::toGroupForRegistration).collect(Collectors.toList());
        return this.ok(list3);
    }

    public ResponseEntity<UserDataForEdit> getUserDataForEdit(String string, List<String> list) {
        BasicUserEditProfileData basicUserEditProfileData = this.internalBasicUserService.getEditData((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        return this.ok(this.usersApiHelper.toDataForEdit(basicUserEditProfileData));
    }

    public ResponseEntity<UserDataForNew> getUserDataForNew(UsersApi.GetUserDataForNewParams getUserDataForNewParams) {
        AbstractSimpleRegistrationData abstractSimpleRegistrationData;
        if (this.apiHelper.isGuest()) {
            abstractSimpleRegistrationData = this.userService.getPublicRegistrationData((InitialGroupVO)ModelHelper.voFromString(InitialGroupVO.class, (String)getUserDataForNewParams.group), getUserDataForNewParams.inviteToken, getUserDataForNewParams.externalPaymentToken);
        } else {
            UserDataParams userDataParams = this.usersApiHelper.toUserDataParams(getUserDataForNewParams);
            abstractSimpleRegistrationData = (AbstractSimpleRegistrationData)this.userService.getDataForNew((Object)userDataParams);
        }
        return this.ok(this.usersApiHelper.toDataForNew(abstractSimpleRegistrationData));
    }

    public ResponseEntity<UserDataForSearch> getUserDataForSearch(List<String> list, String string, Boolean bl) {
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string);
        UserSearchContext userSearchContext = userLocatorVO == null ? (Boolean.TRUE.equals(bl) ? UserSearchContext.MENU : UserSearchContext.REGULAR) : UserSearchContext.BROKERED;
        UserSearchData userSearchData = this.userService.getSearchData(userSearchContext, userLocatorVO);
        UserDataForSearch userDataForSearch = this.usersApiHelper.toDataForSearch(userSearchData);
        return this.ok(userDataForSearch);
    }

    public ResponseEntity<User> locateUser(String string, List<String> list) {
        UserVO userVO = this.userService.locate((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        return this.ok(this.usersApiHelper.toUser((BasicUserVO)userVO));
    }

    public ResponseEntity<FullProfileEditResult> saveUserFullProfile(UsersApi.SaveUserFullProfileParams saveUserFullProfileParams) {
        SaveFullProfileParams saveFullProfileParams = this.usersApiHelper.toSaveFullProfileParams(saveUserFullProfileParams.user, saveUserFullProfileParams.fullProfileEdit, saveUserFullProfileParams.confirmationPassword);
        SaveFullProfileResult saveFullProfileResult = this.internalBasicUserService.saveFullProfile(saveFullProfileParams);
        FullProfileEditResult fullProfileEditResult = this.usersApiHelper.toFullProfileEditResult(saveFullProfileResult);
        return this.ok(fullProfileEditResult);
    }

    public ResponseEntity<List<UserResult>> searchMapDirectory(UsersApi.SearchMapDirectoryParams searchMapDirectoryParams) {
        UserQueryFilters userQueryFilters = (UserQueryFilters)ClassHelper.convert((Object)searchMapDirectoryParams, UserQueryFilters.class);
        UserQuery userQuery = this.usersApiHelper.toUserQuery(userQueryFilters);
        userQuery.setMapDirectory(true);
        Page page = this.userService.search(userQuery);
        return this.pageResponse(page, this.usersApiHelper::toUserResult);
    }

    public ResponseEntity<List<UserResult>> searchUsers(UsersApi.SearchUsersParams searchUsersParams) {
        UserQueryFilters userQueryFilters = (UserQueryFilters)ClassHelper.convert((Object)searchUsersParams, UserQueryFilters.class);
        UserQuery userQuery = this.usersApiHelper.toUserQuery(userQueryFilters);
        Page page = this.userService.search(userQuery);
        return this.pageResponse(page, this.usersApiHelper::toUserResult);
    }

    public ResponseEntity<Void> updateUser(String string, UserEdit userEdit, String string2) {
        UserDTO userDTO = this.usersApiHelper.toUserDTO(userEdit);
        this.internalBasicUserService.save((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string), (BasicUserDTO)userDTO, string2);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<String> validateUserRegistrationField(UsersApi.ValidateUserRegistrationFieldParams validateUserRegistrationFieldParams) {
        ValidateRegistrationFieldParams validateRegistrationFieldParams = this.usersApiHelper.toValidateRegistrationFieldParams(validateUserRegistrationFieldParams);
        String string = this.userService.validateRegistrationField(validateRegistrationFieldParams);
        if (StringHelper.isNotBlank((Object)string)) {
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.setContentType(new MediaType(MediaType.TEXT_PLAIN, StandardCharsets.UTF_8));
            return new ResponseEntity((Object)string, (MultiValueMap)httpHeaders, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    public ResponseEntity<UserView> viewUser(String string, List<String> list) {
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string);
        AbstractViewProfileData abstractViewProfileData = this.internalBasicUserService.getViewProfileData(userLocatorVO);
        return this.ok(this.usersApiHelper.toUserView(abstractViewProfileData));
    }
}

