/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.model.banking.accounts.AccountHistoriesOverviewData;
import org.cyclos.model.banking.accounts.AccountHistoriesOverviewQuery;
import org.cyclos.model.banking.accounts.AccountHistoriesOverviewStatusVO;
import org.cyclos.model.banking.transfers.TransferActionDTO;
import org.cyclos.model.banking.transfers.TransferData;
import org.cyclos.model.banking.transfers.TransferVO;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.services.banking.AccountService;
import org.cyclos.services.banking.TransferService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.TransfersApi;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.TransfersApiHelper;
import org.cyclos.web.rest.model.CurrencyAmountSummary;
import org.cyclos.web.rest.model.TransferDataForSearch;
import org.cyclos.web.rest.model.TransferQueryFilters;
import org.cyclos.web.rest.model.TransferResult;
import org.cyclos.web.rest.model.TransferView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class TransfersApiImpl
extends BaseApiImpl {
    @Autowired
    private AccountService accountService;
    @Autowired
    private TransferService transferService;
    @Autowired
    private TransfersApiHelper transfersApiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;

    public ResponseEntity<String> chargebackTransfer(String string, String string2) {
        TransferActionDTO transferActionDTO = new TransferActionDTO();
        transferActionDTO.setTransfer((TransferVO)ModelHelper.voFromString(TransferVO.class, (String)string));
        transferActionDTO.setConfirmationPassword(string2);
        String string3 = ApiHelper.toId(this.transferService.chargeback(transferActionDTO));
        return this.created(this.apiHelper.uriFromApi("transfers", string3), string3);
    }

    public ResponseEntity<InputStream> exportTransfer(String string, String string2) {
        ExportFormatVO exportFormatVO = (ExportFormatVO)ModelHelper.voFromString(ExportFormatVO.class, (String)string2);
        TransferVO transferVO = (TransferVO)ModelHelper.voFromString(TransferVO.class, (String)string);
        FileInfo fileInfo = this.transferService.exportTransfer(exportFormatVO, transferVO);
        return this.writeFile(fileInfo);
    }

    public ResponseEntity<InputStream> exportTransfers(TransfersApi.ExportTransfersParams exportTransfersParams) {
        TransferQueryFilters transferQueryFilters = (TransferQueryFilters)ClassHelper.convert((Object)exportTransfersParams, TransferQueryFilters.class);
        AccountHistoriesOverviewQuery accountHistoriesOverviewQuery = this.transfersApiHelper.toAccountHistoriesOverviewQuery(transferQueryFilters);
        ExportFormatVO exportFormatVO = (ExportFormatVO)ModelHelper.voFromString(ExportFormatVO.class, (String)exportTransfersParams.format);
        FileInfo fileInfo = this.accountService.exportAccountHistoriesOverview(exportFormatVO, accountHistoriesOverviewQuery);
        return this.writeFile(fileInfo);
    }

    public ResponseEntity<TransferDataForSearch> getTransferDataForSearch(List<String> list) {
        AccountHistoriesOverviewData accountHistoriesOverviewData = this.accountService.getAccountHistoriesOverviewData();
        TransferDataForSearch transferDataForSearch = this.transfersApiHelper.toTransferDataForSearch(accountHistoriesOverviewData);
        return this.ok(transferDataForSearch);
    }

    public ResponseEntity<List<TransferResult>> searchTransfers(TransfersApi.SearchTransfersParams searchTransfersParams) {
        TransferQueryFilters transferQueryFilters = (TransferQueryFilters)ClassHelper.convert((Object)searchTransfersParams, TransferQueryFilters.class);
        AccountHistoriesOverviewQuery accountHistoriesOverviewQuery = this.transfersApiHelper.toAccountHistoriesOverviewQuery(transferQueryFilters);
        Page page = this.accountService.searchAccountHistoriesOverview(accountHistoriesOverviewQuery);
        return this.pageResponse(page, this.transfersApiHelper::toTransferResult);
    }

    public ResponseEntity<List<CurrencyAmountSummary>> searchTransfersSummary(TransfersApi.SearchTransfersSummaryParams searchTransfersSummaryParams) {
        TransferQueryFilters transferQueryFilters = (TransferQueryFilters)ClassHelper.convert((Object)searchTransfersSummaryParams, TransferQueryFilters.class);
        AccountHistoriesOverviewQuery accountHistoriesOverviewQuery = this.transfersApiHelper.toAccountHistoriesOverviewQuery(transferQueryFilters);
        AccountHistoriesOverviewStatusVO accountHistoriesOverviewStatusVO = this.accountService.getAccountHistoriesOverviewStatus(accountHistoriesOverviewQuery);
        List list = CollectionHelper.orEmpty((List)accountHistoriesOverviewStatusVO.getStatuses()).stream().map(this.accountsApiHelper::toCurrencyAmountSummary).collect(Collectors.toList());
        return this.ok(list);
    }

    public ResponseEntity<TransferView> viewTransfer(String string, List<String> list) {
        TransferVO transferVO = (TransferVO)ModelHelper.voFromString(TransferVO.class, (String)string);
        TransferData transferData = this.transferService.getData(transferVO);
        return this.ok(this.transfersApiHelper.toTransferView(transferData));
    }
}

