/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.utils.DateTime;
import org.cyclos.web.rest.api.TransfersApiImpl;
import org.cyclos.web.rest.model.CurrencyAmountSummary;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.PaymentError;
import org.cyclos.web.rest.model.TransOrderByEnum;
import org.cyclos.web.rest.model.TransferDataForSearch;
import org.cyclos.web.rest.model.TransferKind;
import org.cyclos.web.rest.model.TransferResult;
import org.cyclos.web.rest.model.TransferView;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class TransfersApi {
    @Autowired
    private TransfersApiImpl impl;
    public static final String CHARGEBACK_TRANSFER = "/transfers/{key}/chargeback";
    public static final String EXPORT_TRANSFER = "/transfers/{key}/export/{format}";
    public static final String EXPORT_TRANSFERS = "/transfers/export/{format}";
    public static final String GET_TRANSFER_DATA_FOR_SEARCH = "/transfers/data-for-search";
    public static final String SEARCH_TRANSFERS = "/transfers";
    public static final String SEARCH_TRANSFERS_SUMMARY = "/transfers/summary";
    public static final String VIEW_TRANSFER = "/transfers/{key}";

    @RequestMapping(value={"/api/transfers/{key}/chargeback"}, produces={"text/plain", "application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> chargebackTransfer(@PathVariable(value="key") String string, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /transfers/{key}/chargeback");
        httpServletRequest.setAttribute("errorType", PaymentError.class);
        return this.impl.chargebackTransfer(string, string2);
    }

    @RequestMapping(value={"/api/transfers/{key}/export/{format}"}, produces={"*/*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> exportTransfer(@PathVariable(value="key") String string, @PathVariable(value="format") String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /transfers/{key}/export/{format}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.exportTransfer(string, string2);
    }

    @RequestMapping(value={"/api/transfers/export/{format}"}, produces={"*/*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> exportTransfers(@PathVariable(value="format") String string, @RequestParam(value="accessClients", required=false) List<String> list, @RequestParam(value="amountRange", required=false) List<BigDecimal> list2, @RequestParam(value="brokers", required=false) List<String> list3, @RequestParam(value="by", required=false) String string2, @RequestParam(value="channels", required=false) List<String> list4, @RequestParam(value="chargedBack", required=false) Boolean bl, @RequestParam(value="currencies", required=false) List<String> list5, @RequestParam(value="customFields", required=false) List<String> list6, @RequestParam(value="datePeriod", required=false) List<DateTime> list7, @RequestParam(value="excludedIds", required=false) List<String> list8, @RequestParam(value="fromAccountTypes", required=false) List<String> list9, @RequestParam(value="fromCurrentAccessClient", required=false) Boolean bl2, @RequestParam(value="groups", required=false) List<String> list10, @RequestParam(value="includeGeneratedByAccessClient", required=false) Boolean bl3, @RequestParam(value="kinds", required=false) List<TransferKind> list11, @RequestParam(value="orderBy", required=false) TransOrderByEnum transOrderByEnum, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="skipTotalCount", required=false) Boolean bl4, @RequestParam(value="statuses", required=false) List<String> list12, @RequestParam(value="toAccountTypes", required=false) List<String> list13, @RequestParam(value="transactionNumber", required=false) String string3, @RequestParam(value="transferFilters", required=false) List<String> list14, @RequestParam(value="transferTypes", required=false) List<String> list15, @RequestParam(value="user", required=false) String string4, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /transfers/export/{format}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        ExportTransfersParams exportTransfersParams = new ExportTransfersParams();
        exportTransfersParams.format = string;
        exportTransfersParams.accessClients = list;
        exportTransfersParams.amountRange = list2;
        exportTransfersParams.brokers = list3;
        exportTransfersParams.by = string2;
        exportTransfersParams.channels = list4;
        exportTransfersParams.chargedBack = bl;
        exportTransfersParams.currencies = list5;
        exportTransfersParams.customFields = list6;
        exportTransfersParams.datePeriod = list7;
        exportTransfersParams.excludedIds = list8;
        exportTransfersParams.fromAccountTypes = list9;
        exportTransfersParams.fromCurrentAccessClient = bl2;
        exportTransfersParams.groups = list10;
        exportTransfersParams.includeGeneratedByAccessClient = bl3;
        exportTransfersParams.kinds = list11;
        exportTransfersParams.orderBy = transOrderByEnum;
        exportTransfersParams.page = n;
        exportTransfersParams.pageSize = n2;
        exportTransfersParams.skipTotalCount = bl4;
        exportTransfersParams.statuses = list12;
        exportTransfersParams.toAccountTypes = list13;
        exportTransfersParams.transactionNumber = string3;
        exportTransfersParams.transferFilters = list14;
        exportTransfersParams.transferTypes = list15;
        exportTransfersParams.user = string4;
        return this.impl.exportTransfers(exportTransfersParams);
    }

    @RequestMapping(value={"/api/transfers/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<TransferDataForSearch> getTransferDataForSearch(@RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /transfers/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getTransferDataForSearch(list);
    }

    @RequestMapping(value={"/api/transfers"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<TransferResult>> searchTransfers(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="accessClients", required=false) List<String> list2, @RequestParam(value="amountRange", required=false) List<BigDecimal> list3, @RequestParam(value="brokers", required=false) List<String> list4, @RequestParam(value="by", required=false) String string, @RequestParam(value="channels", required=false) List<String> list5, @RequestParam(value="chargedBack", required=false) Boolean bl, @RequestParam(value="currencies", required=false) List<String> list6, @RequestParam(value="customFields", required=false) List<String> list7, @RequestParam(value="datePeriod", required=false) List<DateTime> list8, @RequestParam(value="excludedIds", required=false) List<String> list9, @RequestParam(value="fromAccountTypes", required=false) List<String> list10, @RequestParam(value="fromCurrentAccessClient", required=false) Boolean bl2, @RequestParam(value="groups", required=false) List<String> list11, @RequestParam(value="includeGeneratedByAccessClient", required=false) Boolean bl3, @RequestParam(value="kinds", required=false) List<TransferKind> list12, @RequestParam(value="orderBy", required=false) TransOrderByEnum transOrderByEnum, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="skipTotalCount", required=false) Boolean bl4, @RequestParam(value="statuses", required=false) List<String> list13, @RequestParam(value="toAccountTypes", required=false) List<String> list14, @RequestParam(value="transactionNumber", required=false) String string2, @RequestParam(value="transferFilters", required=false) List<String> list15, @RequestParam(value="transferTypes", required=false) List<String> list16, @RequestParam(value="user", required=false) String string3, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /transfers");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchTransfersParams searchTransfersParams = new SearchTransfersParams();
        searchTransfersParams.fields = list;
        searchTransfersParams.accessClients = list2;
        searchTransfersParams.amountRange = list3;
        searchTransfersParams.brokers = list4;
        searchTransfersParams.by = string;
        searchTransfersParams.channels = list5;
        searchTransfersParams.chargedBack = bl;
        searchTransfersParams.currencies = list6;
        searchTransfersParams.customFields = list7;
        searchTransfersParams.datePeriod = list8;
        searchTransfersParams.excludedIds = list9;
        searchTransfersParams.fromAccountTypes = list10;
        searchTransfersParams.fromCurrentAccessClient = bl2;
        searchTransfersParams.groups = list11;
        searchTransfersParams.includeGeneratedByAccessClient = bl3;
        searchTransfersParams.kinds = list12;
        searchTransfersParams.orderBy = transOrderByEnum;
        searchTransfersParams.page = n;
        searchTransfersParams.pageSize = n2;
        searchTransfersParams.skipTotalCount = bl4;
        searchTransfersParams.statuses = list13;
        searchTransfersParams.toAccountTypes = list14;
        searchTransfersParams.transactionNumber = string2;
        searchTransfersParams.transferFilters = list15;
        searchTransfersParams.transferTypes = list16;
        searchTransfersParams.user = string3;
        return this.impl.searchTransfers(searchTransfersParams);
    }

    @RequestMapping(value={"/api/transfers/summary"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<CurrencyAmountSummary>> searchTransfersSummary(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="accessClients", required=false) List<String> list2, @RequestParam(value="amountRange", required=false) List<BigDecimal> list3, @RequestParam(value="brokers", required=false) List<String> list4, @RequestParam(value="by", required=false) String string, @RequestParam(value="channels", required=false) List<String> list5, @RequestParam(value="chargedBack", required=false) Boolean bl, @RequestParam(value="currencies", required=false) List<String> list6, @RequestParam(value="customFields", required=false) List<String> list7, @RequestParam(value="datePeriod", required=false) List<DateTime> list8, @RequestParam(value="excludedIds", required=false) List<String> list9, @RequestParam(value="fromAccountTypes", required=false) List<String> list10, @RequestParam(value="fromCurrentAccessClient", required=false) Boolean bl2, @RequestParam(value="groups", required=false) List<String> list11, @RequestParam(value="includeGeneratedByAccessClient", required=false) Boolean bl3, @RequestParam(value="kinds", required=false) List<TransferKind> list12, @RequestParam(value="orderBy", required=false) TransOrderByEnum transOrderByEnum, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="skipTotalCount", required=false) Boolean bl4, @RequestParam(value="statuses", required=false) List<String> list13, @RequestParam(value="toAccountTypes", required=false) List<String> list14, @RequestParam(value="transactionNumber", required=false) String string2, @RequestParam(value="transferFilters", required=false) List<String> list15, @RequestParam(value="transferTypes", required=false) List<String> list16, @RequestParam(value="user", required=false) String string3, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /transfers/summary");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchTransfersSummaryParams searchTransfersSummaryParams = new SearchTransfersSummaryParams();
        searchTransfersSummaryParams.fields = list;
        searchTransfersSummaryParams.accessClients = list2;
        searchTransfersSummaryParams.amountRange = list3;
        searchTransfersSummaryParams.brokers = list4;
        searchTransfersSummaryParams.by = string;
        searchTransfersSummaryParams.channels = list5;
        searchTransfersSummaryParams.chargedBack = bl;
        searchTransfersSummaryParams.currencies = list6;
        searchTransfersSummaryParams.customFields = list7;
        searchTransfersSummaryParams.datePeriod = list8;
        searchTransfersSummaryParams.excludedIds = list9;
        searchTransfersSummaryParams.fromAccountTypes = list10;
        searchTransfersSummaryParams.fromCurrentAccessClient = bl2;
        searchTransfersSummaryParams.groups = list11;
        searchTransfersSummaryParams.includeGeneratedByAccessClient = bl3;
        searchTransfersSummaryParams.kinds = list12;
        searchTransfersSummaryParams.orderBy = transOrderByEnum;
        searchTransfersSummaryParams.page = n;
        searchTransfersSummaryParams.pageSize = n2;
        searchTransfersSummaryParams.skipTotalCount = bl4;
        searchTransfersSummaryParams.statuses = list13;
        searchTransfersSummaryParams.toAccountTypes = list14;
        searchTransfersSummaryParams.transactionNumber = string2;
        searchTransfersSummaryParams.transferFilters = list15;
        searchTransfersSummaryParams.transferTypes = list16;
        searchTransfersSummaryParams.user = string3;
        return this.impl.searchTransfersSummary(searchTransfersSummaryParams);
    }

    @RequestMapping(value={"/api/transfers/{key}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<TransferView> viewTransfer(@PathVariable(value="key") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /transfers/{key}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.viewTransfer(string, list);
    }

    public static class ExportTransfersParams {
        public String format;
        public static final String FORMAT = "format";
        public List<String> accessClients;
        public static final String ACCESS_CLIENTS = "accessClients";
        public List<BigDecimal> amountRange;
        public static final String AMOUNT_RANGE = "amountRange";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public String by;
        public static final String BY = "by";
        public List<String> channels;
        public static final String CHANNELS = "channels";
        public Boolean chargedBack;
        public static final String CHARGED_BACK = "chargedBack";
        public List<String> currencies;
        public static final String CURRENCIES = "currencies";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
        public List<DateTime> datePeriod;
        public static final String DATE_PERIOD = "datePeriod";
        public List<String> excludedIds;
        public static final String EXCLUDED_IDS = "excludedIds";
        public List<String> fromAccountTypes;
        public static final String FROM_ACCOUNT_TYPES = "fromAccountTypes";
        public Boolean fromCurrentAccessClient;
        public static final String FROM_CURRENT_ACCESS_CLIENT = "fromCurrentAccessClient";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Boolean includeGeneratedByAccessClient;
        public static final String INCLUDE_GENERATED_BY_ACCESS_CLIENT = "includeGeneratedByAccessClient";
        public List<TransferKind> kinds;
        public static final String KINDS = "kinds";
        public TransOrderByEnum orderBy;
        public static final String ORDER_BY = "orderBy";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<String> statuses;
        public static final String STATUSES = "statuses";
        public List<String> toAccountTypes;
        public static final String TO_ACCOUNT_TYPES = "toAccountTypes";
        public String transactionNumber;
        public static final String TRANSACTION_NUMBER = "transactionNumber";
        public List<String> transferFilters;
        public static final String TRANSFER_FILTERS = "transferFilters";
        public List<String> transferTypes;
        public static final String TRANSFER_TYPES = "transferTypes";
        public String user;
        public static final String USER = "user";
    }

    public static class SearchTransfersParams {
        public List<String> fields;
        public static final String FIELDS = "fields";
        public List<String> accessClients;
        public static final String ACCESS_CLIENTS = "accessClients";
        public List<BigDecimal> amountRange;
        public static final String AMOUNT_RANGE = "amountRange";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public String by;
        public static final String BY = "by";
        public List<String> channels;
        public static final String CHANNELS = "channels";
        public Boolean chargedBack;
        public static final String CHARGED_BACK = "chargedBack";
        public List<String> currencies;
        public static final String CURRENCIES = "currencies";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
        public List<DateTime> datePeriod;
        public static final String DATE_PERIOD = "datePeriod";
        public List<String> excludedIds;
        public static final String EXCLUDED_IDS = "excludedIds";
        public List<String> fromAccountTypes;
        public static final String FROM_ACCOUNT_TYPES = "fromAccountTypes";
        public Boolean fromCurrentAccessClient;
        public static final String FROM_CURRENT_ACCESS_CLIENT = "fromCurrentAccessClient";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Boolean includeGeneratedByAccessClient;
        public static final String INCLUDE_GENERATED_BY_ACCESS_CLIENT = "includeGeneratedByAccessClient";
        public List<TransferKind> kinds;
        public static final String KINDS = "kinds";
        public TransOrderByEnum orderBy;
        public static final String ORDER_BY = "orderBy";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<String> statuses;
        public static final String STATUSES = "statuses";
        public List<String> toAccountTypes;
        public static final String TO_ACCOUNT_TYPES = "toAccountTypes";
        public String transactionNumber;
        public static final String TRANSACTION_NUMBER = "transactionNumber";
        public List<String> transferFilters;
        public static final String TRANSFER_FILTERS = "transferFilters";
        public List<String> transferTypes;
        public static final String TRANSFER_TYPES = "transferTypes";
        public String user;
        public static final String USER = "user";
    }

    public static class SearchTransfersSummaryParams {
        public List<String> fields;
        public static final String FIELDS = "fields";
        public List<String> accessClients;
        public static final String ACCESS_CLIENTS = "accessClients";
        public List<BigDecimal> amountRange;
        public static final String AMOUNT_RANGE = "amountRange";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public String by;
        public static final String BY = "by";
        public List<String> channels;
        public static final String CHANNELS = "channels";
        public Boolean chargedBack;
        public static final String CHARGED_BACK = "chargedBack";
        public List<String> currencies;
        public static final String CURRENCIES = "currencies";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
        public List<DateTime> datePeriod;
        public static final String DATE_PERIOD = "datePeriod";
        public List<String> excludedIds;
        public static final String EXCLUDED_IDS = "excludedIds";
        public List<String> fromAccountTypes;
        public static final String FROM_ACCOUNT_TYPES = "fromAccountTypes";
        public Boolean fromCurrentAccessClient;
        public static final String FROM_CURRENT_ACCESS_CLIENT = "fromCurrentAccessClient";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Boolean includeGeneratedByAccessClient;
        public static final String INCLUDE_GENERATED_BY_ACCESS_CLIENT = "includeGeneratedByAccessClient";
        public List<TransferKind> kinds;
        public static final String KINDS = "kinds";
        public TransOrderByEnum orderBy;
        public static final String ORDER_BY = "orderBy";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<String> statuses;
        public static final String STATUSES = "statuses";
        public List<String> toAccountTypes;
        public static final String TO_ACCOUNT_TYPES = "toAccountTypes";
        public String transactionNumber;
        public static final String TRANSACTION_NUMBER = "transactionNumber";
        public List<String> transferFilters;
        public static final String TRANSFER_FILTERS = "transferFilters";
        public List<String> transferTypes;
        public static final String TRANSFER_TYPES = "transferTypes";
        public String user;
        public static final String USER = "user";
    }
}

