/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.cyclos.model.banking.transactions.TransactionData;
import org.cyclos.model.banking.transactions.TransactionOverviewQuery;
import org.cyclos.model.banking.transactions.TransactionOverviewSearchData;
import org.cyclos.model.banking.transactions.TransactionQuery;
import org.cyclos.model.banking.transactions.TransactionResultVO;
import org.cyclos.model.banking.transactions.TransactionSearchData;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.services.banking.TransactionService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.TransactionsApi;
import org.cyclos.web.rest.helpers.TransactionsApiHelper;
import org.cyclos.web.rest.model.TransactionDataForSearch;
import org.cyclos.web.rest.model.TransactionKind;
import org.cyclos.web.rest.model.TransactionOverviewDataForSearch;
import org.cyclos.web.rest.model.TransactionOverviewQueryFilters;
import org.cyclos.web.rest.model.TransactionOverviewResult;
import org.cyclos.web.rest.model.TransactionQueryFilters;
import org.cyclos.web.rest.model.TransactionResult;
import org.cyclos.web.rest.model.TransactionView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class TransactionsApiImpl
extends BaseApiImpl {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private TransactionsApiHelper transactionsApiHelper;

    public ResponseEntity<InputStream> exportTransaction(String string, String string2) {
        ExportFormatVO exportFormatVO = (ExportFormatVO)ModelHelper.voFromString(ExportFormatVO.class, (String)string2);
        TransactionVO transactionVO = (TransactionVO)ModelHelper.voFromString(TransactionVO.class, (String)string);
        FileInfo fileInfo = this.transactionService.exportTransaction(exportFormatVO, transactionVO);
        return this.writeFile(fileInfo);
    }

    public ResponseEntity<InputStream> exportTransactions(TransactionsApi.ExportTransactionsParams exportTransactionsParams) {
        TransactionQueryFilters transactionQueryFilters = (TransactionQueryFilters)ClassHelper.convert((Object)exportTransactionsParams, TransactionQueryFilters.class);
        TransactionQuery transactionQuery = this.transactionsApiHelper.toTransactionQuery(exportTransactionsParams.owner, transactionQueryFilters);
        ExportFormatVO exportFormatVO = (ExportFormatVO)ModelHelper.voFromString(ExportFormatVO.class, (String)exportTransactionsParams.format);
        FileInfo fileInfo = this.transactionService.exportTransactions(exportFormatVO, transactionQuery);
        return this.writeFile(fileInfo);
    }

    public ResponseEntity<InputStream> exportTransactionsOverview(TransactionsApi.ExportTransactionsOverviewParams exportTransactionsOverviewParams) {
        TransactionOverviewQueryFilters transactionOverviewQueryFilters = (TransactionOverviewQueryFilters)ClassHelper.convert((Object)exportTransactionsOverviewParams, TransactionOverviewQueryFilters.class);
        TransactionOverviewQuery transactionOverviewQuery = this.transactionsApiHelper.toTransactionOverviewQuery(transactionOverviewQueryFilters);
        ExportFormatVO exportFormatVO = (ExportFormatVO)ModelHelper.voFromString(ExportFormatVO.class, (String)exportTransactionsOverviewParams.format);
        FileInfo fileInfo = this.transactionService.exportOverview(exportFormatVO, transactionOverviewQuery);
        return this.writeFile(fileInfo);
    }

    public ResponseEntity<TransactionDataForSearch> getTransactionsDataForSearch(String string, List<String> list) {
        TransactionSearchData transactionSearchData = this.transactionService.getSearchData(ModelHelper.accountOwner((String)string));
        TransactionDataForSearch transactionDataForSearch = this.transactionsApiHelper.toTransactionDataForSearch(transactionSearchData);
        return this.ok(transactionDataForSearch);
    }

    public ResponseEntity<TransactionOverviewDataForSearch> getTransactionsOverviewDataForSearch(List<String> list, Boolean bl) {
        TransactionOverviewSearchData transactionOverviewSearchData = this.transactionService.getOverviewSearchData(Boolean.TRUE.equals(bl));
        TransactionOverviewDataForSearch transactionOverviewDataForSearch = this.transactionsApiHelper.toTransactionOverviewDataForSearch(transactionOverviewSearchData);
        return this.ok(transactionOverviewDataForSearch);
    }

    public ResponseEntity<List<TransactionResult>> searchTransactions(TransactionsApi.SearchTransactionsParams searchTransactionsParams) {
        Page page;
        TransactionQueryFilters transactionQueryFilters = (TransactionQueryFilters)ClassHelper.convert((Object)searchTransactionsParams, TransactionQueryFilters.class);
        if (this.onlyDeprecatedKinds(transactionQueryFilters.getKinds())) {
            page = PageImpl.empty();
        } else {
            TransactionQuery transactionQuery = this.transactionsApiHelper.toTransactionQuery(searchTransactionsParams.owner, transactionQueryFilters);
            page = this.transactionService.search(transactionQuery);
        }
        return this.pageResponse(page, transactionResultVO -> this.transactionsApiHelper.toTransactionResult((TransactionResultVO)transactionResultVO, true));
    }

    public ResponseEntity<List<TransactionOverviewResult>> searchTransactionsOverview(TransactionsApi.SearchTransactionsOverviewParams searchTransactionsOverviewParams) {
        Page page;
        TransactionOverviewQueryFilters transactionOverviewQueryFilters = (TransactionOverviewQueryFilters)ClassHelper.convert((Object)searchTransactionsOverviewParams, TransactionOverviewQueryFilters.class);
        if (this.onlyDeprecatedKinds(transactionOverviewQueryFilters.getKinds())) {
            page = PageImpl.empty();
        } else {
            TransactionOverviewQuery transactionOverviewQuery = this.transactionsApiHelper.toTransactionOverviewQuery(transactionOverviewQueryFilters);
            page = this.transactionService.searchOverview(transactionOverviewQuery);
        }
        return this.pageResponse(page, transactionResultVO -> this.transactionsApiHelper.toTransactionOverviewResult((TransactionResultVO)transactionResultVO, true));
    }

    public ResponseEntity<TransactionView> viewTransaction(String string, List<String> list) {
        TransactionData transactionData = this.transactionService.getData((TransactionVO)ModelHelper.voFromString(TransactionVO.class, (String)string));
        return this.ok(this.transactionsApiHelper.toTransactionView(transactionData));
    }

    private boolean onlyDeprecatedKinds(Collection<TransactionKind> collection) {
        return CollectionHelper.size(collection) == 1 && collection.contains(TransactionKind.CHARGEBACK);
    }
}

