/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.TicketsApiImpl;
import org.cyclos.web.rest.model.DataForTransaction;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.ImageSizeEnum;
import org.cyclos.web.rest.model.PaymentError;
import org.cyclos.web.rest.model.TicketApprovalResult;
import org.cyclos.web.rest.model.TicketNew;
import org.cyclos.web.rest.model.TicketPreview;
import org.cyclos.web.rest.model.TicketProcessResult;
import org.cyclos.web.rest.model.TransactionView;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class TicketsApi {
    @Autowired
    private TicketsApiImpl impl;
    public static final String APPROVE_TICKET = "/tickets/{ticket}/approve";
    public static final String CANCEL_TICKET = "/tickets/{ticket}/cancel";
    public static final String DATA_FOR_NEW_TICKET = "/{user}/tickets/data-for-new";
    public static final String DATA_FOR_NEW_TICKET_DEPRECATED = "/tickets/data-for-new";
    public static final String GET_TICKET_QR_CODE = "/tickets/{ticket}/qr-code";
    public static final String NEW_TICKET = "/{user}/tickets";
    public static final String NEW_TICKET_DEPRECATED = "/tickets";
    public static final String PREVIEW_TICKET = "/tickets/{ticket}/preview";
    public static final String PROCESS_TICKET = "/tickets/{ticket}/process";
    public static final String VIEW_TICKET = "/tickets/{ticket}";

    @RequestMapping(value={"/api/tickets/{ticket}/approve"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<TicketApprovalResult> approveTicket(@PathVariable(value="ticket") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /tickets/{ticket}/approve");
        httpServletRequest.setAttribute("errorType", PaymentError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.approveTicket(string, list, string2);
    }

    @RequestMapping(value={"/api/tickets/{ticket}/cancel"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> cancelTicket(@PathVariable(value="ticket") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /tickets/{ticket}/cancel");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.cancelTicket(string);
    }

    @RequestMapping(value={"/api/{user:.*}/tickets/data-for-new"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataForTransaction> dataForNewTicket(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="type", required=false) String string2, @RequestParam(value="payer", required=false) String string3, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/tickets/data-for-new");
        httpServletRequest.setAttribute("errorType", Error.class);
        DataForNewTicketParams dataForNewTicketParams = new DataForNewTicketParams();
        dataForNewTicketParams.user = string;
        dataForNewTicketParams.fields = list;
        dataForNewTicketParams.type = string2;
        dataForNewTicketParams.payer = string3;
        return this.impl.dataForNewTicket(dataForNewTicketParams);
    }

    @RequestMapping(value={"/api/tickets/data-for-new"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataForTransaction> dataForNewTicketDeprecated(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="type", required=false) String string, @RequestParam(value="payer", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /tickets/data-for-new");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.dataForNewTicketDeprecated(list, string, string2);
    }

    @RequestMapping(value={"/api/tickets/{ticket}/qr-code"}, produces={"image/png", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> getTicketQrCode(@PathVariable(value="ticket") String string, @RequestParam(value="size", required=false) ImageSizeEnum imageSizeEnum, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /tickets/{ticket}/qr-code");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getTicketQrCode(string, imageSizeEnum);
    }

    @RequestMapping(value={"/api/{user:.*}/tickets"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<TransactionView> newTicket(@PathVariable(value="user") String string, @RequestBody(required=true) TicketNew ticketNew, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/tickets");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.newTicket(string, ticketNew, list);
    }

    @RequestMapping(value={"/api/tickets"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<TransactionView> newTicketDeprecated(@RequestBody(required=true) TicketNew ticketNew, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /tickets");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.newTicketDeprecated(ticketNew, list);
    }

    @RequestMapping(value={"/api/tickets/{ticket}/preview"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<TicketPreview> previewTicket(@PathVariable(value="ticket") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /tickets/{ticket}/preview");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.previewTicket(string, list);
    }

    @RequestMapping(value={"/api/tickets/{ticket}/process"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<TicketProcessResult> processTicket(@PathVariable(value="ticket") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="orderId", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /tickets/{ticket}/process");
        httpServletRequest.setAttribute("errorType", PaymentError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.processTicket(string, list, string2);
    }

    @RequestMapping(value={"/api/tickets/{ticket}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<TransactionView> viewTicket(@PathVariable(value="ticket") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /tickets/{ticket}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.viewTicket(string, list);
    }

    public static class DataForNewTicketParams {
        public String user;
        public static final String USER = "user";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String type;
        public static final String TYPE = "type";
        public String payer;
        public static final String PAYER = "payer";
    }
}

