/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.marketplace.advertisements.BasicAdVO;
import org.cyclos.model.marketplace.webshoporders.OrderDTO;
import org.cyclos.model.marketplace.webshoporders.OrderData;
import org.cyclos.model.marketplace.webshoporders.OrderStatus;
import org.cyclos.model.marketplace.webshoporders.OrderVO;
import org.cyclos.model.marketplace.webshoporders.ShoppingCartCheckoutParams;
import org.cyclos.model.marketplace.webshoporders.ShoppingCartCheckoutResult;
import org.cyclos.model.marketplace.webshoporders.ShoppingCartDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.services.marketplace.OrderService;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.helpers.ShoppingCartsApiHelper;
import org.cyclos.web.rest.model.ShoppingCartCheckout;
import org.cyclos.web.rest.model.ShoppingCartDataForCheckout;
import org.cyclos.web.rest.model.ShoppingCartResult;
import org.cyclos.web.rest.model.ShoppingCartView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class ShoppingCartsApiImpl
extends BaseApiImpl {
    @Autowired
    private OrderService orderService;
    @Autowired
    private ShoppingCartsApiHelper shoppingCartsApiHelper;

    public ResponseEntity<Integer> addItemToShoppingCart(String string, Double d) {
        int n = this.orderService.addToCart((BasicAdVO)ModelHelper.voFromString(BasicAdVO.class, (String)string), this.apiHelper.toBigDecimal(d));
        return this.ok(n);
    }

    public ResponseEntity<ShoppingCartView> adjustAndGetShoppingCartDetails(String string, List<String> list) {
        OrderData orderData = this.orderService.adjustShoppingCartAndGetData((OrderVO)ModelHelper.voFromString(OrderVO.class, (String)string));
        ShoppingCartView shoppingCartView = this.shoppingCartsApiHelper.toShoppingCartView(orderData);
        return this.ok(shoppingCartView);
    }

    public ResponseEntity<Integer> checkoutShoppingCart(String string, ShoppingCartCheckout shoppingCartCheckout, String string2) {
        ShoppingCartCheckoutParams shoppingCartCheckoutParams = this.shoppingCartsApiHelper.toShoppingCartCheckoutParams(string, string2, shoppingCartCheckout);
        ShoppingCartCheckoutResult shoppingCartCheckoutResult = this.orderService.checkout(shoppingCartCheckoutParams);
        long l = shoppingCartCheckoutResult.getOrder().getId();
        int n = shoppingCartCheckoutResult.getTotalAdsCount();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().location(this.apiHelper.uriFromApi("orders", l))).body((Object)n);
    }

    public ResponseEntity<ShoppingCartDataForCheckout> getShoppingCartDataForCheckout(String string, List<String> list) {
        OrderData orderData = (OrderData)this.orderService.getData(this.apiHelper.fromId(string));
        if (((OrderDTO)orderData.getDto()).getStatus() != OrderStatus.SHOPPING_CART) {
            throw new EntityNotFoundException();
        }
        ShoppingCartDataForCheckout shoppingCartDataForCheckout = this.shoppingCartsApiHelper.toShoppingCartDataForCheckout(orderData);
        return this.ok(shoppingCartDataForCheckout);
    }

    public ResponseEntity<ShoppingCartView> getShoppingCartDetails(String string, List<String> list) {
        OrderData orderData = (OrderData)this.orderService.getData(this.apiHelper.fromId(string));
        ShoppingCartView shoppingCartView = this.shoppingCartsApiHelper.toShoppingCartView(orderData);
        return this.ok(shoppingCartView);
    }

    public ResponseEntity<List<ShoppingCartResult>> getShoppingCarts(List<String> list) {
        ShoppingCartDTO shoppingCartDTO = this.orderService.getMyCart();
        List<ShoppingCartResult> list2 = this.shoppingCartsApiHelper.toShoppingCarts(shoppingCartDTO);
        return this.ok(list2);
    }

    public ResponseEntity<Integer> modifyItemQuantityOnShoppingCart(String string, Double d) {
        int n = this.orderService.modifyQuantityOnCart((BasicAdVO)ModelHelper.voFromString(BasicAdVO.class, (String)string), this.apiHelper.toBigDecimal(d));
        return this.ok(n);
    }

    public ResponseEntity<Integer> removeItemFromShoppingCart(String string) {
        int n = this.orderService.removeCartItem((BasicAdVO)ModelHelper.voFromString(BasicAdVO.class, (String)string));
        return this.ok(n);
    }

    public ResponseEntity<Integer> removeShoppingCart(String string) {
        int n = this.orderService.removeCartById(this.apiHelper.fromId(string));
        return this.ok(n);
    }
}

