/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import org.cyclos.model.users.users.ConnectedUserQuery;
import org.cyclos.model.users.users.ConnectedUserSearchData;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.model.access.login.AuthVO;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.services.access.InternalAuthService;
import org.cyclos.services.access.LoginUserDTO;
import org.cyclos.services.users.ConnectedUserService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.SessionsApi;
import org.cyclos.web.rest.helpers.SessionsApiHelper;
import org.cyclos.web.rest.model.LoginUser;
import org.cyclos.web.rest.model.SessionDataForSearch;
import org.cyclos.web.rest.model.SessionQueryFilters;
import org.cyclos.web.rest.model.SessionResult;
import org.cyclos.web.rest.model.UserAuth;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class SessionsApiImpl
extends BaseApiImpl {
    @Autowired
    private InternalAuthService internalAuthService;
    @Autowired
    private ConnectedUserService connectedUserService;
    @Autowired
    private SessionsApiHelper sessionsApiHelper;

    public ResponseEntity<Void> disconnectSession(String string) {
        this.connectedUserService.disconnectBySessionTokens(CollectionHelper.asSet((Object[])new String[]{string}));
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<String> disconnectUserSessions(String string) {
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string);
        int n = this.connectedUserService.disconnect(userLocatorVO);
        return this.ok(String.valueOf(n));
    }

    public ResponseEntity<SessionDataForSearch> getSessionDataForSearch(List<String> list) {
        ConnectedUserSearchData connectedUserSearchData = this.connectedUserService.getSearchData();
        SessionDataForSearch sessionDataForSearch = this.sessionsApiHelper.toDataForSearch(connectedUserSearchData);
        return this.ok(sessionDataForSearch);
    }

    public ResponseEntity<UserAuth> loginUser(LoginUser loginUser, List<String> list) {
        LoginUserDTO loginUserDTO = this.sessionsApiHelper.toLoginUserDTO(loginUser);
        AuthVO authVO = this.internalAuthService.loginUser(loginUserDTO);
        UserAuth userAuth = this.sessionsApiHelper.toUserAuth(authVO);
        return this.ok(userAuth);
    }

    public ResponseEntity<List<SessionResult>> searchSessions(SessionsApi.SearchSessionsParams searchSessionsParams) {
        SessionQueryFilters sessionQueryFilters = (SessionQueryFilters)ClassHelper.convert((Object)searchSessionsParams, SessionQueryFilters.class);
        ConnectedUserQuery connectedUserQuery = this.sessionsApiHelper.toConnectedUserQuery(sessionQueryFilters);
        Page page = this.connectedUserService.search(connectedUserQuery);
        return this.pageResponse(page, this.sessionsApiHelper::toSessionResult);
    }
}

