/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.SessionsApiImpl;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.LoginUser;
import org.cyclos.web.rest.model.RoleEnum;
import org.cyclos.web.rest.model.SessionDataForSearch;
import org.cyclos.web.rest.model.SessionResult;
import org.cyclos.web.rest.model.UserAuth;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class SessionsApi {
    @Autowired
    private SessionsApiImpl impl;
    public static final String DISCONNECT_SESSION = "/sessions/{sessionToken}";
    public static final String DISCONNECT_USER_SESSIONS = "/{user}/sessions";
    public static final String GET_SESSION_DATA_FOR_SEARCH = "/sessions/data-for-search";
    public static final String LOGIN_USER = "/sessions";
    public static final String SEARCH_SESSIONS = "/sessions";

    @RequestMapping(value={"/api/sessions/{sessionToken}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> disconnectSession(@PathVariable(value="sessionToken") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /sessions/{sessionToken}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.disconnectSession(string);
    }

    @RequestMapping(value={"/api/{user:.*}/sessions"}, produces={"text/plain", "application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> disconnectUserSessions(@PathVariable(value="user") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /{user}/sessions");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.disconnectUserSessions(string);
    }

    @RequestMapping(value={"/api/sessions/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<SessionDataForSearch> getSessionDataForSearch(@RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /sessions/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getSessionDataForSearch(list);
    }

    @RequestMapping(value={"/api/sessions"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<UserAuth> loginUser(@RequestBody(required=true) LoginUser loginUser, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /sessions");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.loginUser(loginUser, list);
    }

    @RequestMapping(value={"/api/sessions"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<SessionResult>> searchSessions(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="broker", required=false) String string, @RequestParam(value="channels", required=false) List<String> list2, @RequestParam(value="excludeCurrentSession", required=false) Boolean bl, @RequestParam(value="operatorsOf", required=false) String string2, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="roles", required=false) List<RoleEnum> list3, @RequestParam(value="skipTotalCount", required=false) Boolean bl2, @RequestParam(value="user", required=false) String string3, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /sessions");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchSessionsParams searchSessionsParams = new SearchSessionsParams();
        searchSessionsParams.fields = list;
        searchSessionsParams.broker = string;
        searchSessionsParams.channels = list2;
        searchSessionsParams.excludeCurrentSession = bl;
        searchSessionsParams.operatorsOf = string2;
        searchSessionsParams.page = n;
        searchSessionsParams.pageSize = n2;
        searchSessionsParams.roles = list3;
        searchSessionsParams.skipTotalCount = bl2;
        searchSessionsParams.user = string3;
        return this.impl.searchSessions(searchSessionsParams);
    }

    public static class SearchSessionsParams {
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String broker;
        public static final String BROKER = "broker";
        public List<String> channels;
        public static final String CHANNELS = "channels";
        public Boolean excludeCurrentSession;
        public static final String EXCLUDE_CURRENT_SESSION = "excludeCurrentSession";
        public String operatorsOf;
        public static final String OPERATORS_OF = "operatorsOf";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public List<RoleEnum> roles;
        public static final String ROLES = "roles";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public String user;
        public static final String USER = "user";
    }
}

