/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.net.URI;
import java.util.List;
import org.cyclos.model.banking.transactions.InstallmentActionDTO;
import org.cyclos.model.banking.transactions.RecurringPaymentActionDTO;
import org.cyclos.model.banking.transactions.RecurringPaymentDTO;
import org.cyclos.model.banking.transactions.RecurringPaymentEditData;
import org.cyclos.model.banking.transactions.RecurringPaymentVO;
import org.cyclos.model.banking.transfers.TransferVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.services.banking.RecurringPaymentService;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.helpers.InstallmentsApiHelper;
import org.cyclos.web.rest.helpers.RecurringPaymentsApiHelper;
import org.cyclos.web.rest.helpers.TransfersApiHelper;
import org.cyclos.web.rest.model.RecurringPaymentDataForEdit;
import org.cyclos.web.rest.model.RecurringPaymentEdit;
import org.cyclos.web.rest.model.Transfer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class RecurringPaymentsApiImpl
extends BaseApiImpl {
    @Autowired
    private RecurringPaymentService recurringPaymentService;
    @Autowired
    private RecurringPaymentsApiHelper recurringPaymentsApiHelper;
    @Autowired
    private TransfersApiHelper transfersApiHelper;
    @Autowired
    private InstallmentsApiHelper installmentsApiHelper;

    public ResponseEntity<Void> blockRecurringPayment(String string, String string2) {
        RecurringPaymentActionDTO recurringPaymentActionDTO = this.recurringPaymentsApiHelper.toRecurringPaymentActionDTO(string, string2);
        this.recurringPaymentService.block(recurringPaymentActionDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> cancelRecurringPayment(String string, String string2) {
        RecurringPaymentActionDTO recurringPaymentActionDTO = this.recurringPaymentsApiHelper.toRecurringPaymentActionDTO(string, string2);
        this.recurringPaymentService.cancel(recurringPaymentActionDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<RecurringPaymentDataForEdit> getRecurringPaymentDataForEdit(String string, List<String> list) {
        RecurringPaymentEditData recurringPaymentEditData = this.recurringPaymentService.getEditData((RecurringPaymentVO)ModelHelper.voFromString(RecurringPaymentVO.class, (String)string));
        return this.ok(this.recurringPaymentsApiHelper.toDataForEdit(recurringPaymentEditData));
    }

    public ResponseEntity<Void> modifyRecurringPayment(String string, RecurringPaymentEdit recurringPaymentEdit, String string2) {
        RecurringPaymentDTO recurringPaymentDTO = this.recurringPaymentsApiHelper.toRecurringPaymentDTO(string, recurringPaymentEdit);
        this.recurringPaymentService.modify(recurringPaymentDTO, string2);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Transfer> processFailedRecurringPaymentOccurrence(String string, List<String> list, String string2) {
        InstallmentActionDTO installmentActionDTO = this.installmentsApiHelper.toInstallmentActionDTO(string, string2);
        TransferVO transferVO = this.recurringPaymentService.processFailure(installmentActionDTO);
        Transfer transfer = this.transfersApiHelper.toTransfer(transferVO);
        this.fields().apply((Object)transfer);
        return ResponseEntity.created((URI)this.apiHelper.uriFromApi("transfers", transfer.getId())).body((Object)transfer);
    }

    public ResponseEntity<Void> unblockRecurringPayment(String string, String string2) {
        RecurringPaymentActionDTO recurringPaymentActionDTO = this.recurringPaymentsApiHelper.toRecurringPaymentActionDTO(string, string2);
        this.recurringPaymentService.unblock(recurringPaymentActionDTO);
        return ResponseEntity.noContent().build();
    }
}

