/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.access.devices.DeviceConfirmationBarcodeParams;
import org.cyclos.model.access.devices.DeviceConfirmationVO;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.transactions.BaseInternalPaymentPreviewVO;
import org.cyclos.model.banking.transactions.CalculateInstallmentsDTO;
import org.cyclos.model.banking.transactions.PerformInternalTransactionDTO;
import org.cyclos.model.banking.transactions.PerformPaymentDTO;
import org.cyclos.model.banking.transactions.PerformRecurringPaymentDTO;
import org.cyclos.model.banking.transactions.PerformScheduledPaymentDTO;
import org.cyclos.model.banking.transactions.ReceivePaymentData;
import org.cyclos.model.banking.transactions.ReceivePaymentFromUserData;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.banking.PaymentService;
import org.cyclos.services.banking.RecurringPaymentService;
import org.cyclos.services.banking.ScheduledPaymentService;
import org.cyclos.services.banking.TransactionService;
import org.cyclos.utils.ContentType;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.PaymentsApi;
import org.cyclos.web.rest.api.PosApi;
import org.cyclos.web.rest.helpers.DeviceConfirmationsApiHelper;
import org.cyclos.web.rest.helpers.PaymentsApiHelper;
import org.cyclos.web.rest.helpers.PosApiHelper;
import org.cyclos.web.rest.helpers.ScheduledPaymentsApiHelper;
import org.cyclos.web.rest.helpers.TransactionsApiHelper;
import org.cyclos.web.rest.model.DataForTransaction;
import org.cyclos.web.rest.model.DeviceConfirmationView;
import org.cyclos.web.rest.model.ImageSizeEnum;
import org.cyclos.web.rest.model.PaymentPreview;
import org.cyclos.web.rest.model.PerformInstallment;
import org.cyclos.web.rest.model.PerformPayment;
import org.cyclos.web.rest.model.SendMediumEnum;
import org.cyclos.web.rest.model.Transaction;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class PosApiImpl
extends BaseApiImpl {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PaymentService paymentService;
    @Autowired
    private ScheduledPaymentService scheduledPaymentService;
    @Autowired
    private RecurringPaymentService recurringPaymentService;
    @Autowired
    private TransactionsApiHelper transactionsApiHelper;
    @Autowired
    private PaymentsApiHelper paymentsApiHelper;
    @Autowired
    private DeviceConfirmationsApiHelper deviceConfirmationsApiHelper;
    @Autowired
    private ScheduledPaymentsApiHelper scheduledPaymentsApiHelper;
    @Autowired
    private PosApiHelper posApiHelper;

    public ResponseEntity<List<PerformInstallment>> calculateReceivePaymentInstallments(PosApi.CalculateReceivePaymentInstallmentsParams calculateReceivePaymentInstallmentsParams) {
        PaymentsApi.CalculatePerformPaymentInstallmentsParams calculatePerformPaymentInstallmentsParams = (PaymentsApi.CalculatePerformPaymentInstallmentsParams)ClassHelper.convert((Object)calculateReceivePaymentInstallmentsParams, PaymentsApi.CalculatePerformPaymentInstallmentsParams.class);
        CalculateInstallmentsDTO calculateInstallmentsDTO = this.scheduledPaymentsApiHelper.toCalculateInstallments(calculatePerformPaymentInstallmentsParams);
        calculateInstallmentsDTO.setOwner((InternalAccountOwner)ModelHelper.voFromString(UserVO.class, (String)calculateReceivePaymentInstallmentsParams.from));
        calculateInstallmentsDTO.setSubject((InternalAccountOwner)ModelHelper.self());
        List list = this.scheduledPaymentService.calculateInstallmentsReceive(calculateInstallmentsDTO);
        List list2 = list.stream().map(this.scheduledPaymentsApiHelper::toPerformInstallment).collect(Collectors.toList());
        return this.ok(list2);
    }

    public ResponseEntity<DataForTransaction> dataForReceivePayment(List<String> list, String string, String string2) {
        DataForTransaction dataForTransaction;
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string);
        TransferTypeVO transferTypeVO = (TransferTypeVO)ModelHelper.voFromString(TransferTypeVO.class, (String)string2);
        if (userLocatorVO == null) {
            ReceivePaymentData receivePaymentData = this.transactionService.getReceivePaymentData();
            dataForTransaction = this.transactionsApiHelper.toDataForTransaction(receivePaymentData);
        } else {
            ReceivePaymentFromUserData receivePaymentFromUserData = this.transactionService.getReceivePaymentFromUserData(userLocatorVO, transferTypeVO);
            dataForTransaction = this.transactionsApiHelper.toDataForTransaction(receivePaymentFromUserData);
            dataForTransaction.setPrincipalTypes(null);
            dataForTransaction.setAccounts(null);
        }
        return this.ok(dataForTransaction);
    }

    public ResponseEntity<PaymentPreview> previewReceivePayment(PerformPayment performPayment, List<String> list) {
        PerformInternalTransactionDTO performInternalTransactionDTO = this.posApiHelper.toPerformDTO(null, performPayment);
        Object object = performInternalTransactionDTO instanceof PerformScheduledPaymentDTO ? this.scheduledPaymentService.previewReceive((PerformScheduledPaymentDTO)performInternalTransactionDTO) : (performInternalTransactionDTO instanceof PerformRecurringPaymentDTO ? this.recurringPaymentService.previewReceive((PerformRecurringPaymentDTO)performInternalTransactionDTO) : this.paymentService.previewReceive((PerformPaymentDTO)performInternalTransactionDTO));
        return this.ok(this.paymentsApiHelper.toPaymentPreview((BaseInternalPaymentPreviewVO)object, performPayment.getSubject()));
    }

    public ResponseEntity<Transaction> receivePayment(PerformPayment performPayment, List<String> list, String string) {
        PerformInternalTransactionDTO performInternalTransactionDTO = this.posApiHelper.toPerformDTO(string, performPayment);
        Object object = performInternalTransactionDTO instanceof PerformScheduledPaymentDTO ? this.scheduledPaymentService.receive((PerformScheduledPaymentDTO)performInternalTransactionDTO) : (performInternalTransactionDTO instanceof PerformRecurringPaymentDTO ? this.recurringPaymentService.receive((PerformRecurringPaymentDTO)performInternalTransactionDTO) : this.paymentService.receive((PerformPaymentDTO)performInternalTransactionDTO));
        return this.transactionsApiHelper.toResponseTransaction((TransactionVO)object);
    }

    public ResponseEntity<String> receivePaymentCreateDeviceConfirmation(PerformPayment performPayment) {
        PerformInternalTransactionDTO performInternalTransactionDTO = this.posApiHelper.toPerformDTO(null, performPayment);
        DeviceConfirmationVO deviceConfirmationVO = this.transactionService.createDeviceConfirmationForReceive(performInternalTransactionDTO);
        return this.ok(deviceConfirmationVO.getId());
    }

    public ResponseEntity<Void> receivePaymentDeleteDeviceConfirmation(PosApi.ReceivePaymentDeleteDeviceConfirmationParams receivePaymentDeleteDeviceConfirmationParams) {
        PerformInternalTransactionDTO performInternalTransactionDTO = this.posApiHelper.toPerformDTO(null, receivePaymentDeleteDeviceConfirmationParams.payer, receivePaymentDeleteDeviceConfirmationParams.type, receivePaymentDeleteDeviceConfirmationParams.currency);
        this.transactionService.removeDeviceConfirmationForReceive(receivePaymentDeleteDeviceConfirmationParams.id, performInternalTransactionDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<InputStream> receivePaymentDeviceConfirmationQrCode(String string, String string2, ImageSizeEnum imageSizeEnum) throws IOException {
        HttpServletResponse httpServletResponse = ServletHelper.getResponse();
        DeviceConfirmationBarcodeParams deviceConfirmationBarcodeParams = this.deviceConfirmationsApiHelper.toDeviceConfirmationBarcodeParams(string, imageSizeEnum);
        SerializableInputStream serializableInputStream = this.transactionService.deviceConfirmationBarcodeForReceive(ModelHelper.accountOwner((String)string2), deviceConfirmationBarcodeParams);
        ServletHelper.setContentType(httpServletResponse, ContentType.PNG);
        ServletHelper.writeContents(httpServletResponse, (InputStream)serializableInputStream);
        httpServletResponse.flushBuffer();
        return null;
    }

    public ResponseEntity<Void> receivePaymentOtp(SendMediumEnum sendMediumEnum, PerformPayment performPayment) {
        PerformInternalTransactionDTO performInternalTransactionDTO = this.posApiHelper.toPerformDTO(null, performPayment);
        this.transactionService.requestNewOTPForReceive(performInternalTransactionDTO, this.apiHelper.toSendMedium(sendMediumEnum));
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<DeviceConfirmationView> receivePaymentViewDeviceConfirmation(PosApi.ReceivePaymentViewDeviceConfirmationParams receivePaymentViewDeviceConfirmationParams) {
        PerformInternalTransactionDTO performInternalTransactionDTO = this.posApiHelper.toPerformDTO(null, receivePaymentViewDeviceConfirmationParams.payer, receivePaymentViewDeviceConfirmationParams.type, receivePaymentViewDeviceConfirmationParams.currency);
        DeviceConfirmationVO deviceConfirmationVO = this.transactionService.viewDeviceConfirmationForReceive(receivePaymentViewDeviceConfirmationParams.id, performInternalTransactionDTO);
        return this.ok(this.deviceConfirmationsApiHelper.toDeviceConfirmationView(deviceConfirmationVO));
    }
}

