/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.utils.DateTime;
import org.cyclos.web.rest.api.PosApiImpl;
import org.cyclos.web.rest.model.DataForTransaction;
import org.cyclos.web.rest.model.DeviceConfirmationView;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.ImageSizeEnum;
import org.cyclos.web.rest.model.PaymentError;
import org.cyclos.web.rest.model.PaymentPreview;
import org.cyclos.web.rest.model.PerformInstallment;
import org.cyclos.web.rest.model.PerformPayment;
import org.cyclos.web.rest.model.PosError;
import org.cyclos.web.rest.model.SendMediumEnum;
import org.cyclos.web.rest.model.Transaction;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class PosApi {
    @Autowired
    private PosApiImpl impl;
    public static final String CALCULATE_RECEIVE_PAYMENT_INSTALLMENTS = "/pos/installments";
    public static final String DATA_FOR_RECEIVE_PAYMENT = "/pos/data-for-pos";
    public static final String PREVIEW_RECEIVE_PAYMENT = "/pos/preview";
    public static final String RECEIVE_PAYMENT = "/pos";
    public static final String RECEIVE_PAYMENT_CREATE_DEVICE_CONFIRMATION = "/pos/device-confirmations";
    public static final String RECEIVE_PAYMENT_DELETE_DEVICE_CONFIRMATION = "/pos/device-confirmations/{id}";
    public static final String RECEIVE_PAYMENT_DEVICE_CONFIRMATION_QR_CODE = "/pos/device-confirmations/{id}/qr-code";
    public static final String RECEIVE_PAYMENT_OTP = "/pos/otp";
    public static final String RECEIVE_PAYMENT_VIEW_DEVICE_CONFIRMATION = "/pos/device-confirmations/{id}";

    @RequestMapping(value={"/api/pos/installments"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<PerformInstallment>> calculateReceivePaymentInstallments(@RequestParam(value="from", required=true) String string, @RequestParam(value="count", required=true) Integer n, @RequestParam(value="amount", required=true) BigDecimal bigDecimal, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="currency", required=false) String string2, @RequestParam(value="type", required=false) String string3, @RequestParam(value="firstDate", required=false) DateTime dateTime, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /pos/installments");
        httpServletRequest.setAttribute("errorType", PosError.class);
        ServletHelper.denyGuest(httpServletRequest);
        CalculateReceivePaymentInstallmentsParams calculateReceivePaymentInstallmentsParams = new CalculateReceivePaymentInstallmentsParams();
        calculateReceivePaymentInstallmentsParams.from = string;
        calculateReceivePaymentInstallmentsParams.count = n;
        calculateReceivePaymentInstallmentsParams.amount = bigDecimal;
        calculateReceivePaymentInstallmentsParams.fields = list;
        calculateReceivePaymentInstallmentsParams.currency = string2;
        calculateReceivePaymentInstallmentsParams.type = string3;
        calculateReceivePaymentInstallmentsParams.firstDate = dateTime;
        return this.impl.calculateReceivePaymentInstallments(calculateReceivePaymentInstallmentsParams);
    }

    @RequestMapping(value={"/api/pos/data-for-pos"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataForTransaction> dataForReceivePayment(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="from", required=false) String string, @RequestParam(value="type", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /pos/data-for-pos");
        httpServletRequest.setAttribute("errorType", PosError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.dataForReceivePayment(list, string, string2);
    }

    @RequestMapping(value={"/api/pos/preview"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<PaymentPreview> previewReceivePayment(@RequestBody(required=true) PerformPayment performPayment, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /pos/preview");
        httpServletRequest.setAttribute("errorType", PosError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.previewReceivePayment(performPayment, list);
    }

    @RequestMapping(value={"/api/pos"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Transaction> receivePayment(@RequestBody(required=true) PerformPayment performPayment, @RequestParam(value="fields", required=false) List<String> list, @RequestHeader(value="confirmationPassword", required=false) String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /pos");
        httpServletRequest.setAttribute("errorType", PaymentError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.receivePayment(performPayment, list, string);
    }

    @RequestMapping(value={"/api/pos/device-confirmations"}, produces={"text/plain", "application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> receivePaymentCreateDeviceConfirmation(@RequestBody(required=true) PerformPayment performPayment, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /pos/device-confirmations");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.receivePaymentCreateDeviceConfirmation(performPayment);
    }

    @RequestMapping(value={"/api/pos/device-confirmations/{id}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> receivePaymentDeleteDeviceConfirmation(@PathVariable(value="id") String string, @RequestParam(value="payer", required=true) String string2, @RequestParam(value="currency", required=false) String string3, @RequestParam(value="type", required=false) String string4, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /pos/device-confirmations/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        ReceivePaymentDeleteDeviceConfirmationParams receivePaymentDeleteDeviceConfirmationParams = new ReceivePaymentDeleteDeviceConfirmationParams();
        receivePaymentDeleteDeviceConfirmationParams.id = string;
        receivePaymentDeleteDeviceConfirmationParams.payer = string2;
        receivePaymentDeleteDeviceConfirmationParams.currency = string3;
        receivePaymentDeleteDeviceConfirmationParams.type = string4;
        return this.impl.receivePaymentDeleteDeviceConfirmation(receivePaymentDeleteDeviceConfirmationParams);
    }

    @RequestMapping(value={"/api/pos/device-confirmations/{id}/qr-code"}, produces={"image/png", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> receivePaymentDeviceConfirmationQrCode(@PathVariable(value="id") String string, @RequestParam(value="payer", required=true) String string2, @RequestParam(value="size", required=false) ImageSizeEnum imageSizeEnum, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /pos/device-confirmations/{id}/qr-code");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.receivePaymentDeviceConfirmationQrCode(string, string2, imageSizeEnum);
    }

    @RequestMapping(value={"/api/pos/otp"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> receivePaymentOtp(@RequestParam(value="medium", required=true) SendMediumEnum sendMediumEnum, @RequestBody(required=true) PerformPayment performPayment, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /pos/otp");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.receivePaymentOtp(sendMediumEnum, performPayment);
    }

    @RequestMapping(value={"/api/pos/device-confirmations/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DeviceConfirmationView> receivePaymentViewDeviceConfirmation(@PathVariable(value="id") String string, @RequestParam(value="payer", required=true) String string2, @RequestParam(value="currency", required=false) String string3, @RequestParam(value="type", required=false) String string4, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /pos/device-confirmations/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        ReceivePaymentViewDeviceConfirmationParams receivePaymentViewDeviceConfirmationParams = new ReceivePaymentViewDeviceConfirmationParams();
        receivePaymentViewDeviceConfirmationParams.id = string;
        receivePaymentViewDeviceConfirmationParams.payer = string2;
        receivePaymentViewDeviceConfirmationParams.currency = string3;
        receivePaymentViewDeviceConfirmationParams.type = string4;
        return this.impl.receivePaymentViewDeviceConfirmation(receivePaymentViewDeviceConfirmationParams);
    }

    public static class CalculateReceivePaymentInstallmentsParams {
        public String from;
        public static final String FROM = "from";
        public Integer count;
        public static final String COUNT = "count";
        public BigDecimal amount;
        public static final String AMOUNT = "amount";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String currency;
        public static final String CURRENCY = "currency";
        public String type;
        public static final String TYPE = "type";
        public DateTime firstDate;
        public static final String FIRST_DATE = "firstDate";
    }

    public static class ReceivePaymentDeleteDeviceConfirmationParams {
        public String id;
        public static final String ID = "id";
        public String payer;
        public static final String PAYER = "payer";
        public String currency;
        public static final String CURRENCY = "currency";
        public String type;
        public static final String TYPE = "type";
    }

    public static class ReceivePaymentViewDeviceConfirmationParams {
        public String id;
        public static final String ID = "id";
        public String payer;
        public static final String PAYER = "payer";
        public String currency;
        public static final String CURRENCY = "currency";
        public String type;
        public static final String TYPE = "type";
    }
}

