/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.PendingPaymentsApiImpl;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.PaymentError;
import org.cyclos.web.rest.model.PendingPaymentActionParams;
import org.cyclos.web.rest.model.TransactionAuthorizationLevelData;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class PendingPaymentsApi {
    @Autowired
    private PendingPaymentsApiImpl impl;
    public static final String AUTHORIZE_PENDING_PAYMENT = "/pending-payments/{key}/authorize";
    public static final String CANCEL_PENDING_PAYMENT = "/pending-payments/{key}/cancel";
    public static final String DENY_PENDING_PAYMENT = "/pending-payments/{key}/deny";

    @RequestMapping(value={"/api/pending-payments/{key}/authorize"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<TransactionAuthorizationLevelData> authorizePendingPayment(@PathVariable(value="key") String string, @RequestBody(required=true) PendingPaymentActionParams pendingPaymentActionParams, @RequestParam(value="fields", required=false) List<String> list, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /pending-payments/{key}/authorize");
        httpServletRequest.setAttribute("errorType", PaymentError.class);
        ServletHelper.denyGuest(httpServletRequest);
        AuthorizePendingPaymentParams authorizePendingPaymentParams = new AuthorizePendingPaymentParams();
        authorizePendingPaymentParams.key = string;
        authorizePendingPaymentParams.pendingPaymentActionParams = pendingPaymentActionParams;
        authorizePendingPaymentParams.fields = list;
        authorizePendingPaymentParams.confirmationPassword = string2;
        return this.impl.authorizePendingPayment(authorizePendingPaymentParams);
    }

    @RequestMapping(value={"/api/pending-payments/{key}/cancel"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> cancelPendingPayment(@PathVariable(value="key") String string, @RequestBody(required=true) PendingPaymentActionParams pendingPaymentActionParams, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /pending-payments/{key}/cancel");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.cancelPendingPayment(string, pendingPaymentActionParams, string2);
    }

    @RequestMapping(value={"/api/pending-payments/{key}/deny"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> denyPendingPayment(@PathVariable(value="key") String string, @RequestBody(required=true) PendingPaymentActionParams pendingPaymentActionParams, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /pending-payments/{key}/deny");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.denyPendingPayment(string, pendingPaymentActionParams, string2);
    }

    public static class AuthorizePendingPaymentParams {
        public String key;
        public static final String KEY = "key";
        public PendingPaymentActionParams pendingPaymentActionParams;
        public static final String PENDING_PAYMENT_ACTION_PARAMS = "pendingPaymentActionParams";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String confirmationPassword;
        public static final String CONFIRMATION_PASSWORD = "confirmationPassword";
    }
}

